/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.ExampleProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.spark.VariantWalkerContext;
import org.broadinstitute.hellbender.engine.spark.VariantWalkerSpark;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@CommandLineProgramProperties(summary="Example tool that prints variants supplied to the specified output file (stdout if none provided), along with overlapping reads/reference bases/variants (if provided)", oneLineSummary="Example tool that prints variants with optional contextual data", programGroup=ExampleProgramGroup.class, omitFromCommandLine=true)
public final class ExampleVariantWalkerSpark
extends VariantWalkerSpark {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="output", shortName="O", doc="Output file (if not provided, defaults to STDOUT)", common=false, optional=true)
    private GATKPath outputFile = null;
    @Argument(fullName="auxiliaryVariants", shortName="av", doc="Auxiliary set of variants", optional=true)
    private FeatureInput<VariantContext> auxiliaryVariants;

    @Override
    protected void processVariants(JavaRDD<VariantWalkerContext> rdd, JavaSparkContext ctx) {
        rdd.map(ExampleVariantWalkerSpark.variantFunction(this.auxiliaryVariants)).saveAsTextFile(this.outputFile.toPath().toString());
    }

    private static Function<VariantWalkerContext, String> variantFunction(FeatureInput<VariantContext> auxiliaryVariants) {
        return (Function & Serializable)context -> {
            VariantContext variant = context.getVariant();
            ReadsContext readsContext = context.getReadsContext();
            ReferenceContext referenceContext = context.getReferenceContext();
            FeatureContext featureContext = context.getFeatureContext();
            StringBuilder sb = new StringBuilder();
            sb.append("Current variant: " + variant);
            sb.append("\n");
            if (referenceContext.hasBackingDataSource()) {
                sb.append(String.format("\tOverlapping reference bases: %s\n\n", new String(referenceContext.getBases())));
            }
            if (readsContext.hasBackingDataSource()) {
                for (GATKRead read : readsContext) {
                    sb.append(String.format("\tOverlapping read at %s:%d-%d\n", read.getContig(), read.getStart(), read.getEnd()));
                }
                sb.append("\n");
            }
            if (featureContext.hasBackingDataSource()) {
                for (VariantContext variant1 : featureContext.getValues(auxiliaryVariants)) {
                    sb.append(String.format("\tOverlapping variant at %s:%d-%d. Ref: %s Alt(s): %s\n", variant1.getContig(), variant1.getStart(), variant1.getEnd(), variant1.getReference(), variant1.getAlternateAlleles()));
                }
                sb.append("\n");
            }
            return sb.toString();
        };
    }
}

