/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples.metrics.multi;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.metrics.MetricsUtils;
import org.broadinstitute.hellbender.metrics.MultiLevelReducibleCollector;
import org.broadinstitute.hellbender.tools.examples.metrics.multi.ExampleMultiMetrics;
import org.broadinstitute.hellbender.tools.examples.metrics.multi.ExampleMultiMetricsArgumentCollection;
import org.broadinstitute.hellbender.tools.examples.metrics.multi.PerUnitExampleMultiMetricsCollector;
import org.broadinstitute.hellbender.tools.examples.metrics.multi.PerUnitExampleMultiMetricsCollectorArgs;
import org.broadinstitute.hellbender.utils.Utils;

public final class ExampleMultiMetricsCollector
extends MultiLevelReducibleCollector<ExampleMultiMetrics, Integer, PerUnitExampleMultiMetricsCollectorArgs, PerUnitExampleMultiMetricsCollector>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(ExampleMultiMetricsCollector.class);
    ExampleMultiMetricsArgumentCollection inputArgs = null;

    public void initialize(ExampleMultiMetricsArgumentCollection inputArgs, SAMFileHeader samHeader) {
        Utils.nonNull(inputArgs);
        Utils.nonNull(samHeader);
        this.inputArgs = inputArgs;
        this.setup(inputArgs.metricAccumulationLevel.accumulationLevels, samHeader.getReadGroups());
    }

    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(new ReadFilterLibrary.AllowAllReadsReadFilter());
    }

    @Override
    protected PerUnitExampleMultiMetricsCollectorArgs makeArg(SAMRecord samRecord, ReferenceSequence refSeq) {
        return new PerUnitExampleMultiMetricsCollectorArgs();
    }

    @Override
    protected PerUnitExampleMultiMetricsCollector makeChildCollector(String sample, String library, String readGroup) {
        return new PerUnitExampleMultiMetricsCollector(sample, library, readGroup);
    }

    protected static ExampleMultiMetricsCollector combine(ExampleMultiMetricsCollector target, ExampleMultiMetricsCollector source) {
        Utils.nonNull(target);
        Utils.nonNull(source);
        target.combine(source);
        return target;
    }

    @Override
    public PerUnitExampleMultiMetricsCollector combineUnit(PerUnitExampleMultiMetricsCollector collector1, PerUnitExampleMultiMetricsCollector collector2) {
        Utils.nonNull(collector1);
        Utils.nonNull(collector2);
        return collector1.combine(collector2);
    }

    public void saveMetrics(MetricsFile<ExampleMultiMetrics, Integer> metricsFile) {
        Utils.nonNull(metricsFile);
        this.finish();
        this.addAllLevelsToFile(metricsFile);
        MetricsUtils.saveMetrics(metricsFile, this.inputArgs.output);
    }
}

