/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples.metrics.multi;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.metrics.Header;
import htsjdk.samtools.metrics.MetricsFile;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.examples.metrics.multi.ExampleMultiMetrics;
import org.broadinstitute.hellbender.tools.examples.metrics.multi.ExampleMultiMetricsArgumentCollection;
import org.broadinstitute.hellbender.tools.examples.metrics.multi.ExampleMultiMetricsCollector;
import org.broadinstitute.hellbender.tools.spark.pipelines.metrics.MetricsCollectorSpark;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class ExampleMultiMetricsCollectorSpark
implements MetricsCollectorSpark<ExampleMultiMetricsArgumentCollection>,
Serializable {
    private static final long serialVersionUID = 1L;
    private ExampleMultiMetricsArgumentCollection inputArgs = null;
    private ExampleMultiMetricsCollector collector = new ExampleMultiMetricsCollector();
    private ExampleMultiMetricsCollector reducedResultMetrics = null;
    private MetricsFile<ExampleMultiMetrics, Integer> metricsFile = null;

    @Override
    public void initialize(ExampleMultiMetricsArgumentCollection inputArgs, SAMFileHeader samHeader, List<Header> defaultHeaders) {
        this.inputArgs = inputArgs;
        this.collector.initialize(inputArgs, samHeader);
        this.metricsFile = new MetricsFile();
        if (defaultHeaders != null) {
            defaultHeaders.stream().forEach(h -> this.metricsFile.addHeader(h));
        }
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return this.collector.getDefaultReadFilters();
    }

    @Override
    public void collectMetrics(JavaRDD<GATKRead> filteredReads, SAMFileHeader samHeader) {
        if (filteredReads.isEmpty()) {
            throw new GATKException("No valid reads found in input file.");
        }
        this.reducedResultMetrics = (ExampleMultiMetricsCollector)filteredReads.mapPartitions((FlatMapFunction & Serializable)it -> {
            it.forEachRemaining(r -> this.collector.acceptRecord(r.convertToSAMRecord(samHeader), null));
            return Arrays.asList(this.collector).iterator();
        }).reduce((Function2 & Serializable)(c1, c2) -> ExampleMultiMetricsCollector.combine(c1, c2));
    }

    @Override
    public void saveMetrics(String inputName) {
        this.reducedResultMetrics.saveMetrics(this.metricsFile);
    }
}

