/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.examples.metrics.multi;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import java.io.Serializable;
import java.util.Objects;
import org.broadinstitute.hellbender.metrics.PerUnitMetricCollector;
import org.broadinstitute.hellbender.tools.examples.metrics.multi.ExampleMultiMetrics;
import org.broadinstitute.hellbender.tools.examples.metrics.multi.PerUnitExampleMultiMetricsCollectorArgs;
import org.broadinstitute.hellbender.utils.Utils;

public final class PerUnitExampleMultiMetricsCollector
implements PerUnitMetricCollector<ExampleMultiMetrics, Integer, PerUnitExampleMultiMetricsCollectorArgs>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ExampleMultiMetrics metrics;

    public PerUnitExampleMultiMetricsCollector(String sample, String library, String readGroup) {
        this.metrics = new ExampleMultiMetrics(sample, library, readGroup);
    }

    @Override
    public void acceptRecord(PerUnitExampleMultiMetricsCollectorArgs args) {
        ++this.metrics.NUMREADS;
    }

    @Override
    public void finish() {
    }

    @Override
    public void addMetricsToFile(MetricsFile<ExampleMultiMetrics, Integer> file) {
        file.addMetric((MetricBase)this.metrics);
    }

    public PerUnitExampleMultiMetricsCollector combine(PerUnitExampleMultiMetricsCollector sourceCollector) {
        Utils.nonNull(sourceCollector);
        String validationMessage = "Internal error combining collectors";
        PerUnitExampleMultiMetricsCollector.validateEquals(this.metrics.SAMPLE, sourceCollector.metrics.SAMPLE, "Internal error combining collectors");
        PerUnitExampleMultiMetricsCollector.validateEquals(this.metrics.LIBRARY, sourceCollector.metrics.LIBRARY, "Internal error combining collectors");
        PerUnitExampleMultiMetricsCollector.validateEquals(this.metrics.READ_GROUP, sourceCollector.metrics.READ_GROUP, "Internal error combining collectors");
        PerUnitExampleMultiMetricsCollector combinedCollector = new PerUnitExampleMultiMetricsCollector(this.metrics.SAMPLE, this.metrics.LIBRARY, this.metrics.READ_GROUP);
        combinedCollector.metrics.NUMREADS = this.metrics.NUMREADS + sourceCollector.metrics.NUMREADS;
        return combinedCollector;
    }

    private static void validateEquals(String source, String target, String message) {
        if (!Objects.equals(source, target)) {
            throw new IllegalArgumentException(String.format("%s (%s : %s)", message, source == null ? "null" : source, target == null ? "null" : target));
        }
    }
}

