/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.utils.Utils;

public class AliasProvider {
    private final LinkedHashMap<String, List<String>> aliasMap;

    public AliasProvider(LinkedHashMap<String, List<String>> aliasMap) {
        Utils.nonNull(aliasMap);
        this.aliasMap = aliasMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AliasProvider.createAliasList(aliasMap, (String)e.getKey()), (x1, x2) -> {
            throw new IllegalArgumentException("Should not be able to have duplicate field names.");
        }, LinkedHashMap::new));
    }

    private static List<String> createAliasList(LinkedHashMap<String, List<String>> columnNameToAliasMap, String columnName) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(columnName);
        result.addAll((Collection)columnNameToAliasMap.get(columnName));
        return result;
    }

    private String findFieldNameInFuncotations(String fieldName, FuncotationMap txToFuncotationMap, String txId) {
        Utils.nonNull(fieldName);
        Utils.nonNull(txToFuncotationMap);
        Utils.nonNull(txId);
        if (!this.aliasMap.keySet().contains(fieldName)) {
            return "";
        }
        List<String> candidateFieldNames = this.aliasMap.get(fieldName);
        Set<String> funcotationFieldNames = txToFuncotationMap.getFieldNames(txId);
        return candidateFieldNames.stream().filter(funcotationFieldNames::contains).findFirst().orElse("");
    }

    public LinkedHashMap<String, String> createColumnNameToFieldNameMap(FuncotationMap txToFuncotationMap, String txId) {
        return this.aliasMap.keySet().stream().map(k -> Pair.of((Object)k, (Object)this.findFieldNameInFuncotations((String)k, txToFuncotationMap, txId))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (x1, x2) -> {
            throw new IllegalArgumentException("Should not be able to have duplicate field names.");
        }, LinkedHashMap::new));
    }

    public List<String> getFields() {
        return new ArrayList<String>(this.aliasMap.keySet());
    }
}

