/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.hdf5.Utils;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.copynumber.formats.records.CalledCopyRatioSegment;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedInterval;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SimpleSVType;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public class AnnotatedIntervalToSegmentVariantContextConverter {
    static final List<String> callAnnotationNames = Arrays.asList("CALL", "Segment_Call", "Call");
    public static final Allele COPY_NEUTRAL_ALLELE = Allele.create((String)SimpleSVType.createBracketedSymbAlleleString("COPY_NEUTRAL"));
    public static final String COPY_NEUTRAL_ALLELE_STRING = COPY_NEUTRAL_ALLELE.getDisplayString();

    private AnnotatedIntervalToSegmentVariantContextConverter() {
    }

    public static VariantContext convert(AnnotatedInterval segment, ReferenceContext referenceContext) {
        Utils.nonNull((Object)segment);
        Utils.nonNull((Object)referenceContext);
        SimpleInterval startPointInterval = new SimpleInterval(segment.getContig(), segment.getStart(), segment.getStart());
        Allele refAlleleAtStart = Allele.create((byte[])referenceContext.getBases(startPointInterval), (boolean)true);
        CalledCopyRatioSegment.Call call = AnnotatedIntervalToSegmentVariantContextConverter.retrieveCall(segment);
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder().chr(segment.getContig()).start((long)segment.getStart()).stop((long)segment.getEnd()).alleles(Arrays.asList(Allele.create((Allele)refAlleleAtStart, (boolean)false), AnnotatedIntervalToSegmentVariantContextConverter.convertActualSegCallToAllele(call))).attribute("END", (Object)segment.getEnd());
        segment.getAnnotations().keySet().stream().forEach(k -> variantContextBuilder.attribute(k, (Object)segment.getAnnotationValue((String)k)));
        return variantContextBuilder.make();
    }

    private static CalledCopyRatioSegment.Call retrieveCall(AnnotatedInterval segment) {
        for (String callAnnotationName : callAnnotationNames) {
            if (!segment.hasAnnotation(callAnnotationName)) continue;
            CalledCopyRatioSegment.Call call = Arrays.stream(CalledCopyRatioSegment.Call.values()).filter(c -> c.getOutputString().equals(segment.getAnnotationValue(callAnnotationName))).findFirst().orElse(null);
            return call;
        }
        return null;
    }

    private static Allele convertActualSegCallToAllele(CalledCopyRatioSegment.Call call) {
        if (call == null) {
            return Allele.UNSPECIFIED_ALTERNATE_ALLELE;
        }
        switch (call) {
            case DELETION: {
                return Allele.create((String)SimpleSVType.createBracketedSymbAlleleString("DEL"), (boolean)false);
            }
            case AMPLIFICATION: {
                return Allele.create((String)SimpleSVType.createBracketedSymbAlleleString("INS"), (boolean)false);
            }
            case NEUTRAL: {
                return COPY_NEUTRAL_ALLELE;
            }
        }
        throw new GATKException.ShouldNeverReachHereException(call.getOutputString() + " is not represented in conversion to variant context.");
    }
}

