/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorArgumentDefinitions;
import org.broadinstitute.hellbender.tools.funcotator.TranscriptSelectionMode;

public abstract class BaseFuncotatorArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String FuncotatorReferenceVersionB37 = "b37";
    @VisibleForTesting
    public static final String FuncotatorReferenceVersionHg19 = "hg19";
    @VisibleForTesting
    public static final String FuncotatorReferenceVersionHg38 = "hg38";
    @Argument(shortName="O", fullName="output", doc="Output file to which annotated variants should be written.")
    public File outputFile;
    @Argument(fullName="ref-version", doc="The version of the Human Genome reference to use (e.g. hg19, hg38, etc.).  This will correspond to a sub-folder of each data source corresponding to that data source for the given reference.")
    public String referenceVersion;
    @Argument(fullName="data-sources-path", doc="The path to a data source folder for Funcotator.  May be specified more than once to handle multiple data source folders.")
    public List<String> dataSourceDirectories;
    @Argument(fullName="output-file-format", doc="The output file format.  Either VCF, MAF, or SEG.  Please note that MAF output for germline use case VCFs is unsupported.  SEG will generate two output files: a simple tsv and a gene list.")
    public FuncotatorArgumentDefinitions.OutputFormatType outputFormatType;
    @Argument(fullName="exclude-field", optional=true, doc="Fields that should not be rendered in the final output.  Only exact name matches will be excluded.")
    public Set<String> excludedFields = new HashSet<String>();
    @Advanced
    @Hidden
    @Argument(fullName="force-b37-to-hg19-reference-contig-conversion", optional=true, doc="(Advanced / DO NOT USE*) If you select this flag, Funcotator will force a conversion of variant contig names from b37 to hg19.  *This option is useful in integration tests (written by devs) only.")
    public boolean forceB37ToHg19ContigNameConversion = false;
    @Argument(fullName="transcript-selection-mode", optional=true, doc="Method of detailed transcript selection.  This will select the transcript for detailed annotation (CANONICAL, ALL, or BEST_EFFECT).")
    public TranscriptSelectionMode transcriptSelectionMode = FuncotatorArgumentDefinitions.TRANSCRIPT_SELECTION_MODE_DEFAULT_VALUE;
    @Argument(fullName="transcript-list", optional=true, doc="File to use as a list of transcripts (one transcript ID per line, version numbers are ignored) OR A set of transcript IDs to use for annotation to override selected transcript.")
    public Set<String> userTranscriptIdSet = new HashSet<String>();
    @Argument(fullName="annotation-default", optional=true, doc="Annotations to include in all annotated variants if the annotation is not specified in the data sources (in the format <ANNOTATION>:<VALUE>).  This will add the specified annotation to every annotated variant if it is not already present.")
    public List<String> annotationDefaults = new ArrayList<String>();
    @Argument(fullName="annotation-override", optional=true, doc="Override values for annotations (in the format <ANNOTATION>:<VALUE>).  Replaces existing annotations of the given name with given values.")
    public List<String> annotationOverrides = new ArrayList<String>();
    @Argument(fullName="lookahead-cache-bp", optional=true, minValue=0.0, doc="Number of base-pairs to cache when querying variants.  Can be overridden in individual data source configuration files.")
    public int lookaheadFeatureCachingInBp = 100000;
    @Advanced
    @Argument(fullName="min-num-bases-for-segment-funcotation", optional=true, doc="The minimum number of bases for a variant to be annotated as a segment.  Recommended to be changed only for use with FuncotateSegments.  Defaults to 150")
    public int minNumBasesForValidSegment = 150;
}

