/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.utils.Utils;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorArgumentDefinitions;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public abstract class DataSourceFuncotationFactory
implements Closeable {
    protected static final Logger logger = LogManager.getLogger(DataSourceFuncotationFactory.class);
    @VisibleForTesting
    public static final String DEFAULT_VERSION_STRING = "UNKNOWN_VERSION";
    protected String version = "UNKNOWN_VERSION";
    protected Map<String, String> annotationOverrideMap;
    protected boolean dataSourceIsB37 = false;
    protected final FeatureInput<? extends Feature> mainSourceFileAsFeatureInput;
    protected int minBasesForValidSegment;

    @VisibleForTesting
    public FeatureInput<? extends Feature> getMainSourceFileAsFeatureInput() {
        return this.mainSourceFileAsFeatureInput;
    }

    protected DataSourceFuncotationFactory(int minBasesForValidSegment) {
        this.mainSourceFileAsFeatureInput = null;
        this.minBasesForValidSegment = minBasesForValidSegment;
    }

    protected DataSourceFuncotationFactory(FeatureInput<? extends Feature> mainSourceFileAsFeatureInput, int minBasesForValidSegment) {
        this.mainSourceFileAsFeatureInput = mainSourceFileAsFeatureInput;
        this.minBasesForValidSegment = minBasesForValidSegment;
    }

    protected void initializeAnnotationOverrides(LinkedHashMap<String, String> annotationOverrides) {
        LinkedHashSet<String> supportedFuncotations = this.getSupportedFuncotationFields();
        this.annotationOverrideMap = new HashMap<String, String>();
        for (String annotationOverrideKey : annotationOverrides.keySet()) {
            if (!supportedFuncotations.contains(annotationOverrideKey)) continue;
            this.annotationOverrideMap.put(annotationOverrideKey, annotationOverrides.get(annotationOverrideKey));
        }
    }

    public String getInfoString() {
        return this.getName() + " " + this.getVersion();
    }

    @Override
    public void close() {
    }

    protected void setOverrideValuesInFuncotations(List<Funcotation> funcotationList) {
        for (Funcotation funcotation : funcotationList) {
            funcotation.setFieldSerializationOverrideValues(this.annotationOverrideMap);
        }
    }

    public abstract String getName();

    public abstract FuncotatorArgumentDefinitions.DataSourceType getType();

    public String getVersion() {
        return this.version;
    }

    @VisibleForTesting
    public boolean requiresFeatures() {
        return true;
    }

    public abstract LinkedHashSet<String> getSupportedFuncotationFields();

    public LinkedHashSet<String> getSupportedFuncotationFieldsForSegments() {
        return new LinkedHashSet<String>();
    }

    public List<Funcotation> createFuncotations(VariantContext variant, ReferenceContext referenceContext, FeatureContext featureContext) {
        return this.createFuncotations(variant, referenceContext, featureContext, null);
    }

    public List<Funcotation> createFuncotations(VariantContext variant, ReferenceContext referenceContext, FeatureContext featureContext, List<GencodeFuncotation> gencodeFuncotations) {
        Utils.nonNull((Object)variant);
        Utils.nonNull((Object)referenceContext);
        Utils.nonNull((Object)featureContext);
        List<Feature> featureList = this.getFeaturesFromFeatureContext(featureContext);
        if (!this.isFeatureListCompatible(featureList)) {
            return this.createDefaultFuncotationsOnVariant(variant, referenceContext);
        }
        List<Funcotation> outputFuncotations = this.determineFuncotations(variant, referenceContext, featureList, gencodeFuncotations);
        this.setOverrideValuesInFuncotations(outputFuncotations);
        if (outputFuncotations == null || outputFuncotations.size() == 0) {
            return this.createDefaultFuncotationsOnVariant(variant, referenceContext);
        }
        return outputFuncotations;
    }

    private List<Feature> getFeaturesFromFeatureContext(FeatureContext featureContext) {
        return this.requiresFeatures() ? this.queryFeaturesFromFeatureContext(featureContext) : Collections.emptyList();
    }

    private List<Funcotation> determineFuncotations(VariantContext variant, ReferenceContext referenceContext, List<Feature> featureList, List<GencodeFuncotation> gencodeFuncotations) {
        List<Funcotation> outputFuncotations = FuncotatorUtils.isSegmentVariantContext(variant, this.minBasesForValidSegment) && this.isSupportingSegmentFuncotation() ? this.createFuncotationsOnSegment(variant, referenceContext, featureList) : (gencodeFuncotations == null ? this.createFuncotationsOnVariant(variant, referenceContext, featureList) : this.createFuncotationsOnVariant(variant, referenceContext, featureList, gencodeFuncotations));
        return outputFuncotations;
    }

    private boolean isFeatureListCompatible(List<Feature> featureList) {
        if (!this.requiresFeatures()) {
            return true;
        }
        boolean foundCompatibleFeature = false;
        for (Feature f : featureList) {
            if (f == null) continue;
            foundCompatibleFeature = this.getAnnotationFeatureClass().isAssignableFrom(f.getClass());
            break;
        }
        return foundCompatibleFeature;
    }

    private List<Feature> queryFeaturesFromFeatureContext(FeatureContext featureContext) {
        SimpleInterval queryInterval = featureContext.getInterval();
        if (this.dataSourceIsB37) {
            queryInterval = new SimpleInterval(FuncotatorUtils.convertHG19ContigToB37Contig(queryInterval.getContig()), queryInterval.getStart(), queryInterval.getEnd());
        }
        List<Object> features = (queryInterval = this.transformFeatureQueryInterval(queryInterval)).equals(featureContext.getInterval()) ? featureContext.getValues(this.mainSourceFileAsFeatureInput) : featureContext.getValues(this.mainSourceFileAsFeatureInput, queryInterval);
        return features;
    }

    protected SimpleInterval transformFeatureQueryInterval(SimpleInterval queryInterval) {
        return queryInterval;
    }

    protected abstract List<Funcotation> createDefaultFuncotationsOnVariant(VariantContext var1, ReferenceContext var2);

    protected abstract List<Funcotation> createFuncotationsOnVariant(VariantContext var1, ReferenceContext var2, List<Feature> var3);

    protected abstract List<Funcotation> createFuncotationsOnVariant(VariantContext var1, ReferenceContext var2, List<Feature> var3, List<GencodeFuncotation> var4);

    @VisibleForTesting
    public abstract Class<? extends Feature> getAnnotationFeatureClass();

    public boolean isSupportingSegmentFuncotation() {
        return false;
    }

    protected List<Funcotation> createFuncotationsOnSegment(VariantContext segmentVariantContext, ReferenceContext referenceContext, List<Feature> featureList) {
        throw new GATKException.ShouldNeverReachHereException("This funcotation factory does not support the annotation of segments.");
    }
}

