/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.TwoPassVariantWalker;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.FilterFuncotationsUtils;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.ArHetvarFilter;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.ArHomvarFilter;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.ClinVarFilter;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.FuncotationFilter;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.LmmFilter;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.LofFilter;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.TwoPassFuncotationFilter;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Filter variants based on clinically-significant Funcotations.\nThis proof-of-concept tool is an example for how to parse and use the VCF output of Funcotator.\nCurrently hard-coded to look for specific Funcotations from:\n  * ClinVar (http://www.clinvar.com/)\n  * Laboratory for Molecular Medicine (LMM) (http://personalizedmedicine.partners.org/laboratory-for-molecular-medicine/)\nAlso looks for Funcotations from whichever of the following is specified by the user:\n  * Exome Aggregation Consortium (ExAC) (http://exac.broadinstitute.org/)\n  * Genome Aggregation Database (gnomAD) (http://gnomad.broadinstitute.org/)", oneLineSummary="Filter variants based on clinically-significant Funcotations.", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
@ExperimentalFeature
public class FilterFuncotations
extends TwoPassVariantWalker {
    static final String ONE_LINE_SUMMARY = "Filter variants based on clinically-significant Funcotations.";
    static final String SUMMARY = "Filter variants based on clinically-significant Funcotations.\nThis proof-of-concept tool is an example for how to parse and use the VCF output of Funcotator.\nCurrently hard-coded to look for specific Funcotations from:\n  * ClinVar (http://www.clinvar.com/)\n  * Laboratory for Molecular Medicine (LMM) (http://personalizedmedicine.partners.org/laboratory-for-molecular-medicine/)\nAlso looks for Funcotations from whichever of the following is specified by the user:\n  * Exome Aggregation Consortium (ExAC) (http://exac.broadinstitute.org/)\n  * Genome Aggregation Database (gnomAD) (http://gnomad.broadinstitute.org/)";
    @Argument(shortName="O", fullName="output", doc="Output VCF file to which filtered variants should be written.")
    protected GATKPath outputFile;
    @Argument(fullName="ref-version", doc="The version of the Human Genome reference which was used to Funcotate the input VCF.")
    protected Reference reference;
    @Argument(fullName="allele-frequency-data-source", doc="The allele frequency data source (ExAC or gnomAD) that was used to Funcotate the input VCF.")
    protected AlleleFrequencyDataSource afDataSource;
    private VariantContextWriter outputVcfWriter;
    private String[] funcotationKeys;
    private final List<TwoPassFuncotationFilter> firstPassFilters = new ArrayList<TwoPassFuncotationFilter>();
    private final List<FuncotationFilter> secondPassFilters = new ArrayList<FuncotationFilter>();

    @Override
    public void onTraversalStart() {
        VCFHeader vcfHeader = this.getHeaderForVariants();
        VCFInfoHeaderLine funcotationHeaderLine = vcfHeader.getInfoHeaderLine("FUNCOTATION");
        if (funcotationHeaderLine == null) {
            throw new UserException.BadInput("Could not extract Funcotation keys from FUNCOTATION field in input VCF header.");
        }
        this.funcotationKeys = FuncotatorUtils.extractFuncotatorKeysFromHeaderDescription(funcotationHeaderLine.getDescription());
        this.outputVcfWriter = this.createVCFWriter(this.outputFile);
        vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFFilterHeaderLine("NOT_CLINSIG", "Filter for clinically insignificant variants."));
        vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine("CLINSIG", 1, VCFHeaderLineType.String, "Rule(s) which caused this annotation to be flagged as clinically significant."));
        this.outputVcfWriter.writeHeader(vcfHeader);
        this.registerFilters();
    }

    private void registerFilters() {
        ClinVarFilter clinVarFilter = new ClinVarFilter(this.afDataSource);
        LofFilter lofFilter = new LofFilter(this.reference, this.afDataSource);
        LmmFilter lmmFilter = new LmmFilter();
        ArHomvarFilter homvarFilter = new ArHomvarFilter(this.reference);
        ArHetvarFilter hetvarFilter = new ArHetvarFilter(this.reference, this.funcotationKeys);
        this.firstPassFilters.add(hetvarFilter);
        this.secondPassFilters.add(clinVarFilter);
        this.secondPassFilters.add(lofFilter);
        this.secondPassFilters.add(lmmFilter);
        this.secondPassFilters.add(homvarFilter);
        this.secondPassFilters.add(hetvarFilter);
    }

    @Override
    public void firstPassApply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        for (TwoPassFuncotationFilter filter : this.firstPassFilters) {
            filter.firstPassApply(variant);
        }
    }

    @Override
    protected void afterFirstPass() {
        for (TwoPassFuncotationFilter filter : this.firstPassFilters) {
            filter.afterFirstPass();
        }
    }

    @Override
    public void secondPassApply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        Set<String> matchingFilters = this.getMatchingFilters(variant, this.secondPassFilters);
        this.outputVcfWriter.add(this.applyFilters(variant, matchingFilters));
    }

    private Set<String> getMatchingFilters(VariantContext variant, List<FuncotationFilter> funcotationFilters) {
        HashSet<String> matchingFilters = new HashSet<String>();
        Map<Allele, FuncotationMap> funcs = FuncotatorUtils.createAlleleToFuncotationMapFromFuncotationVcfAttribute(this.funcotationKeys, variant, "Gencode_" + this.reference.gencodeVersion + "_annotationTranscript", "FAKE_SOURCE");
        funcs.values().forEach(funcotationMap -> FilterFuncotationsUtils.getTranscriptFuncotations(funcotationMap).forEach(funcotations -> {
            Set matches = funcotationFilters.stream().filter(f -> f.checkFilter((Set<Map.Entry<String, String>>)funcotations, variant)).map(FuncotationFilter::getFilterName).collect(Collectors.toSet());
            matchingFilters.addAll(matches);
        }));
        return matchingFilters;
    }

    private VariantContext applyFilters(VariantContext variant, Set<String> matchingFilters) {
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder(variant);
        boolean isSignificant = !matchingFilters.isEmpty();
        String clinicalSignificance = isSignificant ? String.join((CharSequence)",", matchingFilters) : "NONE";
        variantContextBuilder.attribute("CLINSIG", (Object)clinicalSignificance);
        if (isSignificant) {
            variantContextBuilder.passFilters();
        } else {
            variantContextBuilder.filter("NOT_CLINSIG");
        }
        return variantContextBuilder.make();
    }

    @Override
    public void closeTool() {
        if (this.outputVcfWriter != null) {
            this.outputVcfWriter.close();
        }
    }

    public static enum AlleleFrequencyDataSource {
        exac,
        gnomad;

    }

    public static enum Reference {
        b37(19),
        hg19(19),
        hg38(27);

        private final int gencodeVersion;

        private Reference(int gencodeVersion) {
            this.gencodeVersion = gencodeVersion;
        }

        public int getGencodeVersion() {
            return this.gencodeVersion;
        }
    }
}

