/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureWalker;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.copynumber.utils.annotatedinterval.AnnotatedInterval;
import org.broadinstitute.hellbender.tools.funcotator.AnnotatedIntervalToSegmentVariantContextConverter;
import org.broadinstitute.hellbender.tools.funcotator.DataSourceFuncotationFactory;
import org.broadinstitute.hellbender.tools.funcotator.FlankSettings;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorEngine;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorSegmentArgumentCollection;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.OutputRenderer;
import org.broadinstitute.hellbender.tools.funcotator.TranscriptSelectionMode;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.DataSourceUtils;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadata;
import org.broadinstitute.hellbender.tools.funcotator.metadata.VcfFuncotationMetadata;
import org.broadinstitute.hellbender.transformers.VariantTransformer;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Perform functional annotation on a segment file (tsv).  Outputs two files.  The first is a tsv where each row is a segment and the annotations are the covered genes and which genes+exon is overlapped by the segment breakpoints.  The second file has a gene for each row.  The rest of the information is the segment on which it is covered.\n  The first file will have the name as specified by the output parameter.  The second will have '.gene_list.txt' appended.\nThe functionality here is the same as seen in Oncotator with a SEG file as input, but with both SIMPLE_TSV and GENE_LIST as outputs.  \nNote that FuncotateSegments will support seg files from the GATK, whereas Oncotator will not.\nFuncotateSegments can support hg38 seg files from the GATK.\nFuncotateSegments does not support direct reading of cloud-based datasources.\nFor more information about Oncotator, on small variants, see Ramos AH, Lichtenstein L, et al. Oncotator: Cancer Variant Annotation Tool. Human Mutation (2015). http://dx.doi.org/10.1002/humu.22771", oneLineSummary="Functional annotation for segment files.  The output formats are not well-defined and subject to change.", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
@BetaFeature
public class FuncotateSegments
extends FeatureWalker<AnnotatedInterval> {
    private static final Logger logger = LogManager.getLogger(FuncotateSegments.class);
    private static final List<String> MAPPING_DEFAULT = Arrays.asList("MEAN_LOG2_COPY_RATIO:Segment_Mean", "CALL:Segment_Call", "sample:Sample", "sample_id:Sample", "NUM_POINTS_COPY_RATIO:Num_Probes");
    private static final String MAPPING_FULL_NAME = "alias-to-key-mapping";
    @Argument(doc="Input segment file (tab-separated values).  Must have a call column.", fullName="segments")
    private GATKPath segmentFile;
    @ArgumentCollection
    private final FuncotatorSegmentArgumentCollection funcotatorArgs = new FuncotatorSegmentArgumentCollection();
    @Argument(doc="(Advanced) Mapping between an alias and key values that are recognized by the backend.  Users should not typically have to specify this.", fullName="alias-to-key-mapping")
    private List<String> aliasToKeyMappingAsString = new ArrayList<String>(MAPPING_DEFAULT);
    private LinkedHashMap<String, String> aliasToKeyMapping;
    private FuncotatorEngine funcotatorEngine;
    private OutputRenderer outputRenderer;

    @Override
    protected boolean isAcceptableFeatureType(Class<? extends Feature> featureType) {
        return featureType.equals(AnnotatedInterval.class);
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        Utils.validateArg(this.funcotatorArgs.transcriptSelectionMode != TranscriptSelectionMode.ALL, "Cannot funcotate segments with the ALL transcript selection mode.  Please select another mode.");
        LinkedHashMap<String, String> annotationDefaultsMap = FuncotatorEngine.splitAnnotationArgsIntoMap(this.funcotatorArgs.annotationDefaults);
        LinkedHashMap<String, String> annotationOverridesMap = FuncotatorEngine.splitAnnotationArgsIntoMap(this.funcotatorArgs.annotationOverrides);
        Set<String> finalUserTranscriptIdSet = FuncotatorEngine.processTranscriptList(this.funcotatorArgs.userTranscriptIdSet);
        this.funcotatorArgs.dataSourceDirectories.sort(Comparator.naturalOrder());
        Map<Path, Properties> configData = DataSourceUtils.getAndValidateDataSourcesFromPaths(this.funcotatorArgs.referenceVersion, this.funcotatorArgs.dataSourceDirectories);
        List<DataSourceFuncotationFactory> dataSourceFuncotationFactories = DataSourceUtils.createDataSourceFuncotationFactoriesForDataSources(configData, annotationOverridesMap, this.funcotatorArgs.transcriptSelectionMode, finalUserTranscriptIdSet, this, this.funcotatorArgs.lookaheadFeatureCachingInBp, new FlankSettings(0, 0), true, this.funcotatorArgs.minNumBasesForValidSegment).stream().filter(DataSourceFuncotationFactory::isSupportingSegmentFuncotation).collect(Collectors.toList());
        logger.info("The following datasources support funcotation on segments: ");
        dataSourceFuncotationFactories.forEach(ff -> logger.info(" " + ff.getInfoString()));
        this.funcotatorEngine = new FuncotatorEngine(this.funcotatorArgs, this.getBestAvailableSequenceDictionary(), VcfFuncotationMetadata.create(Arrays.asList(new VCFInfoHeaderLine("END", 1, VCFHeaderLineType.Integer, "End coordinate of the variant"))), dataSourceFuncotationFactories);
        this.aliasToKeyMapping = FuncotatorEngine.splitAnnotationArgsIntoMap(this.aliasToKeyMappingAsString);
        this.outputRenderer = this.funcotatorEngine.createOutputRenderer(annotationDefaultsMap, annotationOverridesMap, new VCFHeader(), this.getDefaultToolVCFHeaderLines(), this);
    }

    @Override
    public void apply(AnnotatedInterval segment, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        VariantContext segmentVariantContext = (VariantContext)this.funcotatorEngine.getDefaultVariantTransformer().andThen(this.getTransformAttributesToStandardNames()).apply(AnnotatedIntervalToSegmentVariantContextConverter.convert(segment, referenceContext));
        ReferenceContext correctReferenceContext = this.funcotatorEngine.getCorrectReferenceContext(segmentVariantContext, referenceContext);
        FuncotationMap funcotationMap = this.funcotatorEngine.createFuncotationMapForSegment(segmentVariantContext, correctReferenceContext, featureContext);
        for (String txId : funcotationMap.getTranscriptList()) {
            funcotationMap.add(txId, FuncotatorUtils.createFuncotationsFromMetadata(segmentVariantContext, this.createMetadata(), "FUNCOTATE_SEGMENTS"));
        }
        VariantContext finalVC = new VariantContextBuilder(segmentVariantContext).chr(segment.getContig()).make();
        this.outputRenderer.write(finalVC, funcotationMap);
    }

    @Override
    public GATKPath getDrivingFeaturePath() {
        return this.segmentFile;
    }

    @Override
    public Object onTraversalSuccess() {
        return true;
    }

    @Override
    public void closeTool() {
        if (this.funcotatorEngine != null) {
            this.funcotatorEngine.close();
        }
        if (this.outputRenderer != null) {
            this.outputRenderer.close();
        }
    }

    @Override
    protected <T extends Feature> SimpleInterval makeFeatureInterval(T feature) {
        if (this.funcotatorArgs.referenceVersion.equals("hg19")) {
            return new SimpleInterval(FuncotatorUtils.convertB37ContigToHg19Contig(feature.getContig()), feature.getStart(), feature.getEnd());
        }
        return new SimpleInterval((Locatable)feature);
    }

    private FuncotationMetadata createMetadata() {
        return VcfFuncotationMetadata.create(Arrays.asList(new VCFInfoHeaderLine("Segment_Mean", 1, VCFHeaderLineType.Float, "Mean for the segment.  Units will be the same as the input file."), new VCFInfoHeaderLine("Num_Probes", 1, VCFHeaderLineType.Integer, "Number of probes/targets/bins overlapping the segment."), new VCFInfoHeaderLine("Segment_Call", 1, VCFHeaderLineType.String, "Segment call (whether the segment is amplified, deleted, etc)."), new VCFInfoHeaderLine("Sample", 1, VCFHeaderLineType.String, "Sample name for the segment."), new VCFInfoHeaderLine("build", 1, VCFHeaderLineType.String, "Genome build (e.g. 'hg19' or 'hg38').")));
    }

    private VariantContext transformAttributesToStandardNames(VariantContext vc) {
        Map<String, Object> transformedAttributes = vc.getAttributes().entrySet().stream().collect(Collectors.toMap(e -> this.aliasToKeyMapping.getOrDefault(e.getKey(), (String)e.getKey()), e -> e.getValue()));
        VariantContextBuilder vcb = new VariantContextBuilder(vc).attributes(transformedAttributes);
        return vcb.make();
    }

    private VariantTransformer getTransformAttributesToStandardNames() {
        return this::transformAttributesToStandardNames;
    }
}

