/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import com.esotericsoftware.kryo.Kryo;
import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.spark.GATKRegistrator;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.utils.Utils;

public class FuncotationMap {
    public static final String NO_TRANSCRIPT_AVAILABLE_KEY = "no_transcript";
    protected static final Logger logger = LogManager.getLogger(FuncotationMap.class);
    private final Map<String, LinkedHashSet<Funcotation>> txToFuncotations = new LinkedHashMap<String, LinkedHashSet<Funcotation>>();

    private FuncotationMap() {
    }

    List<GencodeFuncotation> getGencodeFuncotations(String transcriptId) {
        Utils.nonNull(transcriptId);
        return this.txToFuncotations.getOrDefault(transcriptId, new LinkedHashSet()).stream().filter(FuncotatorUtils::isGencodeFuncotation).map(f -> (GencodeFuncotation)f).collect(Collectors.toList());
    }

    public List<Funcotation> get(String transcriptId) {
        Utils.nonNull(transcriptId);
        return new ArrayList<Funcotation>(this.txToFuncotations.getOrDefault(transcriptId, new LinkedHashSet()));
    }

    public String getFieldValue(String transcriptId, String fieldName, Allele allele) {
        Utils.nonNull(transcriptId);
        Utils.nonNull(fieldName);
        Utils.nonNull(allele);
        Set values = this.txToFuncotations.getOrDefault(transcriptId, new LinkedHashSet()).stream().filter(f -> f.hasField(fieldName)).filter(f -> f.getAltAllele().equals((Object)allele)).map(f -> f.getField(fieldName)).collect(Collectors.toSet());
        if (values.size() > 1) {
            throw new UserException.BadInput("Found more than one unique value for the tuple {" + transcriptId + ", " + allele + ", " + fieldName + "}: " + values.stream().collect(Collectors.joining(", ")));
        }
        if (values.size() == 0) {
            return null;
        }
        return (String)values.iterator().next();
    }

    @VisibleForTesting
    public static FuncotationMap createEmpty() {
        return new FuncotationMap();
    }

    public static FuncotationMap createNoTranscriptInfo(List<Funcotation> funcotations) {
        FuncotationMap result = FuncotationMap.createEmpty();
        result.add(NO_TRANSCRIPT_AVAILABLE_KEY, funcotations);
        return result;
    }

    public static FuncotationMap createFromGencodeFuncotations(List<GencodeFuncotation> gencodeFuncotations) {
        Utils.nonNull(gencodeFuncotations);
        Utils.validateArg(!FuncotationMap.areDuplicateTranscriptIDsFound(gencodeFuncotations), "Duplicate transcript ID entries were found in input: " + gencodeFuncotations.stream().map(GencodeFuncotation::getAnnotationTranscript).collect(Collectors.joining(",")));
        FuncotationMap result = FuncotationMap.createEmpty();
        gencodeFuncotations.forEach(f -> result.addWithoutGencodeCheck(f.getAnnotationTranscript(), (Funcotation)f));
        return result;
    }

    public void add(String txId, List<Funcotation> funcotations) {
        Utils.nonNull(txId);
        Utils.nonNull(funcotations);
        if (FuncotatorUtils.areAnyGencodeFuncotation(funcotations) && this.txToFuncotations.size() > 0) {
            throw new GATKException.ShouldNeverReachHereException("At this time, a Gencode Funcotation cannot be added to a non-empty FuncotationMap.  If you see this error message, please contact the GATK dev team with a forum post.");
        }
        this.addWithoutGencodeCheck(txId, funcotations);
    }

    private void addWithoutGencodeCheck(String txId, List<Funcotation> funcotations) {
        LinkedHashSet<Funcotation> existingFuncotationsToUpdate = this.txToFuncotations.getOrDefault(txId, new LinkedHashSet());
        existingFuncotationsToUpdate.addAll(funcotations);
        this.txToFuncotations.put(txId, existingFuncotationsToUpdate);
    }

    private void addWithoutGencodeCheck(String txId, Funcotation funcotation) {
        LinkedHashSet<Funcotation> existingFuncotationsToUpdate = this.txToFuncotations.getOrDefault(txId, new LinkedHashSet());
        existingFuncotationsToUpdate.add(funcotation);
        this.txToFuncotations.put(txId, existingFuncotationsToUpdate);
    }

    public void add(String txId, Funcotation funcotation) {
        Utils.nonNull(txId);
        Utils.nonNull(funcotation);
        if (FuncotatorUtils.isGencodeFuncotation(funcotation)) {
            throw new GATKException.ShouldNeverReachHereException("At this time, a Gencode Funcotation cannot be added to a FuncotationMap.  If you see this error message, please contact the GATK dev team with a forum post.");
        }
        this.addWithoutGencodeCheck(txId, funcotation);
    }

    public List<String> getTranscriptList() {
        return new ArrayList<String>(this.txToFuncotations.keySet());
    }

    @VisibleForTesting
    LinkedHashSet<String> getTranscriptSet() {
        return new LinkedHashSet<String>(this.txToFuncotations.keySet());
    }

    public static FuncotationMap createAsAllTableFuncotationsFromVcf(String transcriptFieldName, String[] funcotationKeys, String funcotationAttributeForSingleAllele, Allele altAllele, String datasourceName) {
        String[] funcotationAttributeForSingleAlleleByTranscript;
        Utils.nonNull(transcriptFieldName);
        Utils.nonNull(funcotationKeys);
        Utils.nonNull(funcotationAttributeForSingleAllele);
        Utils.nonNull(altAllele);
        Utils.nonNull(datasourceName);
        FuncotationMap result = FuncotationMap.createEmpty();
        for (String funcotationAttribute : funcotationAttributeForSingleAlleleByTranscript = StringUtils.splitByWholeSeparator((String)funcotationAttributeForSingleAllele, (String)"]#[")) {
            Object[] values = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)funcotationAttribute, (String)"|");
            if (values[0].startsWith("[")) {
                values[0] = values[0].replace("[", "");
            }
            if (values[values.length - 1].endsWith("]")) {
                values[values.length - 1] = values[values.length - 1].replace("]", "");
            }
            if (values.length != funcotationKeys.length) {
                logger.error("Keys:  " + StringUtils.join((Object[])funcotationKeys, (String)", "));
                logger.error("Values:  " + StringUtils.join((Object[])values, (String)", "));
                throw new GATKException.ShouldNeverReachHereException("Cannot parse the funcotation attribute.  Num values: " + values.length + "   Num keys: " + funcotationKeys.length);
            }
            Map<String, String> simpleNameValuePairs = IntStream.range(0, values.length).boxed().collect(Collectors.toMap(i -> funcotationKeys[i], arg_0 -> FuncotationMap.lambda$createAsAllTableFuncotationsFromVcf$6((String[])values, arg_0)));
            List<String> valuesAsList = Arrays.stream(funcotationKeys).map(simpleNameValuePairs::get).collect(Collectors.toList());
            result.add(simpleNameValuePairs.getOrDefault(transcriptFieldName, NO_TRANSCRIPT_AVAILABLE_KEY), TableFuncotation.create(Arrays.asList(funcotationKeys), valuesAsList, altAllele, datasourceName, null));
        }
        return result;
    }

    private static boolean areDuplicateTranscriptIDsFound(List<GencodeFuncotation> gencodeFuncotations) {
        return gencodeFuncotations.size() != new HashSet<GencodeFuncotation>(gencodeFuncotations).size();
    }

    public Set<String> getFieldNames(String transcriptId) {
        Utils.nonNull(transcriptId);
        LinkedHashSet funcotations = this.txToFuncotations.getOrDefault(transcriptId, new LinkedHashSet());
        return funcotations.stream().map(Funcotation::getFieldNames).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @VisibleForTesting
    Set<String> getFieldNames() {
        List<String> txIds = this.getTranscriptList();
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        txIds.forEach(txId -> result.addAll(this.getFieldNames((String)txId)));
        return result;
    }

    private Set<String> getFieldNames(String transcriptId, Allele allele) {
        Utils.nonNull(transcriptId);
        Utils.nonNull(allele);
        LinkedHashSet funcotations = this.txToFuncotations.getOrDefault(transcriptId, new LinkedHashSet());
        return funcotations.stream().filter(f -> f.getAltAllele().equals((Object)allele)).map(Funcotation::getFieldNames).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Allele> getAlleles(String transcriptId) {
        LinkedHashSet funcotations = this.txToFuncotations.getOrDefault(transcriptId, new LinkedHashSet());
        return funcotations.stream().map(Funcotation::getAltAllele).collect(Collectors.toSet());
    }

    public boolean doAllTxAlleleCombinationsHaveTheSameFields() {
        Set<String> allFields = this.getFieldNames();
        List<String> txIds = this.getTranscriptList();
        ArrayList txAlleleCombos = new ArrayList();
        for (String txId : txIds) {
            this.getAlleles(txId).forEach(a -> txAlleleCombos.add(Pair.of((Object)txId, (Object)a)));
        }
        return txAlleleCombos.stream().allMatch(p -> this.getFieldNames((String)p.getLeft(), (Allele)p.getRight()).equals(allFields));
    }

    public static FuncotationMap create(FuncotationMap funcotationMap) {
        Utils.nonNull(funcotationMap);
        Kryo kryo = new Kryo();
        GATKRegistrator.registerFuncotationMapDependencies(kryo);
        kryo.register(FuncotationMap.class);
        return (FuncotationMap)kryo.copy((Object)funcotationMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FuncotationMap that = (FuncotationMap)o;
        return this.txToFuncotations.equals(that.txToFuncotations);
    }

    public int hashCode() {
        return this.txToFuncotations.hashCode();
    }

    private static /* synthetic */ String lambda$createAsAllTableFuncotationsFromVcf$6(String[] values, Integer i) {
        return values[i];
    }
}

