/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.engine.filters.CountingVariantFilter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.DataSourceFuncotationFactory;
import org.broadinstitute.hellbender.tools.funcotator.FlankSettings;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorArgumentDefinitions;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorEngine;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorVariantArgumentCollection;
import org.broadinstitute.hellbender.tools.funcotator.OutputRenderer;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.DataSourceUtils;
import org.broadinstitute.hellbender.tools.funcotator.metadata.VcfFuncotationMetadata;
import org.broadinstitute.hellbender.transformers.VariantTransformer;
import org.broadinstitute.hellbender.utils.SequenceDictionaryUtils;
import org.broadinstitute.hellbender.utils.Utils;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Create functional annotations on given variants cross-referenced by a given set of data sources.\nA GATK functional annotation tool (similar functionality to Oncotator).", oneLineSummary="Functional Annotator", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
public class Funcotator
extends VariantWalker {
    private static final Logger logger = LogManager.getLogger(Funcotator.class);
    @ArgumentCollection
    private final FuncotatorVariantArgumentCollection funcotatorArgs = new FuncotatorVariantArgumentCollection();
    private OutputRenderer outputRenderer;
    private FuncotatorEngine funcotatorEngine;

    public FuncotatorVariantArgumentCollection getArguments() {
        return this.funcotatorArgs;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        if (this.seqValidationArguments.performSequenceDictionaryValidation()) {
            logger.info("Validating sequence dictionaries...");
            this.checkReferenceDictionaryIsSupersetOfVariantDictionary();
        } else {
            logger.info("Skipping sequence dictionary validation.");
        }
        logger.info("Processing user transcripts/defaults/overrides...");
        Utils.validateArg(this.funcotatorArgs.outputFormatType != FuncotatorArgumentDefinitions.OutputFormatType.SEG, "This tool does not support segment output.  Please see FuncotateSegments.");
        Set<String> finalUserTranscriptIdSet = FuncotatorEngine.processTranscriptList(this.funcotatorArgs.userTranscriptIdSet);
        LinkedHashMap<String, String> annotationDefaultsMap = FuncotatorEngine.splitAnnotationArgsIntoMap(this.funcotatorArgs.annotationDefaults);
        LinkedHashMap<String, String> annotationOverridesMap = FuncotatorEngine.splitAnnotationArgsIntoMap(this.funcotatorArgs.annotationOverrides);
        VCFHeader vcfHeader = this.getHeaderForVariants();
        logger.info("Initializing data sources...");
        this.funcotatorArgs.dataSourceDirectories.sort(Comparator.naturalOrder());
        Map<Path, Properties> configData = DataSourceUtils.getAndValidateDataSourcesFromPaths(this.funcotatorArgs.referenceVersion, this.funcotatorArgs.dataSourceDirectories);
        logger.info("Finalizing data sources (this step can be long if data sources are cloud-based)...");
        List<DataSourceFuncotationFactory> dataSourceFuncotationFactories = DataSourceUtils.createDataSourceFuncotationFactoriesForDataSources(configData, annotationOverridesMap, this.funcotatorArgs.transcriptSelectionMode, finalUserTranscriptIdSet, this, this.funcotatorArgs.lookaheadFeatureCachingInBp, new FlankSettings(this.funcotatorArgs.fivePrimeFlankSize, this.funcotatorArgs.threePrimeFlankSize), false, this.funcotatorArgs.minNumBasesForValidSegment);
        logger.info("Initializing Funcotator Engine...");
        this.funcotatorEngine = new FuncotatorEngine(this.funcotatorArgs, this.getSequenceDictionaryForDrivingVariants(), VcfFuncotationMetadata.create(new ArrayList<VCFInfoHeaderLine>(vcfHeader.getInfoHeaderLines())), dataSourceFuncotationFactories);
        logger.info("Creating a " + (Object)((Object)this.funcotatorArgs.outputFormatType) + " file for output: " + this.funcotatorArgs.outputFile.toURI());
        this.outputRenderer = this.funcotatorEngine.createOutputRenderer(annotationDefaultsMap, annotationOverridesMap, vcfHeader, this.getDefaultToolVCFHeaderLines(), this);
    }

    private void checkReferenceDictionaryIsSupersetOfVariantDictionary() {
        SAMSequenceDictionary referenceDictionary = this.getReferenceDictionary();
        SAMSequenceDictionary variantDictionary = this.getSequenceDictionaryForDrivingVariants();
        if (referenceDictionary == null) {
            throw new UserException.BadInput("Reference fasta sequence dictionary is null!");
        }
        if (variantDictionary == null) {
            throw new UserException.BadInput("Funcotator by default requires that the variant input have a sequence dictionary in its header. To disable this safety check, use argument --disable-sequence-dictionary-validation");
        }
        SequenceDictionaryUtils.validateDictionaries("Reference", this.getReferenceDictionary(), "Driving Variants", this.getSequenceDictionaryForDrivingVariants(), true, false);
    }

    @Override
    protected CountingVariantFilter makeVariantFilter() {
        return new CountingVariantFilter(FuncotatorEngine.makeVariantFilter(this.funcotatorArgs.removeFilteredVariants));
    }

    @Override
    public VariantTransformer makePostVariantFilterTransformer() {
        return this.funcotatorEngine.getDefaultVariantTransformer();
    }

    @Override
    public void apply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        ReferenceContext correctReferenceContext = this.funcotatorEngine.getCorrectReferenceContext(variant, referenceContext);
        this.enqueueAndHandleVariant(variant, correctReferenceContext, featureContext);
    }

    @Override
    public Object onTraversalSuccess() {
        if (this.funcotatorEngine.onlyProducedIGRs()) {
            logger.warn("================================================================================");
            logger.warn("\u001b[43m     _  _  _   __        __               _                   _  _  _           ");
            logger.warn("    | || || |  \\ \\      / /_ _ _ __ _ __ (_)_ __   __ _      | || || |        ");
            logger.warn("    | || || |   \\ \\ /\\ / / _` | '__| '_ \\| | '_ \\ / _` |     | || || |     ");
            logger.warn("    |_||_||_|    \\ \\V V / (_| | |  | | | | | | | | (_| |     |_||_||_|        ");
            logger.warn("    (_)(_)(_)     \\_/\\_/ \\__,_|_|  |_| |_|_|_| |_|\\__, |     (_)(_)(_)      ");
            logger.warn("                                                  |___/                         \u001b[0;0m");
            logger.warn("--------------------------------------------------------------------------------");
            logger.warn(" Only IGRs were produced for this dataset.  This STRONGLY indicates that this   ");
            logger.warn(" run was misconfigured.     ");
            logger.warn(" You MUST check your data sources to make sure they are correct for these data.");
            logger.warn("================================================================================");
        }
        return true;
    }

    @Override
    public void closeTool() {
        if (this.funcotatorEngine != null) {
            this.funcotatorEngine.close();
        }
        if (this.outputRenderer != null) {
            this.outputRenderer.close();
        }
    }

    private void enqueueAndHandleVariant(VariantContext variant, ReferenceContext referenceContext, FeatureContext featureContext) {
        FuncotationMap funcotationMap = this.funcotatorEngine.createFuncotationMapForVariant(variant, referenceContext, featureContext);
        this.outputRenderer.write(variant, funcotationMap);
    }
}

