/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import java.nio.file.Path;
import java.util.Properties;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.TranscriptSelectionMode;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.DataSourceUtils;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.xsv.SimpleKeyXsvFuncotationFactory;

public class FuncotatorArgumentDefinitions {
    public static final char MAP_NAME_VALUE_DELIMITER = ':';
    public static final String REFERENCE_VERSION_LONG_NAME = "ref-version";
    public static final String ALLELE_FREQUENCY_DATA_SOURCE_NAME = "allele-frequency-data-source";
    public static final String DATA_SOURCES_PATH_LONG_NAME = "data-sources-path";
    public static final String OUTPUT_FORMAT_LONG_NAME = "output-file-format";
    public static final String REMOVE_FILTERED_VARIANTS_LONG_NAME = "remove-filtered-variants";
    public static final String TRANSCRIPT_SELECTION_MODE_LONG_NAME = "transcript-selection-mode";
    public static final TranscriptSelectionMode TRANSCRIPT_SELECTION_MODE_DEFAULT_VALUE = TranscriptSelectionMode.CANONICAL;
    public static final String TRANSCRIPT_LIST_LONG_NAME = "transcript-list";
    public static final String ANNOTATION_DEFAULTS_LONG_NAME = "annotation-default";
    public static final String ANNOTATION_OVERRIDES_LONG_NAME = "annotation-override";
    public static final String EXCLUSION_FIELDS_LONG_NAME = "exclude-field";
    public static final String FIVE_PRIME_FLANK_SIZE_NAME = "five-prime-flank-size";
    public static final String THREE_PRIME_FLANK_SIZE_NAME = "three-prime-flank-size";
    public static final int FIVE_PRIME_FLANK_SIZE_DEFAULT_VALUE = 5000;
    public static final int THREE_PRIME_FLANK_SIZE_DEFAULT_VALUE = 0;
    public static final String LOOKAHEAD_CACHE_IN_BP_NAME = "lookahead-cache-bp";
    public static final int LOOKAHEAD_CACHE_IN_BP_DEFAULT_VALUE = 100000;
    public static final String FORCE_B37_TO_HG19_REFERENCE_CONTIG_CONVERSION = "force-b37-to-hg19-reference-contig-conversion";
    public static final String MIN_NUM_BASES_FOR_SEGMENT_FUNCOTATION = "min-num-bases-for-segment-funcotation";

    public static enum OutputFormatType {
        VCF,
        MAF,
        SEG;

    }

    public static enum DataSourceType {
        SIMPLE_XSV("simpleXSV"){

            @Override
            public void assertConfigFilePropertiesAreValid(Properties configFileProperties, Path configFilePath) {
                DataSourceUtils.assertConfigPropertiesContainsKey("xsv_delimiter", configFileProperties, configFilePath);
                DataSourceUtils.assertConfigPropertiesContainsKey("xsv_key", configFileProperties, configFilePath);
                DataSourceUtils.assertConfigPropertiesContainsKey("xsv_key_column", configFileProperties, configFilePath);
                DataSourceUtils.assertConfigPropertiesContainsKey("xsv_permissive_cols", configFileProperties, configFilePath);
                DataSourceUtils.assertIntegerPropertiesField(configFileProperties, "xsv_key_column", configFilePath);
                DataSourceUtils.assertBooleanPropertiesField(configFileProperties, "xsv_permissive_cols", configFilePath);
                String stringXsvKey = configFileProperties.getProperty("xsv_key");
                try {
                    SimpleKeyXsvFuncotationFactory.XsvDataKeyType.valueOf(stringXsvKey);
                }
                catch (IllegalArgumentException ex) {
                    throw new UserException.BadInput("ERROR in config file: " + configFilePath.toUri().toString() + " - Invalid value in \"" + "xsv_key" + "\" field: " + stringXsvKey, ex);
                }
            }
        }
        ,
        LOCATABLE_XSV("locatableXSV"){

            @Override
            public void assertConfigFilePropertiesAreValid(Properties configFileProperties, Path configFilePath) {
                DataSourceUtils.assertConfigPropertiesContainsKey("xsv_delimiter", configFileProperties, configFilePath);
                DataSourceUtils.assertConfigPropertiesContainsKey("contig_column", configFileProperties, configFilePath);
                DataSourceUtils.assertConfigPropertiesContainsKey("start_column", configFileProperties, configFilePath);
                DataSourceUtils.assertConfigPropertiesContainsKey("end_column", configFileProperties, configFilePath);
                DataSourceUtils.assertIntegerPropertiesField(configFileProperties, "contig_column", configFilePath);
                DataSourceUtils.assertIntegerPropertiesField(configFileProperties, "start_column", configFilePath);
                DataSourceUtils.assertIntegerPropertiesField(configFileProperties, "end_column", configFilePath);
            }
        }
        ,
        VCF("vcf"){

            @Override
            public void assertConfigFilePropertiesAreValid(Properties configFileProperties, Path configFilePath) {
            }
        }
        ,
        GENCODE("gencode"){

            @Override
            public void assertConfigFilePropertiesAreValid(Properties configFileProperties, Path configFilePath) {
                DataSourceUtils.assertConfigPropertiesContainsKey("gencode_fasta_path", configFileProperties, configFilePath);
                DataSourceUtils.assertConfigPropertiesContainsKey("ncbi_build_version", configFileProperties, configFilePath);
                DataSourceUtils.assertPathFilePropertiesField(configFileProperties, "gencode_fasta_path", configFilePath);
            }
        }
        ,
        COSMIC("cosmic"){

            @Override
            public void assertConfigFilePropertiesAreValid(Properties configFileProperties, Path configFilePath) {
            }
        };

        private final String serialized;

        public abstract void assertConfigFilePropertiesAreValid(Properties var1, Path var2);

        private DataSourceType(String serializedValue) {
            this.serialized = serializedValue;
        }

        public String toString() {
            return this.serialized;
        }

        public static DataSourceType getEnum(String s) {
            for (DataSourceType val : DataSourceType.values()) {
                if (!val.serialized.equalsIgnoreCase(s)) continue;
                return val;
            }
            throw new IllegalArgumentException("Unexpected value: " + s);
        }
    }
}

