/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.DataSourceUtils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.nio.NioFileCopierWithProgressMeter;
import org.broadinstitute.hellbender.utils.nio.NioFileCopierWithProgressMeterResults;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Download the Broad Institute pre-packaged data sources for the somatic or germline use case for Funcotator.", oneLineSummary="Data source downloader for Funcotator.", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
public class FuncotatorDataSourceDownloader
extends CommandLineProgram {
    private static final Logger logger = LogManager.getLogger(FuncotatorDataSourceDownloader.class);
    public static final String VALIDATE_INTEGRITY_ARG_LONG_NAME = "validate-integrity";
    public static final String SOMATIC_ARG_LONG_NAME = "somatic";
    public static final String GERMLINE_ARG_LONG_NAME = "germline";
    public static final String OVERWRITE_ARG_LONG_NAME = "overwrite-output-file";
    public static final String EXTRACT_AFTER_DOWNLOAD = "extract-after-download";
    static final String TESTING_OVERRIDE_PATH_FOR_DATA_SOURCES_ARG = "testing-override-path-for-datasources";
    static final String TESTING_OVERRIDE_PATH_FOR_DATA_SOURCES_SHA256_ARG = "testing-override-path-for-datasources-sha256";
    private static final String BASE_URL = "gs://broad-public-datasets/funcotator/funcotator_dataSources." + DataSourceUtils.getDataSourceMaxVersionString();
    private static final String GERMLINE_GCLOUD_DATASOURCES_BASEURL = BASE_URL + "g";
    @VisibleForTesting
    static final Path GERMLINE_GCLOUD_DATASOURCES_PATH = IOUtils.getPath(GERMLINE_GCLOUD_DATASOURCES_BASEURL + ".tar.gz");
    private static final Path GERMLINE_GCLOUD_DATASOURCES_SHA256_PATH = IOUtils.getPath(GERMLINE_GCLOUD_DATASOURCES_BASEURL + ".sha256");
    public static final String SOMATIC_GCLOUD_DATASOURCES_BASEURL = BASE_URL + "s";
    public static final Path SOMATIC_GCLOUD_DATASOURCES_PATH = IOUtils.getPath(SOMATIC_GCLOUD_DATASOURCES_BASEURL + ".tar.gz");
    private static final Path SOMATIC_GCLOUD_DATASOURCES_SHA256_PATH = IOUtils.getPath(SOMATIC_GCLOUD_DATASOURCES_BASEURL + ".sha256");
    @Argument(fullName="validate-integrity", shortName="validate-integrity", doc="Validate the integrity of the data sources after downloading them using sha256.", optional=true)
    private boolean doValidateIntegrity = false;
    @Argument(fullName="somatic", shortName="somatic", mutex={"germline", "testing-override-path-for-datasources-sha256"}, doc="Download the latest pre-packaged datasources for somatic functional annotation.", optional=true)
    private boolean getSomaticDataSources = false;
    @Argument(fullName="germline", shortName="germline", mutex={"somatic", "testing-override-path-for-datasources-sha256"}, doc="Download the latest pre-packaged datasources for germline functional annotation.", optional=true)
    private boolean getGermlineDataSources = false;
    @Argument(fullName="overwrite-output-file", shortName="overwrite-output-file", doc="Overwrite output file if it exists already.", optional=true)
    private boolean overwriteOutputFile = false;
    @Argument(shortName="O", fullName="output", doc="Output location for the data sources.", optional=true)
    protected File outputFile;
    @Argument(shortName="extract-after-download", fullName="extract-after-download", doc="Extract the data sources to a sibling folder after they have been downloaded.", optional=true)
    protected boolean extractDataSourcesAfterDownload = false;
    @Hidden
    @Advanced
    @Argument(shortName="testing-override-path-for-datasources", fullName="testing-override-path-for-datasources", mutex={"somatic", "germline"}, doc="FOR TESTING ONLY: Override path to data sources file with another path.", optional=true)
    private String testingOverrideDataSourcesPath;
    @Hidden
    @Advanced
    @Argument(shortName="testing-override-path-for-datasources-sha256", fullName="testing-override-path-for-datasources-sha256", mutex={"somatic", "germline"}, doc="FOR TESTING ONLY: Override path to data sources sha256sum file with another path.", optional=true)
    private String testingOverrideDataSourcesSha256Path;

    @Override
    protected void onStartup() {
        if (!this.getSomaticDataSources && !this.getGermlineDataSources && this.testingOverrideDataSourcesPath == null) {
            throw new UserException("Must select either somatic or germline datasources.");
        }
        if (this.testingOverrideDataSourcesPath == null && this.testingOverrideDataSourcesSha256Path != null || this.testingOverrideDataSourcesSha256Path == null && this.testingOverrideDataSourcesPath != null) {
            throw new UserException("Must specify both a test data sources path and a test data sources sha256sum path.");
        }
        if (this.overwriteOutputFile) {
            logger.info("Overwrite ENABLED.  Will overwrite existing data sources download.");
        }
    }

    @Override
    protected Object doWork() {
        Path dataSourcesSha256Path;
        Path dataSourcesPath;
        String dataSourceDescription;
        if (this.getSomaticDataSources) {
            dataSourceDescription = "Somatic";
            dataSourcesPath = SOMATIC_GCLOUD_DATASOURCES_PATH;
            dataSourcesSha256Path = SOMATIC_GCLOUD_DATASOURCES_SHA256_PATH;
        } else if (this.getGermlineDataSources) {
            dataSourceDescription = "Germline";
            dataSourcesPath = GERMLINE_GCLOUD_DATASOURCES_PATH;
            dataSourcesSha256Path = GERMLINE_GCLOUD_DATASOURCES_SHA256_PATH;
        } else {
            dataSourceDescription = "TESTING";
            dataSourcesPath = IOUtils.getPath(this.testingOverrideDataSourcesPath);
            dataSourcesSha256Path = IOUtils.getPath(this.testingOverrideDataSourcesSha256Path);
        }
        this.downloadAndValidateDataSources(dataSourceDescription, dataSourcesPath, dataSourcesSha256Path);
        return true;
    }

    private NioFileCopierWithProgressMeter createNioDownloader(Path dsPath) {
        Path outputDestination = this.getOutputLocation(dsPath);
        return NioFileCopierWithProgressMeter.create(dsPath, outputDestination, this.overwriteOutputFile);
    }

    private void downloadAndValidateDataSources(String dataSourceType, Path dsPath, Path checksumPath) {
        logger.info(dataSourceType + " data sources selected.");
        NioFileCopierWithProgressMeter xerox = this.createNioDownloader(dsPath);
        NioFileCopierWithProgressMeterResults results = this.downloadDataSources(xerox, checksumPath);
        if (this.doValidateIntegrity) {
            this.validateIntegrity(results);
        }
        if (this.extractDataSourcesAfterDownload) {
            IOUtils.extractTarGz(results.getDestination(), results.getDestination().getParent(), this.overwriteOutputFile);
        } else {
            logger.info("IMPORTANT: You must unzip the downloaded data sources prior to using them with Funcotator.");
        }
    }

    private NioFileCopierWithProgressMeterResults downloadDataSources(NioFileCopierWithProgressMeter xerox, Path checksumPath) {
        if (this.doValidateIntegrity) {
            String expectedSha256Sum = this.readSha256SumFromPath(checksumPath);
            xerox.setChecksumAlgorithmAndExpectedChecksum("SHA-256", expectedSha256Sum);
        }
        return xerox.initiateCopy();
    }

    private void validateIntegrity(NioFileCopierWithProgressMeterResults results) {
        if (!results.isDestFileValid()) {
            throw new UserException("ERROR: downloaded data sources are corrupt!  Unexpected checksum: " + results.getChecksum() + " != " + results.getExpectedChecksum());
        }
        logger.info("Integrity check on downloaded data sources succeeded.");
    }

    private String readSha256SumFromPath(Path sha256Path) {
        String expectedSha256Sum;
        try {
            logger.info("Collecting expected checksum...");
            expectedSha256Sum = Files.lines(sha256Path).findFirst().orElse(null);
            if (expectedSha256Sum == null) {
                throw new UserException("Unable to retrieve expected checksum from: " + sha256Path.toUri());
            }
            logger.info("Collection complete!");
        }
        catch (IOException ex) {
            throw new UserException("Could not read in sha256sum from file: " + sha256Path.toUri().toString(), ex);
        }
        return this.cleanExpectedSha256SumString(expectedSha256Sum);
    }

    private Path getOutputLocation(Path dataSourcesPath) {
        if (this.outputFile == null) {
            return IOUtils.getPath(dataSourcesPath.getFileName().toString());
        }
        return this.outputFile.toPath();
    }

    private String cleanExpectedSha256SumString(String expectedSha256SumString) {
        String cleanString = expectedSha256SumString.trim().toLowerCase();
        if (cleanString.contains(" ")) {
            cleanString = cleanString.substring(0, cleanString.indexOf(" "));
        }
        if (cleanString.contains("\t")) {
            cleanString = cleanString.substring(0, cleanString.indexOf("\t"));
        }
        return cleanString;
    }
}

