/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.VariantFilter;
import org.broadinstitute.hellbender.engine.filters.VariantFilterLibrary;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.BaseFuncotatorArgumentCollection;
import org.broadinstitute.hellbender.tools.funcotator.DataSourceFuncotationFactory;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorArgumentDefinitions;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.OutputRenderer;
import org.broadinstitute.hellbender.tools.funcotator.compositeoutput.CompositeOutputRenderer;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.DataSourceUtils;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.genelistoutput.GeneListOutputRenderer;
import org.broadinstitute.hellbender.tools.funcotator.mafOutput.MafOutputRenderer;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadata;
import org.broadinstitute.hellbender.tools.funcotator.simpletsvoutput.SimpleTsvOutputRenderer;
import org.broadinstitute.hellbender.tools.funcotator.vcfOutput.VcfOutputRenderer;
import org.broadinstitute.hellbender.transformers.VariantTransformer;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public final class FuncotatorEngine
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(FuncotatorEngine.class);
    private static final String SIMPLE_TSV_SEG_FILE_CONFIG = "org/broadinstitute/hellbender/tools/funcotator/simple_funcotator_seg_file.config";
    @VisibleForTesting
    static final String GENE_LIST_FILE_SUFFIX = ".gene_list.txt";
    private final FuncotationMetadata inputMetadata;
    private final List<DataSourceFuncotationFactory> dataSourceFactories;
    private final BaseFuncotatorArgumentCollection funcotatorArgs;
    private final SAMSequenceDictionary sequenceDictionaryForDrivingVariants;
    private final boolean mustConvertInputContigsToHg19;
    private boolean onlyProducedIGRs = true;

    public FuncotatorEngine(BaseFuncotatorArgumentCollection funcotatorArgs, SAMSequenceDictionary sequenceDictionaryForDrivingVariants, FuncotationMetadata metadata, List<DataSourceFuncotationFactory> funcotationFactories) {
        this.sequenceDictionaryForDrivingVariants = sequenceDictionaryForDrivingVariants;
        this.funcotatorArgs = funcotatorArgs;
        this.inputMetadata = metadata;
        this.dataSourceFactories = funcotationFactories;
        this.dataSourceFactories.sort(DataSourceUtils::datasourceComparator);
        this.mustConvertInputContigsToHg19 = this.determineReferenceAndDatasourceCompatibility();
    }

    List<DataSourceFuncotationFactory> getFuncotationFactories() {
        return Collections.unmodifiableList(this.dataSourceFactories);
    }

    public FuncotationMap createFuncotationMapForVariant(VariantContext variantContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        Utils.nonNull(variantContext);
        Utils.nonNull(referenceContext);
        Utils.nonNull(featureContext);
        if (this.retrieveGencodeFuncotationFactoryStream().count() > 1L) {
            logger.warn("Attempting to annotate with more than one GENCODE datasource.  If these have overlapping transcript IDs, errors may occur.");
        }
        List<GencodeFuncotation> transcriptFuncotations = this.retrieveGencodeFuncotationFactoryStream().map(gf -> gf.createFuncotations(variantContext, referenceContext, featureContext)).flatMap(Collection::stream).map(f -> {
            GencodeFuncotation gf = (GencodeFuncotation)f;
            if (this.onlyProducedIGRs && gf.getVariantClassification() != GencodeFuncotation.VariantClassification.IGR) {
                this.onlyProducedIGRs = false;
            }
            return gf;
        }).collect(Collectors.toList());
        FuncotationMap funcotationMap = FuncotationMap.createFromGencodeFuncotations(transcriptFuncotations);
        for (DataSourceFuncotationFactory funcotationFactory : this.dataSourceFactories) {
            if (funcotationFactory.getType().equals((Object)FuncotatorArgumentDefinitions.DataSourceType.GENCODE)) continue;
            List<String> txIds = funcotationMap.getTranscriptList();
            for (String txId : txIds) {
                funcotationMap.add(txId, funcotationFactory.createFuncotations(variantContext, referenceContext, featureContext, funcotationMap.getGencodeFuncotations(txId)));
            }
        }
        List<String> txIds = funcotationMap.getTranscriptList();
        for (String txId : txIds) {
            funcotationMap.add(txId, FuncotatorUtils.createFuncotations(variantContext, this.inputMetadata, "INPUT_VCF"));
        }
        return funcotationMap;
    }

    FuncotationMap createFuncotationMapForSegment(VariantContext segmentAsVariantContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        Utils.nonNull(segmentAsVariantContext);
        Utils.nonNull(referenceContext);
        Utils.nonNull(featureContext);
        if (this.retrieveGencodeFuncotationFactoryStream().count() > 1L) {
            logger.error("Attempting to annotate with more than one GENCODE datasource.  If these have overlapping transcript IDs, errors may occur, so it has been disallowed.");
            throw new UserException.BadInput("Attempting to funcotate segments with more than one GENCODE datasource.  This is currently not supported.  Please post to the forum if you would like to see support for this.");
        }
        List<Funcotation> funcotations = this.dataSourceFactories.stream().filter(DataSourceFuncotationFactory::isSupportingSegmentFuncotation).map(ff -> ff.createFuncotations(segmentAsVariantContext, referenceContext, featureContext)).flatMap(Collection::stream).collect(Collectors.toList());
        return FuncotationMap.createNoTranscriptInfo(funcotations);
    }

    OutputRenderer createOutputRenderer(LinkedHashMap<String, String> annotationDefaultsMap, LinkedHashMap<String, String> annotationOverridesMap, VCFHeader headerForVariants, Set<VCFHeaderLine> defaultToolVcfHeaderLines, GATKTool gatkToolInstance) {
        OutputRenderer outputRenderer;
        LinkedHashMap<String, String> unaccountedForDefaultAnnotations = this.getUnaccountedForAnnotations(this.getFuncotationFactories(), annotationDefaultsMap);
        LinkedHashMap<String, String> unaccountedForOverrideAnnotations = this.getUnaccountedForAnnotations(this.getFuncotationFactories(), annotationOverridesMap);
        switch (this.funcotatorArgs.outputFormatType) {
            case MAF: {
                outputRenderer = new MafOutputRenderer(this.funcotatorArgs.outputFile.toPath(), this.getFuncotationFactories(), headerForVariants, unaccountedForDefaultAnnotations, unaccountedForOverrideAnnotations, defaultToolVcfHeaderLines.stream().map(Object::toString).collect(Collectors.toCollection(LinkedHashSet::new)), this.funcotatorArgs.referenceVersion, this.funcotatorArgs.excludedFields, gatkToolInstance.getVersion());
                break;
            }
            case VCF: {
                outputRenderer = new VcfOutputRenderer(gatkToolInstance.createVCFWriter(this.funcotatorArgs.outputFile), this.getFuncotationFactories(), headerForVariants, unaccountedForDefaultAnnotations, unaccountedForOverrideAnnotations, defaultToolVcfHeaderLines, this.funcotatorArgs.excludedFields, gatkToolInstance.getVersion());
                break;
            }
            case SEG: {
                outputRenderer = new CompositeOutputRenderer(Arrays.asList(SimpleTsvOutputRenderer.createFromResource(this.funcotatorArgs.outputFile.toPath(), unaccountedForDefaultAnnotations, unaccountedForOverrideAnnotations, this.funcotatorArgs.excludedFields, Paths.get(SIMPLE_TSV_SEG_FILE_CONFIG, new String[0]), gatkToolInstance.getVersion(), true), new GeneListOutputRenderer(new File(this.funcotatorArgs.outputFile.getAbsolutePath() + GENE_LIST_FILE_SUFFIX).toPath(), unaccountedForDefaultAnnotations, unaccountedForOverrideAnnotations, this.funcotatorArgs.excludedFields, gatkToolInstance.getVersion(), this.funcotatorArgs.minNumBasesForValidSegment)), gatkToolInstance.getVersion());
                break;
            }
            default: {
                throw new GATKException("Unsupported output format type specified: " + this.funcotatorArgs.outputFormatType.toString());
            }
        }
        return outputRenderer;
    }

    public static VariantFilter makeVariantFilter(boolean isRemovingFilteredVariants) {
        return isRemovingFilteredVariants ? VariantFilterLibrary.PASSES_FILTERS : VariantFilterLibrary.ALLOW_ALL_VARIANTS;
    }

    private VariantContext getCorrectVariantContextForReference(VariantContext variant) {
        if (this.mustConvertInputContigsToHg19) {
            VariantContextBuilder vcb = new VariantContextBuilder(variant);
            vcb.chr(FuncotatorUtils.convertB37ContigToHg19Contig(variant.getContig()));
            return vcb.make();
        }
        return variant;
    }

    public VariantTransformer getDefaultVariantTransformer() {
        return variantContext -> this.getCorrectVariantContextForReference((VariantContext)variantContext);
    }

    @Override
    public void close() {
        for (DataSourceFuncotationFactory factory : this.dataSourceFactories) {
            if (factory == null) continue;
            factory.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> processTranscriptList(Set<String> rawTranscriptSet) {
        if (rawTranscriptSet.size() != 1) return rawTranscriptSet;
        String filePathString = rawTranscriptSet.iterator().next();
        try (BufferedReader bufferedReader = Files.newBufferedReader(IOUtils.getPath(filePathString));){
            logger.info("Opened transcript file: " + filePathString);
            HashSet<String> transcriptIdSet = new HashSet<String>();
            String line = bufferedReader.readLine();
            while (line != null) {
                logger.info("    Adding transcript ID to transcript set: " + line);
                transcriptIdSet.add(line);
                line = bufferedReader.readLine();
            }
            logger.info("Transcript parsing complete.");
            HashSet<String> hashSet = transcriptIdSet;
            return hashSet;
        }
        catch (IOException ex) {
            logger.warn("Could not open transcript selection list as a file.  Using it as a singleton list of transcript IDs: [" + filePathString + "]");
            return rawTranscriptSet;
        }
    }

    public ReferenceContext getCorrectReferenceContext(VariantContext variant, ReferenceContext referenceContext) {
        ReferenceContext correctReferenceContext;
        if (this.mustConvertInputContigsToHg19) {
            SimpleInterval interval = new SimpleInterval(FuncotatorUtils.convertHG19ContigToB37Contig(variant.getContig()), variant.getStart(), variant.getEnd());
            correctReferenceContext = new ReferenceContext(referenceContext, interval);
        } else {
            correctReferenceContext = referenceContext;
        }
        return correctReferenceContext;
    }

    public boolean onlyProducedIGRs() {
        return this.onlyProducedIGRs;
    }

    private LinkedHashMap<String, String> getUnaccountedForAnnotations(List<DataSourceFuncotationFactory> dataSourceFactories, Map<String, String> annotationMap) {
        LinkedHashMap<String, String> outAnnotations = new LinkedHashMap<String, String>();
        for (String field : annotationMap.keySet()) {
            boolean accountedFor = false;
            for (DataSourceFuncotationFactory funcotationFactory : dataSourceFactories) {
                if (!funcotationFactory.getSupportedFuncotationFields().contains(field)) continue;
                accountedFor = true;
                break;
            }
            if (accountedFor) continue;
            outAnnotations.put(field, annotationMap.get(field));
        }
        return outAnnotations;
    }

    public static LinkedHashMap<String, String> splitAnnotationArgsIntoMap(List<String> annotationArgs) {
        LinkedHashMap<String, String> annotationMap = new LinkedHashMap<String, String>();
        for (String s : annotationArgs) {
            List keyVal = ParsingUtils.split((String)s, (char)':');
            if (keyVal.size() != 2) {
                throw new UserException.BadInput("Argument annotation incorrectly formatted: " + s);
            }
            annotationMap.put((String)keyVal.get(0), (String)keyVal.get(1));
        }
        return annotationMap;
    }

    private boolean determineReferenceAndDatasourceCompatibility() {
        boolean mustConvertInputContigsToHg19 = false;
        if (this.funcotatorArgs.forceB37ToHg19ContigNameConversion) {
            logger.info("Forcing B37 -> HG19 Variant conversion.");
            mustConvertInputContigsToHg19 = true;
        } else if (this.funcotatorArgs.referenceVersion.equals("hg19") && FuncotatorUtils.isSequenceDictionaryUsingB37Reference(this.sequenceDictionaryForDrivingVariants)) {
            logger.info("VCF sequence dictionary detected as B37 in HG19 annotation mode.  Performing conversion.");
            mustConvertInputContigsToHg19 = true;
        } else {
            logger.info("Using given VCF and Reference.  No conversion required.");
        }
        if (mustConvertInputContigsToHg19) {
            logger.warn("WARNING: You are using B37 as a reference.  Funcotator will convert your variants to GRCh37, and this will be fine in the vast majority of cases.  There MAY be some errors (e.g. in the Y chromosome, but possibly in other places as well) due to changes between the two references.");
        }
        return mustConvertInputContigsToHg19;
    }

    private Stream<DataSourceFuncotationFactory> retrieveGencodeFuncotationFactoryStream() {
        return this.dataSourceFactories.stream().filter(f -> f.getType().equals((Object)FuncotatorArgumentDefinitions.DataSourceType.GENCODE));
    }
}

