/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.tribble.annotation.Strand;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.AminoAcid;
import org.broadinstitute.hellbender.tools.funcotator.AnnotatedIntervalToSegmentVariantContextConverter;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.tools.funcotator.SequenceComparison;
import org.broadinstitute.hellbender.tools.funcotator.StrandCorrectedReferenceBases;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadata;
import org.broadinstitute.hellbender.tools.spark.sv.discovery.SimpleSVType;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.reference.ReferenceUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public final class FuncotatorUtils {
    private static final Logger logger = LogManager.getLogger(FuncotatorUtils.class);
    public static final int DEFAULT_MIN_NUM_BASES_FOR_VALID_SEGMENT = 150;
    private static final Map<String, AminoAcid> tableByCodon;
    private static final Map<String, AminoAcid> tableByCode;
    private static final Map<String, AminoAcid> tableByLetter;
    private static final Map<String, AminoAcid> mtDifferentAaTableByCodon;
    private static final Map<Pair<Genus, String>, AminoAcid> mtSpecialStartCodonsBySpecies;
    private static SAMSequenceDictionary B37_SEQUENCE_DICTIONARY;
    private static final Map<String, String> B37_To_HG19_CONTIG_NAME_MAP;
    private static final Map<String, String> HG19_TO_B37_CONTIG_NAME_MAP;
    private static final String CODON_CHANGE_FORMAT_STRING = "c.(%d-%d)%s";
    private static final String PROTEIN_CHANGE_FORMAT_STRING = "p.%s%s%s%s";
    private static final String CDNA_CHANGE_FORMAT_STRING = "c.%s%s%s%s";

    private FuncotatorUtils() {
    }

    public static AminoAcid getEukaryoticAminoAcidByCodon(String codon) {
        if (codon == null) {
            return null;
        }
        return tableByCodon.get(codon.toUpperCase());
    }

    public static AminoAcid getMitochondrialAminoAcidByCodon(String rawCodon) {
        return FuncotatorUtils.getMitochondrialAminoAcidByCodon(rawCodon, false, Genus.UNSPECIFIED);
    }

    public static AminoAcid getMitochondrialAminoAcidByCodon(String rawCodon, boolean isFirst, Genus genus) {
        if (rawCodon == null) {
            return null;
        }
        String upperCodon = rawCodon.replaceAll("[Uu]", "T").toUpperCase();
        if (isFirst && mtSpecialStartCodonsBySpecies.containsKey(Pair.of((Object)((Object)genus), (Object)upperCodon))) {
            return mtSpecialStartCodonsBySpecies.get(Pair.of((Object)((Object)genus), (Object)upperCodon));
        }
        if (mtDifferentAaTableByCodon.containsKey(upperCodon)) {
            return mtDifferentAaTableByCodon.get(upperCodon);
        }
        return tableByCodon.get(upperCodon);
    }

    public static AminoAcid getAminoAcidByLetter(String letter) {
        if (letter == null) {
            return null;
        }
        return tableByLetter.get(letter);
    }

    public static AminoAcid getAminoAcidByLetter(char letter) {
        return tableByLetter.get(String.valueOf(letter));
    }

    public static String[] getAminoAcidNames() {
        String[] names = new String[AminoAcid.values().length];
        for (AminoAcid acid : AminoAcid.values()) {
            names[acid.ordinal()] = acid.getName();
        }
        return names;
    }

    public static String[] getAminoAcidCodes() {
        String[] codes = new String[AminoAcid.values().length];
        for (AminoAcid acid : AminoAcid.values()) {
            codes[acid.ordinal()] = acid.getCode();
        }
        return codes;
    }

    public static boolean isPositionInFrame(int position) {
        ParamUtils.isPositive(position, "Genomic positions start at 1.");
        return (position - 1) % 3 == 0;
    }

    public static int getIndelAdjustedAlleleChangeStartPosition(VariantContext variant) {
        return FuncotatorUtils.getIndelAdjustedAlleleChangeStartPosition(variant, variant.getAlternateAllele(0));
    }

    public static int getIndelAdjustedAlleleChangeStartPosition(VariantContext variant, Allele altAllele) {
        int varStart;
        if (GATKVariantContextUtils.typeOfVariant(variant.getReference(), altAllele).equals((Object)VariantContext.Type.INDEL) && !GATKVariantContextUtils.isComplexIndel(variant.getReference(), altAllele)) {
            int startOffset;
            for (startOffset = 0; startOffset < variant.getReference().length() && startOffset < altAllele.length() && variant.getReference().getBases()[startOffset] == altAllele.getBases()[startOffset]; ++startOffset) {
            }
            varStart = variant.getStart() + startOffset;
        } else {
            varStart = variant.getStart();
        }
        return varStart;
    }

    public static String getNonOverlappingAltAlleleBaseString(Allele firstAllele, Allele secondAllele, boolean copyRefBasesWhenAltIsPastEnd) {
        StringBuilder sb = new StringBuilder();
        int noBase = 120;
        int maxAlleleLength = Math.max(firstAllele.length(), secondAllele.length());
        boolean havePassedOverlapAlready = false;
        if (firstAllele.getBases()[0] != secondAllele.getBases()[0]) {
            for (int i = 0; i < maxAlleleLength; ++i) {
                int firstAlleleBase = 120;
                char secondAlleleBase = 'x';
                if (firstAllele.length() - 1 - i >= 0) {
                    firstAlleleBase = firstAllele.getBaseString().charAt(firstAllele.length() - 1 - i);
                }
                if (secondAllele.length() - 1 - i >= 0) {
                    secondAlleleBase = secondAllele.getBaseString().charAt(secondAllele.length() - 1 - i);
                }
                if (secondAlleleBase == 'x') {
                    if (!copyRefBasesWhenAltIsPastEnd) break;
                    sb.append(firstAllele.getBaseString().substring(0, firstAllele.length() - i));
                    break;
                }
                if (havePassedOverlapAlready && secondAlleleBase == firstAlleleBase) {
                    sb.append(secondAllele.getBaseString().substring(0, secondAllele.length() - i));
                    break;
                }
                if (secondAlleleBase == firstAlleleBase) continue;
                sb.append(secondAlleleBase);
                havePassedOverlapAlready = true;
            }
            sb.reverse();
        } else {
            for (int i = 0; i < maxAlleleLength; ++i) {
                int firstAlleleBase = 120;
                char secondAlleleBase = 'x';
                if (i < firstAllele.length()) {
                    firstAlleleBase = firstAllele.getBaseString().charAt(i);
                }
                if (i < secondAllele.length()) {
                    secondAlleleBase = secondAllele.getBaseString().charAt(i);
                }
                if (secondAlleleBase == 'x') {
                    if (!copyRefBasesWhenAltIsPastEnd) break;
                    sb.append(firstAllele.getBaseString().substring(i));
                    break;
                }
                if (havePassedOverlapAlready && secondAlleleBase == firstAlleleBase) {
                    sb.append(secondAllele.getBaseString().substring(i));
                    break;
                }
                if (secondAlleleBase == firstAlleleBase) continue;
                sb.append(secondAlleleBase);
                havePassedOverlapAlready = true;
            }
        }
        return sb.toString();
    }

    public static int getStartPositionInTranscript(Locatable variant, List<? extends Locatable> transcript, Strand strand) {
        Utils.nonNull(variant);
        Utils.nonNull(transcript);
        FuncotatorUtils.assertValidStrand(strand);
        int position = 1;
        boolean foundPosition = false;
        SimpleInterval variantStartLocus = strand == Strand.POSITIVE ? new SimpleInterval(variant.getContig(), variant.getStart(), variant.getStart()) : new SimpleInterval(variant.getContig(), variant.getEnd(), variant.getEnd());
        if (!transcript.stream().allMatch(exon -> exon.getContig().equals(variantStartLocus.getContig()))) {
            throw new GATKException("Variant and transcript contigs are not equal.");
        }
        for (Locatable locatable : transcript) {
            if (new SimpleInterval(locatable).contains(variantStartLocus)) {
                position = strand == Strand.POSITIVE ? (position += variantStartLocus.getStart() - locatable.getStart()) : (position += locatable.getEnd() - variantStartLocus.getStart());
                foundPosition = true;
                break;
            }
            position += locatable.getEnd() - locatable.getStart() + 1;
        }
        if (foundPosition) {
            return position;
        }
        return -1;
    }

    public static int getAlignedEndPosition(int alleleEndPosition) {
        ParamUtils.isPositive(alleleEndPosition, "Genomic positions must be > 0.");
        return (int)(Math.ceil((double)alleleEndPosition / 3.0) * 3.0);
    }

    public static int getAlignedPosition(int position) {
        if (position > 0) {
            return position - (position - 1) % 3;
        }
        int adjustedPos = 1 - position;
        return -(adjustedPos - (adjustedPos - 1) % 3 + 1);
    }

    public static boolean isInFrameWithEndOfRegion(int startPosition, int regionLength) {
        ParamUtils.isPositiveOrZero(regionLength, "Region length must be >= 0.");
        if (startPosition > 0) {
            return (regionLength - startPosition + 1) % 3 == 0;
        }
        int preFlankOffset = 1 - startPosition;
        return (regionLength + preFlankOffset - (startPosition + preFlankOffset) + 1) % 3 == 0;
    }

    public static boolean isIndelBetweenCodons(int codingSequenceAlleleStart, int alignedCodingSequenceAlleleStart, String refAllele, Strand strand) {
        Utils.nonNull(refAllele);
        FuncotatorUtils.assertValidStrand(strand);
        if (strand == Strand.POSITIVE) {
            int codonOffset = codingSequenceAlleleStart - alignedCodingSequenceAlleleStart;
            return (codonOffset + refAllele.length()) % 3 == 0;
        }
        return codingSequenceAlleleStart == alignedCodingSequenceAlleleStart;
    }

    private static String createCapitalizedAlternateAlleleInsertionCodonChangeString(String alignedAlternateCodingSequenceAllele, String alternateAllele, int startingOffset) {
        StringBuilder sb = new StringBuilder();
        int newStartingOffset = startingOffset + 1;
        int i = 0;
        while (i < newStartingOffset) {
            sb.append(Character.toLowerCase(alignedAlternateCodingSequenceAllele.charAt(i++)));
        }
        while (i - newStartingOffset < alternateAllele.length() - 1) {
            sb.append(Character.toUpperCase(alignedAlternateCodingSequenceAllele.charAt(i++)));
        }
        while (i < alignedAlternateCodingSequenceAllele.length()) {
            sb.append(Character.toLowerCase(alignedAlternateCodingSequenceAllele.charAt(i++)));
        }
        return sb.toString();
    }

    public static String getCodonChangeString(SequenceComparison seqComp, Locatable startCodon) {
        Utils.nonNull(seqComp.getAlignedCodingSequenceAlleleStart());
        Utils.nonNull(seqComp.getAlignedReferenceAlleleStop());
        Utils.nonNull(seqComp.getReferenceAllele());
        Utils.nonNull(seqComp.getAlignedCodingSequenceReferenceAllele());
        Utils.nonNull(seqComp.getAlternateAllele());
        Utils.nonNull(seqComp.getAlignedCodingSequenceAlternateAllele());
        Utils.nonNull(seqComp.getCodingSequenceAlleleStart());
        FuncotatorUtils.assertValidStrand(seqComp.getStrand());
        if (GATKVariantContextUtils.isXnp(seqComp.getAlignedCodingSequenceReferenceAllele(), seqComp.getAlignedCodingSequenceAlternateAllele())) {
            return FuncotatorUtils.getCodonChangeStringForOnp(seqComp.getAlignedCodingSequenceReferenceAllele(), seqComp.getAlignedCodingSequenceAlternateAllele(), seqComp.getAlignedCodingSequenceAlleleStart(), seqComp.getAlignedReferenceAlleleStop());
        }
        boolean indelIsBetweenCodons = FuncotatorUtils.isIndelBetweenCodons(seqComp.getCodingSequenceAlleleStart(), seqComp.getAlignedCodingSequenceAlleleStart(), seqComp.getReferenceAllele(), seqComp.getStrand());
        boolean isInsertion = GATKVariantContextUtils.isInsertion(seqComp.getAlignedCodingSequenceReferenceAllele(), seqComp.getAlignedCodingSequenceAlternateAllele());
        int alignedCodonStart = seqComp.getAlignedCodingSequenceAlleleStart();
        int alignedCodonEnd = seqComp.getAlignedCodingSequenceAlleleStart() + seqComp.getAlignedCodingSequenceReferenceAllele().length() - 1;
        String refCodon = seqComp.getAlignedCodingSequenceReferenceAllele().toLowerCase();
        if (FuncotatorUtils.isStartCodonIndel(seqComp, startCodon)) {
            return "";
        }
        if (GATKVariantContextUtils.isFrameshift(seqComp.getAlignedCodingSequenceReferenceAllele(), seqComp.getAlignedCodingSequenceAlternateAllele())) {
            return FuncotatorUtils.getCodonChangeStringForFrameShifts(seqComp, isInsertion, alignedCodonStart, alignedCodonEnd, refCodon);
        }
        if (isInsertion) {
            return FuncotatorUtils.getCodonChangeStringForInsertion(seqComp, indelIsBetweenCodons, alignedCodonStart, alignedCodonEnd, refCodon);
        }
        return FuncotatorUtils.getCodonChangeStringForDeletion(seqComp, indelIsBetweenCodons, alignedCodonStart, alignedCodonEnd, refCodon);
    }

    private static String getCodonChangeStringForDeletion(SequenceComparison seqComp, boolean indelIsBetweenCodons, int alignedCodonStart, int alignedCodonEnd, String refCodon) {
        if (indelIsBetweenCodons) {
            if (seqComp.getStrand() == Strand.POSITIVE) {
                alignedCodonStart += 3;
                refCodon = refCodon.substring(3);
            } else {
                alignedCodonEnd -= 3;
                refCodon = refCodon.substring(0, refCodon.length() - 3);
            }
            return String.format(CODON_CHANGE_FORMAT_STRING, alignedCodonStart, alignedCodonEnd, refCodon + "del");
        }
        return String.format(CODON_CHANGE_FORMAT_STRING, alignedCodonStart, alignedCodonEnd, refCodon + ">" + seqComp.getAlignedCodingSequenceAlternateAllele().toLowerCase());
    }

    private static String getCodonChangeStringForInsertion(SequenceComparison seqComp, boolean indelIsBetweenCodons, int alignedCodonStart, int alignedCodonEnd, String refCodon) {
        if (indelIsBetweenCodons) {
            String adjacentRefCodon = FuncotatorUtils.getAdjacentReferenceCodon(seqComp.getTranscriptCodingSequence(), seqComp.getAlignedCodingSequenceAlleleStart(), seqComp.getAlignedReferenceAlleleStop(), seqComp.getStrand());
            if (adjacentRefCodon.isEmpty()) {
                String capitalizedAltString = FuncotatorUtils.createCapitalizedAlternateAlleleInsertionCodonChangeString(seqComp.getAlignedCodingSequenceAlternateAllele(), seqComp.getAlternateAllele(), seqComp.getCodingSequenceAlleleStart() - seqComp.getAlignedCodingSequenceAlleleStart() - (seqComp.getStrand() == Strand.POSITIVE ? 0 : 1));
                return String.format(CODON_CHANGE_FORMAT_STRING, seqComp.getAlignedCodingSequenceAlleleStart(), seqComp.getAlignedCodingSequenceAlleleStart() + seqComp.getAlignedCodingSequenceReferenceAllele().length() - 1, seqComp.getAlignedCodingSequenceReferenceAllele().toLowerCase() + ">" + capitalizedAltString);
            }
            if (seqComp.getStrand() == Strand.POSITIVE) {
                String nextRefCodon = adjacentRefCodon;
                return String.format(CODON_CHANGE_FORMAT_STRING, seqComp.getAlignedCodingSequenceAlleleStart() + 3, seqComp.getAlignedCodingSequenceAlleleStart() + 3 + 2, nextRefCodon.toLowerCase() + ">" + seqComp.getAlignedAlternateAllele().substring(3) + nextRefCodon.toLowerCase());
            }
            String prevRefCodon = adjacentRefCodon;
            String altCodon = seqComp.getAlignedAlternateAllele().substring(0, seqComp.getAlignedAlternateAllele().length() - 3);
            return String.format(CODON_CHANGE_FORMAT_STRING, alignedCodonStart -= 3, alignedCodonEnd, prevRefCodon.toLowerCase() + refCodon.toLowerCase() + ">" + prevRefCodon.toLowerCase() + altCodon.toUpperCase() + refCodon.toLowerCase());
        }
        String capitalizedAltString = FuncotatorUtils.createCapitalizedAlternateAlleleInsertionCodonChangeString(seqComp.getAlignedCodingSequenceAlternateAllele(), seqComp.getAlternateAllele(), seqComp.getCodingSequenceAlleleStart() - seqComp.getAlignedCodingSequenceAlleleStart() - (seqComp.getStrand() == Strand.POSITIVE ? 0 : 1));
        return String.format(CODON_CHANGE_FORMAT_STRING, alignedCodonStart, alignedCodonEnd, refCodon + ">" + capitalizedAltString);
    }

    private static String getCodonChangeStringForFrameShifts(SequenceComparison seqComp, boolean isInsertion, int alignedCodonStart, int alignedCodonEnd, String refCodon) {
        if (seqComp.getCodingSequenceAlleleStart() % 3 == 0) {
            if (isInsertion) {
                if (seqComp.getStrand() == Strand.POSITIVE) {
                    refCodon = seqComp.getTranscriptCodingSequence().getBaseString().substring((alignedCodonStart += 3) - 1, alignedCodonEnd += 3).toLowerCase();
                }
            } else if (seqComp.getStrand() == Strand.POSITIVE) {
                alignedCodonStart += 3;
                refCodon = refCodon.substring(3);
            } else {
                alignedCodonEnd -= 3;
                refCodon = refCodon.substring(0, refCodon.length() - 3);
            }
        }
        return String.format(CODON_CHANGE_FORMAT_STRING, alignedCodonStart, alignedCodonEnd, refCodon + "fs");
    }

    private static boolean isStartCodonIndel(SequenceComparison seqComp, Locatable startCodon) {
        SimpleInterval variantInterval;
        return startCodon != null && GATKVariantContextUtils.isIndel(seqComp.getReferenceAllele(), seqComp.getAlternateAllele()) && startCodon.overlaps((Locatable)(variantInterval = new SimpleInterval(seqComp.getContig(), seqComp.getAlleleStart() + 1, seqComp.getAlleleStart() + seqComp.getReferenceAllele().length())));
    }

    private static String getCodonChangeStringForOnp(String alignedRefAllele, String alignedAltAllele, int alignedCodingSequenceAlleleStart, int alignedReferenceAlleleStop) {
        StringBuilder ref = new StringBuilder();
        StringBuilder alt = new StringBuilder();
        for (int i = 0; i < alignedRefAllele.length(); ++i) {
            if (alignedRefAllele.charAt(i) != alignedAltAllele.charAt(i)) {
                ref.append(Character.toUpperCase(alignedRefAllele.charAt(i)));
                alt.append(Character.toUpperCase(alignedAltAllele.charAt(i)));
                continue;
            }
            char c = Character.toLowerCase(alignedRefAllele.charAt(i));
            ref.append(c);
            alt.append(c);
        }
        if (alignedCodingSequenceAlleleStart == alignedReferenceAlleleStop) {
            return "c.(" + alignedCodingSequenceAlleleStart + ")" + ref.toString() + ">" + alt.toString();
        }
        return "c.(" + alignedCodingSequenceAlleleStart + "-" + alignedReferenceAlleleStop + ")" + ref.toString() + ">" + alt.toString();
    }

    private static String getAdjacentReferenceCodon(ReferenceSequence referenceSequence, int currentAlignedCodingSequenceAlleleStart, int currentAlignedCodingSequenceAlleleStop, Strand strand) {
        int endex;
        Utils.nonNull(referenceSequence);
        ParamUtils.isPositive(currentAlignedCodingSequenceAlleleStart, "Genomic positions must be > 0.");
        ParamUtils.isPositive(currentAlignedCodingSequenceAlleleStop, "Genomic positions must be > 0.");
        FuncotatorUtils.assertValidStrand(strand);
        String nextRefCodon = strand == Strand.POSITIVE ? ((endex = currentAlignedCodingSequenceAlleleStop + 3) >= referenceSequence.getBaseString().length() ? "" : referenceSequence.getBaseString().substring(currentAlignedCodingSequenceAlleleStop, endex)) : (currentAlignedCodingSequenceAlleleStart == 1 ? "" : referenceSequence.getBaseString().substring(currentAlignedCodingSequenceAlleleStart - 1 - 3, currentAlignedCodingSequenceAlleleStart - 1));
        return nextRefCodon;
    }

    public static String createSpliceSiteCodonChange(int variantStart, int exonNumber, int exonStart, int exonEnd, Strand strand, int offsetIndelAdjustment) {
        ParamUtils.isPositive(variantStart, "Genomic positions must be > 0.");
        ParamUtils.isPositive(exonNumber, "Exon number must be > 0.");
        ParamUtils.isPositive(exonStart, "Genomic positions must be > 0.");
        ParamUtils.isPositive(exonEnd, "Genomic positions must be > 0.");
        FuncotatorUtils.assertValidStrand(strand);
        char sign = '-';
        int offset = exonStart - variantStart;
        if (Math.abs(offset) > Math.abs(variantStart - exonEnd)) {
            offset = variantStart - exonEnd;
            sign = '+';
        }
        offset = Math.abs(offset);
        if (strand == Strand.NEGATIVE) {
            sign = sign == '+' ? (char)'-' : '+';
        }
        offset = sign == '+' ? (offset += offsetIndelAdjustment) : (offset -= offsetIndelAdjustment);
        if (offset < 0) {
            offset *= -1;
            sign = sign == '+' ? (char)'-' : '+';
        }
        return "c.e" + exonNumber + sign + offset;
    }

    public static String renderProteinChangeString(SequenceComparison seqComp, Locatable startCodon) {
        Utils.nonNull(seqComp.getProteinChangeInfo());
        Utils.nonNull(seqComp.getReferenceAllele());
        Utils.nonNull(seqComp.getAlternateAllele());
        if (GATKVariantContextUtils.isIndel(seqComp.getReferenceAllele(), seqComp.getAlternateAllele())) {
            Utils.nonNull(seqComp.getAlleleStart());
        }
        String refAaSeq = seqComp.getProteinChangeInfo().getRefAaSeq();
        String altAaSeq = seqComp.getProteinChangeInfo().getAltAaSeq();
        int protChangeStartPos = seqComp.getProteinChangeInfo().getAaStartPos();
        int protChangeEndPos = seqComp.getProteinChangeInfo().getAaEndPos();
        if (FuncotatorUtils.isStartCodonIndel(seqComp, startCodon)) {
            return "";
        }
        if (GATKVariantContextUtils.isFrameshift(seqComp.getReferenceAllele(), seqComp.getAlternateAllele())) {
            return String.format(PROTEIN_CHANGE_FORMAT_STRING, "", refAaSeq, protChangeStartPos, "fs");
        }
        if (GATKVariantContextUtils.isInsertion(seqComp.getReferenceAllele(), seqComp.getAlternateAllele())) {
            if (protChangeStartPos == protChangeEndPos) {
                return String.format(PROTEIN_CHANGE_FORMAT_STRING, "", refAaSeq, protChangeStartPos, altAaSeq);
            }
            if (refAaSeq.isEmpty()) {
                return String.format(PROTEIN_CHANGE_FORMAT_STRING, "", protChangeStartPos + "_" + protChangeEndPos, "ins", altAaSeq);
            }
            return String.format(PROTEIN_CHANGE_FORMAT_STRING, protChangeStartPos + "_" + protChangeEndPos, refAaSeq, ">", altAaSeq);
        }
        if (GATKVariantContextUtils.isDeletion(seqComp.getReferenceAllele(), seqComp.getAlternateAllele())) {
            if (protChangeStartPos != protChangeEndPos) {
                return String.format(PROTEIN_CHANGE_FORMAT_STRING, protChangeStartPos + "_" + protChangeEndPos, refAaSeq, ">", altAaSeq);
            }
            return String.format(PROTEIN_CHANGE_FORMAT_STRING, "", refAaSeq, protChangeStartPos, "del");
        }
        if (protChangeStartPos != protChangeEndPos) {
            return String.format(PROTEIN_CHANGE_FORMAT_STRING, protChangeStartPos + "_" + protChangeEndPos, refAaSeq, ">", altAaSeq);
        }
        return String.format(PROTEIN_CHANGE_FORMAT_STRING, "", refAaSeq, protChangeStartPos, altAaSeq);
    }

    public static String getCodingSequenceChangeString(int codingSequenceAlleleStart, String refAllele, String altAllele, Strand strand, Integer exonStartPosition, Integer exonEndPosition, Integer alleleStart) {
        Utils.nonNull(refAllele);
        Utils.nonNull(altAllele);
        FuncotatorUtils.assertValidStrand(strand);
        if (GATKVariantContextUtils.isXnp(refAllele, altAllele)) {
            if (altAllele.length() > 1) {
                return String.format(CDNA_CHANGE_FORMAT_STRING, codingSequenceAlleleStart + "_" + (codingSequenceAlleleStart + refAllele.length() - 1), refAllele, ">", altAllele);
            }
            return String.format(CDNA_CHANGE_FORMAT_STRING, codingSequenceAlleleStart, refAllele, ">", altAllele);
        }
        if (GATKVariantContextUtils.isInsertion(refAllele, altAllele)) {
            if (strand == Strand.NEGATIVE) {
                return String.format(CDNA_CHANGE_FORMAT_STRING, codingSequenceAlleleStart - 1 + "_" + codingSequenceAlleleStart, "", "ins", altAllele.substring(0, altAllele.length() - 1).toUpperCase());
            }
            return String.format(CDNA_CHANGE_FORMAT_STRING, codingSequenceAlleleStart + "_" + (codingSequenceAlleleStart + 1), "", "ins", altAllele.substring(refAllele.length()).toUpperCase());
        }
        int start = codingSequenceAlleleStart + altAllele.length();
        int end = codingSequenceAlleleStart + refAllele.length() - 1;
        String deletedBases = refAllele.substring(altAllele.length()).toUpperCase();
        if (strand == Strand.NEGATIVE) {
            --start;
            --end;
            deletedBases = refAllele.substring(0, refAllele.length() - 1).toUpperCase();
        }
        if (exonStartPosition != null && exonEndPosition != null) {
            int cdsExonStart = codingSequenceAlleleStart - (alleleStart - exonStartPosition);
            int cdsExonEnd = cdsExonStart + (exonEndPosition - exonStartPosition);
            if (start < cdsExonStart) {
                start = cdsExonStart;
            }
            if (end > cdsExonEnd) {
                end = cdsExonEnd;
            }
        }
        String endBoundString = start == end ? "" : "_" + end;
        return String.format(CDNA_CHANGE_FORMAT_STRING, start + endBoundString, "", "del", deletedBases);
    }

    static String createAminoAcidSequence(String codingSequence, boolean isFrameshift, String extraLoggingInfo) {
        return FuncotatorUtils.createAminoAcidSequenceHelper(codingSequence, isFrameshift, false, extraLoggingInfo);
    }

    static String createMitochondrialAminoAcidSequence(String codingSequence, boolean isFrameshift, String extraLoggingInfo) {
        return FuncotatorUtils.createAminoAcidSequenceHelper(codingSequence, isFrameshift, true, extraLoggingInfo);
    }

    private static String createAminoAcidSequenceHelper(String codingSequence, boolean isFrameshift, boolean isMitochondria, String extraLoggingInfo) {
        Utils.nonNull(codingSequence);
        StringBuilder sb = new StringBuilder();
        int maxIndex = codingSequence.length();
        if (maxIndex % 3 != 0) {
            maxIndex = (int)Math.floor(maxIndex / 3) * 3;
            if (!isFrameshift) {
                logger.warn("createAminoAcidSequence given a coding sequence of length not divisible by 3.  Dropping bases from the end: " + codingSequence.length() % 3 + (extraLoggingInfo.isEmpty() ? "" : " " + extraLoggingInfo));
            }
        }
        Function<String, AminoAcid> aminoAcidLookupFunction = isMitochondria ? FuncotatorUtils::getMitochondrialAminoAcidByCodon : FuncotatorUtils::getEukaryoticAminoAcidByCodon;
        for (int i = 0; i < maxIndex; i += 3) {
            AminoAcid aa = aminoAcidLookupFunction.apply(codingSequence.substring(i, i + 3));
            if (aa == null) {
                throw new UserException.MalformedFile("File contains a bad codon sequence that has no amino acid equivalent: " + codingSequence.substring(i, i + 3));
            }
            sb.append(aa.getLetter());
        }
        return sb.toString();
    }

    private static String getAlignedAlleleSequence(String codingSequence, Integer alignedAlleleStart, Integer alignedAlleleStop, Strand strand) {
        String alignedAlleleSeq;
        Utils.nonNull(codingSequence);
        Utils.nonNull(alignedAlleleStart);
        ParamUtils.isPositive(alignedAlleleStart, "Genome positions must be > 0.");
        Utils.nonNull(alignedAlleleStop);
        ParamUtils.isPositive(alignedAlleleStop, "Genome positions must be > 0.");
        FuncotatorUtils.assertValidStrand(strand);
        int start = alignedAlleleStart - 1;
        int end = alignedAlleleStop;
        if (strand == Strand.POSITIVE) {
            if (end > codingSequence.length()) {
                throw new TranscriptCodingSequenceException("Gencode transcript ends at position " + end + " but codingSequence is only " + codingSequence.length() + " bases long!");
            }
            alignedAlleleSeq = codingSequence.substring(start, end);
        } else {
            start = codingSequence.length() - alignedAlleleStop;
            end = codingSequence.length() - alignedAlleleStart + 1;
            if (end > codingSequence.length()) {
                throw new TranscriptCodingSequenceException("Gencode transcript ends at position " + end + " but codingSequence is only " + codingSequence.length() + " bases long!");
            }
            alignedAlleleSeq = ReadUtils.getBasesReverseComplement(codingSequence.substring(start, end).getBytes());
        }
        return alignedAlleleSeq;
    }

    public static String getAlignedCodingSequenceAllele(String codingSequence, Integer alignedAlleleStart, Integer alignedAlleleStop, Allele refAllele, Integer refAlleleStart, Strand strand) {
        String expectedReferenceSequence;
        Utils.nonNull(codingSequence);
        Utils.nonNull(alignedAlleleStart);
        ParamUtils.isPositive(alignedAlleleStart, "Genome positions must be > 0.");
        Utils.nonNull(alignedAlleleStop);
        ParamUtils.isPositive(alignedAlleleStop, "Genome positions must be > 0.");
        Utils.nonNull(refAllele);
        Utils.nonNull(refAlleleStart);
        ParamUtils.isPositive(refAlleleStart, "Genome positions must be > 0.");
        FuncotatorUtils.assertValidStrand(strand);
        String alignedAlleleSeq = FuncotatorUtils.getAlignedAlleleSequence(codingSequence, alignedAlleleStart, alignedAlleleStop, strand);
        if (strand == Strand.POSITIVE) {
            expectedReferenceSequence = codingSequence.substring(refAlleleStart - 1, refAlleleStart - 1 + refAllele.length());
        } else {
            int start = codingSequence.length() - (refAlleleStart - 1 + refAllele.length());
            int end = codingSequence.length() - refAlleleStart;
            expectedReferenceSequence = ReadUtils.getBasesReverseComplement(codingSequence.substring(start, end).getBytes());
        }
        if (!expectedReferenceSequence.equals(refAllele.getBaseString())) {
            String substitutedAlignedSeq = FuncotatorUtils.getAlternateSequence(new StrandCorrectedReferenceBases(codingSequence, strand), refAlleleStart, refAllele, refAllele, strand);
            String substitutedAlignedAlleleSeq = FuncotatorUtils.getAlignedAlleleSequence(substitutedAlignedSeq, alignedAlleleStart, alignedAlleleStop, Strand.POSITIVE);
            logger.warn("Reference allele differs from reference coding sequence (strand: " + strand + ") (Allele " + expectedReferenceSequence + " != " + refAllele.getBaseString() + " coding sequence)!  Substituting given allele for sequence code (" + alignedAlleleSeq + "->" + substitutedAlignedAlleleSeq + ")");
            alignedAlleleSeq = substitutedAlignedAlleleSeq;
        }
        return alignedAlleleSeq;
    }

    public static String getAlignedRefAllele(StrandCorrectedReferenceBases referenceSnippet, int referencePadding, Allele refAllele, Allele altAllele, int codingSequenceRefAlleleStart, int alignedRefAlleleStart, Strand strand, Locatable variantGenomicPositionForLogging) {
        Utils.nonNull(referenceSnippet);
        Utils.nonNull(refAllele);
        Utils.nonNull(altAllele);
        ParamUtils.isPositiveOrZero(referencePadding, "Padding must be >= 0.");
        Utils.nonNull(variantGenomicPositionForLogging);
        FuncotatorUtils.assertValidStrand(strand);
        Utils.validate(alignedRefAlleleStart <= codingSequenceRefAlleleStart, "The alignedRefAlleleStart must be less than or equal to codingSequenceRefAlleleStart!");
        int referenceLength = refAllele.length();
        int extraBasesNeededForCodonAlignment = codingSequenceRefAlleleStart - alignedRefAlleleStart;
        int indelAdjustment = GATKVariantContextUtils.isIndel(refAllele, altAllele) ? 1 : 0;
        boolean negativeDeletionAdjustment = altAllele.length() < refAllele.length() && strand == Strand.NEGATIVE;
        int refStartAlignedIndex = strand == Strand.NEGATIVE ? referencePadding - extraBasesNeededForCodonAlignment : referencePadding - extraBasesNeededForCodonAlignment - indelAdjustment;
        if (refStartAlignedIndex < 0) {
            refStartAlignedIndex = 0;
        }
        int refEndPosExclusive = refStartAlignedIndex + (int)(Math.ceil((double)(extraBasesNeededForCodonAlignment + refAllele.length()) / 3.0) * 3.0);
        String alignedReferenceAllele = referenceSnippet.getBaseString().substring(refStartAlignedIndex, refEndPosExclusive);
        String computedReferenceAlleleWithSubstitution = alignedReferenceAllele.substring(extraBasesNeededForCodonAlignment, extraBasesNeededForCodonAlignment + refAllele.length());
        if (!computedReferenceAlleleWithSubstitution.equals(refAllele.getBaseString())) {
            String substitutedReferenceSnippet = FuncotatorUtils.getAlternateSequence(referenceSnippet, referencePadding + 1, refAllele, refAllele, strand);
            refEndPosExclusive = refStartAlignedIndex + (int)(Math.ceil((double)(extraBasesNeededForCodonAlignment + refAllele.length()) / 3.0) * 3.0);
            String substitutedAlignedAlleleSeq = substitutedReferenceSnippet.substring(refStartAlignedIndex, refEndPosExclusive);
            String positionString = '[' + variantGenomicPositionForLogging.getContig() + ":" + variantGenomicPositionForLogging.getStart() + ']';
            logger.warn("Reference allele is different than the reference coding sequence (strand: " + strand + ", alt = " + altAllele.getBaseString() + ", ref " + refAllele.getBaseString() + " != " + computedReferenceAlleleWithSubstitution + " reference coding seq) @" + positionString + "!  Substituting given allele for sequence code (" + alignedReferenceAllele + "->" + substitutedAlignedAlleleSeq + ")");
            alignedReferenceAllele = substitutedAlignedAlleleSeq;
        }
        return alignedReferenceAllele;
    }

    public static StrandCorrectedReferenceBases createReferenceSnippet(Allele refAllele, Allele altAllele, ReferenceContext reference, Strand strand, int referenceWindow) {
        Utils.validate(reference.numWindowLeadingBases() == reference.numWindowTrailingBases() && reference.numWindowLeadingBases() == 0, "Reference must have no extra bases around the variant.  Found: " + reference.numWindowLeadingBases() + " before / + " + reference.numWindowTrailingBases() + " + after");
        int indelStartBaseAdjustment = GATKVariantContextUtils.isIndel(refAllele, altAllele) ? 1 : 0;
        int start = reference.getWindow().getStart() - referenceWindow + indelStartBaseAdjustment;
        int end = reference.getWindow().getEnd() + referenceWindow;
        SimpleInterval refBasesInterval = new SimpleInterval(reference.getWindow().getContig(), start, end);
        byte[] referenceBases = reference.getBases(refBasesInterval);
        if (strand == Strand.POSITIVE) {
            return new StrandCorrectedReferenceBases(referenceBases, strand);
        }
        return new StrandCorrectedReferenceBases(ReadUtils.getBasesReverseComplement(referenceBases), strand);
    }

    public static StrandCorrectedReferenceBases getBasesInWindowAroundReferenceAllele(Allele refAllele, ReferenceContext referenceContext, Strand strand, int referenceWindowInBases) {
        return FuncotatorUtils.createReferenceSnippet(refAllele, refAllele, referenceContext, strand, referenceWindowInBases);
    }

    public static int getProteinChangePosition(Integer alignedCodingSequenceAlleleStart) {
        Utils.nonNull(alignedCodingSequenceAlleleStart);
        ParamUtils.isPositive(alignedCodingSequenceAlleleStart, "Genome positions must be > 0.");
        return (alignedCodingSequenceAlleleStart - 1) / 3 + 1;
    }

    public static int getProteinChangeEndPosition(Integer proteinChangeStartPosition, Integer alignedAlternateAlleleLength) {
        Utils.nonNull(proteinChangeStartPosition);
        Utils.nonNull(alignedAlternateAlleleLength);
        ParamUtils.isPositive(proteinChangeStartPosition, "Genome positions must be > 0.");
        ParamUtils.isPositive(alignedAlternateAlleleLength, "Allele length > 0.");
        return proteinChangeStartPosition + FuncotatorUtils.getProteinChangePosition(alignedAlternateAlleleLength) - 1;
    }

    public static String getAlternateSequence(StrandCorrectedReferenceBases referenceSequence, int alleleStartPos, Allele refAllele, Allele altAllele, Strand strand) {
        Utils.nonNull(referenceSequence);
        Utils.nonNull(refAllele);
        Utils.nonNull(altAllele);
        ParamUtils.isPositive(alleleStartPos, "Genome positions must be > 0.");
        int alleleIndex = Math.abs(alleleStartPos - 1);
        return referenceSequence.getBaseString().substring(0, alleleIndex) + altAllele.getBaseString() + referenceSequence.getBaseString().substring(alleleIndex + refAllele.length());
    }

    public static int getTranscriptAlleleStartPosition(VariantContext variant, List<? extends Locatable> exons, Strand strand) {
        int position;
        List sortedFilteredExons;
        Utils.nonNull(variant);
        Utils.nonNull(exons);
        FuncotatorUtils.assertValidStrand(strand);
        if (strand == Strand.POSITIVE) {
            sortedFilteredExons = exons.stream().filter(e -> e.getStart() <= variant.getStart()).sorted(Comparator.comparingInt(Locatable::getStart)).collect(Collectors.toList());
            position = variant.getStart() - ((Locatable)sortedFilteredExons.get(sortedFilteredExons.size() - 1)).getStart() + 1;
        } else {
            sortedFilteredExons = exons.stream().filter(e -> e.getEnd() >= variant.getStart()).sorted(Comparator.comparingInt(Locatable::getStart).reversed()).collect(Collectors.toList());
            position = ((Locatable)sortedFilteredExons.get(sortedFilteredExons.size() - 1)).getEnd() - variant.getStart() + 1;
        }
        int numExonsBeforeLast = sortedFilteredExons.size() - 1;
        for (int i = 0; i < numExonsBeforeLast; ++i) {
            Locatable exon = (Locatable)sortedFilteredExons.get(i);
            position += exon.getEnd() - exon.getStart() + 1;
        }
        return position;
    }

    @Deprecated
    public static String getCodingSequence(ReferenceContext reference, List<? extends Locatable> exonList, Strand strand) {
        Utils.nonNull(reference);
        Utils.nonNull(exonList);
        FuncotatorUtils.assertValidStrand(strand);
        if (exonList.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        exonList.sort((lhs, rhs) -> lhs.getStart() < rhs.getStart() ? -1 : (lhs.getStart() > rhs.getStart() ? 1 : 0));
        for (Locatable locatable : exonList) {
            if (!locatable.getContig().equals(reference.getWindow().getContig())) {
                throw new GATKException("Cannot create a coding sequence! Contigs not the same - Ref: " + reference.getInterval().getContig() + ", Exon: " + locatable.getContig());
            }
            if (start > locatable.getStart()) {
                start = locatable.getStart();
            }
            if (end >= locatable.getEnd()) continue;
            end = locatable.getEnd();
        }
        SimpleInterval refWindow = reference.getWindow();
        byte[] byArray = reference.getBases(Math.abs(start - reference.getInterval().getStart()), Math.abs(reference.getInterval().getEnd() - end));
        if (strand == Strand.NEGATIVE) {
            for (int i = 0; i < byArray.length / 2; ++i) {
                byte by = SequenceUtil.complement((byte)byArray[i]);
                byArray[i] = SequenceUtil.complement((byte)byArray[byArray.length - 1 - i]);
                byArray[byArray.length - 1 - i] = by;
            }
        }
        for (Locatable locatable : exonList) {
            int exonStartArrayCoord = locatable.getStart() - refWindow.getStart() - 1;
            if (exonStartArrayCoord == -1) {
                exonStartArrayCoord = 0;
            }
            int exonEndArrayCoord = exonStartArrayCoord + (locatable.getEnd() - locatable.getStart()) + 1;
            sb.append(new String(Arrays.copyOfRange(byArray, exonStartArrayCoord, exonEndArrayCoord)));
        }
        return sb.toString();
    }

    public static boolean isSequenceDictionaryUsingB37Reference(SAMSequenceDictionary sequenceDictionary) {
        if (sequenceDictionary == null) {
            return false;
        }
        if (B37_SEQUENCE_DICTIONARY == null) {
            B37_SEQUENCE_DICTIONARY = FuncotatorUtils.initializeB37SequenceDict();
        }
        for (SAMSequenceRecord b37SequenceRecord : B37_SEQUENCE_DICTIONARY.getSequences()) {
            SAMSequenceRecord inputSequenceRecord = sequenceDictionary.getSequence(b37SequenceRecord.getSequenceName());
            if (inputSequenceRecord == null) {
                return false;
            }
            if (inputSequenceRecord.getSequenceLength() != b37SequenceRecord.getSequenceLength()) {
                return false;
            }
            if (inputSequenceRecord.getMd5() == null || inputSequenceRecord.getMd5().equals(b37SequenceRecord.getMd5())) continue;
            return false;
        }
        return true;
    }

    public static String convertB37ContigToHg19Contig(String b37Contig) {
        return B37_To_HG19_CONTIG_NAME_MAP.getOrDefault(b37Contig, b37Contig);
    }

    public static String convertHG19ContigToB37Contig(String hg19Contig) {
        return HG19_TO_B37_CONTIG_NAME_MAP.getOrDefault(hg19Contig, hg19Contig);
    }

    public static String createIntronicCDnaString(int variantStart, List<? extends Locatable> exonList, String strandCorrectedRefAllele, String strandCorrectedAltAllele) {
        Utils.nonNull(exonList);
        Utils.nonNull(strandCorrectedRefAllele);
        Utils.nonNull(strandCorrectedAltAllele);
        int exonIndex = FuncotatorUtils.getClosestExonIndex(variantStart, exonList);
        if (exonIndex != -1) {
            Locatable closestExon = exonList.get(exonIndex);
            int startDiff = variantStart - closestExon.getStart();
            int endDiff = variantStart - closestExon.getEnd();
            int exonOffset = Math.abs(startDiff) <= Math.abs(endDiff) ? startDiff : endDiff;
            return "c.e" + (exonIndex + 1) + (exonOffset < 0 ? "-" : "+") + Math.abs(exonOffset) + strandCorrectedRefAllele + ">" + strandCorrectedAltAllele;
        }
        return "NA";
    }

    public static int getClosestExonIndex(int variantStartPos, List<? extends Locatable> exonList) {
        Utils.nonNull(exonList);
        int exonIndex = -1;
        int distFromVariant = Integer.MAX_VALUE;
        for (int i = 0; i < exonList.size(); ++i) {
            for (int exonPos : Arrays.asList(exonList.get(i).getStart(), exonList.get(i).getEnd())) {
                int dist = Math.abs(variantStartPos - exonPos);
                if (dist >= distFromVariant) continue;
                exonIndex = i;
                distFromVariant = dist;
            }
        }
        return exonIndex;
    }

    public static SimpleInterval getOverlappingExonPositions(Allele refAllele, Allele altAllele, String contig, int variantStart, int variantEnd, Strand strand, List<? extends Locatable> exonPositionList) {
        Utils.nonNull(refAllele);
        Utils.nonNull(altAllele);
        Utils.nonNull(contig);
        Utils.nonNull(exonPositionList);
        FuncotatorUtils.assertValidStrand(strand);
        ParamUtils.isPositive(variantStart, "Genome positions must be > 0.");
        ParamUtils.isPositive(variantEnd, "Genome positions must be > 0.");
        int alleleStart = variantStart;
        int alleleEnd = variantEnd;
        if (refAllele.length() > refAllele.length()) {
            int lengthAdjustment = refAllele.length() - altAllele.length();
            if (strand == Strand.NEGATIVE) {
                alleleStart -= lengthAdjustment;
            } else {
                alleleEnd += lengthAdjustment;
            }
        }
        SimpleInterval variantInterval = new SimpleInterval(contig, alleleStart, alleleEnd);
        int exonStart = -1;
        int exonStop = -1;
        for (Locatable locatable : exonPositionList) {
            if (!variantInterval.overlaps(locatable)) continue;
            exonStart = locatable.getStart();
            exonStop = locatable.getEnd();
        }
        if (exonStart == -1) {
            return null;
        }
        return new SimpleInterval(contig, exonStart, exonStop);
    }

    public static void assertValidStrand(Strand strand) {
        Utils.nonNull(strand);
        if (strand == Strand.NONE) {
            throw new GATKException("Unable to handle NONE strand.");
        }
    }

    public static Allele getStrandCorrectedAllele(Allele allele, Strand strand) {
        FuncotatorUtils.assertValidStrand(strand);
        if (strand == Strand.POSITIVE) {
            return Allele.create((Allele)allele, (boolean)false);
        }
        return Allele.create((String)ReadUtils.getBasesReverseComplement(allele.getBases()), (boolean)false);
    }

    private static final Map<String, String> initializeB37ToHg19ContigNameMap() {
        HashMap<String, String> b37ToHg19ContigNameMap = new HashMap<String, String>();
        b37ToHg19ContigNameMap.put("1", "chr1");
        b37ToHg19ContigNameMap.put("2", "chr2");
        b37ToHg19ContigNameMap.put("3", "chr3");
        b37ToHg19ContigNameMap.put("4", "chr4");
        b37ToHg19ContigNameMap.put("5", "chr5");
        b37ToHg19ContigNameMap.put("6", "chr6");
        b37ToHg19ContigNameMap.put("7", "chr7");
        b37ToHg19ContigNameMap.put("8", "chr8");
        b37ToHg19ContigNameMap.put("9", "chr9");
        b37ToHg19ContigNameMap.put("10", "chr10");
        b37ToHg19ContigNameMap.put("11", "chr11");
        b37ToHg19ContigNameMap.put("12", "chr12");
        b37ToHg19ContigNameMap.put("13", "chr13");
        b37ToHg19ContigNameMap.put("14", "chr14");
        b37ToHg19ContigNameMap.put("15", "chr15");
        b37ToHg19ContigNameMap.put("16", "chr16");
        b37ToHg19ContigNameMap.put("17", "chr17");
        b37ToHg19ContigNameMap.put("18", "chr18");
        b37ToHg19ContigNameMap.put("19", "chr19");
        b37ToHg19ContigNameMap.put("20", "chr20");
        b37ToHg19ContigNameMap.put("21", "chr21");
        b37ToHg19ContigNameMap.put("22", "chr22");
        b37ToHg19ContigNameMap.put("X", "chrX");
        b37ToHg19ContigNameMap.put("Y", "chrY");
        b37ToHg19ContigNameMap.put("MT", "chrM");
        b37ToHg19ContigNameMap.put("GL000202.1", "GL000202.1");
        b37ToHg19ContigNameMap.put("GL000244.1", "GL000244.1");
        b37ToHg19ContigNameMap.put("GL000235.1", "GL000235.1");
        b37ToHg19ContigNameMap.put("GL000238.1", "GL000238.1");
        b37ToHg19ContigNameMap.put("GL000226.1", "GL000226.1");
        b37ToHg19ContigNameMap.put("GL000218.1", "GL000218.1");
        b37ToHg19ContigNameMap.put("GL000249.1", "GL000249.1");
        b37ToHg19ContigNameMap.put("GL000242.1", "GL000242.1");
        b37ToHg19ContigNameMap.put("GL000221.1", "GL000221.1");
        b37ToHg19ContigNameMap.put("GL000192.1", "GL000192.1");
        b37ToHg19ContigNameMap.put("GL000223.1", "GL000223.1");
        b37ToHg19ContigNameMap.put("GL000232.1", "GL000232.1");
        b37ToHg19ContigNameMap.put("GL000206.1", "GL000206.1");
        b37ToHg19ContigNameMap.put("GL000240.1", "GL000240.1");
        b37ToHg19ContigNameMap.put("GL000214.1", "GL000214.1");
        b37ToHg19ContigNameMap.put("GL000212.1", "GL000212.1");
        b37ToHg19ContigNameMap.put("GL000199.1", "GL000199.1");
        b37ToHg19ContigNameMap.put("GL000248.1", "GL000248.1");
        b37ToHg19ContigNameMap.put("GL000195.1", "GL000195.1");
        b37ToHg19ContigNameMap.put("GL000215.1", "GL000215.1");
        b37ToHg19ContigNameMap.put("GL000225.1", "GL000225.1");
        b37ToHg19ContigNameMap.put("GL000216.1", "GL000216.1");
        b37ToHg19ContigNameMap.put("GL000194.1", "GL000194.1");
        b37ToHg19ContigNameMap.put("GL000217.1", "GL000217.1");
        b37ToHg19ContigNameMap.put("GL000197.1", "GL000197.1");
        b37ToHg19ContigNameMap.put("GL000222.1", "GL000222.1");
        b37ToHg19ContigNameMap.put("GL000200.1", "GL000200.1");
        b37ToHg19ContigNameMap.put("GL000211.1", "GL000211.1");
        b37ToHg19ContigNameMap.put("GL000247.1", "GL000247.1");
        b37ToHg19ContigNameMap.put("GL000233.1", "GL000233.1");
        b37ToHg19ContigNameMap.put("GL000210.1", "GL000210.1");
        b37ToHg19ContigNameMap.put("GL000198.1", "GL000198.1");
        b37ToHg19ContigNameMap.put("GL000245.1", "GL000245.1");
        b37ToHg19ContigNameMap.put("GL000234.1", "GL000234.1");
        b37ToHg19ContigNameMap.put("GL000203.1", "GL000203.1");
        b37ToHg19ContigNameMap.put("GL000239.1", "GL000239.1");
        b37ToHg19ContigNameMap.put("GL000213.1", "GL000213.1");
        b37ToHg19ContigNameMap.put("GL000227.1", "GL000227.1");
        b37ToHg19ContigNameMap.put("GL000208.1", "GL000208.1");
        b37ToHg19ContigNameMap.put("GL000230.1", "GL000230.1");
        b37ToHg19ContigNameMap.put("GL000231.1", "GL000231.1");
        b37ToHg19ContigNameMap.put("GL000228.1", "GL000228.1");
        b37ToHg19ContigNameMap.put("GL000243.1", "GL000243.1");
        b37ToHg19ContigNameMap.put("GL000229.1", "GL000229.1");
        b37ToHg19ContigNameMap.put("GL000205.1", "GL000205.1");
        b37ToHg19ContigNameMap.put("GL000224.1", "GL000224.1");
        b37ToHg19ContigNameMap.put("GL000191.1", "GL000191.1");
        b37ToHg19ContigNameMap.put("GL000196.1", "GL000196.1");
        b37ToHg19ContigNameMap.put("GL000193.1", "GL000193.1");
        b37ToHg19ContigNameMap.put("GL000201.1", "GL000201.1");
        b37ToHg19ContigNameMap.put("GL000237.1", "GL000237.1");
        b37ToHg19ContigNameMap.put("GL000246.1", "GL000246.1");
        b37ToHg19ContigNameMap.put("GL000241.1", "GL000241.1");
        b37ToHg19ContigNameMap.put("GL000204.1", "GL000204.1");
        b37ToHg19ContigNameMap.put("GL000207.1", "GL000207.1");
        b37ToHg19ContigNameMap.put("GL000209.1", "GL000209.1");
        b37ToHg19ContigNameMap.put("GL000219.1", "GL000219.1");
        b37ToHg19ContigNameMap.put("GL000220.1", "GL000220.1");
        b37ToHg19ContigNameMap.put("GL000236.1", "GL000236.1");
        return b37ToHg19ContigNameMap;
    }

    private static final synchronized SAMSequenceDictionary initializeB37SequenceDict() {
        if (B37_SEQUENCE_DICTIONARY == null) {
            try {
                File b37SeqDictFile = Resource.getResourceContentsAsFile("org/broadinstitute/hellbender/tools/funcotator/Homo_sapiens_assembly19.dict");
                return ReferenceUtils.loadFastaDictionary(b37SeqDictFile);
            }
            catch (IOException ex) {
                throw new GATKException("Unable to load b37 dict from jar resources due to IO Exception!", ex);
            }
        }
        return B37_SEQUENCE_DICTIONARY;
    }

    public static boolean isFuncotationInTranscriptList(GencodeFuncotation funcotation, Set<String> acceptableTranscripts) {
        if (funcotation.getAnnotationTranscript() != null) {
            List acceptableTranscriptsWithoutVersionNumbers = acceptableTranscripts.stream().map(FuncotatorUtils::getTranscriptIdWithoutVersionNumber).collect(Collectors.toList());
            return acceptableTranscriptsWithoutVersionNumbers.contains(FuncotatorUtils.getTranscriptIdWithoutVersionNumber(funcotation.getAnnotationTranscript()));
        }
        return false;
    }

    public static String getTranscriptIdWithoutVersionNumber(String transcriptId) {
        return transcriptId.replaceAll("\\.\\d+$", "");
    }

    public static Configuration retrieveConfiguration(File configFile) {
        IOUtils.assertFileIsReadable(configFile.toPath());
        try {
            return new Configurations().properties(configFile);
        }
        catch (ConfigurationException ce) {
            throw new UserException.BadInput("Unable to read from XSV config file: " + configFile.toString(), ce);
        }
    }

    public static boolean isSegmentVariantContext(VariantContext vc, int minSizeForSegment) {
        Utils.nonNull(vc);
        List ACCEPTABLE_ALT_ALLELES = Stream.concat(Stream.of(SimpleSVType.SupportedType.values()).map(s -> SimpleSVType.createBracketedSymbAlleleString(s.toString())), Stream.of(AnnotatedIntervalToSegmentVariantContextConverter.COPY_NEUTRAL_ALLELE.getDisplayString(), "<*>")).collect(Collectors.toList());
        boolean acceptableAlternateAllele = false;
        for (Allele a : vc.getAlternateAlleles()) {
            String representation = a.getDisplayString();
            if (!ACCEPTABLE_ALT_ALLELES.contains(representation)) continue;
            acceptableAlternateAllele = true;
        }
        return acceptableAlternateAllele && VariantContextUtils.getSize((VariantContext)vc) > minSizeForSegment;
    }

    public static String[] extractFuncotatorKeysFromHeaderDescription(String funcotationHeaderDescription) {
        Utils.nonNull(funcotationHeaderDescription);
        String[] descriptionSplit = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)funcotationHeaderDescription, (String)": ");
        return StringUtils.splitByWholeSeparatorPreserveAllTokens((String)descriptionSplit[1], (String)"|");
    }

    static String sanitizeFuncotationFieldForVcf(String individualFuncotationField) {
        Utils.nonNull(individualFuncotationField);
        List<String> badLetters = Arrays.asList(",", ";", "=", "\t", "|", " ", "\n", "#");
        List<String> cleanLetters = badLetters.stream().map(s -> "_%" + String.format("%02X", s.getBytes(StandardCharsets.US_ASCII)[0]) + "_").collect(Collectors.toList());
        return StringUtils.replaceEach((String)individualFuncotationField, (String[])badLetters.toArray(new String[0]), (String[])cleanLetters.toArray(new String[0]));
    }

    public static String sanitizeFuncotationFieldForMaf(String individualFuncotationField) {
        Utils.nonNull(individualFuncotationField);
        return StringUtils.replaceEach((String)individualFuncotationField, (String[])new String[]{"\t", "\n"}, (String[])new String[]{"_%09_", "_%0A_"});
    }

    public static Map<Allele, FuncotationMap> createAlleleToFuncotationMapFromFuncotationVcfAttribute(String[] funcotationHeaderKeys, VariantContext v, String transcriptIdFuncotationName, String dummyDatasourceName) {
        Utils.nonNull(funcotationHeaderKeys);
        Utils.nonNull(v);
        Utils.nonNull(transcriptIdFuncotationName);
        Utils.nonNull(dummyDatasourceName);
        List funcotationPerAllele = v.getAttributeAsList("FUNCOTATION").stream().map(Object::toString).collect(Collectors.toList());
        if (v.getAlternateAlleles().size() != funcotationPerAllele.size()) {
            throw new GATKException.ShouldNeverReachHereException("Could not parse FUNCOTATION field properly.");
        }
        return IntStream.range(0, v.getAlternateAlleles().size()).boxed().collect(Collectors.toMap(arg_0 -> ((VariantContext)v).getAlternateAllele(arg_0), i -> FuncotationMap.createAsAllTableFuncotationsFromVcf(transcriptIdFuncotationName, funcotationHeaderKeys, (String)funcotationPerAllele.get((int)i), v.getAlternateAllele(i.intValue()), dummyDatasourceName)));
    }

    public static boolean isGencodeFuncotation(Funcotation f) {
        Utils.nonNull(f);
        return f instanceof GencodeFuncotation;
    }

    public static boolean areAnyGencodeFuncotation(List<Funcotation> funcotations) {
        return funcotations.stream().anyMatch(FuncotatorUtils::isGencodeFuncotation);
    }

    public static List<Funcotation> createFuncotations(VariantContext vc, FuncotationMetadata metadata, String datasourceName) {
        Utils.nonNull(vc);
        Utils.nonNull(metadata);
        Utils.nonNull(datasourceName);
        List allFields = metadata.retrieveAllHeaderInfo().stream().map(VCFCompoundHeaderLine::getID).collect(Collectors.toList());
        Set attributesNotInMetadata = vc.getAttributes().keySet().stream().filter(k -> !allFields.contains(k)).collect(Collectors.toSet());
        if (attributesNotInMetadata.size() != 0) {
            throw new UserException.MalformedFile("Not all attributes in the variant context appear in the metadata: " + attributesNotInMetadata.stream().collect(Collectors.joining(", ")) + " .... Please add these attributes to the input metadata (e.g. VCF Header).");
        }
        return FuncotatorUtils.createFuncotationsFromMetadata(vc, metadata, datasourceName);
    }

    static List<Funcotation> createFuncotationsFromMetadata(VariantContext vc, FuncotationMetadata metadata, String datasourceName) {
        Utils.nonNull(vc);
        Utils.nonNull(metadata);
        Utils.nonNull(datasourceName);
        List<String> fields = metadata.retrieveAllHeaderInfo().stream().map(VCFCompoundHeaderLine::getID).collect(Collectors.toList());
        ArrayList<Funcotation> result = new ArrayList<Funcotation>();
        for (Allele allele : vc.getAlternateAlleles()) {
            ArrayList<String> funcotationFieldValues = new ArrayList<String>();
            for (String funcotationFieldName : fields) {
                funcotationFieldValues.add(vc.getAttributeAsString(funcotationFieldName, ""));
            }
            result.add(TableFuncotation.create(fields, funcotationFieldValues, allele, datasourceName, metadata));
        }
        return result;
    }

    public static String renderSanitizedFuncotationForVcf(Funcotation funcotation, List<String> includedFields) {
        Utils.nonNull(funcotation);
        Utils.nonNull(includedFields);
        if (includedFields.size() == 0) {
            return "";
        }
        return funcotation.getFieldNames().stream().filter(includedFields::contains).map(field -> FuncotatorUtils.sanitizeFuncotationFieldForVcf(funcotation.getField((String)field))).collect(Collectors.joining("|"));
    }

    public static <T, U> LinkedHashMap<T, U> createLinkedHashMapFromLists(List<T> keys, List<U> values) {
        Utils.nonNull(keys);
        Utils.nonNull(values);
        Utils.validateArg(keys.size() == values.size(), "Keys and values were not the same length.");
        return IntStream.range(0, keys.size()).boxed().collect(Collectors.toMap(keys::get, values::get, (x1, x2) -> {
            throw new IllegalArgumentException("Should not be able to have duplicate field names.");
        }, LinkedHashMap::new));
    }

    static {
        B37_SEQUENCE_DICTIONARY = null;
        HashMap<String, AminoAcid> mapByCodon = new HashMap<String, AminoAcid>(AminoAcid.values().length);
        HashMap<String, AminoAcid> mapByLetter = new HashMap<String, AminoAcid>(AminoAcid.values().length);
        HashMap<String, AminoAcid> mapByCode = new HashMap<String, AminoAcid>(AminoAcid.values().length);
        for (AminoAcid acid : AminoAcid.values()) {
            mapByCode.put(acid.getCode(), acid);
            mapByLetter.put(acid.getLetter(), acid);
            for (String codon : acid.getCodons()) {
                mapByCodon.put(codon, acid);
            }
        }
        HashMap<String, AminoAcid> mtCodons = new HashMap<String, AminoAcid>();
        HashMap<Pair, AminoAcid> mtSpecialStarts = new HashMap<Pair, AminoAcid>();
        mtCodons.put("ATA", AminoAcid.METHIONINE);
        mtCodons.put("AGA", AminoAcid.STOP_CODON);
        mtCodons.put("AGG", AminoAcid.STOP_CODON);
        mtCodons.put("TGA", AminoAcid.TRYPTOPHAN);
        mtSpecialStarts.put(Pair.of((Object)((Object)Genus.BOS), (Object)"ATA"), AminoAcid.METHIONINE);
        mtSpecialStarts.put(Pair.of((Object)((Object)Genus.HOMO), (Object)"ATT"), AminoAcid.METHIONINE);
        mtSpecialStarts.put(Pair.of((Object)((Object)Genus.MUS), (Object)"ATT"), AminoAcid.METHIONINE);
        mtSpecialStarts.put(Pair.of((Object)((Object)Genus.MUS), (Object)"ATC"), AminoAcid.METHIONINE);
        mtSpecialStarts.put(Pair.of((Object)((Object)Genus.CORTURNIX), (Object)"GTG"), AminoAcid.METHIONINE);
        mtSpecialStarts.put(Pair.of((Object)((Object)Genus.GALLUS), (Object)"GTG"), AminoAcid.METHIONINE);
        tableByCodon = Collections.unmodifiableMap(mapByCodon);
        tableByCode = Collections.unmodifiableMap(mapByCode);
        tableByLetter = Collections.unmodifiableMap(mapByLetter);
        mtDifferentAaTableByCodon = Collections.unmodifiableMap(mtCodons);
        mtSpecialStartCodonsBySpecies = Collections.unmodifiableMap(mtSpecialStarts);
        B37_To_HG19_CONTIG_NAME_MAP = FuncotatorUtils.initializeB37ToHg19ContigNameMap();
        HG19_TO_B37_CONTIG_NAME_MAP = B37_To_HG19_CONTIG_NAME_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static enum Genus {
        BOS,
        HOMO,
        MUS,
        CORTURNIX,
        GALLUS,
        UNSPECIFIED;

    }

    public static class TranscriptCodingSequenceException
    extends GATKException {
        private static final long serialVersionUID = 1L;

        public TranscriptCodingSequenceException(String msg) {
            super(msg);
        }

        public TranscriptCodingSequenceException(String msg, Throwable throwable) {
            super(msg, throwable);
        }
    }
}

