/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.funcotator.DataSourceFuncotationFactory;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadata;
import org.broadinstitute.hellbender.tools.funcotator.metadata.VcfFuncotationMetadata;
import org.broadinstitute.hellbender.utils.Utils;

public abstract class OutputRenderer
implements AutoCloseable {
    protected LinkedHashMap<String, String> manualAnnotations;
    protected List<DataSourceFuncotationFactory> dataSourceFactories;
    protected final String toolVersion;

    public OutputRenderer(String toolVersion) {
        this.toolVersion = Utils.nonNull(toolVersion);
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public String getDataSourceInfoString() {
        return this.dataSourceFactories.stream().map(DataSourceFuncotationFactory::getInfoString).collect(Collectors.joining(" | "));
    }

    @Override
    public abstract void close();

    public abstract void write(VariantContext var1, FuncotationMap var2);

    public static Funcotation createFuncotationFromLinkedHashMap(LinkedHashMap<String, String> data, Allele altAllele, String datasourceName) {
        Utils.nonNull(data);
        Utils.nonNull(altAllele);
        Utils.nonNull(datasourceName);
        List<VCFInfoHeaderLine> manualAnnotationHeaderLines = data.entrySet().stream().map(e -> new VCFInfoHeaderLine((String)e.getKey(), 1, VCFHeaderLineType.String, "Specified from map: " + (String)e.getKey() + ":" + (String)e.getValue())).collect(Collectors.toList());
        return TableFuncotation.create(data, altAllele, datasourceName, (FuncotationMetadata)VcfFuncotationMetadata.create(manualAnnotationHeaderLines));
    }
}

