/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import htsjdk.tribble.annotation.Strand;
import htsjdk.variant.variantcontext.Allele;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public final class ProteinChangeInfo {
    private int aaStartPos;
    private int aaEndPos;
    private String refAaSeq;
    private String altAaSeq;

    private ProteinChangeInfo(int aaStartPos, int aaEndPos, String refAaSeq, String altAaSeq) {
        this.aaStartPos = aaStartPos;
        this.aaEndPos = aaEndPos;
        this.refAaSeq = refAaSeq;
        this.altAaSeq = altAaSeq;
    }

    private ProteinChangeInfo(Allele refAllele, Allele altAllele, int codingSequenceAlleleStart, int alignedCodingSequenceAlleleStart, String codingSequence, Strand strand, boolean isMitochondria) {
        boolean isFrameshift = GATKVariantContextUtils.isFrameshift(refAllele, altAllele);
        Pair<String, String> proteinSequences = this.createProteinSequences(refAllele, altAllele, codingSequenceAlleleStart, codingSequence, isFrameshift, isMitochondria);
        String referenceProteinSequence = (String)proteinSequences.getLeft();
        String alternateProteinSequence = (String)proteinSequences.getRight();
        int proteinChangeStartIndex = (alignedCodingSequenceAlleleStart - 1) / 3;
        int maxProteinSequenceLength = Math.max(referenceProteinSequence.length(), alternateProteinSequence.length());
        for (int i = 0; i < maxProteinSequenceLength; ++i) {
            if (i < referenceProteinSequence.length() && i < alternateProteinSequence.length() && referenceProteinSequence.charAt(i) == alternateProteinSequence.charAt(i)) continue;
            proteinChangeStartIndex = i;
            break;
        }
        boolean indelIsBetweenCodons = FuncotatorUtils.isIndelBetweenCodons(codingSequenceAlleleStart, alignedCodingSequenceAlleleStart, refAllele.getBaseString(), strand);
        int numAltAminoAcids = (int)Math.ceil((double)(altAllele.length() - 1) / 3.0);
        int numRefAminoAcids = (int)Math.ceil((double)(refAllele.length() - 1) / 3.0);
        if (isFrameshift) {
            this.initializeForFrameshift(referenceProteinSequence, proteinChangeStartIndex);
        } else if (GATKVariantContextUtils.isInsertion(refAllele, altAllele)) {
            this.initializeForInsertion(alignedCodingSequenceAlleleStart, strand, referenceProteinSequence, alternateProteinSequence, proteinChangeStartIndex, indelIsBetweenCodons, numAltAminoAcids, numRefAminoAcids);
        } else if (GATKVariantContextUtils.isDeletion(refAllele, altAllele)) {
            this.initializeForDeletion(alignedCodingSequenceAlleleStart, strand, referenceProteinSequence, alternateProteinSequence, indelIsBetweenCodons, numAltAminoAcids, numRefAminoAcids);
        } else {
            this.initializeForOnp(referenceProteinSequence, alternateProteinSequence, proteinChangeStartIndex);
        }
    }

    private Pair<String, String> createProteinSequences(Allele refAllele, Allele altAllele, int codingSequenceAlleleStart, String codingSequence, boolean isFrameshift, boolean isMitochondria) {
        String alternateProteinSequence;
        String referenceProteinSequence;
        if (isMitochondria) {
            referenceProteinSequence = FuncotatorUtils.createMitochondrialAminoAcidSequence(codingSequence, false, "(size=" + codingSequence.length() + ", ref allele: " + refAllele.getBaseString() + ")");
            alternateProteinSequence = FuncotatorUtils.createMitochondrialAminoAcidSequence(codingSequence.substring(0, codingSequenceAlleleStart - 1) + altAllele.getBaseString() + codingSequence.substring(codingSequenceAlleleStart + refAllele.length() - 1), isFrameshift, "(size=" + codingSequence.length() + ", alt allele: " + altAllele.getBaseString() + ")");
        } else {
            referenceProteinSequence = FuncotatorUtils.createAminoAcidSequence(codingSequence, false, "(size=" + codingSequence.length() + ", ref allele: " + refAllele.getBaseString() + ")");
            alternateProteinSequence = FuncotatorUtils.createAminoAcidSequence(codingSequence.substring(0, codingSequenceAlleleStart - 1) + altAllele.getBaseString() + codingSequence.substring(codingSequenceAlleleStart + refAllele.length() - 1), isFrameshift, "(size=" + codingSequence.length() + ", alt allele: " + altAllele.getBaseString() + ")");
        }
        return Pair.of((Object)referenceProteinSequence, (Object)alternateProteinSequence);
    }

    private void initializeForOnp(String referenceProteinSequence, String alternateProteinSequence, int proteinChangeStartIndex) {
        int i;
        for (i = proteinChangeStartIndex; i < referenceProteinSequence.length() && i < alternateProteinSequence.length() && referenceProteinSequence.charAt(i) != alternateProteinSequence.charAt(i); ++i) {
        }
        int proteinChangeEndIndex = i;
        if (proteinChangeStartIndex == proteinChangeEndIndex) {
            this.aaEndPos = this.aaStartPos = proteinChangeStartIndex + 1;
            this.altAaSeq = this.refAaSeq = referenceProteinSequence.substring(proteinChangeStartIndex, proteinChangeStartIndex + 1);
        } else {
            this.aaStartPos = proteinChangeStartIndex + 1;
            this.aaEndPos = proteinChangeEndIndex;
            this.refAaSeq = referenceProteinSequence.substring(proteinChangeStartIndex, proteinChangeEndIndex);
            this.altAaSeq = alternateProteinSequence.substring(proteinChangeStartIndex, proteinChangeEndIndex);
        }
    }

    private void initializeForDeletion(int alignedCodingSequenceAlleleStart, Strand strand, String referenceProteinSequence, String alternateProteinSequence, boolean indelIsBetweenCodons, int numAltAminoAcids, int numRefAminoAcids) {
        if (indelIsBetweenCodons) {
            int proteinChangeStartIndex = (alignedCodingSequenceAlleleStart - 1) / 3 + (strand == Strand.POSITIVE ? 1 : 0);
            this.aaStartPos = proteinChangeStartIndex + 1;
            this.aaEndPos = this.aaStartPos + numRefAminoAcids - 1;
            this.refAaSeq = referenceProteinSequence.substring(proteinChangeStartIndex, proteinChangeStartIndex + numRefAminoAcids);
            this.altAaSeq = "";
        } else {
            int proteinChangeStartIndex = (alignedCodingSequenceAlleleStart - 1) / 3;
            int endOffset = strand == Strand.POSITIVE ? 1 : 0;
            this.aaStartPos = proteinChangeStartIndex + 1;
            this.aaEndPos = this.aaStartPos + numRefAminoAcids + endOffset;
            this.refAaSeq = referenceProteinSequence.substring(proteinChangeStartIndex, this.aaEndPos);
            this.altAaSeq = alternateProteinSequence.substring(proteinChangeStartIndex, this.aaStartPos + numAltAminoAcids + endOffset);
            this.trimDeletionProteinChangeVariables();
        }
        if (this.altAaSeq.isEmpty()) {
            this.aaEndPos = this.aaStartPos;
        }
    }

    private void trimDeletionProteinChangeVariables() {
        boolean frontMustBeTrimmed = !this.refAaSeq.isEmpty() && !this.altAaSeq.isEmpty() && this.refAaSeq.charAt(0) == this.altAaSeq.charAt(0);
        boolean backMustBeTrimmed = true;
        while (frontMustBeTrimmed || backMustBeTrimmed) {
            if (frontMustBeTrimmed) {
                this.aaEndPos = ++this.aaStartPos;
                this.refAaSeq = this.refAaSeq.substring(1);
                this.altAaSeq = this.altAaSeq.substring(1);
            }
            boolean bl = backMustBeTrimmed = !this.altAaSeq.isEmpty() && this.refAaSeq.charAt(this.refAaSeq.length() - 1) == this.altAaSeq.charAt(this.altAaSeq.length() - 1);
            if (backMustBeTrimmed) {
                --this.aaEndPos;
                this.refAaSeq = this.refAaSeq.substring(0, this.refAaSeq.length() - 1);
                this.altAaSeq = this.altAaSeq.substring(0, this.altAaSeq.length() - 1);
            }
            frontMustBeTrimmed = !this.refAaSeq.isEmpty() && !this.altAaSeq.isEmpty() && this.refAaSeq.charAt(0) == this.altAaSeq.charAt(0);
        }
    }

    private void initializeForInsertion(int alignedCodingSequenceAlleleStart, Strand strand, String referenceProteinSequence, String alternateProteinSequence, int proteinChangeStartIndex, boolean indelIsBetweenCodons, int numAltAminoAcids, int numRefAminoAcids) {
        if (indelIsBetweenCodons) {
            this.aaStartPos = (alignedCodingSequenceAlleleStart - 1) / 3 + (strand == Strand.POSITIVE ? 1 : 0);
            this.aaEndPos = this.aaStartPos + 1;
            this.refAaSeq = "";
            this.altAaSeq = alternateProteinSequence.substring(proteinChangeStartIndex, proteinChangeStartIndex + numAltAminoAcids);
        } else {
            proteinChangeStartIndex = (alignedCodingSequenceAlleleStart - 1) / 3;
            this.aaStartPos = proteinChangeStartIndex + 1;
            this.aaEndPos = this.aaStartPos + numRefAminoAcids;
            this.refAaSeq = referenceProteinSequence.substring(proteinChangeStartIndex, this.aaEndPos);
            this.altAaSeq = alternateProteinSequence.substring(proteinChangeStartIndex, this.aaStartPos + numAltAminoAcids);
            this.trimInsertionProteinChangeVariables();
        }
    }

    private void trimInsertionProteinChangeVariables() {
        boolean frontMustBeTrimmed = !this.refAaSeq.isEmpty() && !this.altAaSeq.isEmpty() && this.refAaSeq.charAt(0) == this.altAaSeq.charAt(0);
        boolean backMustBeTrimmed = true;
        while (frontMustBeTrimmed || backMustBeTrimmed) {
            if (frontMustBeTrimmed) {
                ++this.aaEndPos;
                this.refAaSeq = this.refAaSeq.substring(1);
                this.altAaSeq = this.altAaSeq.substring(1);
            }
            boolean bl = backMustBeTrimmed = !this.refAaSeq.isEmpty() && this.refAaSeq.charAt(this.refAaSeq.length() - 1) == this.altAaSeq.charAt(this.altAaSeq.length() - 1);
            if (backMustBeTrimmed) {
                if (this.aaStartPos == this.aaEndPos) {
                    --this.aaStartPos;
                } else {
                    --this.aaEndPos;
                }
                this.refAaSeq = this.refAaSeq.substring(0, this.refAaSeq.length() - 1);
                this.altAaSeq = this.altAaSeq.substring(0, this.altAaSeq.length() - 1);
            }
            frontMustBeTrimmed = !this.refAaSeq.isEmpty() && !this.altAaSeq.isEmpty() && this.refAaSeq.charAt(0) == this.altAaSeq.charAt(0);
        }
    }

    private void initializeForFrameshift(String referenceProteinSequence, int proteinChangeStartIndex) {
        this.aaEndPos = this.aaStartPos = proteinChangeStartIndex + 1;
        if (this.aaEndPos > referenceProteinSequence.length()) {
            this.refAaSeq = referenceProteinSequence.substring(referenceProteinSequence.length() - 1, referenceProteinSequence.length());
            this.altAaSeq = "";
        } else {
            this.refAaSeq = referenceProteinSequence.substring(proteinChangeStartIndex, this.aaEndPos);
            this.altAaSeq = "";
        }
    }

    public static ProteinChangeInfo create(int aaStartPos, int aaEndPos, String refAaSeq, String altAaSeq) {
        return new ProteinChangeInfo(aaStartPos, aaEndPos, refAaSeq, altAaSeq);
    }

    public static ProteinChangeInfo create(Allele refAllele, Allele altAllele, int codingSequenceAlleleStart, int alignedCodingSequenceAlleleStart, String codingSequence, Strand strand, boolean isMitochondria) {
        Utils.nonNull(refAllele);
        Utils.nonNull(altAllele);
        Utils.nonNull(codingSequence);
        Utils.nonNull(strand);
        return new ProteinChangeInfo(refAllele, altAllele, codingSequenceAlleleStart, alignedCodingSequenceAlleleStart, codingSequence, strand, isMitochondria);
    }

    public int getAaStartPos() {
        return this.aaStartPos;
    }

    public int getAaEndPos() {
        return this.aaEndPos;
    }

    public String getRefAaSeq() {
        return this.refAaSeq;
    }

    public String getAltAaSeq() {
        return this.altAaSeq;
    }

    public boolean equals(Object that) {
        if (that instanceof ProteinChangeInfo) {
            ProteinChangeInfo thatPCI = (ProteinChangeInfo)that;
            return this.aaStartPos == thatPCI.aaStartPos && this.aaEndPos == thatPCI.aaEndPos && this.refAaSeq.equals(thatPCI.refAaSeq) && this.altAaSeq.equals(thatPCI.altAaSeq);
        }
        return false;
    }

    public String toString() {
        return "ProteinChangeInfo{" + this.aaStartPos + ", " + this.aaEndPos + ", " + (this.refAaSeq.isEmpty() ? "\"\"" : this.refAaSeq) + ", " + (this.altAaSeq.isEmpty() ? "\"\"" : this.altAaSeq) + "}";
    }

    public int hashCode() {
        int result = this.aaStartPos;
        result = 31 * result + this.aaEndPos;
        result = 31 * result + (this.refAaSeq != null ? this.refAaSeq.hashCode() : 0);
        result = 31 * result + (this.altAaSeq != null ? this.altAaSeq.hashCode() : 0);
        return result;
    }
}

