/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.tribble.annotation.Strand;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.funcotator.ProteinChangeInfo;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public class SequenceComparison {
    private String referenceBases = null;
    private Integer referenceWindow = null;
    private ReferenceSequence transcriptCodingSequence = null;
    private ReferenceSequence referenceCodingSequence = null;
    private String contig = null;
    private Strand strand = null;
    private Integer alleleStart = null;
    private Integer transcriptAlleleStart = null;
    private Integer codingSequenceAlleleStart = null;
    private Integer alignedCodingSequenceAlleleStart = null;
    private Integer exonStartPosition = null;
    private Integer exonEndPosition = null;
    private String referenceAllele = null;
    private String alignedReferenceAllele = null;
    private String alignedCodingSequenceReferenceAllele = null;
    private Integer alignedReferenceAlleleStop = null;
    private String alternateAllele = null;
    private String alignedAlternateAllele = null;
    private String alignedCodingSequenceAlternateAllele = null;
    private Integer alignedAlternateAlleleStop = null;
    private Double gcContent = null;
    private ProteinChangeInfo proteinChangeInfo = null;

    public boolean hasSequenceInfo() {
        return this.transcriptCodingSequence != null;
    }

    public String getReferenceBases() {
        return this.referenceBases;
    }

    public SequenceComparison setReferenceBases(String referenceBases) {
        this.referenceBases = referenceBases;
        return this;
    }

    public SequenceComparison setReferenceWindow(Integer referenceWindow) {
        this.referenceWindow = referenceWindow;
        return this;
    }

    public ReferenceSequence getTranscriptCodingSequence() {
        return this.transcriptCodingSequence;
    }

    public SequenceComparison setTranscriptCodingSequence(ReferenceSequence transcriptCodingSequence) {
        this.transcriptCodingSequence = transcriptCodingSequence;
        return this;
    }

    public String getContig() {
        return this.contig;
    }

    public SequenceComparison setContig(String contig) {
        this.contig = contig;
        return this;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public SequenceComparison setStrand(Strand strand) {
        if (strand == Strand.NONE) {
            throw new GATKException("Cannot handle NONE strand.");
        }
        this.strand = strand;
        return this;
    }

    public Integer getAlleleStart() {
        return this.alleleStart;
    }

    public SequenceComparison setAlleleStart(Integer alleleStart) {
        this.alleleStart = alleleStart;
        return this;
    }

    public Integer getTranscriptAlleleStart() {
        return this.transcriptAlleleStart;
    }

    public SequenceComparison setTranscriptAlleleStart(Integer transcriptAlleleStart) {
        this.transcriptAlleleStart = transcriptAlleleStart;
        return this;
    }

    public Integer getCodingSequenceAlleleStart() {
        return this.codingSequenceAlleleStart;
    }

    public SequenceComparison setCodingSequenceAlleleStart(Integer codingSequenceAlleleStart) {
        this.codingSequenceAlleleStart = codingSequenceAlleleStart;
        return this;
    }

    public Integer getAlignedCodingSequenceAlleleStart() {
        return this.alignedCodingSequenceAlleleStart;
    }

    public SequenceComparison setAlignedCodingSequenceAlleleStart(Integer alignedCodingSequenceAlleleStart) {
        this.alignedCodingSequenceAlleleStart = alignedCodingSequenceAlleleStart;
        return this;
    }

    public Integer getExonStartPosition() {
        return this.exonStartPosition;
    }

    public Integer getExonEndPosition() {
        return this.exonEndPosition;
    }

    public SequenceComparison setExonPosition(SimpleInterval exonPosition) {
        this.exonStartPosition = exonPosition.getStart();
        this.exonEndPosition = exonPosition.getEnd();
        return this;
    }

    public String getReferenceAllele() {
        return this.referenceAllele;
    }

    public SequenceComparison setReferenceAllele(String referenceAllele) {
        this.referenceAllele = referenceAllele;
        return this;
    }

    public String getAlignedReferenceAllele() {
        return this.alignedReferenceAllele;
    }

    public SequenceComparison setAlignedReferenceAllele(String alignedReferenceAllele) {
        this.alignedReferenceAllele = alignedReferenceAllele;
        return this;
    }

    public String getAlignedCodingSequenceReferenceAllele() {
        return this.alignedCodingSequenceReferenceAllele;
    }

    public SequenceComparison setAlignedCodingSequenceReferenceAllele(String alignedCodingSequenceReferenceAllele) {
        this.alignedCodingSequenceReferenceAllele = alignedCodingSequenceReferenceAllele;
        return this;
    }

    public Integer getAlignedReferenceAlleleStop() {
        return this.alignedReferenceAlleleStop;
    }

    public SequenceComparison setAlignedReferenceAlleleStop(Integer alignedReferenceAlleleStop) {
        this.alignedReferenceAlleleStop = alignedReferenceAlleleStop;
        return this;
    }

    public String getAlternateAllele() {
        return this.alternateAllele;
    }

    public SequenceComparison setAlternateAllele(String alternateAllele) {
        this.alternateAllele = alternateAllele;
        return this;
    }

    public String getAlignedAlternateAllele() {
        return this.alignedAlternateAllele;
    }

    public SequenceComparison setAlignedAlternateAllele(String alignedAlternateAllele) {
        this.alignedAlternateAllele = alignedAlternateAllele;
        return this;
    }

    public String getAlignedCodingSequenceAlternateAllele() {
        return this.alignedCodingSequenceAlternateAllele;
    }

    public SequenceComparison setAlignedCodingSequenceAlternateAllele(String alignedCodingSequenceAlternateAllele) {
        this.alignedCodingSequenceAlternateAllele = alignedCodingSequenceAlternateAllele;
        return this;
    }

    public SequenceComparison setAlignedAlternateAlleleStop(Integer alignedAlternateAlleleStop) {
        this.alignedAlternateAlleleStop = alignedAlternateAlleleStop;
        return this;
    }

    public Double getGcContent() {
        return this.gcContent;
    }

    public SequenceComparison setGcContent(Double gcContent) {
        this.gcContent = gcContent;
        return this;
    }

    public SequenceComparison setProteinChangeInfo(ProteinChangeInfo p) {
        this.proteinChangeInfo = p;
        return this;
    }

    public ProteinChangeInfo getProteinChangeInfo() {
        return this.proteinChangeInfo;
    }
}

