/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import htsjdk.tribble.annotation.Strand;
import htsjdk.variant.variantcontext.Allele;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;

public class StrandCorrectedAllele
extends Allele {
    public static final long serialVersionUID = 1L;
    private final Strand strand;

    private StrandCorrectedAllele(String allele, boolean isRef, Strand strand) {
        super(allele, isRef);
        FuncotatorUtils.assertValidStrand(strand);
        this.strand = strand;
    }

    public static StrandCorrectedAllele create(String bases) {
        return new StrandCorrectedAllele(bases, false, Strand.POSITIVE);
    }

    public static StrandCorrectedAllele create(String bases, Strand strand) {
        return new StrandCorrectedAllele(bases, false, strand);
    }

    public static StrandCorrectedAllele create(String bases, boolean isRef) {
        return new StrandCorrectedAllele(bases, isRef, Strand.POSITIVE);
    }

    public static StrandCorrectedAllele create(String bases, boolean isRef, Strand strand) {
        return new StrandCorrectedAllele(bases, isRef, strand);
    }

    public Strand getStrand() {
        return this.strand;
    }

    public String toString() {
        return "StrandCorrectedAllele{strand=" + this.strand + " " + super.toString() + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StrandCorrectedAllele that = (StrandCorrectedAllele)((Object)o);
        return this.strand == that.strand;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.strand != null ? this.strand.hashCode() : 0);
        return result;
    }
}

