/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import htsjdk.tribble.annotation.Strand;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public class StrandCorrectedReferenceBases {
    private final Strand strand;
    private final String strandCorrectedReferenceBases;

    public StrandCorrectedReferenceBases(String bases, Strand strand) {
        this.strandCorrectedReferenceBases = bases;
        this.strand = strand;
    }

    public StrandCorrectedReferenceBases(byte[] bases, Strand strand) {
        this.strandCorrectedReferenceBases = new String(bases);
        this.strand = strand;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public String getBaseString(Strand strand) {
        FuncotatorUtils.assertValidStrand(strand);
        if (strand == this.strand) {
            return this.getBaseString();
        }
        return ReadUtils.getBasesReverseComplement(this.getBases());
    }

    public String getBaseString() {
        return this.strandCorrectedReferenceBases;
    }

    public byte[] getBases() {
        return this.strandCorrectedReferenceBases.getBytes();
    }

    public String toString() {
        return "StrandCorrectedReferenceBases{strand=" + this.strand + ", strandCorrectedReferenceBases='" + this.strandCorrectedReferenceBases + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrandCorrectedReferenceBases that = (StrandCorrectedReferenceBases)o;
        if (this.strand != that.strand) {
            return false;
        }
        return this.strandCorrectedReferenceBases != null ? this.strandCorrectedReferenceBases.equals(that.strandCorrectedReferenceBases) : that.strandCorrectedReferenceBases == null;
    }

    public int hashCode() {
        int result = this.strand != null ? this.strand.hashCode() : 0;
        result = 31 * result + (this.strandCorrectedReferenceBases != null ? this.strandCorrectedReferenceBases.hashCode() : 0);
        return result;
    }
}

