/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator;

import java.util.Comparator;
import java.util.Set;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeature;

public enum TranscriptSelectionMode {
    BEST_EFFECT{

        @Override
        public Comparator<GencodeFuncotation> getComparator(Set<String> userRequestedTranscripts) {
            return new BestEffectGencodeFuncotationComparator(userRequestedTranscripts);
        }
    }
    ,
    CANONICAL{

        @Override
        public Comparator<GencodeFuncotation> getComparator(Set<String> userRequestedTranscripts) {
            return new CanonicalGencodeFuncotationComparator(userRequestedTranscripts);
        }
    }
    ,
    ALL{

        @Override
        public Comparator<GencodeFuncotation> getComparator(Set<String> userRequestedTranscripts) {
            return new CanonicalGencodeFuncotationComparator(userRequestedTranscripts);
        }
    };


    public abstract Comparator<GencodeFuncotation> getComparator(Set<String> var1);

    static class CanonicalGencodeFuncotationComparator
    implements Comparator<GencodeFuncotation> {
        private final Comparator<GencodeFuncotation> byUserTranscript;
        private final Comparator<GencodeFuncotation> byIgrStatus;
        private final Comparator<GencodeFuncotation> byVariantClassification;
        private final Comparator<GencodeFuncotation> byProteinCodingStatus;
        private final Comparator<GencodeFuncotation> byLocusLevel;
        private final Comparator<GencodeFuncotation> byApprisRank;
        private final Comparator<GencodeFuncotation> byTranscriptLength;
        private final Comparator<GencodeFuncotation> byTranscriptName;
        private final Comparator<GencodeFuncotation> chainedComparator;

        public CanonicalGencodeFuncotationComparator(Set<String> userRequestedTranscripts) {
            this.byUserTranscript = new ComparatorByUserTranscript(userRequestedTranscripts);
            this.byIgrStatus = new ComparatorByIgrStatus();
            this.byVariantClassification = new ComparatorByVariantClassification();
            this.byProteinCodingStatus = new ComparatorByProteinCodingStatus();
            this.byLocusLevel = new ComparatorByLocusLevel();
            this.byApprisRank = new ComparatorByApprisRank();
            this.byTranscriptLength = new ComparatorByTranscriptSequenceLength();
            this.byTranscriptName = new ComparatorByTranscriptName();
            this.chainedComparator = this.byUserTranscript.thenComparing(this.byProteinCodingStatus).thenComparing(this.byLocusLevel).thenComparing(this.byApprisRank).thenComparing(this.byIgrStatus).thenComparing(this.byVariantClassification).thenComparing(this.byTranscriptLength).thenComparing(this.byTranscriptName);
        }

        @Override
        public int compare(GencodeFuncotation a, GencodeFuncotation b) {
            return this.chainedComparator.compare(a, b);
        }
    }

    static class BestEffectGencodeFuncotationComparator
    implements Comparator<GencodeFuncotation> {
        private final Comparator<GencodeFuncotation> byUserTranscript;
        private final Comparator<GencodeFuncotation> byIgrStatus;
        private final Comparator<GencodeFuncotation> byVariantClassification;
        private final Comparator<GencodeFuncotation> byProteinCodingStatus;
        private final Comparator<GencodeFuncotation> byLocusLevel;
        private final Comparator<GencodeFuncotation> byApprisRank;
        private final Comparator<GencodeFuncotation> byTranscriptLength;
        private final Comparator<GencodeFuncotation> byTranscriptName;
        private final Comparator<GencodeFuncotation> chainedComparator;

        public BestEffectGencodeFuncotationComparator(Set<String> userRequestedTranscripts) {
            this.byUserTranscript = new ComparatorByUserTranscript(userRequestedTranscripts);
            this.byIgrStatus = new ComparatorByIgrStatus();
            this.byVariantClassification = new ComparatorByVariantClassification();
            this.byProteinCodingStatus = new ComparatorByProteinCodingStatus();
            this.byLocusLevel = new ComparatorByLocusLevel();
            this.byApprisRank = new ComparatorByApprisRank();
            this.byTranscriptLength = new ComparatorByTranscriptSequenceLength();
            this.byTranscriptName = new ComparatorByTranscriptName();
            this.chainedComparator = this.byUserTranscript.thenComparing(this.byIgrStatus).thenComparing(this.byVariantClassification).thenComparing(this.byProteinCodingStatus).thenComparing(this.byLocusLevel).thenComparing(this.byApprisRank).thenComparing(this.byTranscriptLength).thenComparing(this.byTranscriptName);
        }

        @Override
        public int compare(GencodeFuncotation a, GencodeFuncotation b) {
            return this.chainedComparator.compare(a, b);
        }
    }

    private static class ComparatorByTranscriptName
    implements Comparator<GencodeFuncotation> {
        @Override
        public int compare(GencodeFuncotation a, GencodeFuncotation b) {
            if (a.getAnnotationTranscript() != null && b.getAnnotationTranscript() == null) {
                return -1;
            }
            if (a.getAnnotationTranscript() == null && b.getAnnotationTranscript() != null) {
                return 1;
            }
            if (a.getAnnotationTranscript() == null && b.getAnnotationTranscript() == null) {
                return -1;
            }
            return a.getAnnotationTranscript().compareTo(b.getAnnotationTranscript());
        }
    }

    private static class ComparatorByTranscriptSequenceLength
    implements Comparator<GencodeFuncotation> {
        @Override
        public int compare(GencodeFuncotation a, GencodeFuncotation b) {
            if (a.getTranscriptLength() != null && b.getTranscriptLength() == null) {
                return -1;
            }
            if (a.getTranscriptLength() == null && b.getTranscriptLength() != null) {
                return 1;
            }
            if (a.getTranscriptLength() != null && b.getTranscriptLength() != null && !a.getTranscriptLength().equals(b.getTranscriptLength())) {
                return b.getTranscriptLength().compareTo(a.getTranscriptLength());
            }
            return 0;
        }
    }

    private static class ComparatorByApprisRank
    implements Comparator<GencodeFuncotation> {
        @Override
        public int compare(GencodeFuncotation a, GencodeFuncotation b) {
            if (a.getApprisRank() != null && b.getApprisRank() == null) {
                return -1;
            }
            if (a.getApprisRank() == null && b.getApprisRank() != null) {
                return 1;
            }
            if (a.getApprisRank() != null && b.getApprisRank() != null && !a.getApprisRank().equals((Object)b.getApprisRank())) {
                return a.getApprisRank().compareTo(b.getApprisRank());
            }
            return 0;
        }
    }

    private static class ComparatorByLocusLevel
    implements Comparator<GencodeFuncotation> {
        @Override
        public int compare(GencodeFuncotation a, GencodeFuncotation b) {
            if (a.getLocusLevel() != null && b.getLocusLevel() == null) {
                return -1;
            }
            if (a.getLocusLevel() == null && b.getLocusLevel() != null) {
                return 1;
            }
            if (a.getLocusLevel() == null && b.getLocusLevel() == null) {
                return 0;
            }
            return a.getLocusLevel().compareTo(b.getLocusLevel());
        }
    }

    private static class ComparatorByProteinCodingStatus
    implements Comparator<GencodeFuncotation> {
        @Override
        public int compare(GencodeFuncotation a, GencodeFuncotation b) {
            boolean isBProteinCoding;
            boolean isAProteinCoding = a.getGeneTranscriptType() == GencodeGtfFeature.GeneTranscriptType.PROTEIN_CODING;
            boolean bl = isBProteinCoding = b.getGeneTranscriptType() == GencodeGtfFeature.GeneTranscriptType.PROTEIN_CODING;
            if (isAProteinCoding != isBProteinCoding) {
                if (isAProteinCoding) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private static class ComparatorByVariantClassification
    implements Comparator<GencodeFuncotation> {
        @Override
        public int compare(GencodeFuncotation a, GencodeFuncotation b) {
            if (a.getVariantClassification().getSeverity() < b.getVariantClassification().getSeverity()) {
                return -1;
            }
            if (a.getVariantClassification().getSeverity() > b.getVariantClassification().getSeverity()) {
                return 1;
            }
            return 0;
        }
    }

    private static class ComparatorByIgrStatus
    implements Comparator<GencodeFuncotation> {
        @Override
        public int compare(GencodeFuncotation a, GencodeFuncotation b) {
            if (b.getVariantClassification().equals((Object)GencodeFuncotation.VariantClassification.IGR) && !a.getVariantClassification().equals((Object)GencodeFuncotation.VariantClassification.IGR)) {
                return -1;
            }
            if (a.getVariantClassification().equals((Object)GencodeFuncotation.VariantClassification.IGR) && !b.getVariantClassification().equals((Object)GencodeFuncotation.VariantClassification.IGR)) {
                return 1;
            }
            return 0;
        }
    }

    private static class ComparatorByUserTranscript
    implements Comparator<GencodeFuncotation> {
        private final Set<String> userRequestedTranscripts;

        public ComparatorByUserTranscript(Set<String> userRequestedTranscripts) {
            this.userRequestedTranscripts = userRequestedTranscripts;
        }

        @Override
        public int compare(GencodeFuncotation a, GencodeFuncotation b) {
            if (FuncotatorUtils.isFuncotationInTranscriptList(a, this.userRequestedTranscripts) && !FuncotatorUtils.isFuncotationInTranscriptList(b, this.userRequestedTranscripts)) {
                return -1;
            }
            if (!FuncotatorUtils.isFuncotationInTranscriptList(a, this.userRequestedTranscripts) && FuncotatorUtils.isFuncotationInTranscriptList(b, this.userRequestedTranscripts)) {
                return 1;
            }
            return 0;
        }
    }
}

