/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.dataSources;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Arrays;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadata;
import org.broadinstitute.hellbender.tools.funcotator.metadata.VcfFuncotationMetadata;
import org.broadinstitute.hellbender.utils.Utils;

public class LocatableFuncotationCreator {
    @VisibleForTesting
    static final String CONTIG_FIELD_NAME = "CONTIG";
    @VisibleForTesting
    static final String START_FIELD_NAME = "START";
    @VisibleForTesting
    static final String END_FIELD_NAME = "END";
    @VisibleForTesting
    static final FuncotationMetadata METADATA = VcfFuncotationMetadata.create(Arrays.asList(new VCFInfoHeaderLine("CONTIG", 1, VCFHeaderLineType.String, "contig"), new VCFInfoHeaderLine("START", 1, VCFHeaderLineType.Integer, "start position"), new VCFInfoHeaderLine("END", 1, VCFHeaderLineType.Integer, "end position")));

    public static Funcotation create(Locatable locatable, Allele altAllele, String dataSourceName) {
        Utils.nonNull(locatable);
        Utils.nonNull(altAllele);
        Utils.nonNull(dataSourceName);
        return TableFuncotation.create(Arrays.asList(CONTIG_FIELD_NAME, START_FIELD_NAME, END_FIELD_NAME), Arrays.asList(locatable.getContig(), String.valueOf(locatable.getStart()), String.valueOf(locatable.getEnd())), altAllele, dataSourceName, METADATA);
    }
}

