/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.dataSources;

import com.google.common.collect.Sets;
import htsjdk.variant.variantcontext.Allele;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadata;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadataUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.xsvLocatableTable.XsvTableFeature;

public class TableFuncotation
implements Funcotation {
    private final String dataSourceName;
    private final LinkedHashMap<String, String> fieldMap;
    private final Allele altAllele;
    private final FuncotationMetadata metadata;

    private TableFuncotation(List<String> fieldNames, List<String> fieldValues, Allele altAllele, String dataSourceName, FuncotationMetadata metadata) {
        HashSet<String> funcotationFieldNames;
        if (fieldNames.size() != fieldValues.size()) {
            throw new UserException.BadInput("Field names and Field values are of different lengths!  This must not be!");
        }
        this.fieldMap = new LinkedHashMap(fieldNames.size());
        for (int i = 0; i < fieldNames.size(); ++i) {
            this.fieldMap.put(fieldNames.get(i), fieldValues.get(i));
        }
        this.altAllele = altAllele;
        this.dataSourceName = dataSourceName;
        this.metadata = metadata == null ? FuncotationMetadataUtils.createWithUnknownAttributes(fieldNames) : metadata;
        Set metadataFieldNames = this.metadata.retrieveAllHeaderInfo().stream().map(f -> f.getID()).collect(Collectors.toSet());
        if (!metadataFieldNames.equals(funcotationFieldNames = new HashSet<String>(fieldNames))) {
            throw new UserException.BadInput("Metadata was not valid for the given field names.  Unmatched fields: " + Sets.symmetricDifference(metadataFieldNames, funcotationFieldNames).stream().collect(Collectors.joining(", ")));
        }
    }

    @Override
    public Allele getAltAllele() {
        return this.altAllele;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public void setFieldSerializationOverrideValue(String fieldName, String overrideValue) {
        if (!this.fieldMap.containsKey(fieldName)) {
            throw new GATKException("Attempted to override a field that is not contained in this TableFuncotation: " + fieldName + " is not one of [" + String.join((CharSequence)",", this.fieldMap.keySet()) + "]");
        }
        this.fieldMap.put(fieldName, overrideValue);
    }

    @Override
    public LinkedHashSet<String> getFieldNames() {
        return new LinkedHashSet<String>(this.fieldMap.keySet());
    }

    @Override
    public String getField(String fieldName) {
        if (this.fieldMap.containsKey(fieldName)) {
            return this.fieldMap.get(fieldName);
        }
        throw new GATKException(this.getClass().getSimpleName() + ": Does not contain field: " + fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fieldMap.containsKey(fieldName);
    }

    @Override
    public FuncotationMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableFuncotation that = (TableFuncotation)o;
        if (this.dataSourceName != null ? !this.dataSourceName.equals(that.dataSourceName) : that.dataSourceName != null) {
            return false;
        }
        if (this.fieldMap != null ? !this.fieldMap.equals(that.fieldMap) : that.fieldMap != null) {
            return false;
        }
        return this.altAllele != null ? this.altAllele.equals((Object)that.altAllele) : that.altAllele == null;
    }

    public int hashCode() {
        int result = this.dataSourceName != null ? this.dataSourceName.hashCode() : 0;
        result = 31 * result + (this.fieldMap != null ? this.fieldMap.hashCode() : 0);
        result = 31 * result + (this.altAllele != null ? this.altAllele.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TableFuncotation{dataSourceName='" + this.dataSourceName + '\'' + ", fieldMap={" + this.fieldMap.keySet().stream().map(k -> k + ":" + this.fieldMap.get(k)).collect(Collectors.joining(" , ")) + '}' + ", altAllele=" + this.altAllele + '}';
    }

    public static TableFuncotation create(List<String> fieldNames, List<String> fieldValues, Allele altAllele, String dataSourceName, FuncotationMetadata metadata) {
        Utils.nonNull(fieldNames);
        Utils.nonNull(fieldValues);
        Utils.nonNull(altAllele);
        Utils.nonNull(dataSourceName);
        return new TableFuncotation(fieldNames, fieldValues, altAllele, dataSourceName, metadata);
    }

    public static TableFuncotation create(LinkedHashSet<String> fieldNames, List<String> fieldValues, Allele altAllele, String dataSourceName, FuncotationMetadata metadata) {
        return TableFuncotation.create(new ArrayList<String>(fieldNames), fieldValues, altAllele, dataSourceName, metadata);
    }

    public static TableFuncotation create(LinkedHashMap<String, String> data, Allele altAllele, String dataSourceName, FuncotationMetadata metadata) {
        ArrayList<String> fieldNames = new ArrayList<String>(data.keySet());
        List<String> fieldValues = fieldNames.stream().map(f -> (String)data.get(f)).collect(Collectors.toList());
        return TableFuncotation.create(fieldNames, fieldValues, altAllele, dataSourceName, metadata);
    }

    public static TableFuncotation create(XsvTableFeature xsvTableFeature, Allele altAllele, String dataSourceName, FuncotationMetadata metadata) {
        Utils.nonNull(xsvTableFeature);
        List<String> fieldNames = xsvTableFeature.getHeaderWithoutLocationColumns();
        List<String> fieldValues = xsvTableFeature.getValuesWithoutLocationColumns();
        return TableFuncotation.create(fieldNames, fieldValues, altAllele, dataSourceName, metadata);
    }

    public String get(String key) {
        return this.fieldMap.get(key);
    }

    public Set<String> keySet() {
        return this.fieldMap.keySet();
    }

    public Collection<String> values() {
        return this.fieldMap.values();
    }

    public int size() {
        return this.fieldMap.size();
    }
}

