/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.dataSources.cosmic;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.DataSourceFuncotationFactory;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorArgumentDefinitions;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.nio.NioFileCopierWithProgressMeter;
import org.sqlite.SQLiteConfig;

public class CosmicFuncotationFactory
extends DataSourceFuncotationFactory {
    protected static final Logger logger = LogManager.getLogger(CosmicFuncotationFactory.class);
    @VisibleForTesting
    static final Pattern GENOME_POSITION_REGEX = Pattern.compile("(\\d+):(\\d+)-(\\d+)");
    @VisibleForTesting
    static final Pattern PROTEIN_POSITION_REGEX = Pattern.compile("[pP]\\.\\(?[A-Z](\\d+)\\)?[A-Z]?_?(?:[A-Z]?(\\d+)?.*)?");
    private static final String PROTEIN_CONTIG = "P";
    private static final String TABLE_NAME = "Cosmic";
    private static final String PROTEIN_POSITION_COLUMN_NAME = "Mutation AA";
    private static final String GENOME_POSITION_COLUMN_NAME = "Mutation genome position";
    private static final String GENE_NAME_COLUMN = "Gene name";
    private static final HashSet<String> IGNORE_FIELDS = new HashSet<String>(Arrays.asList("Mutation AA", "Mutation genome position", "Gene name"));
    private static final String FIELD_NAME_QUERY = "SELECT * FROM Cosmic LIMIT 1;";
    private static final String RESULT_QUERY_TEMPLATE = "SELECT * FROM Cosmic WHERE \"Gene name\" == ";
    private static final String LOCAL_COSMIC_DB_TMP_DIR_PREFIX = "localCosmicDbFolder";
    private static final String LOCAL_COSMIC_DB_FILE_NAME = "cosmic.db";
    private final String name = "Cosmic";
    private final Path pathToCosmicDb;
    private final Connection dbConnection;
    private final LinkedHashSet<String> supportedFields;

    public CosmicFuncotationFactory(Path pathToCosmicDb) {
        this(pathToCosmicDb, new LinkedHashMap<String, String>(), "UNKNOWN_VERSION");
    }

    public CosmicFuncotationFactory(Path pathToCosmicDb, LinkedHashMap<String, String> annotationOverridesMap, String version) {
        this(pathToCosmicDb, annotationOverridesMap, version, false);
    }

    public CosmicFuncotationFactory(Path pathToCosmicDb, LinkedHashMap<String, String> annotationOverridesMap, String version, boolean isDataSourceB37) {
        this(pathToCosmicDb, annotationOverridesMap, version, isDataSourceB37, 150);
    }

    public CosmicFuncotationFactory(Path pathToCosmicDb, LinkedHashMap<String, String> annotationOverridesMap, String version, boolean isDataSourceB37, int minBasesForValidSegment) {
        super(minBasesForValidSegment);
        this.pathToCosmicDb = this.localizeCosmicDbFileIfRemote(pathToCosmicDb);
        this.version = version;
        this.dataSourceIsB37 = isDataSourceB37;
        try {
            Class.forName("org.sqlite.JDBC");
            SQLiteConfig config = new SQLiteConfig();
            config.setReadOnly(true);
            logger.debug("Connecting to SQLite database at: " + this.pathToCosmicDb.toUri().toString());
            this.dbConnection = DriverManager.getConnection("jdbc:sqlite:" + this.pathToCosmicDb.toUri().toString(), config.toProperties());
            logger.debug("Connected to SQLite database!");
        }
        catch (SQLException ex) {
            throw new UserException("Unable to open SQLite DB for COSMIC at: " + this.pathToCosmicDb.toUri().toString(), ex);
        }
        catch (ClassNotFoundException ex) {
            throw new UserException("Cannot load SQLite Java Package!", ex);
        }
        this.supportedFields = new LinkedHashSet(1);
        this.supportedFields.add("Cosmic_overlapping_mutations");
        this.initializeAnnotationOverrides(annotationOverridesMap);
    }

    @Override
    public Class<? extends Feature> getAnnotationFeatureClass() {
        return Feature.class;
    }

    @Override
    public void close() {
        if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (SQLException ex) {
                throw new GATKException("Unable to close the connection to DB: " + this.pathToCosmicDb.toUri().toString(), ex);
            }
        }
    }

    @Override
    public String getName() {
        return TABLE_NAME;
    }

    @Override
    @VisibleForTesting
    public boolean requiresFeatures() {
        return false;
    }

    @Override
    public LinkedHashSet<String> getSupportedFuncotationFields() {
        return this.supportedFields;
    }

    @Override
    protected List<Funcotation> createDefaultFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext) {
        ArrayList<Funcotation> funcotationList = new ArrayList<Funcotation>();
        for (Allele altAllele : variant.getAlternateAlleles()) {
            funcotationList.add(TableFuncotation.create(new ArrayList<String>(this.supportedFields), new ArrayList<String>(Collections.singletonList("")), altAllele, TABLE_NAME, null));
        }
        return funcotationList;
    }

    @Override
    protected List<Funcotation> createFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext, List<Feature> featureList) {
        throw new GATKException(this.getClass().getName() + " requires a set of GencodeFuncotations in order to createFuncotationsOnVariant!  This method should never be called on a " + this.getClass().getName());
    }

    @Override
    protected List<Funcotation> createFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext, List<Feature> featureList, List<GencodeFuncotation> gencodeFuncotations) {
        ArrayList<Funcotation> outputFuncotations = new ArrayList<Funcotation>();
        LinkedHashMap<String, Integer> proteinChangeCounts = new LinkedHashMap<String, Integer>();
        for (GencodeFuncotation gencodeFuncotation : gencodeFuncotations) {
            String geneName = gencodeFuncotation.getHugoSymbol();
            SimpleInterval genomePosition = new SimpleInterval(variant.getContig(), variant.getStart(), variant.getEnd());
            SimpleInterval proteinPosition = gencodeFuncotation.getProteinChange() != null ? this.parseProteinString(gencodeFuncotation.getProteinChange()) : null;
            try {
                Statement statement = this.dbConnection.createStatement();
                Throwable throwable = null;
                try {
                    ResultSet resultSet = statement.executeQuery("SELECT * FROM Cosmic WHERE \"Gene name\" == \"" + geneName + "\";");
                    Throwable throwable2 = null;
                    try {
                        while (resultSet.next()) {
                            SimpleInterval cosmicGenomePosition = this.getGenomePositionFromResults(resultSet);
                            if (cosmicGenomePosition != null && genomePosition.overlaps(cosmicGenomePosition)) {
                                this.updateProteinChangeCountMap(proteinChangeCounts, resultSet);
                                continue;
                            }
                            SimpleInterval cosmicProteinPosition = this.getProteinPositionFromResults(resultSet);
                            if (proteinPosition == null || !proteinPosition.overlaps(cosmicProteinPosition)) continue;
                            this.updateProteinChangeCountMap(proteinChangeCounts, resultSet);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (SQLException ex) {
                throw new GATKException("Unable to query the database for geneName: " + geneName, ex);
            }
        }
        for (Allele altAllele : variant.getAlternateAlleles()) {
            outputFuncotations.add(TableFuncotation.create(new ArrayList<String>(this.supportedFields), Collections.singletonList(proteinChangeCounts.entrySet().stream().map(entry -> (String)entry.getKey() + '(' + entry.getValue() + ')').collect(Collectors.joining("|"))), altAllele, TABLE_NAME, null));
        }
        return outputFuncotations;
    }

    private void updateProteinChangeCountMap(Map<String, Integer> proteinChangeCounts, ResultSet resultSet) {
        String proteinChange = this.getProteinChangeStringFromResults(resultSet);
        if (!proteinChange.isEmpty()) {
            int count = proteinChangeCounts.getOrDefault(proteinChange, 0);
            proteinChangeCounts.put(proteinChange, count + 1);
        }
    }

    @Override
    public FuncotatorArgumentDefinitions.DataSourceType getType() {
        return FuncotatorArgumentDefinitions.DataSourceType.COSMIC;
    }

    private Path localizeCosmicDbFileIfRemote(Path cosmicDbPathMaybeRemote) {
        if (cosmicDbPathMaybeRemote.getFileSystem().equals(FileSystems.getDefault())) {
            return cosmicDbPathMaybeRemote;
        }
        File tmpDir = IOUtils.createTempDir(LOCAL_COSMIC_DB_TMP_DIR_PREFIX);
        tmpDir.deleteOnExit();
        Path tmpDirPath = tmpDir.toPath();
        Path localCosmicDbFilePath = tmpDirPath.resolve(LOCAL_COSMIC_DB_FILE_NAME);
        logger.info("Localizing Cosmic db file for compatibility and faster lookup times...");
        NioFileCopierWithProgressMeter.create(cosmicDbPathMaybeRemote, localCosmicDbFilePath, true).initiateCopy();
        return localCosmicDbFilePath;
    }

    private final SimpleInterval getGenomePositionFromResults(ResultSet resultSet) {
        Utils.nonNull(resultSet);
        try {
            String rawPosition = resultSet.getString(GENOME_POSITION_COLUMN_NAME);
            Matcher matcher = GENOME_POSITION_REGEX.matcher(rawPosition);
            if (matcher.matches()) {
                String rawContig = matcher.group(1);
                String contig = rawContig.startsWith("chr") ? rawContig : "chr" + rawContig;
                int start = Integer.valueOf(matcher.group(2));
                int end = Integer.valueOf(matcher.group(3));
                try {
                    return new SimpleInterval(contig, start, end);
                }
                catch (IllegalArgumentException ex) {
                    logger.warn("Warning - unable to parse genome position string due to invalid position information.  Ignoring potential COSMIC match with genome position: " + rawPosition);
                    return null;
                }
            }
        }
        catch (SQLException ex) {
            throw new GATKException("Cannot get Genome Position from column: Mutation genome position", ex);
        }
        return null;
    }

    private SimpleInterval getProteinPositionFromResults(ResultSet resultSet) {
        return this.parseProteinString(this.getProteinChangeStringFromResults(resultSet));
    }

    private String getProteinChangeStringFromResults(ResultSet resultSet) {
        Utils.nonNull(resultSet);
        try {
            String proteinChangeString = resultSet.getString(PROTEIN_POSITION_COLUMN_NAME);
            return proteinChangeString == null ? "" : proteinChangeString;
        }
        catch (SQLException ex) {
            throw new GATKException("Cannot get protein change from column: Mutation genome position", ex);
        }
    }

    private SimpleInterval parseProteinString(String proteinPositionString) {
        Utils.nonNull(proteinPositionString);
        Matcher matcher = PROTEIN_POSITION_REGEX.matcher(proteinPositionString);
        if (matcher.matches()) {
            try {
                if (matcher.group(2) != null) {
                    return new SimpleInterval(PROTEIN_CONTIG, Integer.valueOf(matcher.group(1)), Integer.valueOf(matcher.group(2)));
                }
                return new SimpleInterval(PROTEIN_CONTIG, Integer.valueOf(matcher.group(1)), Integer.valueOf(matcher.group(1)));
            }
            catch (IllegalArgumentException ex) {
                logger.warn("Warning - unable to parse protein string due to invalid position information.  Ignoring potential COSMIC match with protein sequence: " + proteinPositionString);
                return null;
            }
        }
        return null;
    }

    private final void printResultSet(ResultSet resultSet) {
        try {
            int i;
            ResultSetMetaData metadata = resultSet.getMetaData();
            int columnCount = metadata.getColumnCount();
            for (i = 1; i <= columnCount; ++i) {
                System.out.print(metadata.getColumnName(i) + ", ");
            }
            System.out.println();
            while (resultSet.next()) {
                for (i = 1; i <= columnCount; ++i) {
                    System.out.print(resultSet.getString(i) + ", ");
                }
                System.out.println();
            }
        }
        catch (SQLException ex) {
            throw new GATKException("Cannot print resultSet!");
        }
    }
}

