/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotationBuilder;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadata;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeature;

public class GencodeFuncotation
implements Funcotation {
    private String hugoSymbol;
    private String ncbiBuild;
    private String chromosome;
    private int start;
    private int end;
    private VariantClassification variantClassification;
    private VariantClassification secondaryVariantClassification;
    private VariantType variantType;
    private String refAllele;
    private String tumorSeqAllele2;
    private String genomeChange;
    private String annotationTranscript;
    private String transcriptStrand;
    private Integer transcriptExon;
    private Integer transcriptStartPos;
    private Integer transcriptEndPos;
    private String cDnaChange;
    private String codonChange;
    private String proteinChange;
    private Double gcContent;
    private String referenceContext;
    private List<String> otherTranscripts;
    private String dataSourceName;
    private Integer locusLevel;
    private GencodeGtfFeature.FeatureTag apprisRank;
    private Integer transcriptLength;
    private String version;
    private GencodeGtfFeature.GeneTranscriptType geneTranscriptType;
    private String hugoSymbolSerializedOverride = null;
    private String ncbiBuildSerializedOverride = null;
    private String chromosomeSerializedOverride = null;
    private String startSerializedOverride = null;
    private String endSerializedOverride = null;
    private String variantClassificationSerializedOverride = null;
    private String secondaryVariantClassificationSerializedOverride = null;
    private String variantTypeSerializedOverride = null;
    private String refAlleleSerializedOverride = null;
    private String tumorSeqAllele1SerializedOverride = null;
    private String tumorSeqAllele2SerializedOverride = null;
    private String genomeChangeSerializedOverride = null;
    private String annotationTranscriptSerializedOverride = null;
    private String transcriptStrandSerializedOverride = null;
    private String transcriptExonSerializedOverride = null;
    private String transcriptPosSerializedOverride = null;
    private String cDnaChangeSerializedOverride = null;
    private String codonChangeSerializedOverride = null;
    private String proteinChangeSerializedOverride = null;
    private String gcContentSerializedOverride = null;
    private String referenceContextSerializedOverride = null;
    private String otherTranscriptsSerializedOverride = null;
    private FuncotationMetadata metadata;

    @VisibleForTesting
    GencodeFuncotation() {
    }

    @VisibleForTesting
    GencodeFuncotation(GencodeFuncotation that) {
        this.hugoSymbol = that.hugoSymbol;
        this.ncbiBuild = that.ncbiBuild;
        this.chromosome = that.chromosome;
        this.start = that.start;
        this.end = that.end;
        this.variantClassification = that.variantClassification;
        this.secondaryVariantClassification = that.secondaryVariantClassification;
        this.variantType = that.variantType;
        this.refAllele = that.refAllele;
        this.tumorSeqAllele2 = that.tumorSeqAllele2;
        this.genomeChange = that.genomeChange;
        this.annotationTranscript = that.annotationTranscript;
        this.transcriptStrand = that.transcriptStrand;
        this.transcriptExon = that.transcriptExon;
        this.transcriptStartPos = that.transcriptStartPos;
        this.transcriptEndPos = that.transcriptEndPos;
        this.cDnaChange = that.cDnaChange;
        this.codonChange = that.codonChange;
        this.proteinChange = that.proteinChange;
        this.gcContent = that.gcContent;
        this.referenceContext = that.referenceContext;
        this.otherTranscripts = that.otherTranscripts;
        this.dataSourceName = that.dataSourceName;
        this.locusLevel = that.locusLevel;
        this.apprisRank = that.apprisRank;
        this.transcriptLength = that.transcriptLength;
        this.version = that.version;
        this.geneTranscriptType = that.geneTranscriptType;
        this.hugoSymbolSerializedOverride = that.hugoSymbolSerializedOverride;
        this.ncbiBuildSerializedOverride = that.ncbiBuildSerializedOverride;
        this.chromosomeSerializedOverride = that.chromosomeSerializedOverride;
        this.startSerializedOverride = that.startSerializedOverride;
        this.endSerializedOverride = that.endSerializedOverride;
        this.variantClassificationSerializedOverride = that.variantClassificationSerializedOverride;
        this.secondaryVariantClassificationSerializedOverride = that.secondaryVariantClassificationSerializedOverride;
        this.variantTypeSerializedOverride = that.variantTypeSerializedOverride;
        this.refAlleleSerializedOverride = that.refAlleleSerializedOverride;
        this.tumorSeqAllele1SerializedOverride = that.tumorSeqAllele1SerializedOverride;
        this.tumorSeqAllele2SerializedOverride = that.tumorSeqAllele2SerializedOverride;
        this.genomeChangeSerializedOverride = that.genomeChangeSerializedOverride;
        this.annotationTranscriptSerializedOverride = that.annotationTranscriptSerializedOverride;
        this.transcriptStrandSerializedOverride = that.transcriptStrandSerializedOverride;
        this.transcriptExonSerializedOverride = that.transcriptExonSerializedOverride;
        this.transcriptPosSerializedOverride = that.transcriptPosSerializedOverride;
        this.cDnaChangeSerializedOverride = that.cDnaChangeSerializedOverride;
        this.codonChangeSerializedOverride = that.codonChangeSerializedOverride;
        this.proteinChangeSerializedOverride = that.proteinChangeSerializedOverride;
        this.gcContentSerializedOverride = that.gcContentSerializedOverride;
        this.referenceContextSerializedOverride = that.referenceContextSerializedOverride;
        this.otherTranscriptsSerializedOverride = that.otherTranscriptsSerializedOverride;
        this.metadata = that.metadata;
    }

    public static GencodeFuncotationBuilder getBuilder() {
        return new GencodeFuncotationBuilder();
    }

    @Override
    public Allele getAltAllele() {
        return Allele.create((byte[])this.tumorSeqAllele2.getBytes(), (boolean)false);
    }

    @Override
    public void setFieldSerializationOverrideValue(String fieldName, String overrideValue) {
        String shortFieldName;
        switch (shortFieldName = fieldName.replaceAll("^" + this.getDataSourceName() + "_" + this.version + "_", "")) {
            case "hugoSymbol": {
                this.hugoSymbolSerializedOverride = overrideValue;
                break;
            }
            case "ncbiBuild": {
                this.ncbiBuildSerializedOverride = overrideValue;
                break;
            }
            case "chromosome": {
                this.chromosomeSerializedOverride = overrideValue;
                break;
            }
            case "start": {
                this.startSerializedOverride = overrideValue;
                break;
            }
            case "end": {
                this.endSerializedOverride = overrideValue;
                break;
            }
            case "variantClassification": {
                this.variantClassificationSerializedOverride = overrideValue;
                break;
            }
            case "secondaryVariantClassification": {
                this.secondaryVariantClassificationSerializedOverride = overrideValue;
                break;
            }
            case "variantType": {
                this.variantTypeSerializedOverride = overrideValue;
                break;
            }
            case "refAllele": {
                this.refAlleleSerializedOverride = overrideValue;
                break;
            }
            case "tumorSeqAllele1": {
                this.tumorSeqAllele1SerializedOverride = overrideValue;
                break;
            }
            case "tumorSeqAllele2": {
                this.tumorSeqAllele2SerializedOverride = overrideValue;
                break;
            }
            case "genomeChange": {
                this.genomeChangeSerializedOverride = overrideValue;
                break;
            }
            case "annotationTranscript": {
                this.annotationTranscriptSerializedOverride = overrideValue;
                break;
            }
            case "transcriptStrand": {
                this.transcriptStrandSerializedOverride = overrideValue;
                break;
            }
            case "transcriptExon": {
                this.transcriptExonSerializedOverride = overrideValue;
                break;
            }
            case "transcriptPos": {
                this.transcriptPosSerializedOverride = overrideValue;
                break;
            }
            case "cDnaChange": {
                this.cDnaChangeSerializedOverride = overrideValue;
                break;
            }
            case "codonChange": {
                this.codonChangeSerializedOverride = overrideValue;
                break;
            }
            case "proteinChange": {
                this.proteinChangeSerializedOverride = overrideValue;
                break;
            }
            case "gcContent": {
                this.gcContentSerializedOverride = overrideValue;
                break;
            }
            case "referenceContext": {
                this.referenceContextSerializedOverride = overrideValue;
                break;
            }
            case "otherTranscripts": {
                this.otherTranscriptsSerializedOverride = overrideValue;
                break;
            }
            default: {
                throw new UserException("Attempted to override invalid field in this GencodeFuncotation: " + fieldName + " (value was: " + overrideValue + ")");
            }
        }
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public LinkedHashSet<String> getFieldNames() {
        return new LinkedHashSet<String>(Arrays.asList(this.getDataSourceName() + "_" + this.version + "_hugoSymbol", this.getDataSourceName() + "_" + this.version + "_ncbiBuild", this.getDataSourceName() + "_" + this.version + "_chromosome", this.getDataSourceName() + "_" + this.version + "_start", this.getDataSourceName() + "_" + this.version + "_end", this.getDataSourceName() + "_" + this.version + "_variantClassification", this.getDataSourceName() + "_" + this.version + "_secondaryVariantClassification", this.getDataSourceName() + "_" + this.version + "_variantType", this.getDataSourceName() + "_" + this.version + "_refAllele", this.getDataSourceName() + "_" + this.version + "_tumorSeqAllele1", this.getDataSourceName() + "_" + this.version + "_tumorSeqAllele2", this.getDataSourceName() + "_" + this.version + "_genomeChange", this.getDataSourceName() + "_" + this.version + "_annotationTranscript", this.getDataSourceName() + "_" + this.version + "_transcriptStrand", this.getDataSourceName() + "_" + this.version + "_transcriptExon", this.getDataSourceName() + "_" + this.version + "_transcriptPos", this.getDataSourceName() + "_" + this.version + "_cDnaChange", this.getDataSourceName() + "_" + this.version + "_codonChange", this.getDataSourceName() + "_" + this.version + "_proteinChange", this.getDataSourceName() + "_" + this.version + "_gcContent", this.getDataSourceName() + "_" + this.version + "_referenceContext", this.getDataSourceName() + "_" + this.version + "_otherTranscripts"));
    }

    @Override
    public String getField(String fieldName) {
        String altFieldName = this.getDataSourceName() + "_" + this.version + "_" + fieldName;
        LinkedHashSet<String> fieldNames = this.getFieldNames();
        if (fieldNames.contains(fieldName) || fieldNames.contains(altFieldName)) {
            switch (fieldName.replace(this.getDataSourceName() + "_" + this.version + "_", "")) {
                case "hugoSymbol": {
                    return this.hugoSymbolSerializedOverride != null ? this.hugoSymbolSerializedOverride : (this.hugoSymbol == null || this.hugoSymbol.isEmpty() ? "Unknown" : this.hugoSymbol);
                }
                case "ncbiBuild": {
                    return this.ncbiBuildSerializedOverride != null ? this.ncbiBuildSerializedOverride : (this.ncbiBuild != null ? this.ncbiBuild : "");
                }
                case "chromosome": {
                    return this.chromosomeSerializedOverride != null ? this.chromosomeSerializedOverride : (this.chromosome != null ? this.chromosome : "");
                }
                case "start": {
                    return this.startSerializedOverride != null ? this.startSerializedOverride : String.valueOf(this.start);
                }
                case "end": {
                    return this.endSerializedOverride != null ? this.endSerializedOverride : String.valueOf(this.end);
                }
                case "variantClassification": {
                    return this.variantClassificationSerializedOverride != null ? this.variantClassificationSerializedOverride : (this.variantClassification != null ? String.valueOf((Object)this.variantClassification) : "");
                }
                case "secondaryVariantClassification": {
                    return this.secondaryVariantClassificationSerializedOverride != null ? this.secondaryVariantClassificationSerializedOverride : (this.secondaryVariantClassification != null ? String.valueOf((Object)this.secondaryVariantClassification) : "");
                }
                case "variantType": {
                    return this.variantTypeSerializedOverride != null ? this.variantTypeSerializedOverride : (this.variantType != null ? String.valueOf((Object)this.variantType) : "");
                }
                case "refAllele": {
                    return this.refAlleleSerializedOverride != null ? this.refAlleleSerializedOverride : (this.refAllele != null ? this.refAllele : "");
                }
                case "tumorSeqAllele1": {
                    return this.tumorSeqAllele1SerializedOverride != null ? this.tumorSeqAllele1SerializedOverride : (this.refAllele != null ? this.refAllele : "");
                }
                case "tumorSeqAllele2": {
                    return this.tumorSeqAllele2SerializedOverride != null ? this.tumorSeqAllele2SerializedOverride : (this.tumorSeqAllele2 != null ? this.tumorSeqAllele2 : "");
                }
                case "genomeChange": {
                    return this.genomeChangeSerializedOverride != null ? this.genomeChangeSerializedOverride : (this.genomeChange != null ? this.genomeChange : "");
                }
                case "annotationTranscript": {
                    return this.annotationTranscriptSerializedOverride != null ? this.annotationTranscriptSerializedOverride : (this.annotationTranscript != null ? this.annotationTranscript : "");
                }
                case "transcriptStrand": {
                    return this.transcriptStrandSerializedOverride != null ? this.transcriptStrandSerializedOverride : (this.transcriptStrand != null ? this.transcriptStrand : "");
                }
                case "transcriptExon": {
                    return this.transcriptExonSerializedOverride != null ? this.transcriptExonSerializedOverride : (this.transcriptExon != null ? String.valueOf(this.transcriptExon) : "");
                }
                case "transcriptPos": {
                    return this.transcriptPosSerializedOverride != null ? this.transcriptPosSerializedOverride : this.getTranscriptPosString();
                }
                case "cDnaChange": {
                    return this.cDnaChangeSerializedOverride != null ? this.cDnaChangeSerializedOverride : (this.cDnaChange != null ? this.cDnaChange : "");
                }
                case "codonChange": {
                    return this.codonChangeSerializedOverride != null ? this.codonChangeSerializedOverride : (this.codonChange != null ? this.codonChange : "");
                }
                case "proteinChange": {
                    return this.proteinChangeSerializedOverride != null ? this.proteinChangeSerializedOverride : (this.proteinChange != null ? this.proteinChange : "");
                }
                case "gcContent": {
                    return this.gcContentSerializedOverride != null ? this.gcContentSerializedOverride : (this.gcContent != null ? String.valueOf(this.gcContent) : "");
                }
                case "referenceContext": {
                    return this.referenceContextSerializedOverride != null ? this.referenceContextSerializedOverride : (this.referenceContext != null ? this.referenceContext : "");
                }
                case "otherTranscripts": {
                    return this.otherTranscriptsSerializedOverride != null ? this.otherTranscriptsSerializedOverride : (this.otherTranscripts != null ? this.otherTranscripts.stream().map(Object::toString).collect(Collectors.joining("/")) : "");
                }
            }
        }
        throw new GATKException(this.getClass().getSimpleName() + ": Does not contain field: " + fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        LinkedHashSet<String> fieldNames = this.getFieldNames();
        String altFieldName = this.getDataSourceName() + "_" + this.version + "_" + fieldName;
        return fieldNames.contains(fieldName) || fieldNames.contains(altFieldName);
    }

    @Override
    public FuncotationMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GencodeFuncotation that = (GencodeFuncotation)o;
        if (this.start != that.start) {
            return false;
        }
        if (this.end != that.end) {
            return false;
        }
        if (this.hugoSymbol != null ? !this.hugoSymbol.equals(that.hugoSymbol) : that.hugoSymbol != null) {
            return false;
        }
        if (this.ncbiBuild != null ? !this.ncbiBuild.equals(that.ncbiBuild) : that.ncbiBuild != null) {
            return false;
        }
        if (this.chromosome != null ? !this.chromosome.equals(that.chromosome) : that.chromosome != null) {
            return false;
        }
        if (this.variantClassification != that.variantClassification) {
            return false;
        }
        if (this.secondaryVariantClassification != that.secondaryVariantClassification) {
            return false;
        }
        if (this.variantType != that.variantType) {
            return false;
        }
        if (this.refAllele != null ? !this.refAllele.equals(that.refAllele) : that.refAllele != null) {
            return false;
        }
        if (this.tumorSeqAllele2 != null ? !this.tumorSeqAllele2.equals(that.tumorSeqAllele2) : that.tumorSeqAllele2 != null) {
            return false;
        }
        if (this.genomeChange != null ? !this.genomeChange.equals(that.genomeChange) : that.genomeChange != null) {
            return false;
        }
        if (this.annotationTranscript != null ? !this.annotationTranscript.equals(that.annotationTranscript) : that.annotationTranscript != null) {
            return false;
        }
        if (this.transcriptStrand != null ? !this.transcriptStrand.equals(that.transcriptStrand) : that.transcriptStrand != null) {
            return false;
        }
        if (this.transcriptExon != null ? !this.transcriptExon.equals(that.transcriptExon) : that.transcriptExon != null) {
            return false;
        }
        if (this.transcriptStartPos != null ? !this.transcriptStartPos.equals(that.transcriptStartPos) : that.transcriptStartPos != null) {
            return false;
        }
        if (this.transcriptEndPos != null ? !this.transcriptEndPos.equals(that.transcriptEndPos) : that.transcriptEndPos != null) {
            return false;
        }
        if (this.cDnaChange != null ? !this.cDnaChange.equals(that.cDnaChange) : that.cDnaChange != null) {
            return false;
        }
        if (this.codonChange != null ? !this.codonChange.equals(that.codonChange) : that.codonChange != null) {
            return false;
        }
        if (this.proteinChange != null ? !this.proteinChange.equals(that.proteinChange) : that.proteinChange != null) {
            return false;
        }
        if (this.gcContent != null ? !this.gcContent.equals(that.gcContent) : that.gcContent != null) {
            return false;
        }
        if (this.referenceContext != null ? !this.referenceContext.equals(that.referenceContext) : that.referenceContext != null) {
            return false;
        }
        if (this.otherTranscripts != null ? !this.otherTranscripts.equals(that.otherTranscripts) : that.otherTranscripts != null) {
            return false;
        }
        if (this.dataSourceName != null ? !this.dataSourceName.equals(that.dataSourceName) : that.dataSourceName != null) {
            return false;
        }
        if (this.locusLevel != null ? !this.locusLevel.equals(that.locusLevel) : that.locusLevel != null) {
            return false;
        }
        if (this.apprisRank != that.apprisRank) {
            return false;
        }
        if (this.transcriptLength != null ? !this.transcriptLength.equals(that.transcriptLength) : that.transcriptLength != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.geneTranscriptType != that.geneTranscriptType) {
            return false;
        }
        if (this.hugoSymbolSerializedOverride != null ? !this.hugoSymbolSerializedOverride.equals(that.hugoSymbolSerializedOverride) : that.hugoSymbolSerializedOverride != null) {
            return false;
        }
        if (this.ncbiBuildSerializedOverride != null ? !this.ncbiBuildSerializedOverride.equals(that.ncbiBuildSerializedOverride) : that.ncbiBuildSerializedOverride != null) {
            return false;
        }
        if (this.chromosomeSerializedOverride != null ? !this.chromosomeSerializedOverride.equals(that.chromosomeSerializedOverride) : that.chromosomeSerializedOverride != null) {
            return false;
        }
        if (this.startSerializedOverride != null ? !this.startSerializedOverride.equals(that.startSerializedOverride) : that.startSerializedOverride != null) {
            return false;
        }
        if (this.endSerializedOverride != null ? !this.endSerializedOverride.equals(that.endSerializedOverride) : that.endSerializedOverride != null) {
            return false;
        }
        if (this.variantClassificationSerializedOverride != null ? !this.variantClassificationSerializedOverride.equals(that.variantClassificationSerializedOverride) : that.variantClassificationSerializedOverride != null) {
            return false;
        }
        if (this.secondaryVariantClassificationSerializedOverride != null ? !this.secondaryVariantClassificationSerializedOverride.equals(that.secondaryVariantClassificationSerializedOverride) : that.secondaryVariantClassificationSerializedOverride != null) {
            return false;
        }
        if (this.variantTypeSerializedOverride != null ? !this.variantTypeSerializedOverride.equals(that.variantTypeSerializedOverride) : that.variantTypeSerializedOverride != null) {
            return false;
        }
        if (this.refAlleleSerializedOverride != null ? !this.refAlleleSerializedOverride.equals(that.refAlleleSerializedOverride) : that.refAlleleSerializedOverride != null) {
            return false;
        }
        if (this.tumorSeqAllele1SerializedOverride != null ? !this.tumorSeqAllele1SerializedOverride.equals(that.tumorSeqAllele1SerializedOverride) : that.tumorSeqAllele1SerializedOverride != null) {
            return false;
        }
        if (this.tumorSeqAllele2SerializedOverride != null ? !this.tumorSeqAllele2SerializedOverride.equals(that.tumorSeqAllele2SerializedOverride) : that.tumorSeqAllele2SerializedOverride != null) {
            return false;
        }
        if (this.genomeChangeSerializedOverride != null ? !this.genomeChangeSerializedOverride.equals(that.genomeChangeSerializedOverride) : that.genomeChangeSerializedOverride != null) {
            return false;
        }
        if (this.annotationTranscriptSerializedOverride != null ? !this.annotationTranscriptSerializedOverride.equals(that.annotationTranscriptSerializedOverride) : that.annotationTranscriptSerializedOverride != null) {
            return false;
        }
        if (this.transcriptStrandSerializedOverride != null ? !this.transcriptStrandSerializedOverride.equals(that.transcriptStrandSerializedOverride) : that.transcriptStrandSerializedOverride != null) {
            return false;
        }
        if (this.transcriptExonSerializedOverride != null ? !this.transcriptExonSerializedOverride.equals(that.transcriptExonSerializedOverride) : that.transcriptExonSerializedOverride != null) {
            return false;
        }
        if (this.transcriptPosSerializedOverride != null ? !this.transcriptPosSerializedOverride.equals(that.transcriptPosSerializedOverride) : that.transcriptPosSerializedOverride != null) {
            return false;
        }
        if (this.cDnaChangeSerializedOverride != null ? !this.cDnaChangeSerializedOverride.equals(that.cDnaChangeSerializedOverride) : that.cDnaChangeSerializedOverride != null) {
            return false;
        }
        if (this.codonChangeSerializedOverride != null ? !this.codonChangeSerializedOverride.equals(that.codonChangeSerializedOverride) : that.codonChangeSerializedOverride != null) {
            return false;
        }
        if (this.proteinChangeSerializedOverride != null ? !this.proteinChangeSerializedOverride.equals(that.proteinChangeSerializedOverride) : that.proteinChangeSerializedOverride != null) {
            return false;
        }
        if (this.gcContentSerializedOverride != null ? !this.gcContentSerializedOverride.equals(that.gcContentSerializedOverride) : that.gcContentSerializedOverride != null) {
            return false;
        }
        if (this.referenceContextSerializedOverride != null ? !this.referenceContextSerializedOverride.equals(that.referenceContextSerializedOverride) : that.referenceContextSerializedOverride != null) {
            return false;
        }
        if (this.otherTranscriptsSerializedOverride != null ? !this.otherTranscriptsSerializedOverride.equals(that.otherTranscriptsSerializedOverride) : that.otherTranscriptsSerializedOverride != null) {
            return false;
        }
        return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
    }

    public int hashCode() {
        int result = this.hugoSymbol != null ? this.hugoSymbol.hashCode() : 0;
        result = 31 * result + (this.ncbiBuild != null ? this.ncbiBuild.hashCode() : 0);
        result = 31 * result + (this.chromosome != null ? this.chromosome.hashCode() : 0);
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        result = 31 * result + (this.variantClassification != null ? this.variantClassification.hashCode() : 0);
        result = 31 * result + (this.secondaryVariantClassification != null ? this.secondaryVariantClassification.hashCode() : 0);
        result = 31 * result + (this.variantType != null ? this.variantType.hashCode() : 0);
        result = 31 * result + (this.refAllele != null ? this.refAllele.hashCode() : 0);
        result = 31 * result + (this.tumorSeqAllele2 != null ? this.tumorSeqAllele2.hashCode() : 0);
        result = 31 * result + (this.genomeChange != null ? this.genomeChange.hashCode() : 0);
        result = 31 * result + (this.annotationTranscript != null ? this.annotationTranscript.hashCode() : 0);
        result = 31 * result + (this.transcriptStrand != null ? this.transcriptStrand.hashCode() : 0);
        result = 31 * result + (this.transcriptExon != null ? this.transcriptExon.hashCode() : 0);
        result = 31 * result + (this.transcriptStartPos != null ? this.transcriptStartPos.hashCode() : 0);
        result = 31 * result + (this.transcriptEndPos != null ? this.transcriptEndPos.hashCode() : 0);
        result = 31 * result + (this.cDnaChange != null ? this.cDnaChange.hashCode() : 0);
        result = 31 * result + (this.codonChange != null ? this.codonChange.hashCode() : 0);
        result = 31 * result + (this.proteinChange != null ? this.proteinChange.hashCode() : 0);
        result = 31 * result + (this.gcContent != null ? this.gcContent.hashCode() : 0);
        result = 31 * result + (this.referenceContext != null ? this.referenceContext.hashCode() : 0);
        result = 31 * result + (this.otherTranscripts != null ? this.otherTranscripts.hashCode() : 0);
        result = 31 * result + (this.dataSourceName != null ? this.dataSourceName.hashCode() : 0);
        result = 31 * result + (this.locusLevel != null ? this.locusLevel.hashCode() : 0);
        result = 31 * result + (this.apprisRank != null ? this.apprisRank.hashCode() : 0);
        result = 31 * result + (this.transcriptLength != null ? this.transcriptLength.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.geneTranscriptType != null ? this.geneTranscriptType.hashCode() : 0);
        result = 31 * result + (this.hugoSymbolSerializedOverride != null ? this.hugoSymbolSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.ncbiBuildSerializedOverride != null ? this.ncbiBuildSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.chromosomeSerializedOverride != null ? this.chromosomeSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.startSerializedOverride != null ? this.startSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.endSerializedOverride != null ? this.endSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.variantClassificationSerializedOverride != null ? this.variantClassificationSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.secondaryVariantClassificationSerializedOverride != null ? this.secondaryVariantClassificationSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.variantTypeSerializedOverride != null ? this.variantTypeSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.refAlleleSerializedOverride != null ? this.refAlleleSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.tumorSeqAllele1SerializedOverride != null ? this.tumorSeqAllele1SerializedOverride.hashCode() : 0);
        result = 31 * result + (this.tumorSeqAllele2SerializedOverride != null ? this.tumorSeqAllele2SerializedOverride.hashCode() : 0);
        result = 31 * result + (this.genomeChangeSerializedOverride != null ? this.genomeChangeSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.annotationTranscriptSerializedOverride != null ? this.annotationTranscriptSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.transcriptStrandSerializedOverride != null ? this.transcriptStrandSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.transcriptExonSerializedOverride != null ? this.transcriptExonSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.transcriptPosSerializedOverride != null ? this.transcriptPosSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.cDnaChangeSerializedOverride != null ? this.cDnaChangeSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.codonChangeSerializedOverride != null ? this.codonChangeSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.proteinChangeSerializedOverride != null ? this.proteinChangeSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.gcContentSerializedOverride != null ? this.gcContentSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.referenceContextSerializedOverride != null ? this.referenceContextSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.otherTranscriptsSerializedOverride != null ? this.otherTranscriptsSerializedOverride.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String getHugoSymbol() {
        return this.hugoSymbol;
    }

    public void setHugoSymbol(String hugoSymbol) {
        this.hugoSymbol = hugoSymbol;
    }

    public String getNcbiBuild() {
        return this.ncbiBuild;
    }

    public void setNcbiBuild(String ncbiBuild) {
        this.ncbiBuild = ncbiBuild;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public void setChromosome(String chromosome) {
        this.chromosome = chromosome;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public VariantClassification getVariantClassification() {
        return this.variantClassification;
    }

    public void setVariantClassification(VariantClassification variantClassification) {
        this.variantClassification = variantClassification;
    }

    public VariantClassification getSecondaryVariantClassification() {
        return this.secondaryVariantClassification;
    }

    public void setSecondaryVariantClassification(VariantClassification secondaryVariantClassification) {
        this.secondaryVariantClassification = secondaryVariantClassification;
    }

    public VariantType getVariantType() {
        return this.variantType;
    }

    public void setVariantType(VariantType variantType) {
        this.variantType = variantType;
    }

    public String getRefAllele() {
        return this.refAllele;
    }

    public void setRefAllele(String refAllele) {
        this.refAllele = refAllele;
    }

    public String getTumorSeqAllele2() {
        return this.tumorSeqAllele2;
    }

    public void setTumorSeqAllele2(String tumorSeqAllele2) {
        this.tumorSeqAllele2 = tumorSeqAllele2;
    }

    public String getGenomeChange() {
        return this.genomeChange;
    }

    public void setGenomeChange(String genomeChange) {
        this.genomeChange = genomeChange;
    }

    public String getAnnotationTranscript() {
        return this.annotationTranscript;
    }

    public void setAnnotationTranscript(String annotationTranscript) {
        this.annotationTranscript = annotationTranscript;
    }

    public String getTranscriptStrand() {
        return this.transcriptStrand;
    }

    public void setTranscriptStrand(String transcriptStrand) {
        this.transcriptStrand = transcriptStrand;
    }

    public Integer getTranscriptExonNumber() {
        return this.transcriptExon;
    }

    public void setTranscriptExonNumber(Integer transcriptExonNumber) {
        this.transcriptExon = transcriptExonNumber;
    }

    public Integer getTranscriptStartPos() {
        return this.transcriptStartPos;
    }

    public void setTranscriptStartPos(Integer transcriptStartPos) {
        this.transcriptStartPos = transcriptStartPos;
    }

    public Integer getTranscriptEndPos() {
        return this.transcriptEndPos;
    }

    public void setTranscriptEndPos(Integer transcriptEndPos) {
        this.transcriptEndPos = transcriptEndPos;
    }

    public String getcDnaChange() {
        return this.cDnaChange;
    }

    public void setcDnaChange(String cDnaChange) {
        this.cDnaChange = cDnaChange;
    }

    public String getCodonChange() {
        return this.codonChange;
    }

    public void setCodonChange(String codonChange) {
        this.codonChange = codonChange;
    }

    public String getProteinChange() {
        return this.proteinChange;
    }

    public void setProteinChange(String proteinChange) {
        this.proteinChange = proteinChange;
    }

    public Double getGcContent() {
        return this.gcContent;
    }

    public void setGcContent(Double gcContent) {
        this.gcContent = gcContent;
    }

    public List<String> getOtherTranscripts() {
        return this.otherTranscripts;
    }

    public void setOtherTranscripts(List<String> otherTranscripts) {
        this.otherTranscripts = otherTranscripts;
    }

    public Integer getLocusLevel() {
        return this.locusLevel;
    }

    public void setLocusLevel(Integer locusLevel) {
        this.locusLevel = locusLevel;
    }

    public GencodeGtfFeature.FeatureTag getApprisRank() {
        return this.apprisRank;
    }

    public void setApprisRank(GencodeGtfFeature.FeatureTag apprisRank) {
        this.apprisRank = apprisRank;
    }

    public Integer getTranscriptLength() {
        return this.transcriptLength;
    }

    public void setTranscriptLength(Integer transcriptLength) {
        this.transcriptLength = transcriptLength;
    }

    public String getReferenceContext() {
        return this.referenceContext;
    }

    public void setReferenceContext(String referenceContext) {
        this.referenceContext = referenceContext;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public GencodeGtfFeature.GeneTranscriptType getGeneTranscriptType() {
        return this.geneTranscriptType;
    }

    public void setGeneTranscriptType(GencodeGtfFeature.GeneTranscriptType geneTranscriptType) {
        this.geneTranscriptType = geneTranscriptType;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setMetadata(FuncotationMetadata metadata) {
        this.metadata = metadata;
    }

    private String getTranscriptPosString() {
        if (this.transcriptStartPos == null) {
            return "";
        }
        if (this.transcriptStartPos.equals(this.transcriptEndPos)) {
            return String.valueOf(this.transcriptStartPos);
        }
        return this.transcriptStartPos + "_" + this.transcriptEndPos;
    }

    public static enum VariantClassification {
        COULD_NOT_DETERMINE("COULD_NOT_DETERMINE", 99),
        INTRON("INTRON", 10),
        FIVE_PRIME_UTR("FIVE_PRIME_UTR", 6),
        THREE_PRIME_UTR("THREE_PRIME_UTR", 6),
        IGR("IGR", 20),
        FIVE_PRIME_FLANK("FIVE_PRIME_FLANK", 15),
        THREE_PRIME_FLANK("THREE_PRIME_FLANK", 16),
        MISSENSE("MISSENSE", 1),
        NONSENSE("NONSENSE", 0),
        NONSTOP("NONSTOP", 0),
        SILENT("SILENT", 5),
        SPLICE_SITE("SPLICE_SITE", 4),
        IN_FRAME_DEL("IN_FRAME_DEL", 1),
        IN_FRAME_INS("IN_FRAME_INS", 1),
        FRAME_SHIFT_INS("FRAME_SHIFT_INS", 2),
        FRAME_SHIFT_DEL("FRAME_SHIFT_DEL", 2),
        START_CODON_SNP("START_CODON_SNP", 3),
        START_CODON_INS("START_CODON_INS", 3),
        START_CODON_DEL("START_CODON_DEL", 3),
        DE_NOVO_START_IN_FRAME("DE_NOVO_START_IN_FRAME", 1),
        DE_NOVO_START_OUT_FRAME("DE_NOVO_START_OUT_FRAME", 0),
        RNA("RNA", 4),
        LINCRNA("LINCRNA", 4);

        private final int relativeSeverity;
        private final String serialized;

        private VariantClassification(String serialized, int sev) {
            this.serialized = serialized;
            this.relativeSeverity = sev;
        }

        public int getSeverity() {
            return this.relativeSeverity;
        }

        public String toString() {
            return this.serialized;
        }
    }

    public static enum VariantType {
        INS("INS"),
        DEL("DEL"),
        SNP("SNP"),
        DNP("DNP"),
        TNP("TNP"),
        ONP("ONP"),
        MNP("MNP"),
        NA("NA");

        private final String serialized;

        private VariantType(String serialized) {
            this.serialized = serialized;
        }

        public String toString() {
            return this.serialized;
        }
    }
}

