/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.tribble.annotation.Strand;
import htsjdk.variant.variantcontext.Allele;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadataUtils;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeature;

public class GencodeFuncotationBuilder {
    @VisibleForTesting
    GencodeFuncotation gencodeFuncotation;

    public GencodeFuncotationBuilder() {
        this.gencodeFuncotation = new GencodeFuncotation();
    }

    public GencodeFuncotationBuilder(GencodeFuncotation gf) {
        this.gencodeFuncotation = new GencodeFuncotation(gf);
    }

    public GencodeFuncotation build() {
        this.gencodeFuncotation.setMetadata(FuncotationMetadataUtils.createWithUnknownAttributes(new ArrayList<String>(this.gencodeFuncotation.getFieldNames())));
        return this.gencodeFuncotation;
    }

    public GencodeFuncotationBuilder setRefAllele(Allele refAllele) {
        this.gencodeFuncotation.setRefAllele(refAllele.getBaseString());
        return this;
    }

    public GencodeFuncotationBuilder setStrand(Strand strand) {
        switch (strand) {
            case POSITIVE: {
                this.gencodeFuncotation.setTranscriptStrand("+");
                break;
            }
            case NEGATIVE: {
                this.gencodeFuncotation.setTranscriptStrand("-");
                break;
            }
            default: {
                throw new GATKException.ShouldNeverReachHereException("An invalid Strand type was specified.  Strand must be POSITIVE or NEGATIVE.");
            }
        }
        return this;
    }

    public GencodeFuncotationBuilder setHugoSymbol(String hugoSymbol) {
        this.gencodeFuncotation.setHugoSymbol(hugoSymbol);
        return this;
    }

    public GencodeFuncotationBuilder setNcbiBuild(String ncbiBuild) {
        this.gencodeFuncotation.setNcbiBuild(ncbiBuild);
        return this;
    }

    public GencodeFuncotationBuilder setChromosome(String chromosomeName) {
        this.gencodeFuncotation.setChromosome(chromosomeName);
        return this;
    }

    public GencodeFuncotationBuilder setStart(int start) {
        this.gencodeFuncotation.setStart(start);
        return this;
    }

    public GencodeFuncotationBuilder setEnd(int end) {
        this.gencodeFuncotation.setEnd(end);
        return this;
    }

    public GencodeFuncotationBuilder setVariantType(GencodeFuncotation.VariantType variantType) {
        this.gencodeFuncotation.setVariantType(variantType);
        return this;
    }

    public GencodeFuncotationBuilder setTumorSeqAllele2(String altAllele) {
        this.gencodeFuncotation.setTumorSeqAllele2(altAllele);
        return this;
    }

    public GencodeFuncotationBuilder setGenomeChange(String genomeChange) {
        this.gencodeFuncotation.setGenomeChange(genomeChange);
        return this;
    }

    public GencodeFuncotationBuilder setAnnotationTranscript(String transcriptId) {
        this.gencodeFuncotation.setAnnotationTranscript(transcriptId);
        return this;
    }

    public GencodeFuncotationBuilder setTranscriptStartPos(Integer transcriptStartPos) {
        this.gencodeFuncotation.setTranscriptStartPos(transcriptStartPos);
        return this;
    }

    public GencodeFuncotationBuilder setTranscriptEndPos(Integer transcriptEndPos) {
        this.gencodeFuncotation.setTranscriptEndPos(transcriptEndPos);
        return this;
    }

    public GencodeFuncotationBuilder setOtherTranscripts(List<String> transcripts) {
        this.gencodeFuncotation.setOtherTranscripts(transcripts);
        return this;
    }

    public GencodeFuncotationBuilder setVariantClassification(GencodeFuncotation.VariantClassification variantClassification) {
        this.gencodeFuncotation.setVariantClassification(variantClassification);
        return this;
    }

    public GencodeFuncotationBuilder setSecondaryVariantClassification(GencodeFuncotation.VariantClassification variantClassification) {
        this.gencodeFuncotation.setSecondaryVariantClassification(variantClassification);
        return this;
    }

    public GencodeFuncotationBuilder setTranscriptExonNumber(int transcriptExonNumber) {
        this.gencodeFuncotation.setTranscriptExonNumber(transcriptExonNumber);
        return this;
    }

    public GencodeFuncotationBuilder setCodonChange(String codonChange) {
        this.gencodeFuncotation.setCodonChange(codonChange);
        return this;
    }

    public GencodeFuncotationBuilder setProteinChange(String proteinChange) {
        this.gencodeFuncotation.setProteinChange(proteinChange);
        return this;
    }

    public GencodeFuncotationBuilder setcDnaChange(String cDnaChange) {
        this.gencodeFuncotation.setcDnaChange(cDnaChange);
        return this;
    }

    public GencodeFuncotationBuilder setLocusLevel(Integer locusLevel) {
        this.gencodeFuncotation.setLocusLevel(locusLevel);
        return this;
    }

    public GencodeFuncotationBuilder setApprisRank(GencodeGtfFeature.FeatureTag apprisRank) {
        this.gencodeFuncotation.setApprisRank(apprisRank);
        return this;
    }

    public GencodeFuncotationBuilder setTranscriptLength(Integer transcriptLength) {
        this.gencodeFuncotation.setTranscriptLength(transcriptLength);
        return this;
    }

    public GencodeFuncotationBuilder setGcContent(Double gcContent) {
        this.gencodeFuncotation.setGcContent(gcContent);
        return this;
    }

    public GencodeFuncotationBuilder setReferenceContext(String referenceContext) {
        this.gencodeFuncotation.setReferenceContext(referenceContext);
        return this;
    }

    public GencodeFuncotationBuilder setVersion(String version) {
        this.gencodeFuncotation.setVersion(version);
        return this;
    }

    public GencodeFuncotationBuilder setGeneTranscriptType(GencodeGtfFeature.GeneTranscriptType geneTranscriptType) {
        this.gencodeFuncotation.setGeneTranscriptType(geneTranscriptType);
        return this;
    }

    public GencodeFuncotationBuilder setDataSourceName(String name) {
        this.gencodeFuncotation.setDataSourceName(name);
        return this;
    }
}

