/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.Feature;
import htsjdk.tribble.annotation.Strand;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.AminoAcid;
import org.broadinstitute.hellbender.tools.funcotator.DataSourceFuncotationFactory;
import org.broadinstitute.hellbender.tools.funcotator.FlankSettings;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorArgumentDefinitions;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorConstants;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.ProteinChangeInfo;
import org.broadinstitute.hellbender.tools.funcotator.SequenceComparison;
import org.broadinstitute.hellbender.tools.funcotator.StrandCorrectedReferenceBases;
import org.broadinstitute.hellbender.tools.funcotator.TranscriptSelectionMode;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotationBuilder;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.segment.SegmentExonUtils;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadata;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadataUtils;
import org.broadinstitute.hellbender.tools.funcotator.metadata.VcfFuncotationMetadata;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfExonFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfGeneFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfStartCodonFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfTranscriptFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfUTRFeature;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.nio.NioFileCopierWithProgressMeter;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.reference.ReferenceUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.sqlite.util.StringUtils;

public class GencodeFuncotationFactory
extends DataSourceFuncotationFactory {
    public static final String DEFAULT_NAME = "Gencode";
    public static final String OTHER_TRANSCRIPTS_INFO_SEP = "_";
    protected static final Logger logger = LogManager.getLogger(GencodeFuncotationFactory.class);
    private static final String LOCAL_GENCODE_TRANSCRIPT_TMP_DIR_PREFIX = "localGencodeTranscriptFastaFolder";
    private static final String LOCAL_GENCODE_TRANSCRIPT_FILE_BASE_NAME = "gencodeTranscriptFastaFile";
    private static final int spliceSiteVariantWindowBases = 2;
    private static final int gcContentWindowSizeBases = 200;
    private static final int numLeadingBasesForUtrAnnotationSequenceConstruction = 2;
    private static final int defaultNumTrailingBasesForUtrAnnotationSequenceConstruction = 3;
    @VisibleForTesting
    static final int TRANSCRIPT_END_WINDOW_PADDING_THRESHOLD = 10;
    private static final int referenceWindow = 10;
    private static final HashSet<GencodeGtfFeature.FeatureTag> apprisRanks = new HashSet<GencodeGtfFeature.FeatureTag>(Arrays.asList(GencodeGtfFeature.FeatureTag.APPRIS_PRINCIPAL, GencodeGtfFeature.FeatureTag.APPRIS_PRINCIPAL_1, GencodeGtfFeature.FeatureTag.APPRIS_PRINCIPAL_2, GencodeGtfFeature.FeatureTag.APPRIS_PRINCIPAL_3, GencodeGtfFeature.FeatureTag.APPRIS_PRINCIPAL_4, GencodeGtfFeature.FeatureTag.APPRIS_PRINCIPAL_5, GencodeGtfFeature.FeatureTag.APPRIS_ALTERNATIVE_1, GencodeGtfFeature.FeatureTag.APPRIS_ALTERNATIVE_2, GencodeGtfFeature.FeatureTag.APPRIS_CANDIDATE_HIGHEST_SCORE, GencodeGtfFeature.FeatureTag.APPRIS_CANDIDATE_LONGEST_CCDS, GencodeGtfFeature.FeatureTag.APPRIS_CANDIDATE_CCDS, GencodeGtfFeature.FeatureTag.APPRIS_CANDIDATE_LONGEST_SEQ, GencodeGtfFeature.FeatureTag.APPRIS_CANDIDATE_LONGEST, GencodeGtfFeature.FeatureTag.APPRIS_CANDIDATE));
    private static final Set<GencodeFuncotation.VariantClassification> codingVariantClassifications = Sets.newHashSet(Arrays.asList(GencodeFuncotation.VariantClassification.MISSENSE, GencodeFuncotation.VariantClassification.NONSENSE, GencodeFuncotation.VariantClassification.NONSTOP, GencodeFuncotation.VariantClassification.SILENT, GencodeFuncotation.VariantClassification.IN_FRAME_DEL, GencodeFuncotation.VariantClassification.IN_FRAME_INS, GencodeFuncotation.VariantClassification.FRAME_SHIFT_INS, GencodeFuncotation.VariantClassification.FRAME_SHIFT_DEL, GencodeFuncotation.VariantClassification.START_CODON_SNP, GencodeFuncotation.VariantClassification.START_CODON_INS, GencodeFuncotation.VariantClassification.START_CODON_DEL));
    public static final String GENES_SUFFIX = "_genes";
    public static final String START_GENE_SUFFIX = "_start_gene";
    public static final String END_GENE_SUFFIX = "_end_gene";
    public static final String START_EXON_SUFFIX = "_start_exon";
    public static final String END_EXON_SUFFIX = "_end_exon";
    private static final String GENES_FIELD_SEPARATOR = ",";
    private static final String NO_GENE_INFO_STR = "";
    private static final String LEGACY_SEGMENT_ALT_ALLELE_VALUE = "";
    private static final String LEGACY_SEGMENT_REF_ALLELE_VALUE = "";
    private final String name;
    private final ReferenceDataSource transcriptFastaReferenceDataSource;
    private final Map<String, MappedTranscriptIdInfo> transcriptIdMap;
    private final TranscriptSelectionMode transcriptSelectionMode;
    private final Set<String> userRequestedTranscripts;
    private final Path gencodeTranscriptFastaFile;
    private String ncbiBuildVersion = null;
    private final Comparator<GencodeFuncotation> gencodeFuncotationComparator;
    private final FlankSettings flankSettings;
    private final FuncotationMetadata segmentMetadata;
    private boolean isSegmentFuncotationEnabled;

    public GencodeFuncotationFactory(Path gencodeTranscriptFastaFilePath, String version, String name, TranscriptSelectionMode transcriptSelectionMode, Set<String> userRequestedTranscripts, LinkedHashMap<String, String> annotationOverrides, FeatureInput<? extends Feature> mainFeatureInput, String ncbiBuildVersion) {
        this(gencodeTranscriptFastaFilePath, version, name, transcriptSelectionMode, userRequestedTranscripts, annotationOverrides, mainFeatureInput, new FlankSettings(0, 0), ncbiBuildVersion);
    }

    public GencodeFuncotationFactory(Path gencodeTranscriptFastaFilePath, String version, String name, TranscriptSelectionMode transcriptSelectionMode, Set<String> userRequestedTranscripts, LinkedHashMap<String, String> annotationOverrides, FeatureInput<? extends Feature> mainFeatureInput, FlankSettings flankSettings, String ncbiBuildVersion) {
        this(gencodeTranscriptFastaFilePath, version, name, transcriptSelectionMode, userRequestedTranscripts, annotationOverrides, mainFeatureInput, flankSettings, false, ncbiBuildVersion, true);
    }

    public GencodeFuncotationFactory(Path gencodeTranscriptFastaFilePath, String version, String name, TranscriptSelectionMode transcriptSelectionMode, Set<String> userRequestedTranscripts, LinkedHashMap<String, String> annotationOverrides, FeatureInput<? extends Feature> mainFeatureInput, FlankSettings flankSettings, boolean isDataSourceB37, String ncbiBuildVersion, boolean isSegmentFuncotationEnabled) {
        this(gencodeTranscriptFastaFilePath, version, name, transcriptSelectionMode, userRequestedTranscripts, annotationOverrides, mainFeatureInput, flankSettings, isDataSourceB37, ncbiBuildVersion, isSegmentFuncotationEnabled, 150);
    }

    public GencodeFuncotationFactory(Path gencodeTranscriptFastaFilePath, String version, String name, TranscriptSelectionMode transcriptSelectionMode, Set<String> userRequestedTranscripts, LinkedHashMap<String, String> annotationOverrides, FeatureInput<? extends Feature> mainFeatureInput, FlankSettings flankSettings, boolean isDataSourceB37, String ncbiBuildVersion, boolean isSegmentFuncotationEnabled, int minBasesForValidSegment) {
        super(mainFeatureInput, minBasesForValidSegment);
        this.gencodeTranscriptFastaFile = this.localizeGencodeTranscriptFastaFile(gencodeTranscriptFastaFilePath);
        this.flankSettings = flankSettings;
        this.transcriptFastaReferenceDataSource = ReferenceDataSource.of(this.gencodeTranscriptFastaFile);
        this.transcriptIdMap = GencodeFuncotationFactory.createTranscriptIdMap(this.transcriptFastaReferenceDataSource);
        this.transcriptSelectionMode = transcriptSelectionMode;
        this.version = version;
        this.name = name;
        this.dataSourceIsB37 = isDataSourceB37;
        this.ncbiBuildVersion = ncbiBuildVersion;
        this.isSegmentFuncotationEnabled = isSegmentFuncotationEnabled;
        this.userRequestedTranscripts = new HashSet<String>();
        for (String transcript : userRequestedTranscripts) {
            this.userRequestedTranscripts.add(FuncotatorUtils.getTranscriptIdWithoutVersionNumber(transcript));
        }
        this.gencodeFuncotationComparator = transcriptSelectionMode.getComparator(userRequestedTranscripts);
        this.segmentMetadata = isSegmentFuncotationEnabled ? this.createSegmentFuncotationMetadata() : FuncotationMetadataUtils.createWithUnknownAttributes(Collections.emptyList());
        this.initializeAnnotationOverrides(annotationOverrides);
    }

    private Path localizeGencodeTranscriptFastaFile(Path gencodeTranscriptFastaFilePath) {
        if (gencodeTranscriptFastaFilePath.getFileSystem().equals(FileSystems.getDefault())) {
            return gencodeTranscriptFastaFilePath;
        }
        Path remoteGencodeTranscriptFastaIndexFilePath = IOUtils.getPath(ReferenceUtils.getFastaIndexFileName(gencodeTranscriptFastaFilePath.toUri().toString()));
        Path remoteGencodeTranscriptFastaSequenceDictionaryFilePath = IOUtils.getPath(ReferenceUtils.getFastaDictionaryFileName(gencodeTranscriptFastaFilePath.toUri().toString()));
        File tmpDir = IOUtils.createTempDir(LOCAL_GENCODE_TRANSCRIPT_TMP_DIR_PREFIX);
        tmpDir.deleteOnExit();
        Path tmpDirPath = tmpDir.toPath();
        Path localGencodeTranscriptFastaFilePath = tmpDirPath.resolve("gencodeTranscriptFastaFile.fa");
        Path localGencodeTranscriptFastaIndexFilePath = IOUtils.getPath(ReferenceUtils.getFastaIndexFileName(localGencodeTranscriptFastaFilePath.toUri().toString()));
        Path localGencodeTranscriptFastaSequenceDictionaryFilePath = IOUtils.getPath(ReferenceUtils.getFastaDictionaryFileName(localGencodeTranscriptFastaFilePath.toUri().toString()));
        logger.info("Localizing Gencode transcript FASTA file for faster lookup times...");
        NioFileCopierWithProgressMeter.create(gencodeTranscriptFastaFilePath, localGencodeTranscriptFastaFilePath, true).initiateCopy();
        NioFileCopierWithProgressMeter.create(remoteGencodeTranscriptFastaIndexFilePath, localGencodeTranscriptFastaIndexFilePath, true).initiateCopy();
        NioFileCopierWithProgressMeter.create(remoteGencodeTranscriptFastaSequenceDictionaryFilePath, localGencodeTranscriptFastaSequenceDictionaryFilePath, true).initiateCopy();
        return localGencodeTranscriptFastaFilePath;
    }

    @Override
    public Class<? extends Feature> getAnnotationFeatureClass() {
        return GencodeGtfFeature.class;
    }

    @Override
    public String getInfoString() {
        return this.getName() + " " + this.getVersion() + " " + this.transcriptSelectionMode.toString();
    }

    @Override
    public void close() {
        this.transcriptFastaReferenceDataSource.close();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LinkedHashSet<String> getSupportedFuncotationFields() {
        return new LinkedHashSet<String>(Arrays.asList(this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_hugoSymbol", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_ncbiBuild", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_chromosome", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_start", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_end", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_variantClassification", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_secondaryVariantClassification", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_variantType", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_refAllele", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_tumorSeqAllele1", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_tumorSeqAllele2", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_genomeChange", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_annotationTranscript", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_transcriptStrand", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_transcriptExon", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_transcriptPos", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_cDnaChange", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_codonChange", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_proteinChange", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_gcContent", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_referenceContext", this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_otherTranscripts"));
    }

    @Override
    protected List<Funcotation> createDefaultFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext) {
        if (FuncotatorUtils.isSegmentVariantContext(variant, this.minBasesForValidSegment)) {
            return this.createSegmentFuncotations(variant, Collections.emptyList(), null, null, null, null);
        }
        ArrayList<Funcotation> funcotationList = new ArrayList<Funcotation>();
        funcotationList.addAll(this.createIgrFuncotations(variant, referenceContext));
        return funcotationList;
    }

    private List<GencodeFuncotation> createGencodeFuncotationsByAllTranscripts(VariantContext variant, ReferenceContext referenceContext, Allele altAllele, List<GencodeGtfGeneFeature> gencodeGtfGeneFeatures) {
        List<GencodeFuncotation> gencodeFuncotationList = gencodeGtfGeneFeatures.stream().map(f -> this.createFuncotationsHelper(variant, altAllele, (GencodeGtfGeneFeature)f, referenceContext)).flatMap(Collection::stream).collect(Collectors.toList());
        if (gencodeFuncotationList.size() > 0) {
            this.sortFuncotationsByTranscriptForOutput(gencodeFuncotationList);
            this.populateOtherTranscriptsMapForFuncotation(gencodeFuncotationList);
        }
        if (this.transcriptSelectionMode != TranscriptSelectionMode.ALL && gencodeFuncotationList.size() > 0) {
            return Collections.singletonList(gencodeFuncotationList.get(0));
        }
        return gencodeFuncotationList;
    }

    private void populateOtherTranscriptsMapForFuncotation(List<GencodeFuncotation> gencodeFuncotations) {
        Map funcotationToCondensedString = gencodeFuncotations.stream().collect(Collectors.toMap(f -> f.getAnnotationTranscript(), GencodeFuncotationFactory::condenseGencodeFuncotation, (x, y) -> y, LinkedHashMap::new));
        for (GencodeFuncotation g : gencodeFuncotations) {
            List<String> otherTranscriptStrings = funcotationToCondensedString.keySet().stream().filter(f -> !f.equals(g.getAnnotationTranscript())).map(f -> (String)funcotationToCondensedString.get(f)).collect(Collectors.toList());
            g.setOtherTranscripts(otherTranscriptStrings);
        }
    }

    @Override
    protected List<Funcotation> createFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext, List<Feature> geneFeatureList) {
        ArrayList<Funcotation> outputFuncotations = new ArrayList<Funcotation>();
        List<Feature> nonNullFeatures = geneFeatureList.stream().filter(g -> g != null).collect(Collectors.toList());
        if (nonNullFeatures.size() > 0) {
            for (Allele altAllele : variant.getAlternateAlleles()) {
                List<GencodeGtfGeneFeature> gencodeGtfGeneFeatures;
                List<GencodeFuncotation> gencodeFuncotationList = this.createGencodeFuncotationsByAllTranscripts(variant, referenceContext, altAllele, gencodeGtfGeneFeatures = GencodeFuncotationFactory.convertFeaturesToGencodeGtfGeneFeatures(nonNullFeatures));
                if (!gencodeFuncotationList.isEmpty()) {
                    outputFuncotations.addAll(gencodeFuncotationList);
                    continue;
                }
                outputFuncotations.add(this.createIgrFuncotation(variant, altAllele, referenceContext));
            }
        } else {
            outputFuncotations.addAll(this.createIgrFuncotations(variant, referenceContext));
        }
        return outputFuncotations;
    }

    private static List<GencodeGtfGeneFeature> convertFeaturesToGencodeGtfGeneFeatures(List<Feature> nonNullFeatures) {
        return nonNullFeatures.stream().filter(g -> g != null).map(g -> (GencodeGtfGeneFeature)g).collect(Collectors.toList());
    }

    @Override
    protected List<Funcotation> createFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext, List<Feature> featureList, List<GencodeFuncotation> gencodeFuncotations) {
        throw new GATKException("This method should never be called on a " + this.getClass().getName());
    }

    @Override
    public FuncotatorArgumentDefinitions.DataSourceType getType() {
        return FuncotatorArgumentDefinitions.DataSourceType.GENCODE;
    }

    @Override
    protected SimpleInterval transformFeatureQueryInterval(SimpleInterval queryInterval) {
        int queryPadding = Math.max(this.flankSettings.fivePrimeFlankSize, this.flankSettings.threePrimeFlankSize);
        int newStart = queryInterval.getStart() - queryPadding;
        int newEnd = queryInterval.getEnd() + queryPadding;
        return new SimpleInterval(queryInterval.getContig(), newStart < 1 ? 1 : newStart, newEnd);
    }

    static void filterAnnotationsByUserTranscripts(List<GencodeFuncotation> funcotations, Set<String> selectedTranscripts) {
        if (selectedTranscripts != null && !selectedTranscripts.isEmpty()) {
            funcotations.removeIf(f -> !FuncotatorUtils.isFuncotationInTranscriptList(f, selectedTranscripts));
        }
    }

    @VisibleForTesting
    static Map<String, MappedTranscriptIdInfo> createTranscriptIdMap(ReferenceDataSource fastaReference) {
        HashMap<String, MappedTranscriptIdInfo> idMap = new HashMap<String, MappedTranscriptIdInfo>();
        for (SAMSequenceRecord sequence : fastaReference.getSequenceDictionary().getSequences()) {
            MappedTranscriptIdInfo transcriptInfo = GencodeFuncotationFactory.createMappedTranscriptIdInfo(sequence);
            for (String transcriptId : Utils.split(sequence.getSequenceName(), "|")) {
                idMap.put(transcriptId, transcriptInfo);
            }
        }
        return idMap;
    }

    private static MappedTranscriptIdInfo createMappedTranscriptIdInfo(SAMSequenceRecord sequence) {
        MappedTranscriptIdInfo transcriptIdInfo = new MappedTranscriptIdInfo();
        Pattern utrPattern = Pattern.compile("UTR[35]:(\\d+)-(\\d+)");
        Pattern cdsPattern = Pattern.compile("CDS:(\\d+)-(\\d+)");
        boolean has3pUtr = false;
        boolean has5pUtr = false;
        for (String field : Utils.split(sequence.getSequenceName(), "|")) {
            Matcher m;
            if (field.length() > 4 && field.substring(0, 5).equals("UTR5:")) {
                m = utrPattern.matcher(field);
                m.find();
                transcriptIdInfo.fivePrimeUtrStart = Integer.valueOf(m.group(1));
                transcriptIdInfo.fivePrimeUtrEnd = Integer.valueOf(m.group(2));
                has5pUtr = true;
                continue;
            }
            if (field.length() > 4 && field.substring(0, 5).equals("UTR3:")) {
                m = utrPattern.matcher(field);
                m.find();
                transcriptIdInfo.threePrimeUtrStart = Integer.valueOf(m.group(1));
                transcriptIdInfo.threePrimeUtrEnd = Integer.valueOf(m.group(2));
                has3pUtr = true;
                continue;
            }
            if (field.length() <= 3 || !field.substring(0, 4).equals("CDS:")) continue;
            m = cdsPattern.matcher(field);
            m.find();
            transcriptIdInfo.codingSequenceStart = Integer.valueOf(m.group(1));
            transcriptIdInfo.codingSequenceEnd = Integer.valueOf(m.group(2));
        }
        if (transcriptIdInfo.codingSequenceStart == 0) {
            transcriptIdInfo.codingSequenceStart = 1;
        }
        if (transcriptIdInfo.codingSequenceEnd == 0) {
            transcriptIdInfo.codingSequenceEnd = sequence.getSequenceLength();
        }
        transcriptIdInfo.mapKey = sequence.getSequenceName();
        transcriptIdInfo.has3pUtr = has3pUtr;
        transcriptIdInfo.has5pUtr = has5pUtr;
        return transcriptIdInfo;
    }

    private static String getCodingSequenceFromTranscriptFasta(String transcriptId, Map<String, MappedTranscriptIdInfo> transcriptIdMap, ReferenceDataSource transcriptFastaReferenceDataSource, String transcriptTailPaddingBaseString) {
        MappedTranscriptIdInfo transcriptMapIdAndMetadata = transcriptIdMap.get(transcriptId);
        if (transcriptMapIdAndMetadata == null) {
            throw new UserException.BadInput("Unable to find the given Transcript ID in our transcript list for our coding sequence (not in given transcript FASTA file): " + transcriptId);
        }
        SimpleInterval transcriptInterval = new SimpleInterval(transcriptMapIdAndMetadata.mapKey, transcriptMapIdAndMetadata.codingSequenceStart, transcriptMapIdAndMetadata.codingSequenceEnd);
        return transcriptFastaReferenceDataSource.queryAndPrefetch(transcriptInterval).getBaseString() + transcriptTailPaddingBaseString;
    }

    private static String getFivePrimeUtrSequenceFromTranscriptFasta(String transcriptId, Map<String, MappedTranscriptIdInfo> transcriptIdMap, ReferenceDataSource transcriptFastaReferenceDataSource, int extraBases) {
        MappedTranscriptIdInfo transcriptMapIdAndMetadata = transcriptIdMap.get(transcriptId);
        if (transcriptMapIdAndMetadata == null) {
            throw new UserException.BadInput("Unable to find the given Transcript ID in our transcript list for our 5'UTR (not in given transcript FASTA file): " + transcriptId);
        }
        if (transcriptMapIdAndMetadata.has5pUtr) {
            SimpleInterval transcriptInterval = new SimpleInterval(transcriptMapIdAndMetadata.mapKey, transcriptMapIdAndMetadata.fivePrimeUtrStart, transcriptMapIdAndMetadata.fivePrimeUtrEnd + extraBases);
            return transcriptFastaReferenceDataSource.queryAndPrefetch(transcriptInterval).getBaseString();
        }
        return "";
    }

    @VisibleForTesting
    static boolean isVariantInCodingRegion(GencodeFuncotation.VariantClassification varClass, GencodeFuncotation.VariantClassification secondaryVarClass) {
        Utils.nonNull(varClass);
        if (varClass == GencodeFuncotation.VariantClassification.SPLICE_SITE) {
            Utils.nonNull(secondaryVarClass);
            return secondaryVarClass != GencodeFuncotation.VariantClassification.INTRON;
        }
        return codingVariantClassifications.contains((Object)varClass);
    }

    private List<GencodeFuncotation> createFuncotationsHelper(VariantContext variant, Allele altAllele, GencodeGtfGeneFeature gtfFeature, ReferenceContext reference) {
        List<GencodeGtfTranscriptFeature> transcriptList = gtfFeature.getGtfSourceFileType().equals("GENCODE") ? GencodeFuncotationFactory.retrieveBasicTranscripts(gtfFeature) : gtfFeature.getTranscripts();
        return this.createFuncotationsHelper(variant, altAllele, reference, transcriptList);
    }

    private static List<GencodeGtfTranscriptFeature> retrieveBasicTranscripts(GencodeGtfGeneFeature gtfFeature) {
        return gtfFeature.getTranscripts().stream().filter(GencodeFuncotationFactory::isBasic).collect(Collectors.toList());
    }

    private List<GencodeFuncotation> createFuncotationsHelper(VariantContext variant, Allele altAllele, ReferenceContext reference, List<GencodeGtfTranscriptFeature> basicTranscripts) {
        ArrayList<GencodeFuncotation> outputFuncotations = new ArrayList<GencodeFuncotation>();
        for (GencodeGtfTranscriptFeature transcript : basicTranscripts) {
            try {
                GencodeFuncotation gencodeFuncotation = this.createGencodeFuncotationOnSingleTranscript(variant, altAllele, reference, transcript);
                if (gencodeFuncotation == null) continue;
                outputFuncotations.add(gencodeFuncotation);
            }
            catch (FuncotatorUtils.TranscriptCodingSequenceException ex) {
                logger.error("Problem creating a GencodeFuncotation on transcript " + transcript.getTranscriptId() + " for variant: " + variant.getContig() + ":" + variant.getStart() + "-" + variant.getEnd() + "(" + variant.getReference() + " -> " + altAllele + "): " + ex.getMessage());
                logger.warn("Creating default GencodeFuncotation on transcript " + transcript.getTranscriptId() + " for problem variant: " + variant.getContig() + ":" + variant.getStart() + "-" + variant.getEnd() + "(" + variant.getReference() + " -> " + altAllele + ")");
                outputFuncotations.add(this.createDefaultFuncotationsOnProblemVariant(variant, altAllele, reference, transcript, this.version, this.getName()));
            }
        }
        return outputFuncotations;
    }

    private GencodeFuncotation createDefaultFuncotationsOnProblemVariant(VariantContext variant, Allele altAllele, ReferenceContext reference, GencodeGtfTranscriptFeature transcript, String version, String dataSourceName) {
        return GencodeFuncotationFactory.createDefaultFuncotationsOnProblemVariant(variant, altAllele, reference, transcript, version, dataSourceName, this.ncbiBuildVersion);
    }

    @VisibleForTesting
    static final GencodeFuncotation createDefaultFuncotationsOnProblemVariant(VariantContext variant, Allele altAllele, ReferenceContext reference, GencodeGtfTranscriptFeature transcript, String version, String dataSourceName, String ncbiBuildVersion) {
        GencodeFuncotationBuilder gencodeFuncotationBuilder = GencodeFuncotationFactory.createGencodeFuncotationBuilderWithTrivialFieldsPopulated(variant, altAllele, transcript, ncbiBuildVersion);
        gencodeFuncotationBuilder.setVersion(version);
        StrandCorrectedReferenceBases referenceBases = FuncotatorUtils.createReferenceSnippet(variant.getReference(), altAllele, reference, transcript.getGenomicStrand(), 10);
        gencodeFuncotationBuilder.setReferenceContext(referenceBases.getBaseString(Strand.POSITIVE));
        gencodeFuncotationBuilder.setGcContent(GencodeFuncotationFactory.calculateGcContent(variant.getReference(), altAllele, reference, 200));
        gencodeFuncotationBuilder.setVariantClassification(GencodeFuncotation.VariantClassification.COULD_NOT_DETERMINE);
        gencodeFuncotationBuilder.setDataSourceName(dataSourceName);
        return gencodeFuncotationBuilder.build();
    }

    private static boolean isBasic(GencodeGtfTranscriptFeature transcript) {
        return transcript.getOptionalFields().stream().filter(f -> f.getName().equals("tag")).filter(f -> f.getValue() instanceof GencodeGtfFeature.FeatureTag).filter(f -> f.getValue().equals((Object)GencodeGtfFeature.FeatureTag.BASIC)).count() > 0L;
    }

    private GencodeFuncotation createGencodeFuncotationOnSingleTranscript(VariantContext variant, Allele altAllele, ReferenceContext reference, GencodeGtfTranscriptFeature transcript) {
        GencodeFuncotation gencodeFuncotation;
        GencodeGtfFeature containingSubfeature = GencodeFuncotationFactory.getContainingGtfSubfeature((Locatable)variant, transcript);
        if (containingSubfeature == null) {
            if (transcript.overlaps((Locatable)variant)) {
                throw new FuncotatorUtils.TranscriptCodingSequenceException(String.format("Variant overlaps transcript but is not completely contained within it. Funcotator cannot currently handle this case. Transcript: %s  Variant: %s", transcript.getTranscriptId(), variant));
            }
            if (GencodeFuncotationFactory.isFivePrimeFlank(variant, transcript, this.flankSettings.fivePrimeFlankSize)) {
                return this.createFlankFuncotation(variant, altAllele, transcript, reference, GencodeFuncotation.VariantClassification.FIVE_PRIME_FLANK);
            }
            if (GencodeFuncotationFactory.isThreePrimeFlank(variant, transcript, this.flankSettings.threePrimeFlankSize)) {
                return this.createFlankFuncotation(variant, altAllele, transcript, reference, GencodeFuncotation.VariantClassification.THREE_PRIME_FLANK);
            }
            return null;
        }
        GencodeFuncotation specialAlleleFuncotation = this.checkForAndCreateSpecialAlleleFuncotation(variant, altAllele, reference, transcript);
        if (specialAlleleFuncotation != null) {
            return specialAlleleFuncotation;
        }
        int startPosInTranscript = FuncotatorUtils.getStartPositionInTranscript((Locatable)variant, GencodeFuncotationFactory.getSortedCdsAndStartStopPositions(transcript), transcript.getGenomicStrand());
        if (GencodeGtfExonFeature.class.isAssignableFrom(containingSubfeature.getClass())) {
            if (startPosInTranscript == -1) {
                throw new FuncotatorUtils.TranscriptCodingSequenceException("Cannot yet handle indels starting outside an exon and ending within an exon.");
            }
            gencodeFuncotation = this.createExonFuncotation(variant, altAllele, reference, transcript, (GencodeGtfExonFeature)containingSubfeature);
        } else if (GencodeGtfUTRFeature.class.isAssignableFrom(containingSubfeature.getClass())) {
            gencodeFuncotation = this.createUtrFuncotation(variant, altAllele, reference, transcript, (GencodeGtfUTRFeature)containingSubfeature);
        } else if (GencodeGtfTranscriptFeature.class.isAssignableFrom(containingSubfeature.getClass())) {
            gencodeFuncotation = this.createIntronFuncotation(variant, altAllele, reference, transcript);
        } else {
            throw new GATKException.ShouldNeverReachHereException("Unable to determine type of variant-containing subfeature: " + containingSubfeature.getClass().getName());
        }
        return gencodeFuncotation;
    }

    private GencodeFuncotation checkForAndCreateSpecialAlleleFuncotation(VariantContext variant, Allele altAllele, ReferenceContext reference, GencodeGtfTranscriptFeature transcript) {
        if (altAllele.isSymbolic() || altAllele.equals((Object)Allele.SPAN_DEL)) {
            return this.createFuncotationForSymbolicAltAllele(variant, altAllele, transcript, reference);
        }
        if (variant.getReference().getBaseString().contains(FuncotatorConstants.MASKED_ANY_BASE_STRING) || altAllele.getBaseString().contains(FuncotatorConstants.MASKED_ANY_BASE_STRING)) {
            return this.createFuncotationForMaskedBases(variant, altAllele, transcript, reference);
        }
        return null;
    }

    private GencodeFuncotation createExonFuncotation(VariantContext variant, Allele altAllele, ReferenceContext reference, GencodeGtfTranscriptFeature transcript, GencodeGtfExonFeature exon) {
        if (transcript.getGeneType() != GencodeGtfFeature.GeneTranscriptType.PROTEIN_CODING) {
            return this.createCodingRegionFuncotationForNonProteinCodingFeature(variant, altAllele, reference, transcript, exon);
        }
        return this.createCodingRegionFuncotationForProteinCodingFeature(variant, altAllele, reference, transcript, exon);
    }

    private GencodeFuncotation createCodingRegionFuncotationForNonProteinCodingFeature(VariantContext variant, Allele altAllele, ReferenceContext reference, GencodeGtfTranscriptFeature transcript, GencodeGtfExonFeature exon) {
        List<? extends Locatable> exonPositionList = GencodeFuncotationFactory.getSortedCdsAndStartStopPositions(transcript);
        GencodeFuncotationBuilder gencodeFuncotationBuilder = this.createGencodeFuncotationBuilderWithTrivialFieldsPopulated(variant, altAllele, transcript);
        gencodeFuncotationBuilder.setTranscriptExonNumber(exon.getExonNumber());
        gencodeFuncotationBuilder.setVersion(this.version);
        this.setTranscriptPosition(variant, altAllele, transcript, gencodeFuncotationBuilder);
        StrandCorrectedReferenceBases referenceBases = FuncotatorUtils.createReferenceSnippet(variant.getReference(), altAllele, reference, exon.getGenomicStrand(), 10);
        gencodeFuncotationBuilder.setReferenceContext(referenceBases.getBaseString(Strand.POSITIVE));
        SimpleInterval exonOverlapInterval = FuncotatorUtils.getOverlappingExonPositions(variant.getReference(), altAllele, variant.getContig(), variant.getStart(), variant.getEnd(), transcript.getGenomicStrand(), exonPositionList);
        gencodeFuncotationBuilder.setGcContent(GencodeFuncotationFactory.calculateGcContent(variant.getReference(), altAllele, reference, 200)).setcDnaChange(FuncotatorUtils.getCodingSequenceChangeString(FuncotatorUtils.getStartPositionInTranscript((Locatable)variant, exonPositionList, transcript.getGenomicStrand()), exon.getGenomicStrand() == Strand.FORWARD ? variant.getReference().getBaseString() : ReadUtils.getBasesReverseComplement(variant.getReference().getBases()), exon.getGenomicStrand() == Strand.FORWARD ? altAllele.getBaseString() : ReadUtils.getBasesReverseComplement(altAllele.getBases()), exon.getGenomicStrand(), exonOverlapInterval != null ? Integer.valueOf(exonOverlapInterval.getStart()) : null, exonOverlapInterval != null ? Integer.valueOf(exonOverlapInterval.getStart()) : null, exonOverlapInterval != null ? Integer.valueOf(variant.getStart()) : null));
        gencodeFuncotationBuilder.setVariantClassification(GencodeFuncotationFactory.convertGeneTranscriptTypeToVariantClassification(exon.getGeneType()));
        gencodeFuncotationBuilder.setDataSourceName(this.getName());
        return gencodeFuncotationBuilder.build();
    }

    private void setTranscriptPosition(VariantContext variant, Allele altAllele, GencodeGtfTranscriptFeature transcript, GencodeFuncotationBuilder gencodeFuncotationBuilder) {
        int txStart = FuncotatorUtils.getTranscriptAlleleStartPosition(variant, transcript.getExons(), transcript.getGenomicStrand());
        this.setTranscriptPosition(variant, altAllele, txStart, gencodeFuncotationBuilder);
    }

    private void setTranscriptPosition(VariantContext variant, Allele altAllele, int txStart, GencodeFuncotationBuilder gencodeFuncotationBuilder) {
        gencodeFuncotationBuilder.setTranscriptStartPos(txStart);
        if (variant.getReference().length() == 1) {
            gencodeFuncotationBuilder.setTranscriptEndPos(txStart);
        } else {
            int indelOffset = 0;
            if (GATKVariantContextUtils.isIndel(variant.getReference(), altAllele)) {
                indelOffset = 1;
            }
            gencodeFuncotationBuilder.setTranscriptEndPos(txStart + variant.getReference().length() - indelOffset - 1);
        }
    }

    private GencodeFuncotation createCodingRegionFuncotationForProteinCodingFeature(VariantContext variant, Allele altAllele, ReferenceContext reference, GencodeGtfTranscriptFeature transcript, GencodeGtfExonFeature exon) {
        List<? extends Locatable> exonPositionList = GencodeFuncotationFactory.getSortedCdsAndStartStopPositions(transcript);
        GencodeFuncotation.VariantType variantType = GencodeFuncotationFactory.getVariantType(variant.getReference(), altAllele);
        GencodeFuncotationBuilder gencodeFuncotationBuilder = this.createGencodeFuncotationBuilderWithTrivialFieldsPopulated(variant, altAllele, transcript);
        gencodeFuncotationBuilder.setTranscriptExonNumber(exon.getExonNumber());
        gencodeFuncotationBuilder.setVersion(this.version);
        SequenceComparison sequenceComparison = GencodeFuncotationFactory.createSequenceComparison(variant, altAllele, reference, transcript, exonPositionList, this.transcriptIdMap, this.transcriptFastaReferenceDataSource, true);
        this.setTranscriptPosition(variant, altAllele, sequenceComparison.getTranscriptAlleleStart(), gencodeFuncotationBuilder);
        if (sequenceComparison.getStrand() == Strand.POSITIVE) {
            gencodeFuncotationBuilder.setReferenceContext(sequenceComparison.getReferenceBases());
        } else {
            gencodeFuncotationBuilder.setReferenceContext(ReadUtils.getBasesReverseComplement(sequenceComparison.getReferenceBases().getBytes()));
        }
        gencodeFuncotationBuilder.setGcContent(sequenceComparison.getGcContent()).setcDnaChange(FuncotatorUtils.getCodingSequenceChangeString(sequenceComparison.getCodingSequenceAlleleStart(), sequenceComparison.getReferenceAllele(), sequenceComparison.getAlternateAllele(), sequenceComparison.getStrand(), sequenceComparison.getExonStartPosition(), sequenceComparison.getExonEndPosition(), sequenceComparison.getAlleleStart()));
        if (sequenceComparison.hasSequenceInfo()) {
            String codonChange = FuncotatorUtils.getCodonChangeString(sequenceComparison, (Locatable)exon.getStartCodon());
            String proteinChange = FuncotatorUtils.renderProteinChangeString(sequenceComparison, (Locatable)exon.getStartCodon());
            gencodeFuncotationBuilder.setCodonChange(codonChange).setProteinChange(proteinChange);
            GencodeFuncotation.VariantClassification varClass = GencodeFuncotationFactory.createVariantClassification(variant, altAllele, variantType, exon, transcript.getExons().size(), sequenceComparison);
            gencodeFuncotationBuilder.setVariantClassification(varClass);
            if (varClass == GencodeFuncotation.VariantClassification.SPLICE_SITE) {
                GencodeFuncotation.VariantClassification secondaryVarClass = GencodeFuncotationFactory.getVariantClassificationForCodingRegion(variant, altAllele, variantType, sequenceComparison);
                gencodeFuncotationBuilder.setSecondaryVariantClassification(secondaryVarClass);
            }
        } else {
            gencodeFuncotationBuilder.setVariantClassification(GencodeFuncotationFactory.convertGeneTranscriptTypeToVariantClassification(exon.getGeneType()));
        }
        gencodeFuncotationBuilder.setDataSourceName(this.getName());
        return gencodeFuncotationBuilder.build();
    }

    @VisibleForTesting
    static List<? extends Locatable> getSortedCdsAndStartStopPositions(GencodeGtfTranscriptFeature transcript) {
        transcript.getExons().sort((lhs, rhs) -> lhs.getExonNumber() < rhs.getExonNumber() ? -1 : (lhs.getExonNumber() > rhs.getExonNumber() ? 1 : 0));
        ArrayList<GencodeGtfFeature> regionList = new ArrayList<GencodeGtfFeature>(transcript.getExons().size());
        for (GencodeGtfExonFeature exon : transcript.getExons()) {
            if (exon.getCds() != null) {
                if (exon.getStartCodon() != null && !exon.getCds().contains((Locatable)exon.getStartCodon())) {
                    regionList.add(exon.getStartCodon());
                }
                regionList.add(exon.getCds());
                if (exon.getStopCodon() == null || exon.getCds().contains((Locatable)exon.getStopCodon())) continue;
                regionList.add(exon.getStopCodon());
                continue;
            }
            if (exon.getStartCodon() != null) {
                regionList.add(exon.getStartCodon());
                continue;
            }
            if (exon.getStopCodon() == null) continue;
            regionList.add(exon.getStopCodon());
        }
        if (transcript.getGenomicStrand() == Strand.NEGATIVE) {
            regionList.sort(Comparator.comparingInt(GencodeGtfFeature::getStart).reversed());
        }
        return regionList;
    }

    @VisibleForTesting
    static GencodeFuncotation.VariantClassification createVariantClassification(VariantContext variant, Allele altAllele, GencodeFuncotation.VariantType variantType, GencodeGtfExonFeature exon, int numberOfExonsInTranscript, SequenceComparison sequenceComparison) {
        Utils.nonNull(variant);
        Utils.nonNull(altAllele);
        Utils.nonNull(variantType);
        Utils.nonNull(exon);
        ParamUtils.isPositive(numberOfExonsInTranscript, "Number of exons in transcript must be positive (given: " + numberOfExonsInTranscript + ")");
        Utils.nonNull(sequenceComparison);
        GencodeFuncotation.VariantClassification varClass = null;
        boolean hasBeenClassified = false;
        SimpleInterval realVariationInterval = GencodeFuncotationFactory.getBasesChangedIntervalIgnoringLeadingVcfContextBase(variant, altAllele);
        if (exon.getStopCodon() != null && exon.getStopCodon().overlaps(realVariationInterval)) {
            boolean foundStop = false;
            int i = 0;
            while (i + 3 - 1 < sequenceComparison.getAlignedCodingSequenceAlternateAllele().length()) {
                String codon = sequenceComparison.getAlignedCodingSequenceAlternateAllele().substring(i, i + 3);
                if (FuncotatorUtils.getEukaryoticAminoAcidByCodon(codon) == AminoAcid.STOP_CODON) {
                    foundStop = true;
                    break;
                }
                i += 3;
            }
            if (!foundStop) {
                varClass = GencodeFuncotation.VariantClassification.NONSTOP;
                hasBeenClassified = true;
            }
        }
        if (!hasBeenClassified) {
            boolean isInternalExon = exon.getExonNumber() != 1 && exon.getExonNumber() != numberOfExonsInTranscript;
            boolean doLeftOverlapCheck = isInternalExon || sequenceComparison.getStrand() == Strand.NEGATIVE && exon.getExonNumber() == 1 || sequenceComparison.getStrand() == Strand.POSITIVE && exon.getExonNumber() == numberOfExonsInTranscript;
            boolean doRightOverlapCheck = isInternalExon || sequenceComparison.getStrand() == Strand.POSITIVE && exon.getExonNumber() == 1 || sequenceComparison.getStrand() == Strand.NEGATIVE && exon.getExonNumber() == numberOfExonsInTranscript;
            boolean overlapsLeft = false;
            boolean overlapsRight = false;
            int adjustedExonStart = GencodeFuncotationFactory.adjustLocusForInsertion(exon.getStart(), variant, altAllele, realVariationInterval);
            int adjustedExonEnd = GencodeFuncotationFactory.adjustLocusForInsertion(exon.getEnd(), variant, altAllele, realVariationInterval);
            if (doLeftOverlapCheck) {
                SimpleInterval leftSideInterval = new SimpleInterval(exon.getContig(), adjustedExonStart - 2, adjustedExonStart + 1);
                overlapsLeft = leftSideInterval.overlaps(realVariationInterval);
            }
            if (doRightOverlapCheck) {
                SimpleInterval rightSideInterval = new SimpleInterval(exon.getContig(), adjustedExonEnd - 2 + 1, adjustedExonEnd + 1 + 1);
                overlapsRight = rightSideInterval.overlaps(realVariationInterval);
            }
            if (overlapsLeft || overlapsRight) {
                varClass = GencodeFuncotation.VariantClassification.SPLICE_SITE;
            } else if (exon.getStartCodon() != null && exon.getStartCodon().overlaps(realVariationInterval)) {
                switch (variantType) {
                    case INS: {
                        varClass = GencodeFuncotation.VariantClassification.START_CODON_INS;
                        break;
                    }
                    case DEL: {
                        varClass = GencodeFuncotation.VariantClassification.START_CODON_DEL;
                        break;
                    }
                    default: {
                        varClass = GencodeFuncotation.VariantClassification.START_CODON_SNP;
                        break;
                    }
                }
            } else {
                varClass = GencodeFuncotationFactory.getVariantClassificationForCodingRegion(variant, altAllele, variantType, sequenceComparison);
            }
        }
        return varClass;
    }

    private static int adjustLocusForInsertion(int genomicLocus, VariantContext variant, Allele altAllele, SimpleInterval changedBasesInterval) {
        int adjustedPosition = genomicLocus;
        if (altAllele.length() > variant.getReference().length() && genomicLocus > changedBasesInterval.getStart()) {
            adjustedPosition += changedBasesInterval.getEnd() - changedBasesInterval.getStart() + 1;
        }
        return adjustedPosition;
    }

    private static GencodeFuncotation.VariantClassification getVariantClassificationForCodingRegion(VariantContext variant, Allele altAllele, GencodeFuncotation.VariantType variantType, SequenceComparison sequenceComparison) {
        GencodeFuncotation.VariantClassification varClass = variantType == GencodeFuncotation.VariantType.INS ? (GATKVariantContextUtils.isFrameshift(variant.getReference(), altAllele) ? GencodeFuncotation.VariantClassification.FRAME_SHIFT_INS : GencodeFuncotation.VariantClassification.IN_FRAME_INS) : (variantType == GencodeFuncotation.VariantType.DEL ? (GATKVariantContextUtils.isFrameshift(variant.getReference(), altAllele) ? GencodeFuncotation.VariantClassification.FRAME_SHIFT_DEL : GencodeFuncotation.VariantClassification.IN_FRAME_DEL) : GencodeFuncotationFactory.getVarClassFromEqualLengthCodingRegions(sequenceComparison));
        return varClass;
    }

    private static GencodeFuncotation.VariantClassification getVarClassFromEqualLengthCodingRegions(SequenceComparison sequenceComparison) {
        GencodeFuncotation.VariantClassification varClass = GencodeFuncotation.VariantClassification.SILENT;
        boolean foundErroneousStop = false;
        String refAaSeq = sequenceComparison.getProteinChangeInfo().getRefAaSeq();
        String altAaSeq = sequenceComparison.getProteinChangeInfo().getAltAaSeq();
        for (int i = 0; i < altAaSeq.length(); ++i) {
            char altAminoAcid = altAaSeq.charAt(i);
            if (altAminoAcid == refAaSeq.charAt(i)) continue;
            if (FuncotatorUtils.getAminoAcidByLetter(altAminoAcid) == AminoAcid.STOP_CODON) {
                foundErroneousStop = true;
                break;
            }
            varClass = GencodeFuncotation.VariantClassification.MISSENSE;
        }
        if (foundErroneousStop) {
            varClass = GencodeFuncotation.VariantClassification.NONSENSE;
        }
        return varClass;
    }

    private GencodeFuncotation createUtrFuncotation(VariantContext variant, Allele altAllele, ReferenceContext reference, GencodeGtfTranscriptFeature transcript, GencodeGtfUTRFeature utr) {
        GencodeFuncotationBuilder gencodeFuncotationBuilder = this.createGencodeFuncotationBuilderWithTrivialFieldsPopulated(variant, altAllele, transcript);
        for (GencodeGtfExonFeature exon : transcript.getExons()) {
            if (!exon.contains((Locatable)utr)) continue;
            gencodeFuncotationBuilder.setTranscriptExonNumber(exon.getExonNumber());
            break;
        }
        gencodeFuncotationBuilder.setGcContent(GencodeFuncotationFactory.calculateGcContent(variant.getReference(), altAllele, reference, 200));
        Strand strand = transcript.getGenomicStrand();
        Allele strandCorrectedAltAllele = FuncotatorUtils.getStrandCorrectedAllele(altAllele, strand);
        StrandCorrectedReferenceBases referenceBases = FuncotatorUtils.createReferenceSnippet(variant.getReference(), altAllele, reference, strand, 10);
        gencodeFuncotationBuilder.setReferenceContext(referenceBases.getBaseString(Strand.POSITIVE));
        if (GencodeFuncotationFactory.is5PrimeUtr(utr, transcript)) {
            gencodeFuncotationBuilder.setVariantClassification(GencodeFuncotation.VariantClassification.FIVE_PRIME_UTR);
            if (this.transcriptIdMap.containsKey(transcript.getTranscriptId())) {
                int numExtraTrailingBases = variant.getReference().length() < 3 ? 3 : variant.getReference().length() + 1;
                String fivePrimeUtrCodingSequence = GencodeFuncotationFactory.getFivePrimeUtrSequenceFromTranscriptFasta(transcript.getTranscriptId(), this.transcriptIdMap, this.transcriptFastaReferenceDataSource, numExtraTrailingBases);
                int codingStartPos = FuncotatorUtils.getStartPositionInTranscript((Locatable)variant, transcript.getExons(), strand);
                int indelOffset = variant.getReference().length() != altAllele.length() ? 1 : 0;
                int frontOffset = strand == Strand.POSITIVE ? indelOffset : 0;
                int backOffset = strand == Strand.NEGATIVE ? indelOffset : 0;
                String rawAltUtrSubSequence = referenceBases.getBaseString().substring(8 + frontOffset, 10) + strandCorrectedAltAllele + referenceBases.getBaseString().substring(10 + variant.getReference().length(), 10 + numExtraTrailingBases + backOffset);
                boolean startFound = false;
                int codingRegionOffset = frontOffset - 2;
                int i = 0;
                while (i + 3 < rawAltUtrSubSequence.length()) {
                    boolean bl = startFound = FuncotatorUtils.getEukaryoticAminoAcidByCodon(rawAltUtrSubSequence.substring(i, i + 3)) == AminoAcid.METHIONINE;
                    if (startFound) {
                        codingRegionOffset += i;
                        break;
                    }
                    ++i;
                }
                if (startFound) {
                    if (FuncotatorUtils.isInFrameWithEndOfRegion(codingStartPos + codingRegionOffset, fivePrimeUtrCodingSequence.length())) {
                        gencodeFuncotationBuilder.setVariantClassification(GencodeFuncotation.VariantClassification.DE_NOVO_START_IN_FRAME);
                    } else {
                        gencodeFuncotationBuilder.setVariantClassification(GencodeFuncotation.VariantClassification.DE_NOVO_START_OUT_FRAME);
                    }
                }
            } else {
                logger.warn("Attempted to process transcript information for transcript WITHOUT sequence data.  Ignoring sequence information for Gencode Transcript ID: " + transcript.getTranscriptId());
            }
        } else {
            gencodeFuncotationBuilder.setVariantClassification(GencodeFuncotation.VariantClassification.THREE_PRIME_UTR);
        }
        gencodeFuncotationBuilder.setVersion(this.version);
        gencodeFuncotationBuilder.setDataSourceName(this.getName());
        return gencodeFuncotationBuilder.build();
    }

    private GencodeFuncotation createIntronFuncotation(VariantContext variant, Allele altAllele, ReferenceContext reference, GencodeGtfTranscriptFeature transcript) {
        Allele strandCorrectedRefAllele = FuncotatorUtils.getStrandCorrectedAllele(variant.getReference(), transcript.getGenomicStrand());
        Allele strandCorrectedAltAllele = FuncotatorUtils.getStrandCorrectedAllele(altAllele, transcript.getGenomicStrand());
        GencodeFuncotationBuilder gencodeFuncotationBuilder = this.createGencodeFuncotationBuilderWithTrivialFieldsPopulated(variant, altAllele, transcript);
        StrandCorrectedReferenceBases referenceBases = FuncotatorUtils.createReferenceSnippet(variant.getReference(), altAllele, reference, transcript.getGenomicStrand(), 10);
        gencodeFuncotationBuilder.setReferenceContext(referenceBases.getBaseString(Strand.POSITIVE));
        if (transcript.getGeneType() == GencodeGtfFeature.GeneTranscriptType.PROTEIN_CODING) {
            gencodeFuncotationBuilder.setVariantClassification(GencodeFuncotation.VariantClassification.INTRON);
        } else {
            gencodeFuncotationBuilder.setVariantClassification(GencodeFuncotationFactory.convertGeneTranscriptTypeToVariantClassification(transcript.getGeneType()));
        }
        gencodeFuncotationBuilder.setGcContent(GencodeFuncotationFactory.calculateGcContent(variant.getReference(), altAllele, reference, 200));
        GencodeGtfExonFeature spliceSiteExon = GencodeFuncotationFactory.getExonWithinSpliceSiteWindow(variant, altAllele, transcript, 2);
        if (spliceSiteExon != null) {
            gencodeFuncotationBuilder.setVariantClassification(GencodeFuncotation.VariantClassification.SPLICE_SITE).setSecondaryVariantClassification(GencodeFuncotation.VariantClassification.INTRON);
            int offsetIndelAdjustment = 0;
            if (GATKVariantContextUtils.isDeletion(strandCorrectedRefAllele, strandCorrectedAltAllele)) {
                offsetIndelAdjustment = 1;
            }
            gencodeFuncotationBuilder.setCodonChange(FuncotatorUtils.createSpliceSiteCodonChange(variant.getStart(), spliceSiteExon.getExonNumber(), spliceSiteExon.getStart(), spliceSiteExon.getEnd(), transcript.getGenomicStrand(), offsetIndelAdjustment));
        }
        gencodeFuncotationBuilder.setcDnaChange(FuncotatorUtils.createIntronicCDnaString(variant.getStart(), transcript.getExons(), strandCorrectedRefAllele.getBaseString(), strandCorrectedAltAllele.getBaseString()));
        gencodeFuncotationBuilder.setVersion(this.version);
        gencodeFuncotationBuilder.setDataSourceName(this.getName());
        return gencodeFuncotationBuilder.build();
    }

    private static SimpleInterval getBasesChangedIntervalIgnoringLeadingVcfContextBase(VariantContext variant, Allele altAllele) {
        SimpleInterval changedBasesInterval;
        if (GATKVariantContextUtils.typeOfVariant(variant.getReference(), altAllele).equals((Object)VariantContext.Type.INDEL)) {
            int end;
            int adjustedStart;
            if (variant.getReference().length() < altAllele.length()) {
                adjustedStart = FuncotatorUtils.getIndelAdjustedAlleleChangeStartPosition(variant, altAllele);
                end = variant.getEnd() + (altAllele.length() - (adjustedStart - variant.getStart()));
            } else {
                adjustedStart = FuncotatorUtils.getIndelAdjustedAlleleChangeStartPosition(variant, altAllele);
                end = variant.getEnd();
            }
            changedBasesInterval = new SimpleInterval(variant.getContig(), adjustedStart, end);
        } else {
            changedBasesInterval = new SimpleInterval((Locatable)variant);
        }
        return changedBasesInterval;
    }

    private static GencodeGtfExonFeature getExonWithinSpliceSiteWindow(VariantContext variant, Allele altAllele, GencodeGtfTranscriptFeature transcript, int spliceSiteVariantWindowBases) {
        GencodeGtfExonFeature spliceSiteExon = null;
        SimpleInterval changedBasesInterval = GencodeFuncotationFactory.getBasesChangedIntervalIgnoringLeadingVcfContextBase(variant, altAllele);
        for (GencodeGtfExonFeature exon : transcript.getExons()) {
            int adjustedExonStart = GencodeFuncotationFactory.adjustLocusForInsertion(exon.getStart(), variant, altAllele, changedBasesInterval);
            int adjustedExonEnd = GencodeFuncotationFactory.adjustLocusForInsertion(exon.getEnd(), variant, altAllele, changedBasesInterval);
            SimpleInterval exonStartInterval = new SimpleInterval(exon.getContig(), adjustedExonStart, adjustedExonStart);
            SimpleInterval exonEndInterval = new SimpleInterval(exon.getContig(), adjustedExonEnd, adjustedExonEnd);
            if (!changedBasesInterval.overlapsWithMargin(exonStartInterval, spliceSiteVariantWindowBases) && !changedBasesInterval.overlapsWithMargin(exonEndInterval, spliceSiteVariantWindowBases)) continue;
            spliceSiteExon = exon;
            break;
        }
        return spliceSiteExon;
    }

    private static GencodeGtfFeature getContainingGtfSubfeature(Locatable variant, GencodeGtfTranscriptFeature transcript) {
        boolean determinedRegionAlready = false;
        GencodeGtfFeature subFeature = null;
        if (transcript.contains(variant)) {
            if (transcript.getUtrs().size() > 0) {
                for (GencodeGtfUTRFeature utr : transcript.getUtrs()) {
                    if (!utr.overlaps(variant)) continue;
                    subFeature = utr;
                    determinedRegionAlready = true;
                }
            }
            for (GencodeGtfExonFeature exon : transcript.getExons()) {
                if (exon.getCds() != null && exon.getCds().contains(variant)) {
                    subFeature = exon;
                    determinedRegionAlready = true;
                    continue;
                }
                if (exon.getStartCodon() != null && exon.getStartCodon().overlaps(variant)) {
                    subFeature = exon;
                    determinedRegionAlready = true;
                    continue;
                }
                if (exon.getStopCodon() == null || !exon.getStopCodon().overlaps(variant)) continue;
                subFeature = exon;
                determinedRegionAlready = true;
            }
            if (!determinedRegionAlready) {
                subFeature = transcript;
            }
        }
        return subFeature;
    }

    @VisibleForTesting
    static SequenceComparison createSequenceComparison(VariantContext variant, Allele alternateAllele, ReferenceContext reference, GencodeGtfTranscriptFeature transcript, List<? extends Locatable> exonPositionList, Map<String, MappedTranscriptIdInfo> transcriptIdMap, ReferenceDataSource transcriptFastaReferenceDataSource, boolean processSequenceInformation) {
        SequenceComparison sequenceComparison = new SequenceComparison();
        sequenceComparison.setContig(variant.getContig());
        sequenceComparison.setStrand(transcript.getGenomicStrand());
        Allele refAllele = FuncotatorUtils.getStrandCorrectedAllele(variant.getReference(), transcript.getGenomicStrand());
        Allele altAllele = FuncotatorUtils.getStrandCorrectedAllele(alternateAllele, transcript.getGenomicStrand());
        StrandCorrectedReferenceBases referenceBases = FuncotatorUtils.createReferenceSnippet(variant.getReference(), alternateAllele, reference, transcript.getGenomicStrand(), 10);
        sequenceComparison.setReferenceWindow(10);
        sequenceComparison.setReferenceBases(referenceBases.getBaseString());
        sequenceComparison.setGcContent(GencodeFuncotationFactory.calculateGcContent(variant.getReference(), altAllele, reference, 200));
        sequenceComparison.setReferenceAllele(refAllele.getBaseString());
        sequenceComparison.setAlleleStart(variant.getStart());
        sequenceComparison.setTranscriptAlleleStart(FuncotatorUtils.getTranscriptAlleleStartPosition(variant, transcript.getExons(), transcript.getGenomicStrand()));
        sequenceComparison.setCodingSequenceAlleleStart(FuncotatorUtils.getStartPositionInTranscript((Locatable)variant, exonPositionList, transcript.getGenomicStrand()));
        sequenceComparison.setExonPosition(FuncotatorUtils.getOverlappingExonPositions(refAllele, altAllele, variant.getContig(), variant.getStart(), variant.getEnd(), transcript.getGenomicStrand(), exonPositionList));
        sequenceComparison.setAlignedCodingSequenceAlleleStart(FuncotatorUtils.getAlignedPosition(sequenceComparison.getCodingSequenceAlleleStart()));
        sequenceComparison.setAlignedReferenceAlleleStop(FuncotatorUtils.getAlignedEndPosition(sequenceComparison.getCodingSequenceAlleleStart() + refAllele.length() - 1));
        sequenceComparison.setAlignedReferenceAllele(FuncotatorUtils.getAlignedRefAllele(referenceBases, 10, refAllele, altAllele, sequenceComparison.getCodingSequenceAlleleStart(), sequenceComparison.getAlignedCodingSequenceAlleleStart(), sequenceComparison.getStrand(), (Locatable)variant));
        sequenceComparison.setAlternateAllele(altAllele.getBaseString());
        sequenceComparison.setAlignedAlternateAlleleStop(FuncotatorUtils.getAlignedEndPosition(sequenceComparison.getCodingSequenceAlleleStart() + altAllele.length() - 1));
        int alignedRefAlleleStartPos = sequenceComparison.getCodingSequenceAlleleStart() - sequenceComparison.getAlignedCodingSequenceAlleleStart() + 1;
        sequenceComparison.setAlignedAlternateAllele(FuncotatorUtils.getAlternateSequence(new StrandCorrectedReferenceBases(sequenceComparison.getAlignedReferenceAllele(), transcript.getGenomicStrand()), alignedRefAlleleStartPos, refAllele, altAllele, sequenceComparison.getStrand()));
        if (processSequenceInformation) {
            if (transcriptIdMap.containsKey(transcript.getTranscriptId())) {
                String transcriptTailPaddingBaseString = GencodeFuncotationFactory.getTranscriptEndPaddingBases(variant, altAllele, exonPositionList, reference);
                String rawCodingSequence = GencodeFuncotationFactory.getCodingSequenceFromTranscriptFasta(transcript.getTranscriptId(), transcriptIdMap, transcriptFastaReferenceDataSource, transcriptTailPaddingBaseString);
                if (sequenceComparison.getCodingSequenceAlleleStart() - 1 + refAllele.getBaseString().length() > rawCodingSequence.length()) {
                    throw new FuncotatorUtils.TranscriptCodingSequenceException("Reference allele runs off end of coding sequence.  Cannot yet handle this case.");
                }
                String correctedCodingSequence = rawCodingSequence.substring(0, sequenceComparison.getCodingSequenceAlleleStart() - 1) + refAllele.getBaseString() + rawCodingSequence.substring(sequenceComparison.getCodingSequenceAlleleStart() + refAllele.length() - 1);
                sequenceComparison.setTranscriptCodingSequence(new ReferenceSequence(transcript.getTranscriptId(), transcript.getStart(), correctedCodingSequence.getBytes()));
                sequenceComparison.setAlignedCodingSequenceReferenceAllele(FuncotatorUtils.getAlignedCodingSequenceAllele(sequenceComparison.getTranscriptCodingSequence().getBaseString(), sequenceComparison.getAlignedCodingSequenceAlleleStart(), sequenceComparison.getAlignedReferenceAlleleStop(), refAllele, sequenceComparison.getCodingSequenceAlleleStart(), Strand.POSITIVE));
                sequenceComparison.setAlignedCodingSequenceAlternateAllele(FuncotatorUtils.getAlternateSequence(new StrandCorrectedReferenceBases(sequenceComparison.getAlignedCodingSequenceReferenceAllele(), transcript.getGenomicStrand()), alignedRefAlleleStartPos, refAllele, altAllele, sequenceComparison.getStrand()));
                ProteinChangeInfo proteinChangeInfo = ProteinChangeInfo.create(refAllele, altAllele, sequenceComparison.getCodingSequenceAlleleStart(), sequenceComparison.getAlignedCodingSequenceAlleleStart(), correctedCodingSequence, sequenceComparison.getStrand(), FuncotatorConstants.MITOCHONDRIAL_CONTIG_NAMES.contains(variant.getContig()));
                sequenceComparison.setProteinChangeInfo(proteinChangeInfo);
            } else {
                logger.warn("Attempted to process transcript information for transcript WITHOUT sequence data.  Ignoring sequence information for Gencode Transcript ID: " + transcript.getTranscriptId());
            }
        }
        return sequenceComparison;
    }

    @VisibleForTesting
    static String getTranscriptEndPaddingBases(VariantContext variant, Allele altAllele, List<? extends Locatable> exonPositionList, ReferenceContext reference) {
        byte[] transcriptTailPaddingBases;
        int transcriptEndGenomicPosition = exonPositionList.get(exonPositionList.size() - 1).getEnd();
        int basesToTranscriptEnd = transcriptEndGenomicPosition - variant.getStart() + 1;
        if (variant.getType() == VariantContext.Type.INDEL && basesToTranscriptEnd < 10) {
            int numIndelBases = Math.abs(variant.getReference().length() - altAllele.length());
            int numPaddingBases = (int)((Math.ceil((double)numIndelBases / 3.0) + 1.0) * 3.0);
            transcriptTailPaddingBases = reference.getBases(new SimpleInterval(reference.getWindow().getContig(), transcriptEndGenomicPosition + 1, transcriptEndGenomicPosition + numPaddingBases));
        } else {
            transcriptTailPaddingBases = new byte[]{};
        }
        return new String(transcriptTailPaddingBases);
    }

    public static double calculateGcContent(Allele refAllele, Allele altAllele, ReferenceContext referenceContext, int windowSize) {
        Utils.nonNull(referenceContext);
        ParamUtils.isPositive(windowSize, "Window size must be >= 1.");
        int trailingWindowSize = windowSize;
        int leadingWindowSize = GATKVariantContextUtils.isInsertion(refAllele, altAllele) || GATKVariantContextUtils.isDeletion(refAllele, altAllele) ? windowSize - 1 : windowSize;
        byte[] bases = referenceContext.getBases(leadingWindowSize, trailingWindowSize);
        long gcCount = 0L;
        for (byte base : bases) {
            if (!BaseUtils.basesAreEqual(base, BaseUtils.Base.G.base) && !BaseUtils.basesAreEqual(base, BaseUtils.Base.C.base)) continue;
            ++gcCount;
        }
        return (double)gcCount / (double)bases.length;
    }

    private GencodeFuncotationBuilder createGencodeFuncotationBuilderWithTrivialFieldsPopulated(VariantContext variant, Allele altAllele, GencodeGtfTranscriptFeature transcript) {
        return GencodeFuncotationFactory.createGencodeFuncotationBuilderWithTrivialFieldsPopulated(variant, altAllele, transcript, this.ncbiBuildVersion);
    }

    @VisibleForTesting
    static GencodeFuncotationBuilder createGencodeFuncotationBuilderWithTrivialFieldsPopulated(VariantContext variant, Allele altAllele, GencodeGtfTranscriptFeature transcript, String ncbiBuildVersion) {
        GencodeFuncotationBuilder gencodeFuncotationBuilder = new GencodeFuncotationBuilder();
        gencodeFuncotationBuilder.setRefAllele(variant.getReference()).setStrand(transcript.getGenomicStrand()).setHugoSymbol(transcript.getGeneName()).setNcbiBuild(ncbiBuildVersion).setChromosome(transcript.getChromosomeName()).setStart(variant.getStart()).setGeneTranscriptType(transcript.getTranscriptType());
        gencodeFuncotationBuilder.setEnd(variant.getEnd()).setVariantType(GencodeFuncotationFactory.getVariantType(variant.getReference(), altAllele)).setTumorSeqAllele2(altAllele.getBaseString()).setGenomeChange(GencodeFuncotationFactory.getGenomeChangeString(variant, altAllele)).setAnnotationTranscript(transcript.getTranscriptId());
        if (transcript.getLocusLevel() == null) {
            gencodeFuncotationBuilder.setLocusLevel(0);
        } else {
            gencodeFuncotationBuilder.setLocusLevel(Integer.valueOf(transcript.getLocusLevel().toString()));
        }
        gencodeFuncotationBuilder.setApprisRank(GencodeFuncotationFactory.getApprisRank(transcript));
        gencodeFuncotationBuilder.setTranscriptLength(transcript.getExons().stream().mapToInt(Locatable::getLengthOnReference).sum());
        return gencodeFuncotationBuilder;
    }

    @VisibleForTesting
    static boolean is5PrimeUtr(GencodeGtfUTRFeature utr, GencodeGtfTranscriptFeature transcript) {
        GencodeGtfStartCodonFeature startCodon = null;
        for (GencodeGtfExonFeature exon : transcript.getExons()) {
            if (exon.getStartCodon() == null) continue;
            startCodon = exon.getStartCodon();
            break;
        }
        boolean isBefore = transcript.getGenomicStrand() == Strand.POSITIVE ? startCodon != null && utr.getStart() < startCodon.getStart() && utr.getEnd() < startCodon.getStart() : startCodon != null && utr.getStart() > startCodon.getEnd() && utr.getEnd() > startCodon.getEnd();
        return isBefore;
    }

    @VisibleForTesting
    static boolean isFivePrimeFlank(VariantContext variant, GencodeGtfTranscriptFeature transcript, int fivePrimeFlankSize) {
        return transcript.getGenomicStrand() == Strand.POSITIVE && GencodeFuncotationFactory.isInTranscriptLeftFlank(variant, transcript, fivePrimeFlankSize) || transcript.getGenomicStrand() == Strand.NEGATIVE && GencodeFuncotationFactory.isInTranscriptRightFlank(variant, transcript, fivePrimeFlankSize);
    }

    @VisibleForTesting
    static boolean isThreePrimeFlank(VariantContext variant, GencodeGtfTranscriptFeature transcript, int threePrimeFlankSize) {
        return transcript.getGenomicStrand() == Strand.POSITIVE && GencodeFuncotationFactory.isInTranscriptRightFlank(variant, transcript, threePrimeFlankSize) || transcript.getGenomicStrand() == Strand.NEGATIVE && GencodeFuncotationFactory.isInTranscriptLeftFlank(variant, transcript, threePrimeFlankSize);
    }

    private static boolean isInTranscriptLeftFlank(VariantContext variant, GencodeGtfTranscriptFeature transcript, int flankSize) {
        return variant.getContig().equals(transcript.getContig()) && variant.getEnd() < transcript.getStart() && transcript.getStart() - variant.getEnd() <= flankSize;
    }

    private static boolean isInTranscriptRightFlank(VariantContext variant, GencodeGtfTranscriptFeature transcript, int flankSize) {
        return variant.getContig().equals(transcript.getContig()) && variant.getStart() > transcript.getEnd() && variant.getStart() - transcript.getEnd() <= flankSize;
    }

    @VisibleForTesting
    static String getGenomeChangeString(VariantContext variant, Allele altAllele) {
        if (variant.getReference().length() < altAllele.length()) {
            String cleanAltAlleleString = FuncotatorUtils.getNonOverlappingAltAlleleBaseString(variant.getReference(), altAllele, false);
            return "g." + variant.getContig() + ":" + variant.getStart() + OTHER_TRANSCRIPTS_INFO_SEP + (variant.getStart() + 1) + "ins" + cleanAltAlleleString;
        }
        if (variant.getReference().length() > altAllele.length()) {
            int endPos;
            String cleanAltAlleleString = FuncotatorUtils.getNonOverlappingAltAlleleBaseString(variant.getReference(), altAllele, true);
            int startPos = variant.getStart() + 1;
            if (startPos == (endPos = variant.getStart() + variant.getReference().length() - 1)) {
                return "g." + variant.getContig() + ":" + startPos + "del" + cleanAltAlleleString;
            }
            return "g." + variant.getContig() + ":" + startPos + OTHER_TRANSCRIPTS_INFO_SEP + endPos + "del" + cleanAltAlleleString;
        }
        if (variant.getReference().length() == 1) {
            return "g." + variant.getContig() + ":" + variant.getStart() + variant.getReference().getBaseString() + ">" + altAllele.getBaseString();
        }
        return "g." + variant.getContig() + ":" + variant.getStart() + OTHER_TRANSCRIPTS_INFO_SEP + (variant.getStart() + variant.getReference().length() - 1) + variant.getReference().getBaseString() + ">" + altAllele.getBaseString();
    }

    private void sortFuncotationsByTranscriptForOutput(List<GencodeFuncotation> funcotationList) {
        funcotationList.sort(this.gencodeFuncotationComparator);
    }

    private List<GencodeFuncotation> createIgrFuncotations(VariantContext variant, ReferenceContext reference) {
        ArrayList<GencodeFuncotation> gencodeFuncotations = new ArrayList<GencodeFuncotation>();
        for (Allele altAllele : variant.getAlternateAlleles()) {
            gencodeFuncotations.add(this.createIgrFuncotation(variant, altAllele, reference));
        }
        return gencodeFuncotations;
    }

    private static String condenseGencodeFuncotation(GencodeFuncotation funcotation) {
        Utils.nonNull(funcotation);
        StringBuilder condensedFuncotationStringBuilder = new StringBuilder();
        if (!funcotation.getVariantClassification().equals((Object)GencodeFuncotation.VariantClassification.IGR)) {
            condensedFuncotationStringBuilder.append(funcotation.getHugoSymbol());
            condensedFuncotationStringBuilder.append(OTHER_TRANSCRIPTS_INFO_SEP);
            condensedFuncotationStringBuilder.append(funcotation.getAnnotationTranscript());
            condensedFuncotationStringBuilder.append(OTHER_TRANSCRIPTS_INFO_SEP);
            condensedFuncotationStringBuilder.append((Object)funcotation.getVariantClassification());
            if (!(funcotation.getProteinChange() == null || funcotation.getVariantClassification().equals((Object)GencodeFuncotation.VariantClassification.INTRON) || funcotation.getSecondaryVariantClassification() != null && funcotation.getSecondaryVariantClassification().equals((Object)GencodeFuncotation.VariantClassification.INTRON))) {
                condensedFuncotationStringBuilder.append(OTHER_TRANSCRIPTS_INFO_SEP);
                condensedFuncotationStringBuilder.append(funcotation.getProteinChange());
            }
        } else {
            condensedFuncotationStringBuilder.append("IGR_ANNOTATON");
        }
        return condensedFuncotationStringBuilder.toString();
    }

    private GencodeFuncotation createIgrFuncotation(VariantContext variant, Allele altAllele, ReferenceContext reference) {
        GencodeFuncotationBuilder funcotationBuilder = new GencodeFuncotationBuilder();
        funcotationBuilder.setGcContent(GencodeFuncotationFactory.calculateGcContent(variant.getReference(), altAllele, reference, 200));
        String alleleString = altAllele.getBaseString().isEmpty() ? altAllele.toString() : altAllele.getBaseString();
        funcotationBuilder.setVariantClassification(GencodeFuncotation.VariantClassification.IGR).setRefAllele(variant.getReference()).setTumorSeqAllele2(alleleString).setStart(variant.getStart()).setEnd(variant.getEnd()).setVariantType(GencodeFuncotationFactory.getVariantType(variant.getReference(), altAllele)).setChromosome(variant.getContig()).setAnnotationTranscript("no_transcript");
        if (!altAllele.isSymbolic() && !altAllele.equals((Object)Allele.SPAN_DEL)) {
            funcotationBuilder.setGenomeChange(GencodeFuncotationFactory.getGenomeChangeString(variant, altAllele));
        }
        funcotationBuilder.setNcbiBuild(this.ncbiBuildVersion);
        funcotationBuilder.setReferenceContext(FuncotatorUtils.createReferenceSnippet(variant.getReference(), altAllele, reference, Strand.POSITIVE, 10).getBaseString());
        funcotationBuilder.setVersion(this.version);
        funcotationBuilder.setDataSourceName(this.getName());
        return funcotationBuilder.build();
    }

    private GencodeFuncotation createFlankFuncotation(VariantContext variant, Allele altAllele, GencodeGtfTranscriptFeature transcript, ReferenceContext reference, GencodeFuncotation.VariantClassification flankType) {
        if (altAllele.isSymbolic() || altAllele.equals((Object)Allele.SPAN_DEL)) {
            return this.createFuncotationForSymbolicAltAllele(variant, altAllele, transcript, reference, flankType);
        }
        GencodeFuncotationBuilder funcotationBuilder = new GencodeFuncotationBuilder();
        StrandCorrectedReferenceBases referenceBases = FuncotatorUtils.createReferenceSnippet(variant.getReference(), altAllele, reference, Strand.POSITIVE, 10);
        String referenceBasesString = referenceBases.getBaseString(Strand.POSITIVE);
        double gcContent = GencodeFuncotationFactory.calculateGcContent(variant.getReference(), altAllele, reference, 200);
        funcotationBuilder.setHugoSymbol(transcript.getGeneName()).setChromosome(variant.getContig()).setStart(variant.getStart()).setEnd(variant.getEnd()).setStrand(transcript.getGenomicStrand()).setVariantClassification(flankType).setVariantType(GencodeFuncotationFactory.getVariantType(variant.getReference(), altAllele)).setRefAllele(variant.getReference()).setTumorSeqAllele2(altAllele.getBaseString()).setGenomeChange(GencodeFuncotationFactory.getGenomeChangeString(variant, altAllele)).setAnnotationTranscript(transcript.getTranscriptId()).setReferenceContext(referenceBasesString).setGcContent(gcContent).setNcbiBuild(this.ncbiBuildVersion).setGeneTranscriptType(transcript.getTranscriptType());
        funcotationBuilder.setVersion(this.version);
        funcotationBuilder.setDataSourceName(this.getName());
        return funcotationBuilder.build();
    }

    private GencodeFuncotation createFuncotationForSymbolicAltAllele(VariantContext variant, Allele altSymbolicAllele, GencodeGtfTranscriptFeature annotationTranscript, ReferenceContext reference) {
        return this.createFuncotationForSymbolicAltAllele(variant, altSymbolicAllele, annotationTranscript, reference, GencodeFuncotation.VariantClassification.COULD_NOT_DETERMINE);
    }

    private GencodeFuncotation createFuncotationForSymbolicAltAllele(VariantContext variant, Allele altSymbolicAllele, GencodeGtfTranscriptFeature annotationTranscript, ReferenceContext reference, GencodeFuncotation.VariantClassification variantClassification) {
        logger.warn("Cannot create complete funcotation for variant at " + variant.getContig() + ":" + variant.getStart() + "-" + variant.getEnd() + " due to alternate allele: " + altSymbolicAllele.toString());
        GencodeFuncotationBuilder funcotationBuilder = new GencodeFuncotationBuilder();
        funcotationBuilder.setGcContent(GencodeFuncotationFactory.calculateGcContent(variant.getReference(), altSymbolicAllele, reference, 200));
        String alleleString = altSymbolicAllele.getBaseString().isEmpty() ? altSymbolicAllele.toString() : altSymbolicAllele.getBaseString();
        funcotationBuilder.setVariantClassification(variantClassification).setRefAllele(variant.getReference()).setStrand(Strand.POSITIVE).setTumorSeqAllele2(alleleString).setStart(variant.getStart()).setEnd(variant.getEnd()).setVariantType(GencodeFuncotationFactory.getVariantType(variant.getReference(), altSymbolicAllele)).setChromosome(variant.getContig()).setOtherTranscripts(Collections.emptyList()).setAnnotationTranscript(annotationTranscript.getTranscriptId());
        funcotationBuilder.setHugoSymbol(annotationTranscript.getGeneName());
        funcotationBuilder.setNcbiBuild(this.ncbiBuildVersion);
        StrandCorrectedReferenceBases referenceBases = FuncotatorUtils.getBasesInWindowAroundReferenceAllele(variant.getReference(), reference, Strand.POSITIVE, 10);
        funcotationBuilder.setReferenceContext(referenceBases.getBaseString());
        funcotationBuilder.setVersion(this.version);
        funcotationBuilder.setDataSourceName(this.getName());
        return funcotationBuilder.build();
    }

    private GencodeFuncotation createFuncotationForMaskedBases(VariantContext variant, Allele altAllele, GencodeGtfTranscriptFeature annotationTranscript, ReferenceContext reference) {
        StringBuilder alleleLogStringBuilder = new StringBuilder();
        if (variant.getReference().getBaseString().contains(FuncotatorConstants.MASKED_ANY_BASE_STRING)) {
            alleleLogStringBuilder.append(" ref allele: " + variant.getReference().toString());
        }
        if (altAllele.getBaseString().contains(FuncotatorConstants.MASKED_ANY_BASE_STRING)) {
            alleleLogStringBuilder.append(" alt allele: " + altAllele.toString());
        }
        logger.warn("Cannot create complete funcotation for variant at " + variant.getContig() + ":" + variant.getStart() + "-" + variant.getEnd() + " due to" + alleleLogStringBuilder.toString());
        GencodeFuncotationBuilder funcotationBuilder = new GencodeFuncotationBuilder();
        funcotationBuilder.setGcContent(GencodeFuncotationFactory.calculateGcContent(variant.getReference(), altAllele, reference, 200));
        String alleleString = altAllele.getBaseString().isEmpty() ? altAllele.toString() : altAllele.getBaseString();
        funcotationBuilder.setVariantClassification(GencodeFuncotation.VariantClassification.COULD_NOT_DETERMINE).setRefAllele(variant.getReference()).setStrand(Strand.POSITIVE).setTumorSeqAllele2(alleleString).setStart(variant.getStart()).setEnd(variant.getEnd()).setVariantType(GencodeFuncotationFactory.getVariantType(variant.getReference(), altAllele)).setChromosome(variant.getContig()).setOtherTranscripts(Collections.emptyList()).setAnnotationTranscript(annotationTranscript.getTranscriptId());
        funcotationBuilder.setHugoSymbol(annotationTranscript.getGeneName());
        funcotationBuilder.setNcbiBuild(this.ncbiBuildVersion);
        StrandCorrectedReferenceBases referenceBases = FuncotatorUtils.getBasesInWindowAroundReferenceAllele(variant.getReference(), reference, Strand.POSITIVE, 10);
        funcotationBuilder.setReferenceContext(referenceBases.getBaseString(Strand.POSITIVE));
        funcotationBuilder.setVersion(this.version);
        funcotationBuilder.setDataSourceName(this.getName());
        return funcotationBuilder.build();
    }

    @VisibleForTesting
    static GencodeFuncotation.VariantType getVariantType(Allele refAllele, Allele altAllele) {
        if (altAllele.length() > refAllele.length()) {
            return GencodeFuncotation.VariantType.INS;
        }
        if (altAllele.equals((Object)Allele.SPAN_DEL) || altAllele.equals((Object)Allele.NO_CALL) || altAllele.isSymbolic()) {
            return GencodeFuncotation.VariantType.NA;
        }
        if (altAllele.length() < refAllele.length()) {
            return GencodeFuncotation.VariantType.DEL;
        }
        switch (refAllele.length()) {
            case 1: {
                return GencodeFuncotation.VariantType.SNP;
            }
            case 2: {
                return GencodeFuncotation.VariantType.DNP;
            }
            case 3: {
                return GencodeFuncotation.VariantType.TNP;
            }
        }
        return GencodeFuncotation.VariantType.ONP;
    }

    @VisibleForTesting
    static GencodeGtfFeature.FeatureTag getApprisRank(GencodeGtfTranscriptFeature gtfFeature) {
        List gtfApprisTags = gtfFeature.getOptionalFields().stream().filter(f -> f.getName().equals("tag")).filter(f -> f.getValue() instanceof GencodeGtfFeature.FeatureTag).filter(f -> apprisRanks.contains(f.getValue())).map(f -> (GencodeGtfFeature.FeatureTag)((Object)((Object)f.getValue()))).collect(Collectors.toList());
        if (gtfApprisTags.isEmpty()) {
            return null;
        }
        if (gtfApprisTags.size() == 1) {
            return (GencodeGtfFeature.FeatureTag)((Object)gtfApprisTags.get(0));
        }
        gtfApprisTags.sort(Comparator.naturalOrder());
        return (GencodeGtfFeature.FeatureTag)((Object)gtfApprisTags.get(0));
    }

    private static GencodeFuncotation.VariantClassification convertGeneTranscriptTypeToVariantClassification(GencodeGtfFeature.GeneTranscriptType type) {
        switch (type) {
            case MT_RRNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case MT_TRNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case MIRNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case MISC_RNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case RRNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case SCRNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case SNRNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case SNORNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case RIBOZYME: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case SRNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case SCARNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case MT_TRNA_PSEUDOGENE: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case TRNA_PSEUDOGENE: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case SNORNA_PSEUDOGENE: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case SNRNA_PSEUDOGENE: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case SCRNA_PSEUDOGENE: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case RRNA_PSEUDOGENE: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case MISC_RNA_PSEUDOGENE: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case MIRNA_PSEUDOGENE: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case ANTISENSE_RNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case KNOWN_NCRNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case LINCRNA: {
                return GencodeFuncotation.VariantClassification.LINCRNA;
            }
            case MACRO_LNCRNA: {
                return GencodeFuncotation.VariantClassification.LINCRNA;
            }
            case THREE_PRIME_OVERLAPPING_NCRNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case VAULTRNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
            case BIDIRECTIONAL_PROMOTER_LNCRNA: {
                return GencodeFuncotation.VariantClassification.RNA;
            }
        }
        return GencodeFuncotation.VariantClassification.RNA;
    }

    @Override
    public LinkedHashSet<String> getSupportedFuncotationFieldsForSegments() {
        return this.segmentMetadata.retrieveAllHeaderInfo().stream().map(VCFCompoundHeaderLine::getID).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<String> getSupportedFuncotationFieldsForSegmentsAsList() {
        return this.segmentMetadata.retrieveAllHeaderInfo().stream().map(VCFCompoundHeaderLine::getID).collect(Collectors.toList());
    }

    private FuncotationMetadata createSegmentFuncotationMetadata() {
        return VcfFuncotationMetadata.create(Arrays.asList(new VCFInfoHeaderLine(this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + GENES_SUFFIX, 1, VCFHeaderLineType.String, "The genes overlapping the segment.  Blank if none."), new VCFInfoHeaderLine(this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + START_GENE_SUFFIX, 1, VCFHeaderLineType.String, "The genes overlapping the start of the segment.  Blank if none."), new VCFInfoHeaderLine(this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + END_GENE_SUFFIX, 1, VCFHeaderLineType.String, "The genes overlapping the end of the segment.  Blank if none."), new VCFInfoHeaderLine(this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + START_EXON_SUFFIX, 1, VCFHeaderLineType.String, "The genes overlapping the start of the segment.  Blank if none."), new VCFInfoHeaderLine(this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + END_EXON_SUFFIX, 1, VCFHeaderLineType.String, "The genes overlapping the end of the segment.  Blank if none."), new VCFInfoHeaderLine(this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_alt_allele", 1, VCFHeaderLineType.String, "Always blank.  Included for legacy reasons."), new VCFInfoHeaderLine(this.getName() + OTHER_TRANSCRIPTS_INFO_SEP + this.getVersion() + "_ref_allele", 1, VCFHeaderLineType.String, "Always blank.  Included for legacy reasons.")));
    }

    @Override
    public boolean isSupportingSegmentFuncotation() {
        return this.isSegmentFuncotationEnabled;
    }

    @Override
    public List<Funcotation> createFuncotationsOnSegment(VariantContext segmentVariantContext, ReferenceContext referenceContext, List<Feature> gencodeGtfGeneFeaturesAsFeatures) {
        Utils.validateArg(this.transcriptSelectionMode != TranscriptSelectionMode.ALL, "Cannot create funcotations on segments if the selection mode is " + (Object)((Object)TranscriptSelectionMode.ALL));
        List<GencodeGtfGeneFeature> geneFeatures = gencodeGtfGeneFeaturesAsFeatures.stream().map(g -> (GencodeGtfGeneFeature)g).collect(Collectors.toList());
        return this.createSegmentFuncotations(segmentVariantContext, referenceContext, geneFeatures, this.gencodeFuncotationComparator);
    }

    private List<Funcotation> createSegmentFuncotations(VariantContext segmentVariantContext, ReferenceContext referenceContext, List<GencodeGtfGeneFeature> geneFeatures, Comparator<GencodeFuncotation> comparator) {
        List<GencodeGtfTranscriptFeature> allBasicOverlappingTranscripts = geneFeatures.stream().flatMap(gf -> gf.getTranscripts().stream()).filter(GencodeFuncotationFactory::isBasic).filter(t -> t.overlaps((Locatable)segmentVariantContext)).collect(Collectors.toList());
        List<String> genes = GencodeFuncotationFactory.retrieveGeneNamesFromTranscripts(allBasicOverlappingTranscripts).stream().sorted().collect(Collectors.toList());
        VariantContext segStartAsVariant = GencodeFuncotationFactory.createSubSegmentAsVariantContext(segmentVariantContext, segmentVariantContext.getStart(), segmentVariantContext.getStart());
        SimpleInterval segStartAsVariantInterval = new SimpleInterval(referenceContext.getInterval().getContig(), segStartAsVariant.getStart(), segStartAsVariant.getEnd());
        List<GencodeGtfTranscriptFeature> transcriptsOverlappingStart = GencodeFuncotationFactory.subsetToOverlappingTranscripts(segStartAsVariant, allBasicOverlappingTranscripts);
        VariantContext segEndAsVariant = GencodeFuncotationFactory.createSubSegmentAsVariantContext(segmentVariantContext, segmentVariantContext.getEnd(), segmentVariantContext.getEnd());
        SimpleInterval segEndAsVariantInterval = new SimpleInterval(referenceContext.getInterval().getContig(), segEndAsVariant.getStart(), segEndAsVariant.getEnd());
        List<GencodeGtfTranscriptFeature> transcriptsOverlappingEnd = GencodeFuncotationFactory.subsetToOverlappingTranscripts(segEndAsVariant, allBasicOverlappingTranscripts);
        List<GencodeFuncotation> startGencodeFuncotations = this.createFuncotationsHelper(segStartAsVariant, segStartAsVariant.getReference(), new ReferenceContext(referenceContext, segStartAsVariantInterval), transcriptsOverlappingStart);
        startGencodeFuncotations.sort(comparator);
        GencodeFuncotation startFuncotation = startGencodeFuncotations.size() == 0 ? null : startGencodeFuncotations.get(0);
        List<GencodeFuncotation> endGencodeFuncotations = this.createFuncotationsHelper(segEndAsVariant, segEndAsVariant.getReference(), new ReferenceContext(referenceContext, segEndAsVariantInterval), transcriptsOverlappingEnd);
        endGencodeFuncotations.sort(comparator);
        GencodeFuncotation endFuncotation = endGencodeFuncotations.size() == 0 ? null : endGencodeFuncotations.get(0);
        GencodeGtfTranscriptFeature chosenTranscriptStart = startFuncotation != null ? GencodeFuncotationFactory.findFirstTranscriptMatch(transcriptsOverlappingStart, startGencodeFuncotations.get(0).getAnnotationTranscript()) : null;
        GencodeGtfTranscriptFeature chosenTranscriptEnd = endFuncotation != null ? GencodeFuncotationFactory.findFirstTranscriptMatch(transcriptsOverlappingEnd, endGencodeFuncotations.get(0).getAnnotationTranscript()) : null;
        return this.createSegmentFuncotations(segmentVariantContext, genes, startFuncotation, endFuncotation, chosenTranscriptStart, chosenTranscriptEnd);
    }

    private static List<GencodeGtfTranscriptFeature> subsetToOverlappingTranscripts(VariantContext variant, List<GencodeGtfTranscriptFeature> allBasicOverlappingTranscripts) {
        return allBasicOverlappingTranscripts.stream().filter(tx -> tx.overlaps((Locatable)variant)).collect(Collectors.toList());
    }

    private static VariantContext createSubSegmentAsVariantContext(VariantContext segmentVariantContext, int start, int end) {
        return new VariantContextBuilder().chr(segmentVariantContext.getContig()).start((long)start).stop((long)end).alleles((Collection)segmentVariantContext.getAlleles()).make();
    }

    private List<Funcotation> createSegmentFuncotations(VariantContext segmentVariantContext, List<String> genes, GencodeFuncotation startFuncotation, GencodeFuncotation endFuncotation, GencodeGtfTranscriptFeature chosenTranscriptStart, GencodeGtfTranscriptFeature chosenTranscriptEnd) {
        String genesValue = StringUtils.join(genes, (String)GENES_FIELD_SEPARATOR);
        String startGeneValue = startFuncotation == null ? "" : startFuncotation.getHugoSymbol();
        String endGeneValue = endFuncotation == null ? "" : endFuncotation.getHugoSymbol();
        String startExonValue = chosenTranscriptStart == null ? "" : SegmentExonUtils.determineSegmentExonPosition(chosenTranscriptStart, (Locatable)segmentVariantContext).getSegmentStartExonOverlap();
        String endExonValue = chosenTranscriptEnd == null ? "" : SegmentExonUtils.determineSegmentExonPosition(chosenTranscriptEnd, (Locatable)segmentVariantContext).getSegmentEndExonOverlap();
        return segmentVariantContext.getAlternateAlleles().stream().map(a -> TableFuncotation.create(this.getSupportedFuncotationFieldsForSegmentsAsList(), Arrays.asList(genesValue, startGeneValue, endGeneValue, startExonValue, endExonValue, "", ""), a, this.getName(), this.segmentMetadata)).collect(Collectors.toList());
    }

    private static Set<String> retrieveGeneNamesFromTranscripts(List<GencodeGtfTranscriptFeature> txs) {
        return txs.stream().map(GencodeGtfFeature::getGeneName).collect(Collectors.toSet());
    }

    private static GencodeGtfTranscriptFeature findFirstTranscriptMatch(List<GencodeGtfTranscriptFeature> transcripts, String txId) {
        return transcripts.stream().filter(tx -> tx.getTranscriptId().equals(txId)).findFirst().orElse(null);
    }

    @VisibleForTesting
    static class MappedTranscriptIdInfo {
        String mapKey;
        int codingSequenceStart;
        int codingSequenceEnd;
        boolean has3pUtr;
        int threePrimeUtrStart;
        int threePrimeUtrEnd;
        boolean has5pUtr;
        int fivePrimeUtrStart;
        int fivePrimeUtrEnd;

        MappedTranscriptIdInfo() {
        }
    }
}

