/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.segment;

import com.google.common.collect.Lists;
import htsjdk.samtools.util.IntervalTree;
import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.annotation.Strand;
import java.util.List;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.segment.SegmentExonOverlaps;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfExonFeature;
import org.broadinstitute.hellbender.utils.codecs.gtf.GencodeGtfTranscriptFeature;

public class SegmentExonUtils {
    private static final String AND_BELOW_STR = "-";
    private static final String AND_ABOVE_STR = "+";
    private static final int NO_EXON_OVERLAP = -1;

    private SegmentExonUtils() {
    }

    public static SegmentExonOverlaps determineSegmentExonPosition(GencodeGtfTranscriptFeature transcript, Locatable segment) {
        List exons;
        Utils.nonNull(transcript);
        Utils.nonNull(segment);
        String NOT_IN_TRANSCRIPT = "";
        List list = exons = transcript.getGenomicStrand() == Strand.NEGATIVE ? Lists.reverse(transcript.getExons()) : transcript.getExons();
        if (exons.size() == 0) {
            return new SegmentExonOverlaps("", "");
        }
        SimpleInterval segmentStart = new SimpleInterval(segment.getContig(), segment.getStart(), segment.getStart());
        SimpleInterval segmentEnd = new SimpleInterval(segment.getContig(), segment.getEnd(), segment.getEnd());
        int inclusiveIndexPositiveDirectionStart = SegmentExonUtils.findInclusiveExonIndex(transcript.getGenomicStrand(), exons, segmentStart, true);
        int inclusiveIndexPositiveDirectionEnd = SegmentExonUtils.findInclusiveExonIndex(transcript.getGenomicStrand(), exons, segmentEnd, false);
        String startResult = inclusiveIndexPositiveDirectionStart != -1 ? inclusiveIndexPositiveDirectionStart + SegmentExonUtils.determineSegmentOverlapDirection(transcript.getGenomicStrand(), true) : "";
        String endResult = inclusiveIndexPositiveDirectionEnd != -1 ? inclusiveIndexPositiveDirectionEnd + SegmentExonUtils.determineSegmentOverlapDirection(transcript.getGenomicStrand(), false) : "";
        return new SegmentExonOverlaps(startResult, endResult);
    }

    private static int findInclusiveExonIndex(Strand codingDirection, List<GencodeGtfExonFeature> exons, SimpleInterval pointLocation, boolean isStartOfSegment) {
        boolean isIntron;
        int result = -1;
        if (exons.size() == 0) {
            return result;
        }
        IntervalTree exonFeatureIntervalTree = new IntervalTree();
        exons.forEach(e -> {
            GencodeGtfExonFeature cfr_ignored_0 = (GencodeGtfExonFeature)exonFeatureIntervalTree.put(e.getGenomicStartLocation(), e.getGenomicEndLocation(), e);
        });
        IntervalTree.Node gencodeGtfExonFeatureNode = exonFeatureIntervalTree.minOverlapper(pointLocation.getStart(), pointLocation.getEnd());
        GencodeGtfExonFeature exon = gencodeGtfExonFeatureNode != null ? (GencodeGtfExonFeature)gencodeGtfExonFeatureNode.getValue() : null;
        boolean isOverlapExonExtents = IntervalUtils.overlaps(pointLocation, new SimpleInterval(pointLocation.getContig(), exons.get(0).getGenomicStartLocation(), exons.get(exons.size() - 1).getGenomicEndLocation()));
        boolean bl = isIntron = exon == null && isOverlapExonExtents;
        if (exon == null && !isIntron) {
            result = -1;
        } else if (isIntron) {
            int increment = codingDirection == Strand.POSITIVE ? (isStartOfSegment ? 0 : -1) : (isStartOfSegment ? -1 : 0);
            for (int i = 1; i < exons.size(); ++i) {
                GencodeGtfExonFeature currentExon = exons.get(i);
                GencodeGtfExonFeature prevExon = exons.get(i - 1);
                SimpleInterval intron = new SimpleInterval(currentExon.getChromosomeName(), prevExon.getEnd() + 1, currentExon.getStart() - 1);
                if (!IntervalUtils.overlaps(pointLocation, intron)) continue;
                result = codingDirection == Strand.NEGATIVE ? exons.size() - i + increment : i + increment;
            }
        } else {
            result = exon.getExonNumber() - 1;
        }
        return result;
    }

    private static String determineSegmentOverlapDirection(Strand strand, boolean isSegmentStart) {
        if (isSegmentStart ^ strand == Strand.POSITIVE) {
            return AND_BELOW_STR;
        }
        return AND_ABOVE_STR;
    }
}

