/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.dataSources.vcf;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.funcotator.DataSourceFuncotationFactory;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorArgumentDefinitions;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadata;
import org.broadinstitute.hellbender.tools.funcotator.metadata.VcfFuncotationMetadata;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public class VcfFuncotationFactory
extends DataSourceFuncotationFactory {
    protected static final Logger logger = LogManager.getLogger(VcfFuncotationFactory.class);
    private final String name;
    private final Path sourceFilePath;
    private final LinkedHashMap<String, String> supportedFieldNamesAndDefaults;
    private final LinkedHashSet<String> supportedFieldNames;
    private final FuncotationMetadata supportedFieldMetadata;
    private final LRUCache<Triple<VariantContext, ReferenceContext, List<Feature>>, List<Funcotation>> cache = new LRUCache();
    private static final String DUPLICATE_RECORD_DELIMITER = "|";
    private static final String ID_FIELD_NAME = "ID";
    private static final String FILTER_FIELD_NAME = "FILTER";
    @VisibleForTesting
    int cacheHits = 0;
    @VisibleForTesting
    int cacheMisses = 0;

    public VcfFuncotationFactory(String name, String version, Path sourceFilePath, LinkedHashMap<String, String> annotationOverridesMap, FeatureInput<? extends Feature> mainSourceFileAsFeatureInput) {
        this(name, version, sourceFilePath, annotationOverridesMap, mainSourceFileAsFeatureInput, false);
    }

    public VcfFuncotationFactory(String name, String version, Path sourceFilePath, LinkedHashMap<String, String> annotationOverridesMap, FeatureInput<? extends Feature> mainSourceFileAsFeatureInput, boolean isDataSourceB37) {
        this(name, version, sourceFilePath, annotationOverridesMap, mainSourceFileAsFeatureInput, isDataSourceB37, 150);
    }

    public VcfFuncotationFactory(String name, String version, Path sourceFilePath, LinkedHashMap<String, String> annotationOverridesMap, FeatureInput<? extends Feature> mainSourceFileAsFeatureInput, boolean isDataSourceB37, int minBasesForValidSegment) {
        super(mainSourceFileAsFeatureInput, minBasesForValidSegment);
        this.name = name;
        this.version = version;
        this.sourceFilePath = sourceFilePath;
        this.dataSourceIsB37 = isDataSourceB37;
        this.supportedFieldNamesAndDefaults = new LinkedHashMap();
        this.supportedFieldNames = new LinkedHashSet();
        this.populateSupportedFieldNamesFromVcfFile();
        this.supportedFieldMetadata = this.createFuncotationMetadata(sourceFilePath);
        if (this.supportedFieldNames.size() == 0) {
            logger.warn("WARNING: VcfFuncotationFactory has nothing to annotate from VCF File: " + sourceFilePath.toUri().toString());
        } else {
            this.annotationOverrideMap = new LinkedHashMap();
            for (Map.Entry<String, String> entry : annotationOverridesMap.entrySet()) {
                if (!this.supportedFieldNamesAndDefaults.containsKey(entry.getKey())) continue;
                this.annotationOverrideMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private FuncotationMetadata createFuncotationMetadata(Path sourceFilePath) {
        try (FeatureDataSource vcfReader = new FeatureDataSource(sourceFilePath.toUri().toString());){
            Object header = vcfReader.getHeader();
            if (!(header instanceof VCFHeader)) {
                throw new IllegalArgumentException(sourceFilePath + " does not have a valid VCF header");
            }
            VCFHeader sourceVcfHeader = (VCFHeader)header;
            List<VCFInfoHeaderLine> metadataVcfInfoHeaderLines = this.createFuncotationVcfInfoHeaderLines(sourceVcfHeader);
            VcfFuncotationMetadata vcfFuncotationMetadata = VcfFuncotationMetadata.create(metadataVcfInfoHeaderLines);
            return vcfFuncotationMetadata;
        }
    }

    @VisibleForTesting
    List<VCFInfoHeaderLine> createFuncotationVcfInfoHeaderLines(VCFHeader vcfHeader) {
        List<VCFInfoHeaderLine> supportedVcfInfoHeaderLines = vcfHeader.getInfoHeaderLines().stream().filter(vcfInfoHeaderLine -> this.supportedFieldNames.contains(VcfFuncotationFactory.createFinalFieldName(this.name, vcfInfoHeaderLine.getID()))).map(vcfInfoHeaderLine -> VcfFuncotationFactory.copyWithRename(vcfInfoHeaderLine, this.name)).collect(Collectors.toList());
        VCFInfoHeaderLine idHeaderLine = new VCFInfoHeaderLine(VcfFuncotationFactory.createFinalFieldName(this.name, ID_FIELD_NAME), VCFHeaderLineCount.A, VCFHeaderLineType.String, "ID of the variant from the data source creating this annotation.");
        supportedVcfInfoHeaderLines.add(idHeaderLine);
        VCFInfoHeaderLine filterHeaderLine = new VCFInfoHeaderLine(VcfFuncotationFactory.createFinalFieldName(this.name, FILTER_FIELD_NAME), 1, VCFHeaderLineType.String, "FILTER status of the variant from the data source creating this annotation.");
        supportedVcfInfoHeaderLines.add(filterHeaderLine);
        return supportedVcfInfoHeaderLines;
    }

    private static VCFInfoHeaderLine copyWithRename(VCFInfoHeaderLine vcfInfoHeaderLine, String name) {
        if (vcfInfoHeaderLine.getCountType() == VCFHeaderLineCount.INTEGER) {
            return new VCFInfoHeaderLine(VcfFuncotationFactory.createFinalFieldName(name, vcfInfoHeaderLine.getID()), vcfInfoHeaderLine.getCount(), vcfInfoHeaderLine.getType(), vcfInfoHeaderLine.getDescription());
        }
        return new VCFInfoHeaderLine(VcfFuncotationFactory.createFinalFieldName(name, vcfInfoHeaderLine.getID()), vcfInfoHeaderLine.getCountType(), vcfInfoHeaderLine.getType(), vcfInfoHeaderLine.getDescription());
    }

    @Override
    public Class<? extends Feature> getAnnotationFeatureClass() {
        return VariantContext.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FuncotatorArgumentDefinitions.DataSourceType getType() {
        return FuncotatorArgumentDefinitions.DataSourceType.VCF;
    }

    @Override
    public LinkedHashSet<String> getSupportedFuncotationFields() {
        return this.supportedFieldNames;
    }

    @Override
    protected List<Funcotation> createDefaultFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext) {
        if (this.supportedFieldNames.size() != 0) {
            return this.createDefaultFuncotationsOnVariantHelper(variant, referenceContext, Collections.emptySet());
        }
        return Collections.emptyList();
    }

    @Override
    protected List<Funcotation> createFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext, List<Feature> featureList) {
        ArrayList<Funcotation> outputFuncotations = new ArrayList<Funcotation>();
        Triple<VariantContext, ReferenceContext, List<Feature>> cacheKey = this.createCacheKey(variant, referenceContext, featureList);
        List cacheResult = (List)this.cache.get(cacheKey);
        if (cacheResult != null) {
            ++this.cacheHits;
            return cacheResult;
        }
        if (this.supportedFieldNames.size() != 0) {
            List featureVariantList = featureList.stream().filter(f -> f != null).map(f -> (VariantContext)f).collect(Collectors.toList());
            LinkedHashMap<Allele, Funcotation> outputOrderedMap = new LinkedHashMap<Allele, Funcotation>();
            for (VariantContext featureVariant : featureVariantList) {
                int[] matchIndices = GATKVariantContextUtils.matchAllelesOnly(variant, featureVariant);
                for (int i = 0; i < matchIndices.length; ++i) {
                    int matchIndex = matchIndices[i];
                    Allele queryAltAllele = variant.getAlternateAllele(i);
                    if (matchIndex == -1) continue;
                    LinkedHashMap<String, String> annotations = new LinkedHashMap<String, String>(this.supportedFieldNamesAndDefaults);
                    for (Map.Entry<String, Object> entry : featureVariant.getAttributes().entrySet()) {
                        this.populateAnnotationMap(featureVariant, variant, matchIndex, annotations, entry);
                    }
                    annotations.put(VcfFuncotationFactory.createFinalFieldName(this.name, ID_FIELD_NAME), featureVariant.getID());
                    annotations.put(VcfFuncotationFactory.createFinalFieldName(this.name, FILTER_FIELD_NAME), featureVariant.getFilters().stream().collect(Collectors.joining(";")));
                    TableFuncotation newFuncotation = TableFuncotation.create(annotations, queryAltAllele, this.name, this.supportedFieldMetadata);
                    outputOrderedMap.merge(queryAltAllele, newFuncotation, VcfFuncotationFactory::mergeDuplicateFuncotationFactoryVariant);
                }
            }
            variant.getAlternateAlleles().forEach(a -> outputFuncotations.add(outputOrderedMap.computeIfAbsent((Allele)a, allele -> this.createDefaultFuncotation((Allele)allele))));
        }
        ++this.cacheMisses;
        this.cache.put(cacheKey, outputFuncotations);
        return outputFuncotations;
    }

    private static Funcotation mergeDuplicateFuncotationFactoryVariant(Funcotation funcotation1, Funcotation funcotation2) {
        Utils.validateArg(funcotation1.getAltAllele().equals((Object)funcotation2.getAltAllele()), "Merge called on funcotations that have differing alt alleles.");
        Utils.validateArg(funcotation1.getDataSourceName().equals(funcotation2.getDataSourceName()), "Merge called on funcotations that have differing datasource names.");
        LinkedHashSet<String> allFieldNames = funcotation1.getFieldNames();
        allFieldNames.addAll(funcotation2.getFieldNames());
        LinkedHashMap<String, String> mergedFieldsMap = new LinkedHashMap<String, String>();
        for (String fieldName : allFieldNames) {
            mergedFieldsMap.put(fieldName, VcfFuncotationFactory.mergeFuncotationValue(fieldName, funcotation1, funcotation2));
        }
        return TableFuncotation.create(mergedFieldsMap, funcotation1.getAltAllele(), funcotation1.getDataSourceName(), VcfFuncotationFactory.merge(funcotation1.getMetadata(), funcotation2.getMetadata()));
    }

    private static FuncotationMetadata merge(FuncotationMetadata funcotationMetadata1, FuncotationMetadata funcotationMetadata2) {
        LinkedHashSet<VCFInfoHeaderLine> rawMetadata = new LinkedHashSet<VCFInfoHeaderLine>(funcotationMetadata1.retrieveAllHeaderInfo());
        rawMetadata.addAll(funcotationMetadata2.retrieveAllHeaderInfo());
        return VcfFuncotationMetadata.create(new ArrayList<VCFInfoHeaderLine>(rawMetadata));
    }

    private static String mergeFuncotationValue(String fieldName, Funcotation funcotation1, Funcotation funcotation2) {
        boolean doesRegion1ContainAnnotation = funcotation1.hasField(fieldName);
        boolean doesRegion2ContainAnnotation = funcotation2.hasField(fieldName);
        if (doesRegion1ContainAnnotation && doesRegion2ContainAnnotation) {
            return VcfFuncotationFactory.renderFieldConflicts(funcotation1.getField(fieldName), funcotation2.getField(fieldName));
        }
        if (doesRegion1ContainAnnotation) {
            return funcotation1.getField(fieldName);
        }
        if (doesRegion2ContainAnnotation) {
            return funcotation2.getField(fieldName);
        }
        return null;
    }

    private static String renderFieldConflicts(String value1, String value2) {
        return value1 + DUPLICATE_RECORD_DELIMITER + value2;
    }

    private void populateAnnotationMap(VariantContext funcotationFactoryVariant, VariantContext queryVariant, int funcotationFactoryAltAlleleIndex, LinkedHashMap<String, String> annotations, Map.Entry<String, Object> attributeEntry) {
        String valueString;
        String attributeName = attributeEntry.getKey();
        if (attributeEntry.getValue() instanceof Collection) {
            Collection objectList = (Collection)attributeEntry.getValue();
            VCFHeaderLineCount countType = this.supportedFieldMetadata.retrieveHeaderInfo(VcfFuncotationFactory.createFinalFieldName(this.name, attributeName)).getCountType();
            valueString = funcotationFactoryVariant.isBiallelic() && queryVariant.isBiallelic() ? objectList.stream().map(Object::toString).collect(Collectors.joining(String.valueOf(','))) : this.determineValueStringFromMultiallelicAttributeList(funcotationFactoryAltAlleleIndex, objectList, countType);
        } else {
            valueString = attributeEntry.getValue().toString();
        }
        annotations.put(VcfFuncotationFactory.createFinalFieldName(this.name, attributeName), valueString);
    }

    private String determineValueStringFromMultiallelicAttributeList(int funcotationFactoryAltAlleleIndex, Collection<Object> attributeEntryValues, VCFHeaderLineCount countType) {
        switch (countType) {
            case A: {
                return attributeEntryValues.toArray()[funcotationFactoryAltAlleleIndex].toString();
            }
            case R: {
                Object referenceAlleleValue = attributeEntryValues.toArray()[0];
                return referenceAlleleValue.toString() + ',' + attributeEntryValues.toArray()[funcotationFactoryAltAlleleIndex + 1].toString();
            }
        }
        return attributeEntryValues.stream().map(Object::toString).collect(Collectors.joining(String.valueOf(',')));
    }

    @Override
    protected List<Funcotation> createFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext, List<Feature> featureList, List<GencodeFuncotation> gencodeFuncotations) {
        return this.createFuncotationsOnVariant(variant, referenceContext, featureList);
    }

    private List<Funcotation> createDefaultFuncotationsOnVariantHelper(VariantContext variant, ReferenceContext referenceContext, Set<Allele> annotatedAltAlleles) {
        ArrayList<Funcotation> funcotationList = new ArrayList<Funcotation>();
        if (this.supportedFieldNames.size() != 0) {
            List alternateAlleles = variant.getAlternateAlleles();
            for (Allele altAllele : alternateAlleles) {
                if (annotatedAltAlleles.contains(altAllele)) continue;
                funcotationList.add(this.createDefaultFuncotation(altAllele));
            }
        }
        return funcotationList;
    }

    private TableFuncotation createDefaultFuncotation(Allele altAllele) {
        return TableFuncotation.create(this.supportedFieldNamesAndDefaults, altAllele, this.name, this.supportedFieldMetadata);
    }

    private void populateSupportedFieldNamesFromVcfFile() {
        VCFFileReader reader = new VCFFileReader(this.sourceFilePath);
        VCFHeader header = reader.getFileHeader();
        ArrayList<String> infoLineKeys = new ArrayList<String>();
        HashMap<String, Boolean> infoFieldFlagMap = new HashMap<String, Boolean>();
        for (VCFInfoHeaderLine infoLine : header.getInfoHeaderLines()) {
            infoLineKeys.add(infoLine.getID());
            infoFieldFlagMap.put(infoLine.getID(), infoLine.getType() == VCFHeaderLineType.Flag);
        }
        infoLineKeys.sort(Comparator.naturalOrder());
        for (String key : infoLineKeys) {
            if (((Boolean)infoFieldFlagMap.get(key)).booleanValue()) {
                this.supportedFieldNamesAndDefaults.put(VcfFuncotationFactory.createFinalFieldName(this.name, key), "false");
            } else {
                this.supportedFieldNamesAndDefaults.put(VcfFuncotationFactory.createFinalFieldName(this.name, key), "");
            }
            this.supportedFieldNames.add(VcfFuncotationFactory.createFinalFieldName(this.name, key));
        }
        this.supportedFieldNamesAndDefaults.put(VcfFuncotationFactory.createFinalFieldName(this.name, ID_FIELD_NAME), "");
        this.supportedFieldNames.add(VcfFuncotationFactory.createFinalFieldName(this.name, ID_FIELD_NAME));
        this.supportedFieldNamesAndDefaults.put(VcfFuncotationFactory.createFinalFieldName(this.name, FILTER_FIELD_NAME), "");
        this.supportedFieldNames.add(VcfFuncotationFactory.createFinalFieldName(this.name, FILTER_FIELD_NAME));
    }

    @VisibleForTesting
    static String createFinalFieldName(String funcotationFactoryName, String fieldName) {
        return funcotationFactoryName + "_" + fieldName;
    }

    private Triple<VariantContext, ReferenceContext, List<Feature>> createCacheKey(VariantContext variant, ReferenceContext referenceContext, List<Feature> featureList) {
        return Triple.of((Object)variant, (Object)referenceContext, featureList);
    }

    @Override
    public void close() {
        logger.info(this.getName() + " " + this.getVersion() + " cache hits/total: " + this.cacheHits + "/" + (this.cacheMisses + this.cacheHits));
    }

    class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        static final long serialVersionUID = 55337L;
        @VisibleForTesting
        static final int MAX_ENTRIES = 20;

        public LRUCache() {
            super(20);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 20;
        }
    }
}

