/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.dataSources.xsv;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.tribble.Feature;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.DataSourceFuncotationFactory;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorArgumentDefinitions;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.codecs.xsvLocatableTable.XsvLocatableTableCodec;
import org.broadinstitute.hellbender.utils.codecs.xsvLocatableTable.XsvTableFeature;

public class LocatableXsvFuncotationFactory
extends DataSourceFuncotationFactory {
    @VisibleForTesting
    static String DEFAULT_NAME = "LocatableXsv";
    private final String name;
    private LinkedHashSet<String> supportedFieldNames = null;
    private List<String> supportedFieldNameList = null;
    private List<String> emptyFieldList = null;

    public LocatableXsvFuncotationFactory(String name, String version, LinkedHashMap<String, String> annotationOverridesMap, FeatureInput<? extends Feature> mainSourceFileAsFeatureInput) {
        this(name, version, annotationOverridesMap, mainSourceFileAsFeatureInput, false);
    }

    public LocatableXsvFuncotationFactory(String name, String version, LinkedHashMap<String, String> annotationOverridesMap, FeatureInput<? extends Feature> mainSourceFileAsFeatureInput, boolean isDataSourceB37) {
        this(name, version, annotationOverridesMap, mainSourceFileAsFeatureInput, isDataSourceB37, 150);
    }

    public LocatableXsvFuncotationFactory(String name, String version, LinkedHashMap<String, String> annotationOverridesMap, FeatureInput<? extends Feature> mainSourceFileAsFeatureInput, boolean isDataSourceB37, int minBasesForValidSegment) {
        super(mainSourceFileAsFeatureInput, minBasesForValidSegment);
        this.name = name;
        this.version = version;
        this.annotationOverrideMap = new LinkedHashMap<String, String>(annotationOverridesMap);
        this.dataSourceIsB37 = isDataSourceB37;
    }

    @Override
    public Class<? extends Feature> getAnnotationFeatureClass() {
        return XsvTableFeature.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LinkedHashSet<String> getSupportedFuncotationFields() {
        if (this.supportedFieldNames == null) {
            throw new GATKException("Must set supportedFuncotationFields before querying for them!");
        }
        return new LinkedHashSet<String>(this.supportedFieldNames);
    }

    @Override
    protected List<Funcotation> createDefaultFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext) {
        return this.createDefaultFuncotationsOnVariantHelper(variant, referenceContext, Collections.emptySet());
    }

    @Override
    protected List<Funcotation> createFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext, List<Feature> featureList) {
        ArrayList<Funcotation> outputFuncotations = new ArrayList<Funcotation>();
        List alternateAlleles = variant.getAlternateAlleles();
        HashSet<Allele> annotatedAltAlleles = new HashSet<Allele>(alternateAlleles.size());
        if (!featureList.isEmpty()) {
            for (Feature feature : featureList) {
                if (feature == null) continue;
                XsvTableFeature tableFeature = (XsvTableFeature)feature;
                if (!tableFeature.getDataSourceName().equals(this.name)) break;
                for (Allele altAllele : alternateAlleles) {
                    outputFuncotations.add(TableFuncotation.create(tableFeature, altAllele, this.name, null));
                    annotatedAltAlleles.add(altAllele);
                }
            }
        }
        if (annotatedAltAlleles.size() != alternateAlleles.size()) {
            outputFuncotations.addAll(this.createDefaultFuncotationsOnVariantHelper(variant, referenceContext, annotatedAltAlleles));
        }
        return outputFuncotations;
    }

    @Override
    protected List<Funcotation> createFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext, List<Feature> featureList, List<GencodeFuncotation> gencodeFuncotations) {
        return this.createFuncotationsOnVariant(variant, referenceContext, featureList);
    }

    @Override
    public FuncotatorArgumentDefinitions.DataSourceType getType() {
        return FuncotatorArgumentDefinitions.DataSourceType.LOCATABLE_XSV;
    }

    private List<Funcotation> createDefaultFuncotationsOnVariantHelper(VariantContext variant, ReferenceContext referenceContext, Set<Allele> annotatedAltAlleles) {
        ArrayList<Funcotation> funcotationList = new ArrayList<Funcotation>();
        List alternateAlleles = variant.getAlternateAlleles();
        for (Allele altAllele : alternateAlleles) {
            if (annotatedAltAlleles.contains(altAllele)) continue;
            funcotationList.add(TableFuncotation.create(this.supportedFieldNameList, this.emptyFieldList, altAllele, this.name, null));
        }
        return funcotationList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSupportedFuncotationFields(Path inputDataFilePath) {
        Utils.nonNull(inputDataFilePath);
        if (this.supportedFieldNames == null) {
            LocatableXsvFuncotationFactory locatableXsvFuncotationFactory = this;
            synchronized (locatableXsvFuncotationFactory) {
                if (this.supportedFieldNames == null) {
                    List<String> columnNames;
                    this.supportedFieldNames = new LinkedHashSet(10);
                    XsvLocatableTableCodec codec = new XsvLocatableTableCodec();
                    try {
                        if (!codec.canDecode(this.mainSourceFileAsFeatureInput.getFeaturePath())) {
                            throw new GATKException.ShouldNeverReachHereException("Could not decode from data file: " + this.mainSourceFileAsFeatureInput.getFeaturePath());
                        }
                    }
                    catch (NullPointerException ex) {
                        throw new GATKException.ShouldNeverReachHereException("Could not decode from data file!  Has not been set yet!");
                    }
                    try (InputStream fileInputStream = Files.newInputStream(inputDataFilePath, new OpenOption[0]);){
                        AsciiLineReaderIterator lineReaderIterator = new AsciiLineReaderIterator(AsciiLineReader.from((InputStream)fileInputStream));
                        codec.readActualHeader((LineIterator)lineReaderIterator);
                        columnNames = codec.getHeaderWithoutLocationColumns();
                    }
                    catch (IOException ioe) {
                        throw new UserException.BadInput("Could not read header from data file: " + inputDataFilePath.toUri().toString(), ioe);
                    }
                    if (columnNames == null) {
                        throw new UserException.MalformedFile("Could not decode from data file: " + inputDataFilePath.toUri().toString());
                    }
                    this.supportedFieldNames.addAll(columnNames);
                    this.initializeFieldNameLists();
                    this.annotationOverrideMap.entrySet().removeIf(e -> !this.supportedFieldNames.contains(e.getKey()));
                }
            }
        }
    }

    private void initializeFieldNameLists() {
        if (this.supportedFieldNames == null) {
            throw new GATKException("Must set supportedFuncotationFields before initializing field name lists!");
        }
        this.supportedFieldNameList = new ArrayList<String>(this.supportedFieldNames);
        this.emptyFieldList = new ArrayList<String>(this.supportedFieldNameList.size());
        for (String s : this.supportedFieldNameList) {
            this.emptyFieldList.add("");
        }
    }
}

