/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.dataSources.xsv;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.DataSourceFuncotationFactory;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorArgumentDefinitions;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.nio.PathLineIterator;

public class SimpleKeyXsvFuncotationFactory
extends DataSourceFuncotationFactory {
    private final String name;
    private final String delimiter;
    private final Path xsvInputPath;
    private final int keyColumn;
    private final XsvDataKeyType keyType;
    private final int numHeaderLinesToIgnore;
    private final List<String> annotationColumnNames;
    private final List<String> emptyAnnotationList;
    private final Map<String, List<String>> annotationMap;

    public SimpleKeyXsvFuncotationFactory(String name, Path filePath, String version, String delim, int keyColumn, XsvDataKeyType keyType) {
        this(name, filePath, version, delim, keyColumn, keyType, new LinkedHashMap<String, String>(), 0, false);
    }

    public SimpleKeyXsvFuncotationFactory(String name, Path filePath, String version, String delim, int keyColumn, XsvDataKeyType keyType, LinkedHashMap<String, String> annotationOverrides) {
        this(name, filePath, version, delim, keyColumn, keyType, annotationOverrides, 0, false);
    }

    public SimpleKeyXsvFuncotationFactory(String name, Path filePath, String version, String delim, int keyColumn, XsvDataKeyType keyType, LinkedHashMap<String, String> annotationOverrides, int numHeaderLinesToIgnore) {
        this(name, filePath, version, delim, keyColumn, keyType, annotationOverrides, numHeaderLinesToIgnore, false);
    }

    public SimpleKeyXsvFuncotationFactory(String name, Path filePath, String version, String delim, int keyColumn, XsvDataKeyType keyType, LinkedHashMap<String, String> annotationOverrides, int numHeaderLinesToIgnore, boolean permissiveColumns) {
        this(name, filePath, version, delim, keyColumn, keyType, annotationOverrides, numHeaderLinesToIgnore, permissiveColumns, false);
    }

    public SimpleKeyXsvFuncotationFactory(String name, Path filePath, String version, String delim, int keyColumn, XsvDataKeyType keyType, LinkedHashMap<String, String> annotationOverrides, int numHeaderLinesToIgnore, boolean permissiveColumns, boolean isDataSourceB37) {
        this(name, filePath, version, delim, keyColumn, keyType, annotationOverrides, numHeaderLinesToIgnore, permissiveColumns, isDataSourceB37, 150);
    }

    public SimpleKeyXsvFuncotationFactory(String name, Path filePath, String version, String delim, int keyColumn, XsvDataKeyType keyType, LinkedHashMap<String, String> annotationOverrides, int numHeaderLinesToIgnore, boolean permissiveColumns, boolean isDataSourceB37, int minBasesForValidSegment) {
        super(minBasesForValidSegment);
        this.name = name;
        this.delimiter = delim;
        this.xsvInputPath = filePath;
        this.version = version;
        this.keyColumn = keyColumn;
        this.keyType = keyType;
        this.annotationOverrideMap = annotationOverrides;
        this.numHeaderLinesToIgnore = numHeaderLinesToIgnore;
        this.dataSourceIsB37 = isDataSourceB37;
        this.annotationMap = new HashMap<String, List<String>>();
        try (PathLineIterator pathLineIterator = new PathLineIterator(this.xsvInputPath);){
            Iterator<String> it = pathLineIterator.iterator();
            this.annotationColumnNames = this.createColumnNames(it, numHeaderLinesToIgnore);
            this.emptyAnnotationList = new ArrayList<String>(this.annotationColumnNames.size());
            for (String s : this.annotationColumnNames) {
                this.emptyAnnotationList.add("");
            }
            this.populateAnnotationMap(it, permissiveColumns);
        }
        this.initializeAnnotationOverrides(annotationOverrides);
    }

    @Override
    public Class<? extends Feature> getAnnotationFeatureClass() {
        return Feature.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @VisibleForTesting
    public boolean requiresFeatures() {
        return false;
    }

    @Override
    public LinkedHashSet<String> getSupportedFuncotationFields() {
        return new LinkedHashSet<String>(this.annotationColumnNames);
    }

    @Override
    protected List<Funcotation> createDefaultFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext) {
        return this.createDefaultFuncotationsOnVariantHelper(variant, referenceContext, Collections.emptySet());
    }

    @Override
    protected List<Funcotation> createFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext, List<Feature> featureList) {
        throw new GATKException(this.getClass().getName() + " requires a set of GencodeFuncotations in order to createFuncotationsOnVariant!  This method should never be called on a " + this.getClass().getName());
    }

    @Override
    protected List<Funcotation> createFuncotationsOnVariant(VariantContext variant, ReferenceContext referenceContext, List<Feature> featureList, List<GencodeFuncotation> gencodeFuncotations) {
        ArrayList<Funcotation> outputFuncotations = new ArrayList<Funcotation>();
        for (GencodeFuncotation gencodeFuncotation : gencodeFuncotations) {
            String key;
            HashSet<Allele> annotatedAltAlleles = new HashSet<Allele>(variant.getAlternateAlleles().size());
            if (this.keyType == XsvDataKeyType.GENE_NAME) {
                key = gencodeFuncotation.getHugoSymbol();
            } else if (this.keyType == XsvDataKeyType.TRANSCRIPT_ID) {
                key = FuncotatorUtils.getTranscriptIdWithoutVersionNumber(gencodeFuncotation.getAnnotationTranscript());
            } else {
                throw new GATKException.ShouldNeverReachHereException("Unrecognized key type: " + (Object)((Object)this.keyType));
            }
            List<String> annotations = this.annotationMap.get(key);
            if (annotations != null) {
                for (Allele altAllele : variant.getAlternateAlleles()) {
                    outputFuncotations.add(TableFuncotation.create(this.annotationColumnNames, annotations, altAllele, this.name, null));
                    annotatedAltAlleles.add(altAllele);
                }
            }
            if (annotatedAltAlleles.size() == variant.getAlternateAlleles().size()) continue;
            outputFuncotations.addAll(this.createDefaultFuncotationsOnVariantHelper(variant, referenceContext, annotatedAltAlleles));
        }
        return outputFuncotations;
    }

    @Override
    public FuncotatorArgumentDefinitions.DataSourceType getType() {
        return FuncotatorArgumentDefinitions.DataSourceType.SIMPLE_XSV;
    }

    private List<Funcotation> createDefaultFuncotationsOnVariantHelper(VariantContext variant, ReferenceContext referenceContext, Set<Allele> annotatedAltAlleles) {
        ArrayList<Funcotation> funcotationList = new ArrayList<Funcotation>();
        List alternateAlleles = variant.getAlternateAlleles();
        for (Allele altAllele : alternateAlleles) {
            if (annotatedAltAlleles.contains(altAllele)) continue;
            funcotationList.add(TableFuncotation.create(this.annotationColumnNames, this.emptyAnnotationList, altAllele, this.name, null));
        }
        return funcotationList;
    }

    private List<String> createColumnNames(Iterator<String> lineIterator, int numHeaderLinesToIgnore) {
        for (int i = 0; i < numHeaderLinesToIgnore; ++i) {
            lineIterator.next();
        }
        List annotationColumnNames = Utils.split(lineIterator.next(), this.delimiter).stream().map(n -> n.replaceAll("^\\s+", "").replaceAll("\\s+$", "")).map(n -> this.getName() + "_" + n.replaceAll(" ", "_")).collect(Collectors.toCollection(ArrayList::new));
        if (annotationColumnNames.size() < 2) {
            throw new UserException.MalformedFile("Data Source is badly formatted (" + this.xsvInputPath.toUri().toString() + ") - contains too few columns (" + annotationColumnNames.size() + ")!  Is the delimiter specified incorrectly?");
        }
        annotationColumnNames.remove(this.keyColumn);
        return annotationColumnNames;
    }

    private void populateAnnotationMap(Iterator<String> it, boolean permissiveColumnNumbers) {
        boolean emptyLineFlag = false;
        int dataRowNum = this.numHeaderLinesToIgnore + 2;
        while (it.hasNext()) {
            String rawRow = it.next();
            if (rawRow.length() == 0 && !emptyLineFlag) {
                emptyLineFlag = true;
                continue;
            }
            if (emptyLineFlag) {
                throw new UserException.MalformedFile("File contains an empty line (" + dataRowNum + ").  All lines must have data.");
            }
            List<String> dataRow = Utils.split(rawRow, this.delimiter);
            String rowKey = dataRow.remove(this.keyColumn);
            if (this.keyType == XsvDataKeyType.TRANSCRIPT_ID) {
                rowKey = FuncotatorUtils.getTranscriptIdWithoutVersionNumber(rowKey);
            }
            if (dataRow.size() != this.annotationColumnNames.size()) {
                if (!permissiveColumnNumbers) {
                    throw new UserException.MalformedFile("Data Source is badly formatted (" + this.xsvInputPath.toUri().toString() + ") - row " + dataRowNum + " does not contain the same number of columns as header (" + dataRow.size() + " != " + this.annotationColumnNames.size() + ")!");
                }
                if (dataRow.size() > this.annotationColumnNames.size()) {
                    dataRow.remove(dataRow.size() - 1);
                } else {
                    while (dataRow.size() < this.annotationColumnNames.size()) {
                        dataRow.add("");
                    }
                }
            }
            this.annotationMap.put(rowKey, dataRow);
            ++dataRowNum;
        }
    }

    public static enum XsvDataKeyType {
        GENE_NAME,
        TRANSCRIPT_ID;

    }
}

