/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.filtrationRules;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.AlleleFrequencyUtils;

public class AlleleFrequencyExacUtils
extends AlleleFrequencyUtils {
    private static String EXAC_ALLELE_COUNT_PREFIX = "ExAC_AC_";
    private static String EXAC_ALLELE_NUMBER_PREFIX = "ExAC_AN_";
    private static final Logger logger = LogManager.getLogger(AlleleFrequencyExacUtils.class);

    protected static double getMaxMinorAlleleFreq(Set<Map.Entry<String, String>> funcotations) {
        return Arrays.stream(ExacSubPopulation.values()).filter(subpop -> funcotations.stream().anyMatch(entry -> ((String)entry.getKey()).equals(EXAC_ALLELE_COUNT_PREFIX + subpop.name()))).map(subpop -> {
            String exacAlleleCount = EXAC_ALLELE_COUNT_PREFIX + subpop.name();
            String exacAlleleNumber = EXAC_ALLELE_NUMBER_PREFIX + subpop.name();
            List<String> keys = Arrays.asList(exacAlleleCount, exacAlleleNumber);
            Set matchingFuncotations = funcotations.stream().filter(entry -> keys.contains(entry.getKey())).collect(Collectors.toSet());
            try {
                Double ac = matchingFuncotations.stream().filter(entry1 -> ((String)entry1.getKey()).equals(exacAlleleCount)).findFirst().map(entry -> Double.valueOf((String)entry.getValue())).orElse(0.0);
                Integer an = matchingFuncotations.stream().filter(entry1 -> ((String)entry1.getKey()).equals(exacAlleleNumber)).findFirst().map(entry -> Integer.valueOf((String)entry.getValue())).orElse(0);
                if (an == 0) {
                    return 0.0;
                }
                return ac / (double)an.intValue();
            }
            catch (NumberFormatException e) {
                logger.warn("Found an inconsistency in the funcotation annotations: " + e.getMessage());
                return 0.0;
            }
        }).max(Double::compareTo).orElse(0.0);
    }

    private static enum ExacSubPopulation {
        AFR,
        AMR,
        EAS,
        FIN,
        NFE,
        OTH,
        SAS;

    }
}

