/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.filtrationRules;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;

class AlleleFrequencyGnomadUtils {
    AlleleFrequencyGnomadUtils() {
    }

    static double getMaxMinorAlleleFreq(Map<String, String> funcotations) {
        return AlleleFrequencyGnomadUtils.getSubpopAlleleFrequencies(funcotations).filter(funcotations::containsKey).map(subpop -> Double.valueOf((String)funcotations.get(subpop))).max(Double::compareTo).orElse(0.0);
    }

    static boolean allFrequenciesFiltered(Map<String, String> funcotations) {
        return AlleleFrequencyGnomadUtils.datasetsPresent(funcotations).count() == 0L;
    }

    private static Stream<String> getSubpopAlleleFrequencies(Map<String, String> funcotations) {
        return AlleleFrequencyGnomadUtils.datasetsPresent(funcotations).flatMap(dataset -> Arrays.stream(GnomadSubpopSuffixes.values()).map(suffix -> ((GnomadDataset)dataset).alleleFrequencyPrefix + suffix.name()));
    }

    private static Stream<GnomadDataset> datasetsPresent(Map<String, String> funcotations) {
        return Arrays.stream(GnomadDataset.values()).filter(dataset -> !funcotations.containsKey(((GnomadDataset)dataset).filterAnnotation) || funcotations.containsKey(((GnomadDataset)dataset).filterAnnotation) && ((String)funcotations.get(((GnomadDataset)dataset).filterAnnotation)).equals("PASS"));
    }

    private static enum GnomadDataset {
        gnomAD_genome,
        gnomAD_exome;

        private String alleleFrequencyPrefix = this.name() + "_AF_";
        private String filterAnnotation = this.name() + "_FILTER";
    }

    private static enum GnomadSubpopSuffixes {
        afr,
        afr_female,
        afr_male,
        amr,
        amr_female,
        amr_male,
        asj,
        asj_female,
        asj_male,
        eas,
        eas_female,
        eas_jpn,
        eas_kor,
        eas_male,
        eas_oea,
        female,
        fin,
        fin_female,
        fin_male,
        male,
        nfe,
        nfe_bgr,
        nfe_est,
        nfe_female,
        nfe_male,
        nfe_nwe,
        nfe_onf,
        nfe_seu,
        nfe_swe,
        oth,
        oth_female,
        oth_male,
        popmax,
        raw,
        sas,
        sas_female,
        sas_male;

    }
}

