/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.filtrationRules;

import java.util.Map;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.funcotator.FilterFuncotations;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.AlleleFrequencyExacUtils;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.AlleleFrequencyGnomadUtils;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.FuncotationFiltrationRule;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public abstract class AlleleFrequencyUtils {
    public static FuncotationFiltrationRule buildMaxMafRule(double maxMaf, FilterFuncotations.AlleleFrequencyDataSource afDataSource) {
        ParamUtils.inRange(maxMaf, 0.0, 1.0, "MAF must be between 0 and 1");
        if (afDataSource.equals((Object)FilterFuncotations.AlleleFrequencyDataSource.exac)) {
            return (funcotations, variant) -> AlleleFrequencyExacUtils.getMaxMinorAlleleFreq(funcotations) <= maxMaf;
        }
        return (funcotations, variant) -> {
            Map<String, String> condensedFuncotations = funcotations.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return !AlleleFrequencyGnomadUtils.allFrequenciesFiltered(condensedFuncotations) && AlleleFrequencyGnomadUtils.getMaxMinorAlleleFreq(condensedFuncotations) <= maxMaf;
        };
    }
}

