/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.filtrationRules;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.funcotator.FilterFuncotations;
import org.broadinstitute.hellbender.tools.funcotator.FilterFuncotationsUtils;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.AutosomalRecessiveConstants;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.FuncotationFiltrationRule;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.TwoPassFuncotationFilter;

public class ArHetvarFilter
extends TwoPassFuncotationFilter {
    private final String gene;
    private final String annotationTranscript;
    private final List<VariantContext> arCompoundHetVariants = new ArrayList<VariantContext>();
    private final Map<String, List<VariantContext>> arHetVariantsByGene = new HashMap<String, List<VariantContext>>();
    private final String[] funcotationKeys;
    private boolean firstPassApplied;
    private boolean afterFirstPassApplied;

    @Override
    List<FuncotationFiltrationRule> getRules() {
        return Collections.singletonList(this::arHetvarRule);
    }

    public ArHetvarFilter(FilterFuncotations.Reference reference, String[] funcotationKeys) {
        super("AR");
        this.gene = "Gencode_" + reference.getGencodeVersion() + "_hugoSymbol";
        this.annotationTranscript = "Gencode_" + reference.getGencodeVersion() + "_annotationTranscript";
        this.funcotationKeys = funcotationKeys;
    }

    @Override
    public void firstPassApply(VariantContext variant) {
        this.firstPassApplied = true;
        this.buildArHetByGene(variant);
    }

    @Override
    public void afterFirstPass() {
        if (!this.firstPassApplied) {
            throw new GATKException("firstPassApply should be called before afterFirstPass");
        }
        this.afterFirstPassApplied = true;
        this.arHetVariantsByGene.keySet().forEach(gene -> {
            if (this.arHetVariantsByGene.get(gene).size() > 1) {
                this.arCompoundHetVariants.addAll((Collection<VariantContext>)this.arHetVariantsByGene.get(gene));
            }
        });
    }

    private boolean arHetvarRule(Set<Map.Entry<String, String>> funcotations, VariantContext variant) {
        if (!this.firstPassApplied) {
            throw new GATKException("firstPassApply should be called before this rule is applied");
        }
        if (!this.afterFirstPassApplied) {
            throw new GATKException("afterFirstPassApplied should be called before this rule is applied");
        }
        return this.arCompoundHetVariants.stream().anyMatch(hetVariant -> this.variantContextsMatch((VariantContext)hetVariant, variant));
    }

    private void buildArHetByGene(VariantContext variant) {
        Map<Allele, FuncotationMap> funcs = FuncotatorUtils.createAlleleToFuncotationMapFromFuncotationVcfAttribute(this.funcotationKeys, variant, this.annotationTranscript, "FAKE_SOURCE");
        funcs.values().forEach(funcotationMap -> FilterFuncotationsUtils.getTranscriptFuncotations(funcotationMap).forEach(funcotations -> {
            String gene;
            Optional<Map.Entry> maybeGeneFuncotation = funcotations.stream().filter(funcotation -> ((String)funcotation.getKey()).equals(this.gene)).findFirst();
            if (maybeGeneFuncotation.isPresent() && AutosomalRecessiveConstants.AUTOSOMAL_RECESSIVE_GENES.contains(gene = (String)maybeGeneFuncotation.get().getValue()) && variant.getHetCount() > 0) {
                if (this.arHetVariantsByGene.containsKey(gene)) {
                    this.arHetVariantsByGene.get(gene).add(variant);
                } else {
                    ArrayList<VariantContext> variants = new ArrayList<VariantContext>();
                    variants.add(variant);
                    this.arHetVariantsByGene.put(gene, variants);
                }
            }
        }));
    }

    private boolean variantContextsMatch(VariantContext v1, VariantContext v2) {
        return v1.getContig().equals(v2.getContig()) && v1.getStart() == v2.getStart() && v1.getEnd() == v2.getEnd() && v1.getReference() == v2.getReference() && v1.getAlternateAlleles().size() == v2.getAlternateAlleles().size() && v1.getAlternateAlleles().containsAll(v2.getAlternateAlleles());
    }
}

