/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.filtrationRules;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.hellbender.tools.funcotator.FilterFuncotations;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.AutosomalRecessiveConstants;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.FuncotationFilter;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.FuncotationFiltrationRule;

public class ArHomvarFilter
extends FuncotationFilter {
    private final String gene;

    public ArHomvarFilter(FilterFuncotations.Reference reference) {
        super("AR");
        this.gene = "Gencode_" + reference.getGencodeVersion() + "_hugoSymbol";
    }

    @Override
    List<FuncotationFiltrationRule> getRules() {
        return Collections.singletonList(this::arHomvarRule);
    }

    private boolean arHomvarRule(Set<Map.Entry<String, String>> funcotations, VariantContext variantContext) {
        boolean isInterestingGene = funcotations.stream().anyMatch(funcotation -> ((String)funcotation.getKey()).equals(this.gene) && AutosomalRecessiveConstants.AUTOSOMAL_RECESSIVE_GENES.contains(funcotation.getValue()));
        if (isInterestingGene) {
            return variantContext.getHomVarCount() > 0;
        }
        return false;
    }
}

