/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.filtrationRules;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.funcotator.FilterFuncotations;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.AlleleFrequencyUtils;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.FuncotationFilter;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.FuncotationFiltrationRule;

public class ClinVarFilter
extends FuncotationFilter {
    public static final String CLINSIG_INFO_VALUE = "CLINVAR";
    private static final String ACMG_DISEASE_FUNCOTATION = "ACMG_recommendation_Disease_Name";
    private static final String CLINVAR_SIGNIFICANCE_FUNCOTATION = "ClinVar_VCF_CLNSIG";
    private static final List<String> CLINVAR_SIGNIFICANCE_MATCHING_VALUES = Arrays.asList("Pathogenic", "Likely_pathogenic", "Pathogenic/Likely_pathogenic");
    private static final double CLINVAR_MAX_MAF = 0.05;
    private final FilterFuncotations.AlleleFrequencyDataSource afDataSource;

    public ClinVarFilter(FilterFuncotations.AlleleFrequencyDataSource afDataSource) {
        super(CLINSIG_INFO_VALUE);
        this.afDataSource = afDataSource;
    }

    @Override
    List<FuncotationFiltrationRule> getRules() {
        return Arrays.asList((funcotations, variant) -> this.containsKey(funcotations, ACMG_DISEASE_FUNCOTATION), (funcotations, variant) -> {
            Set significance = this.matchOnKeyOrDefault(funcotations, CLINVAR_SIGNIFICANCE_FUNCOTATION, "").filter(value -> !value.isEmpty()).collect(Collectors.toSet());
            return CLINVAR_SIGNIFICANCE_MATCHING_VALUES.stream().anyMatch(significance::contains);
        }, AlleleFrequencyUtils.buildMaxMafRule(0.05, this.afDataSource));
    }
}

