/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.filtrationRules;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.FuncotationFiltrationRule;
import org.broadinstitute.hellbender.utils.Utils;

public abstract class FuncotationFilter {
    private final String filterName;

    FuncotationFilter(String filterName) {
        this.filterName = filterName;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public Boolean checkFilter(Set<Map.Entry<String, String>> prunedTranscriptFuncotations, VariantContext variant) {
        Utils.nonNull(prunedTranscriptFuncotations);
        return this.getRules().stream().map(rule -> rule.checkRule(prunedTranscriptFuncotations, variant)).reduce(Boolean::logicalAnd).orElse(false);
    }

    abstract List<FuncotationFiltrationRule> getRules();

    protected Stream<String> matchOnKeyOrDefault(Set<Map.Entry<String, String>> funcotations, String key, String defaultValue) {
        return this.getMatchesOrDefault(funcotations, entry -> ((String)entry.getKey()).equals(key), defaultValue);
    }

    protected Stream<String> getMatchesOrDefault(Set<Map.Entry<String, String>> funcotations, Predicate<Map.Entry<String, String>> matcher, String defaultValue) {
        Set matched = funcotations.stream().filter(matcher).map(Map.Entry::getValue).collect(Collectors.toSet());
        if (matched.isEmpty()) {
            return Stream.of(defaultValue);
        }
        return matched.stream();
    }

    protected Boolean containsKey(Set<Map.Entry<String, String>> funcotations, String key) {
        return funcotations.stream().anyMatch(entry -> ((String)entry.getKey()).equals(key));
    }
}

