/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.filtrationRules;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.tools.funcotator.FilterFuncotations;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.AlleleFrequencyUtils;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.FuncotationFilter;
import org.broadinstitute.hellbender.tools.funcotator.filtrationRules.FuncotationFiltrationRule;

public class LofFilter
extends FuncotationFilter {
    public static final String CLINSIG_INFO_VALUE = "LOF";
    private static final String LOF_GENE_FUNCOTATION = "ACMGLMMLof_LOF_Mechanism";
    private static final Set<String> CONSTANT_LOF_CLASSIFICATIONS = Stream.of(GencodeFuncotation.VariantClassification.FRAME_SHIFT_DEL, GencodeFuncotation.VariantClassification.FRAME_SHIFT_INS, GencodeFuncotation.VariantClassification.NONSENSE, GencodeFuncotation.VariantClassification.START_CODON_DEL, GencodeFuncotation.VariantClassification.SPLICE_SITE).map(GencodeFuncotation.VariantClassification::toString).collect(Collectors.toSet());
    private static final double LOF_MAX_MAF = 0.01;
    private final String classificationFuncotation;
    private final FilterFuncotations.AlleleFrequencyDataSource afDataSource;

    public LofFilter(FilterFuncotations.Reference ref, FilterFuncotations.AlleleFrequencyDataSource afDataSource) {
        super(CLINSIG_INFO_VALUE);
        this.classificationFuncotation = "Gencode_" + ref.getGencodeVersion() + "_variantClassification";
        this.afDataSource = afDataSource;
    }

    @Override
    List<FuncotationFiltrationRule> getRules() {
        return Arrays.asList((funcotations, variant) -> this.matchOnKeyOrDefault(funcotations, this.classificationFuncotation, "").anyMatch(CONSTANT_LOF_CLASSIFICATIONS::contains), (funcotations, variant) -> this.matchOnKeyOrDefault(funcotations, LOF_GENE_FUNCOTATION, "").anyMatch("YES"::equals), AlleleFrequencyUtils.buildMaxMafRule(0.01, this.afDataSource));
    }
}

