/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.genelistoutput;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.IOUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.greypanther.natsort.SimpleNaturalComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.OutputRenderer;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.simpletsvoutput.SimpleTsvOutputRenderer;
import org.broadinstitute.hellbender.utils.Utils;

public class GeneListOutputRenderer
extends OutputRenderer {
    @VisibleForTesting
    public static final String CONFIG_RESOURCE = "org/broadinstitute/hellbender/tools/funcotator/gene_list_output.config";
    private static final String GENE_FIELD_NAME = "gene";
    private static final String EXON_FIELD_NAME = "exon";
    private static final String GENE_LIST_OUTPUT_RENDERER_DUMMY_NAME = "GENE_LIST_OUTPUT_RENDERER";
    private static final String GENCODE_GENES_FIELD_PATTERN_STRING = "Gencode_[0-9]+_genes";
    private static final String GENCODE_START_GENE_FIELD_PATTERN_STRING = "Gencode_[0-9]+_start_gene";
    private static final String GENCODE_START_EXON_FIELD_PATTERN_STRING = "Gencode_[0-9]+_start_exon";
    private static final String GENCODE_END_GENE_FIELD_PATTERN_STRING = "Gencode_[0-9]+_end_gene";
    private static final String GENCODE_END_EXON_FIELD_PATTERN_STRING = "Gencode_[0-9]+_end_exon";
    private static final String ERR_STR_IS_THIS_SEG_FILE = "Is the input a file of segment variant contexts?";
    @VisibleForTesting
    static final String MISSING_GENCODE_FIELD_ERROR_MSG = "Could not find exactly one gencode field match in the funcotation map";
    @VisibleForTesting
    static final String ONE_ALTERNATE_ALLELE_ERR_MSG = "  Only one alternate allele per variant context is accepted.";
    @VisibleForTesting
    static final String INVALID_VARIANT_CONTEXT_ERR_MSG = "  Variant context does not represent a copy number segment";
    @VisibleForTesting
    static final String INCORRECT_NUM_TRANSCRIPT_ERR_MSG = "  Need exactly one transcript ID";
    @VisibleForTesting
    static final String INVALID_TRANSCRIPT_ID_ERR_MSG = "  Invalid transcript ID seen";
    private final SortedMap<Pair<String, String>, Pair<VariantContext, FuncotationMap>> geneExonToVariantFuncotationMap;
    private final SimpleTsvOutputRenderer simpleTsvOutputRenderer;
    private final Pattern gencodeGenesFieldPattern;
    private final Pattern gencodeStartExonFieldPattern;
    private final Pattern gencodeStartGeneFieldPattern;
    private final Pattern gencodeEndGeneFieldPattern;
    private final Pattern gencodeEndExonFieldPattern;
    private final int minNumBasesForValidSegment;

    public GeneListOutputRenderer(Path outputFilePath, LinkedHashMap<String, String> unaccountedForDefaultAnnotations, LinkedHashMap<String, String> unaccountedForOverrideAnnotations, Set<String> excludedOutputFields, String toolVersion) {
        this(outputFilePath, unaccountedForDefaultAnnotations, unaccountedForOverrideAnnotations, excludedOutputFields, toolVersion, 150);
    }

    public GeneListOutputRenderer(Path outputFilePath, LinkedHashMap<String, String> unaccountedForDefaultAnnotations, LinkedHashMap<String, String> unaccountedForOverrideAnnotations, Set<String> excludedOutputFields, String toolVersion, int minNumBasesForValidSegment) {
        super(toolVersion);
        Utils.nonNull(unaccountedForDefaultAnnotations);
        Utils.nonNull(unaccountedForOverrideAnnotations);
        Utils.nonNull(excludedOutputFields);
        Utils.nonNull(toolVersion);
        Utils.nonNull(outputFilePath);
        IOUtil.assertFileIsWritable((File)outputFilePath.toFile());
        this.geneExonToVariantFuncotationMap = new TreeMap<Pair<String, String>, Pair<VariantContext, FuncotationMap>>(new PairedSimpleNaturalComparator());
        this.simpleTsvOutputRenderer = SimpleTsvOutputRenderer.createFromResource(outputFilePath, unaccountedForDefaultAnnotations, unaccountedForOverrideAnnotations, excludedOutputFields, Paths.get(CONFIG_RESOURCE, new String[0]), toolVersion, false);
        this.gencodeGenesFieldPattern = Pattern.compile(GENCODE_GENES_FIELD_PATTERN_STRING);
        this.gencodeStartGeneFieldPattern = Pattern.compile(GENCODE_START_GENE_FIELD_PATTERN_STRING);
        this.gencodeStartExonFieldPattern = Pattern.compile(GENCODE_START_EXON_FIELD_PATTERN_STRING);
        this.gencodeEndGeneFieldPattern = Pattern.compile(GENCODE_END_GENE_FIELD_PATTERN_STRING);
        this.gencodeEndExonFieldPattern = Pattern.compile(GENCODE_END_EXON_FIELD_PATTERN_STRING);
        this.minNumBasesForValidSegment = minNumBasesForValidSegment;
    }

    @Override
    public void close() {
        this.flushAllGenes();
        this.simpleTsvOutputRenderer.close();
    }

    @Override
    public void write(VariantContext variant, FuncotationMap txToFuncotationMap) {
        this.validateAbleToWrite(variant, txToFuncotationMap);
        String genesFieldName = GeneListOutputRenderer.determineGencodeFieldName(txToFuncotationMap, "no_transcript", this.gencodeGenesFieldPattern);
        List<String> genes = Arrays.asList(StringUtils.split((String)txToFuncotationMap.getFieldValue("no_transcript", genesFieldName, txToFuncotationMap.getAlleles("no_transcript").iterator().next()), (String)","));
        String startGene = txToFuncotationMap.getFieldValue("no_transcript", GeneListOutputRenderer.determineGencodeFieldName(txToFuncotationMap, "no_transcript", this.gencodeStartGeneFieldPattern), txToFuncotationMap.getAlleles("no_transcript").iterator().next());
        String startExon = txToFuncotationMap.getFieldValue("no_transcript", GeneListOutputRenderer.determineGencodeFieldName(txToFuncotationMap, "no_transcript", this.gencodeStartExonFieldPattern), txToFuncotationMap.getAlleles("no_transcript").iterator().next());
        String endGene = txToFuncotationMap.getFieldValue("no_transcript", GeneListOutputRenderer.determineGencodeFieldName(txToFuncotationMap, "no_transcript", this.gencodeEndGeneFieldPattern), txToFuncotationMap.getAlleles("no_transcript").iterator().next());
        String endExon = txToFuncotationMap.getFieldValue("no_transcript", GeneListOutputRenderer.determineGencodeFieldName(txToFuncotationMap, "no_transcript", this.gencodeEndExonFieldPattern), txToFuncotationMap.getAlleles("no_transcript").iterator().next());
        Stream.of(Pair.of((Object)startGene, (Object)startExon), Pair.of((Object)endGene, (Object)endExon)).filter(p -> !StringUtils.isEmpty((CharSequence)((CharSequence)p.getLeft()))).forEach(p -> this.geneExonToVariantFuncotationMap.put((Pair<String, String>)p, (Pair<VariantContext, FuncotationMap>)Pair.of((Object)variant, (Object)FuncotationMap.create(txToFuncotationMap))));
        genes.stream().filter(g -> !g.equals(startGene) && !g.equals(endGene)).filter(g -> !StringUtils.isEmpty((CharSequence)g)).forEach(g -> this.geneExonToVariantFuncotationMap.put((Pair<String, String>)Pair.of((Object)g, (Object)""), (Pair<VariantContext, FuncotationMap>)Pair.of((Object)variant, (Object)FuncotationMap.create(txToFuncotationMap))));
    }

    private void flushAllGenes() {
        for (Pair<String, String> geneExon : this.geneExonToVariantFuncotationMap.keySet()) {
            VariantContext segmentVariantContext = (VariantContext)((Pair)this.geneExonToVariantFuncotationMap.get(geneExon)).getLeft();
            FuncotationMap funcotationMap = (FuncotationMap)((Pair)this.geneExonToVariantFuncotationMap.get(geneExon)).getRight();
            Allele altAllele = funcotationMap.get("no_transcript").get(0).getAltAllele();
            Funcotation newFuncotation = this.createGeneExonFuncotation((String)geneExon.getLeft(), (String)geneExon.getRight(), altAllele);
            funcotationMap.add("no_transcript", newFuncotation);
            this.simpleTsvOutputRenderer.write(segmentVariantContext, funcotationMap);
        }
    }

    private Funcotation createGeneExonFuncotation(String gene, String exon, Allele allele) {
        return TableFuncotation.create(Arrays.asList(GENE_FIELD_NAME, EXON_FIELD_NAME), Arrays.asList(gene, exon), allele, GENE_LIST_OUTPUT_RENDERER_DUMMY_NAME, null);
    }

    private static String determineGencodeFieldName(FuncotationMap funcotationMap, String txId, Pattern pattern) {
        Set<String> allPossibleFields = funcotationMap.getFieldNames(txId);
        List matches = allPossibleFields.stream().map(pattern::matcher).filter(Matcher::matches).map(Matcher::group).collect(Collectors.toList());
        if (matches.size() != 1) {
            throw new UserException.BadInput("Could not find exactly one gencode field match in the funcotation map: " + matches.stream().collect(Collectors.joining(", ")));
        }
        return (String)matches.get(0);
    }

    @VisibleForTesting
    SortedMap<Pair<String, String>, Pair<VariantContext, FuncotationMap>> getGeneExonToVariantFuncotationMap() {
        return this.geneExonToVariantFuncotationMap;
    }

    @VisibleForTesting
    void validateAbleToWrite(VariantContext variant, FuncotationMap txToFuncotationMap) {
        try {
            Utils.validateArg(FuncotatorUtils.isSegmentVariantContext(variant, this.minNumBasesForValidSegment), "Is the input a file of segment variant contexts?  Variant context does not represent a copy number segment: " + variant);
            Utils.validateArg(txToFuncotationMap.getTranscriptList().size() == 1, "Is the input a file of segment variant contexts?  Need exactly one transcript ID: " + StringUtils.join(txToFuncotationMap.getTranscriptList(), (String)","));
            Utils.validateArg(txToFuncotationMap.getTranscriptList().get(0).equals("no_transcript"), "Is the input a file of segment variant contexts?  Invalid transcript ID seen  (must be no transcript available dummy ID): " + txToFuncotationMap.getTranscriptList().get(0));
            Utils.validateArg(txToFuncotationMap.getAlleles("no_transcript").size() == 1, "Is the input a file of segment variant contexts?  Only one alternate allele per variant context is accepted.");
        }
        catch (IllegalArgumentException iae) {
            throw new UserException.BadInput(iae.getMessage());
        }
    }

    private final class PairedSimpleNaturalComparator<T extends CharSequence, U extends CharSequence>
    implements Comparator<Pair<T, U>> {
        private final Comparator<T> leftComparator = SimpleNaturalComparator.getInstance();
        private final Comparator<U> rightComparator = SimpleNaturalComparator.getInstance();

        PairedSimpleNaturalComparator() {
        }

        @Override
        public int compare(Pair<T, U> o1, Pair<T, U> o2) {
            int compareLeft = this.leftComparator.compare(o1.getLeft(), o2.getLeft());
            if (compareLeft != 0) {
                return compareLeft;
            }
            return this.rightComparator.compare(o1.getRight(), o2.getRight());
        }
    }
}

