/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.mafOutput;

import com.google.common.collect.ImmutableMap;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.TableFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadata;
import org.broadinstitute.hellbender.tools.funcotator.metadata.TumorNormalPair;
import org.broadinstitute.hellbender.tools.funcotator.metadata.VcfFuncotationMetadata;
import org.broadinstitute.hellbender.utils.Utils;

public class CustomMafFuncotationCreator {
    public static final List<String> COUNT_FIELD_NAMES = Arrays.asList("t_alt_count", "t_ref_count", "n_alt_count", "n_ref_count", "tumor_f");
    public static final String MAF_DBSNP_VAL_STATUS_FIELD = "custom_dbsnp_val_status";
    public static final String BY_FREQ = "byFrequency";
    public static final String BY_1KG = "by1000genomes";
    public static final Map<String, String> DBSNP_VALIDATION_VALUE_MAP = ImmutableMap.builder().put((Object)"dbSNP_VLD", (Object)"byFrequency").put((Object)"dbSNP_KGVAL", (Object)"by1000genomes").put((Object)"dbSNP_KGPROD", (Object)"by1000genomes").put((Object)"dbSNP_KGPilot1", (Object)"by1000genomes").put((Object)"dbSNP_KGPilot123", (Object)"by1000genomes").put((Object)"dbSNP_KGPilot3", (Object)"by1000genomes").put((Object)"dbSNP_KGPhase1", (Object)"by1000genomes").put((Object)"dbSNP_KGPhase3", (Object)"by1000genomes").build();
    public static final String MAF_DBSNP_VAL_STATUS_DELIMITER = ";";

    private static List<Funcotation> createCustomMafCountFields(VariantContext variant, TumorNormalPair tnPair) {
        Utils.nonNull(variant);
        Utils.nonNull(tnPair);
        ArrayList<Funcotation> result = new ArrayList<Funcotation>();
        for (int i = 0; i < variant.getAlternateAlleles().size(); ++i) {
            boolean hasTumorAF;
            Allele allele = variant.getAlternateAllele(i);
            String tumorSampleName = tnPair.getTumor();
            String normalSampleName = tnPair.getNormal();
            Genotype tumorGenotype = variant.getGenotype(tumorSampleName);
            boolean hasTumorAD = tumorGenotype != null && tumorGenotype.hasAD();
            boolean bl = hasTumorAF = tumorGenotype != null && tumorGenotype.hasAnyAttribute("AF");
            if (hasTumorAD && tumorGenotype.getAD().length < 2) {
                throw new UserException("Allelic Depth (AD field) for Variant[" + variant.getContig() + ":" + variant.getStart() + "_" + variant.getReference().toString() + "->" + ((Allele)variant.getAlternateAlleles().get(0)).toString() + ']' + " Does not contain both a REF and an ALT value (only one value is present)!");
            }
            String tAltCount = hasTumorAD ? Integer.toString(tumorGenotype.getAD()[i + 1]) : "";
            String tRefCount = hasTumorAD ? Integer.toString(tumorGenotype.getAD()[0]) : "";
            String tumorFAllAlleles = hasTumorAF ? tumorGenotype.getAnyAttribute("AF").toString() : "";
            String tumorF = hasTumorAF ? StringUtils.split((String)tumorFAllAlleles, (String)",")[i] : "";
            Genotype normalGenotype = variant.getGenotype(normalSampleName);
            boolean hasNormalAD = normalGenotype != null && normalGenotype.hasAD();
            String nAltCount = hasNormalAD ? Integer.toString(normalGenotype.getAD()[i + 1]) : "";
            String nRefCount = hasNormalAD ? Integer.toString(normalGenotype.getAD()[0]) : "";
            List<String> fieldValues = Arrays.asList(tAltCount, tRefCount, nAltCount, nRefCount, tumorF);
            result.add(TableFuncotation.create(COUNT_FIELD_NAMES, fieldValues, allele, "MAF_COUNT_OUTPUT", CustomMafFuncotationCreator.createCustomMafCountFieldsMetadata()));
        }
        return result;
    }

    private static FuncotationMetadata createCustomMafCountFieldsMetadata() {
        return VcfFuncotationMetadata.create(Arrays.asList(new VCFInfoHeaderLine(COUNT_FIELD_NAMES.get(0), VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Number of alternate reads in the tumor."), new VCFInfoHeaderLine(COUNT_FIELD_NAMES.get(1), VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Number of reference reads in the tumor."), new VCFInfoHeaderLine(COUNT_FIELD_NAMES.get(2), VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Number of alternate reads in the normal."), new VCFInfoHeaderLine(COUNT_FIELD_NAMES.get(3), VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Number of reference reads in the normal."), new VCFInfoHeaderLine(COUNT_FIELD_NAMES.get(4), VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele fractions of alternate alleles in the tumor.")));
    }

    private static FuncotationMetadata createCustomMafDbSnpFieldsMetadata() {
        return VcfFuncotationMetadata.create(Collections.singletonList(new VCFInfoHeaderLine(MAF_DBSNP_VAL_STATUS_FIELD, VCFHeaderLineCount.A, VCFHeaderLineType.String, "dbSNP Validation status.")));
    }

    public static List<Funcotation> createCustomMafCountFields(VariantContext variant, List<TumorNormalPair> tnPairs) {
        Utils.nonNull(variant);
        Utils.nonNull(tnPairs);
        if (tnPairs.size() == 0) {
            return CustomMafFuncotationCreator.createEmptyCountFields(variant.getAlternateAlleles());
        }
        return CustomMafFuncotationCreator.createCustomMafCountFields(variant, tnPairs.get(0));
    }

    private static List<Funcotation> createEmptyCountFields(List<Allele> alleles) {
        Utils.nonNull(alleles);
        ArrayList<Funcotation> result = new ArrayList<Funcotation>();
        for (Allele allele : alleles) {
            result.add(TableFuncotation.create(COUNT_FIELD_NAMES, Collections.nCopies(COUNT_FIELD_NAMES.size(), ""), allele, "MAF_COUNT_OUTPUT", CustomMafFuncotationCreator.createCustomMafCountFieldsMetadata()));
        }
        return result;
    }

    public static List<Funcotation> createCustomMafDbSnpFields(List<Funcotation> funcotations) {
        Utils.nonNull(funcotations);
        if (funcotations.size() == 0) {
            return Collections.emptyList();
        }
        List sourceDbSnpFuncotationsToGenerate = funcotations.stream().filter(f -> f.getDataSourceName().startsWith("dbSNP")).collect(Collectors.toList());
        return sourceDbSnpFuncotationsToGenerate.stream().map(CustomMafFuncotationCreator::createDbSnpCustomFuncotation).collect(Collectors.toList());
    }

    private static Funcotation createDbSnpCustomFuncotation(Funcotation dbSnpFuncotation) {
        return TableFuncotation.create(Collections.singletonList(MAF_DBSNP_VAL_STATUS_FIELD), Collections.singletonList(DBSNP_VALIDATION_VALUE_MAP.entrySet().stream().filter(e -> dbSnpFuncotation.getFieldOrDefault((String)e.getKey(), "").toLowerCase().contains("true")).map(e -> DBSNP_VALIDATION_VALUE_MAP.getOrDefault(e.getKey(), "")).distinct().collect(Collectors.joining(MAF_DBSNP_VAL_STATUS_DELIMITER))), dbSnpFuncotation.getAltAllele(), "MAF_DBSNP_OUTPUT", CustomMafFuncotationCreator.createCustomMafDbSnpFieldsMetadata());
    }
}

