/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.mafOutput;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.funcotator.DataSourceFuncotationFactory;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.OutputRenderer;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.mafOutput.CustomMafFuncotationCreator;
import org.broadinstitute.hellbender.tools.funcotator.mafOutput.MafOutputRendererConstants;
import org.broadinstitute.hellbender.tools.funcotator.metadata.SamplePairExtractor;
import org.broadinstitute.hellbender.tools.funcotator.metadata.TumorNormalPair;
import org.broadinstitute.hellbender.utils.Utils;

public class MafOutputRenderer
extends OutputRenderer {
    public static String VERSION = "2.4";
    private static final Logger logger = LogManager.getLogger(MafOutputRenderer.class);
    private static final Set<String> HG_19_CHR_SET = new HashSet<String>(Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "X", "Y"));
    private static final List<String> ORDERED_GENCODE_VARIANT_CLASSIFICATIONS = new ArrayList<String>(Arrays.asList(GencodeFuncotation.VariantClassification.IN_FRAME_DEL.toString(), GencodeFuncotation.VariantClassification.IN_FRAME_INS.toString(), GencodeFuncotation.VariantClassification.FRAME_SHIFT_INS.toString(), GencodeFuncotation.VariantClassification.FRAME_SHIFT_DEL.toString(), GencodeFuncotation.VariantClassification.MISSENSE.toString(), GencodeFuncotation.VariantClassification.NONSENSE.toString(), GencodeFuncotation.VariantClassification.SILENT.toString(), GencodeFuncotation.VariantClassification.SPLICE_SITE.toString(), GencodeFuncotation.VariantClassification.DE_NOVO_START_IN_FRAME.toString(), GencodeFuncotation.VariantClassification.DE_NOVO_START_OUT_FRAME.toString(), GencodeFuncotation.VariantClassification.START_CODON_SNP.toString(), GencodeFuncotation.VariantClassification.START_CODON_INS.toString(), GencodeFuncotation.VariantClassification.START_CODON_DEL.toString(), GencodeFuncotation.VariantClassification.NONSTOP.toString(), GencodeFuncotation.VariantClassification.FIVE_PRIME_UTR.toString(), GencodeFuncotation.VariantClassification.THREE_PRIME_UTR.toString(), GencodeFuncotation.VariantClassification.FIVE_PRIME_FLANK.toString(), GencodeFuncotation.VariantClassification.INTRON.toString(), GencodeFuncotation.VariantClassification.LINCRNA.toString()));
    private static final List<String> ORDERED_MAF_VARIANT_CLASSIFICATIONS = new ArrayList<String>(Arrays.asList(MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.IN_FRAME_DEL.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.IN_FRAME_INS.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.FRAME_SHIFT_INS.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.FRAME_SHIFT_DEL.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.MISSENSE.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.NONSENSE.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.SILENT.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.SPLICE_SITE.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.DE_NOVO_START_IN_FRAME.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.DE_NOVO_START_OUT_FRAME.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.START_CODON_SNP.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.START_CODON_INS.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.START_CODON_DEL.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.NONSTOP.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.FIVE_PRIME_UTR.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.THREE_PRIME_UTR.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.FIVE_PRIME_FLANK.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.INTRON.toString()), MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.LINCRNA.toString())));
    private final LinkedHashMap<String, String> defaultMap = new LinkedHashMap();
    private final Map<String, List<String>> outputFieldNameMap = new LinkedHashMap<String, List<String>>();
    private boolean hasWrittenHeader = false;
    private final Path outputFilePath;
    private Writer writer;
    private final LinkedHashSet<String> toolHeaderLines;
    private final VCFHeader inputFileHeader;
    private final LinkedHashMap<String, String> overrideAnnotations;
    private final List<TumorNormalPair> tnPairs;
    private final String referenceVersion;
    private final Set<String> excludedOutputFields;

    public MafOutputRenderer(Path outputFilePath, List<DataSourceFuncotationFactory> dataSources, VCFHeader inputFileHeader, LinkedHashMap<String, String> unaccountedForDefaultAnnotations, LinkedHashMap<String, String> unaccountedForOverrideAnnotations, Set<String> toolHeaderLines, String referenceVersion, Set<String> excludedOutputFields, String toolVersion) {
        super(toolVersion);
        Utils.nonNull(outputFilePath);
        Utils.nonNull(dataSources);
        Utils.nonNull(inputFileHeader);
        Utils.nonNull(unaccountedForDefaultAnnotations);
        Utils.nonNull(unaccountedForOverrideAnnotations);
        Utils.nonNull(toolHeaderLines);
        Utils.nonNull(referenceVersion);
        Utils.nonNull(excludedOutputFields);
        this.outputFilePath = outputFilePath;
        this.toolHeaderLines = new LinkedHashSet<String>(toolHeaderLines);
        this.inputFileHeader = inputFileHeader;
        this.dataSourceFactories = dataSources;
        this.referenceVersion = referenceVersion;
        this.tnPairs = SamplePairExtractor.extractPossibleTumorNormalPairs(this.inputFileHeader);
        if (this.tnPairs.size() == 0) {
            logger.warn("No tumor/normal pairs were seen, cannot populate the some of the MAF fields (e.g. t_alt_count).  Please add '##tumor_sample=<tumor_sample_name>' and (if applicable) '##normal_sample=<normal_sample_name>' to the input VCF header");
        }
        if (this.tnPairs.size() > 1) {
            throw new UserException.BadInput("Input files with more than one tumor normal pair are currently not supported.  Found: " + this.tnPairs.stream().map(tn -> tn.toString()).collect(Collectors.joining("; ")));
        }
        this.manualAnnotations = new LinkedHashMap();
        this.manualAnnotations.putAll(unaccountedForDefaultAnnotations);
        this.overrideAnnotations = unaccountedForOverrideAnnotations;
        this.initializeDefaultMapWithKeys();
        this.initializeOutputFieldNameMap();
        for (DataSourceFuncotationFactory funcotationFactory : this.dataSourceFactories) {
            for (String field : funcotationFactory.getSupportedFuncotationFields()) {
                if (this.defaultMap.containsKey(field)) continue;
                boolean found = false;
                for (Map.Entry<String, List<String>> entry : this.outputFieldNameMap.entrySet()) {
                    if (!entry.getValue().contains(field)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.defaultMap.put(field, "__UNKNOWN__");
            }
        }
        Iterator it = this.manualAnnotations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry manualAnnotation = it.next();
            if (this.defaultMap.containsKey(manualAnnotation.getKey())) {
                this.defaultMap.put((String)manualAnnotation.getKey(), (String)manualAnnotation.getValue());
                it.remove();
                continue;
            }
            boolean isAliasedName = false;
            for (Map.Entry<String, List<String>> entry : this.outputFieldNameMap.entrySet()) {
                if (!entry.getValue().contains(manualAnnotation.getKey())) continue;
                isAliasedName = true;
                this.defaultMap.put(entry.getKey(), (String)manualAnnotation.getValue());
            }
            if (!isAliasedName) continue;
            it.remove();
        }
        this.defaultMap.put("Score", "NA");
        this.defaultMap.put("BAM_File", "NA");
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(outputFilePath, new OpenOption[0])));
        }
        catch (IOException ex) {
            throw new UserException("Error opening output file path: " + outputFilePath.toUri().toString(), ex);
        }
        this.excludedOutputFields = excludedOutputFields;
    }

    @Override
    public void close() {
        if (!this.hasWrittenHeader) {
            String dummyAltAllele = "AT";
            LinkedHashMap<String, String> dummyMafCompliantOutputMap = this.createMafCompliantOutputMap(Allele.create((String)"AT"), Collections.emptyList());
            this.writeHeader(new ArrayList<String>(dummyMafCompliantOutputMap.keySet()));
        }
        if (this.writer != null) {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException e) {
                throw new UserException.CouldNotCreateOutputFile("Failed while closing the maf writer, the output may be corrupted.", (Exception)e);
            }
        }
    }

    @Override
    public void write(VariantContext variant, FuncotationMap txToFuncotationMap) {
        if (txToFuncotationMap.getTranscriptList().size() > 1) {
            logger.warn("MAF typically does not support multiple transcripts per variant, though this should be able to render (grouped by transcript).  No user action needed.");
        }
        List<Funcotation> customMafCountFuncotations = CustomMafFuncotationCreator.createCustomMafCountFields(variant, this.tnPairs);
        txToFuncotationMap.getTranscriptList().forEach(txId -> txToFuncotationMap.add((String)txId, customMafCountFuncotations));
        for (String txId2 : txToFuncotationMap.getTranscriptList()) {
            List<Funcotation> customDbSnpFuncotations = CustomMafFuncotationCreator.createCustomMafDbSnpFields(txToFuncotationMap.get(txId2));
            if (customDbSnpFuncotations.size() == 0) {
                logger.warn("No dbSNP annotations exist for this variant.  Cannot render the dbSNP fields in the MAF.  These fields will not be correct.  " + variant);
                continue;
            }
            txToFuncotationMap.add(txId2, customDbSnpFuncotations);
        }
        for (Allele altAllele : variant.getAlternateAlleles()) {
            if (altAllele.equals((Object)Allele.SPAN_DEL)) continue;
            for (String txId3 : txToFuncotationMap.getTranscriptList()) {
                List<Funcotation> funcotations = txToFuncotationMap.get(txId3);
                LinkedHashMap<String, String> mafCompliantOutputMap = this.createMafCompliantOutputMap(altAllele, funcotations);
                if (!this.hasWrittenHeader) {
                    this.writeHeader(new ArrayList<String>(mafCompliantOutputMap.keySet()));
                }
                try {
                    Iterator<Map.Entry<String, String>> entryIterator = mafCompliantOutputMap.entrySet().iterator();
                    Map.Entry<String, String> entry = entryIterator.next();
                    this.writeString(entry.getValue());
                    while (entryIterator.hasNext()) {
                        entry = entryIterator.next();
                        this.writeString("\t");
                        this.writeString(entry.getValue());
                    }
                    this.writeLine("");
                }
                catch (IOException e) {
                    throw new UserException.CouldNotCreateOutputFile("Error while writing maf file, cause by: " + e.getMessage(), (Exception)e);
                }
            }
        }
    }

    @VisibleForTesting
    LinkedHashMap<String, String> createMafCompliantOutputMap(Allele altAllele, List<Funcotation> funcotations) {
        LinkedHashMap<String, Object> outputMap = new LinkedHashMap<String, Object>(this.defaultMap);
        LinkedHashMap<String, Object> extraFieldOutputMap = new LinkedHashMap<String, Object>();
        for (Funcotation funcotation : funcotations) {
            if (!funcotation.getAltAllele().equals((Object)altAllele)) continue;
            for (String field : funcotation.getFieldNames()) {
                this.setField(extraFieldOutputMap, field, funcotation.getField(field));
            }
        }
        extraFieldOutputMap.putAll(this.overrideAnnotations);
        block2: for (Map.Entry entry : this.outputFieldNameMap.entrySet()) {
            for (String fieldName : (List)entry.getValue()) {
                if (!extraFieldOutputMap.containsKey(fieldName)) continue;
                outputMap.put((String)entry.getKey(), extraFieldOutputMap.remove(fieldName));
                continue block2;
            }
        }
        outputMap.putAll(extraFieldOutputMap);
        LinkedHashMap<String, String> mafCompliantMap = this.replaceFuncotationValuesWithMafCompliantValues(outputMap);
        return mafCompliantMap.keySet().stream().filter(k -> !this.excludedOutputFields.contains(k)).collect(Collectors.toMap(Function.identity(), k -> FuncotatorUtils.sanitizeFuncotationFieldForMaf((String)mafCompliantMap.get(k)), (u, v) -> {
            throw new GATKException.ShouldNeverReachHereException("Found duplicate keys for MAF output");
        }, LinkedHashMap::new));
    }

    @VisibleForTesting
    LinkedHashMap<String, String> getDefaultMap() {
        return this.defaultMap;
    }

    @VisibleForTesting
    LinkedHashMap<String, String> replaceFuncotationValuesWithMafCompliantValues(Map<String, Object> outputMap) {
        LinkedHashMap<String, String> finalOutMap = new LinkedHashMap<String, String>(outputMap.size());
        for (String key : outputMap.keySet()) {
            finalOutMap.put(key, MafOutputRenderer.mafTransform(key, outputMap.get(key).toString(), this.referenceVersion));
        }
        if (finalOutMap.containsKey("Other_Transcripts")) {
            finalOutMap.put("Other_Transcripts", finalOutMap.get("Other_Transcripts").replaceAll("/", "|"));
        }
        this.adjustIndelAlleleInformationForMafOutput(finalOutMap);
        return finalOutMap;
    }

    @VisibleForTesting
    void adjustIndelAlleleInformationForMafOutput(LinkedHashMap<String, String> outputMap) {
        if (outputMap.containsKey("Variant_Type") && (outputMap.get("Variant_Type").equals("INS") || outputMap.get("Variant_Type").equals("DEL"))) {
            int altAlleleLength;
            int refAlleleLength = outputMap.get("Reference_Allele").length();
            if (refAlleleLength < (altAlleleLength = outputMap.get("Tumor_Seq_Allele2").length())) {
                outputMap.put("Tumor_Seq_Allele2", outputMap.get("Tumor_Seq_Allele2").substring(refAlleleLength));
                outputMap.put("Reference_Allele", "-");
                outputMap.put("Tumor_Seq_Allele1", "-");
                outputMap.put("End_Position", String.valueOf(Integer.valueOf(outputMap.get("Start_Position")) + 1));
            } else if (refAlleleLength > altAlleleLength) {
                outputMap.put("Reference_Allele", outputMap.get("Reference_Allele").substring(altAlleleLength));
                outputMap.put("Tumor_Seq_Allele1", outputMap.get("Tumor_Seq_Allele1").substring(altAlleleLength));
                outputMap.put("Tumor_Seq_Allele2", "-");
                outputMap.put("Start_Position", String.valueOf(Integer.valueOf(outputMap.get("Start_Position")) + 1));
                outputMap.put("End_Position", String.valueOf(Integer.valueOf(outputMap.get("Start_Position")) + refAlleleLength - 2));
            }
        }
    }

    public static String mafTransform(String key, String value, String referenceVersion) {
        switch (key) {
            case "Variant_Classification": {
                if (!MafOutputRendererConstants.VariantClassificationMap.containsKey(value)) break;
                return MafOutputRendererConstants.VariantClassificationMap.get(value);
            }
            case "Chromosome": {
                String trimVal;
                if (value.equals("chrM")) {
                    return "MT";
                }
                if (!value.toLowerCase().startsWith("chr") || !referenceVersion.toLowerCase().equals("hg19") && !referenceVersion.toLowerCase().equals("b37") || !HG_19_CHR_SET.contains(trimVal = value.substring(3))) break;
                return trimVal;
            }
            case "Other_Transcripts": {
                return StringUtils.replaceEachRepeatedly((String)value, (String[])ORDERED_GENCODE_VARIANT_CLASSIFICATIONS.toArray(new String[0]), (String[])ORDERED_MAF_VARIANT_CLASSIFICATIONS.toArray(new String[0]));
            }
        }
        return value;
    }

    public static String mafTransformInvert(String key, String value, String referenceVersion) {
        switch (key) {
            case "Variant_Classification": {
                if (!MafOutputRendererConstants.VariantClassificationMapInverse.containsKey(value)) break;
                return MafOutputRendererConstants.VariantClassificationMapInverse.get(value);
            }
            case "Chromosome": {
                if (value.equals("MT")) {
                    return "chrM";
                }
                if (!referenceVersion.toLowerCase().equals("hg19") && !referenceVersion.toLowerCase().equals("b37") || value.length() > 2 || !HG_19_CHR_SET.contains(value)) break;
                return "chr" + value;
            }
            case "Other_Transcripts": {
                String replacement = StringUtils.replaceEachRepeatedly((String)value, (String[])ORDERED_MAF_VARIANT_CLASSIFICATIONS.subList(0, ORDERED_MAF_VARIANT_CLASSIFICATIONS.size() - 1).toArray(new String[0]), (String[])ORDERED_GENCODE_VARIANT_CLASSIFICATIONS.subList(0, ORDERED_MAF_VARIANT_CLASSIFICATIONS.size() - 1).toArray(new String[0]));
                String needle = MafOutputRendererConstants.VariantClassificationMap.get(GencodeFuncotation.VariantClassification.LINCRNA.toString());
                int indx = replacement.indexOf(needle);
                while (indx != -1) {
                    if (indx <= 3 || indx > 3 && !replacement.substring(indx - 4, indx).equals("LINC")) {
                        replacement = replacement.substring(0, indx) + GencodeFuncotation.VariantClassification.LINCRNA.toString() + replacement.substring(indx + needle.length());
                        indx += needle.length();
                    } else {
                        ++indx;
                    }
                    indx = replacement.indexOf(needle, indx);
                }
                return replacement;
            }
        }
        return value;
    }

    private void setField(Map<String, Object> outputMap, String key, Object value) {
        Utils.nonNull(outputMap);
        Utils.nonNull(key);
        if (value != null) {
            outputMap.put(key, value);
        } else {
            outputMap.put(key, "__UNKNOWN__");
        }
    }

    private void writeLine(String line) throws IOException {
        this.writeString(line);
        this.writeString(System.lineSeparator());
    }

    private void writeString(String s) throws IOException {
        this.writer.write(s);
    }

    protected void writeHeader(List<String> outputFields) {
        try {
            this.writeLine("#version " + VERSION);
            this.writeLine("##");
            for (VCFHeaderLine vCFHeaderLine : this.inputFileHeader.getMetaDataInInputOrder()) {
                this.writer.write("#");
                this.writer.write("#");
                this.writer.write(" ");
                this.writeLine(vCFHeaderLine.toString());
            }
            for (String string : this.toolHeaderLines) {
                this.writer.write("#");
                this.writer.write("#");
                this.writer.write(" ");
                this.writeLine(string);
            }
            this.writer.write("#");
            this.writer.write("#");
            this.writer.write(" ");
            this.writer.write(" Funcotator ");
            this.writer.write(this.toolVersion);
            this.writer.write(" | Date ");
            this.writer.write(new SimpleDateFormat("yyyymmdd'T'hhmmss").format(new Date()));
            this.writer.write(" | ");
            this.writer.write(this.getDataSourceInfoString());
            this.writeLine("");
            this.writer.write(outputFields.stream().collect(Collectors.joining("\t")));
            if (this.manualAnnotations.size() > 0) {
                this.writeLine("\t" + this.manualAnnotations.keySet().stream().collect(Collectors.joining("\t")));
            } else {
                this.writer.write("\n");
            }
            this.hasWrittenHeader = true;
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile("Exception while writing maf header, caused by " + e.getMessage(), (Exception)e);
        }
    }

    public ImmutableMap<String, Set<String>> getReverseOutputFieldNameMap() {
        return ImmutableMap.copyOf(Utils.getReverseValueToListMap(this.outputFieldNameMap));
    }

    protected void initializeDefaultMapWithKeys() {
        this.defaultMap.put("Hugo_Symbol", "__UNKNOWN__");
        this.defaultMap.put("Entrez_Gene_Id", "__UNKNOWN__");
        this.defaultMap.put("Center", "__UNKNOWN__");
        this.defaultMap.put("NCBI_Build", "__UNKNOWN__");
        this.defaultMap.put("Chromosome", "__UNKNOWN__");
        this.defaultMap.put("Start_Position", "__UNKNOWN__");
        this.defaultMap.put("End_Position", "__UNKNOWN__");
        this.defaultMap.put("Strand", "+");
        this.defaultMap.put("Variant_Classification", "__UNKNOWN__");
        this.defaultMap.put("Variant_Type", "__UNKNOWN__");
        this.defaultMap.put("Reference_Allele", "__UNKNOWN__");
        this.defaultMap.put("Tumor_Seq_Allele1", "__UNKNOWN__");
        this.defaultMap.put("Tumor_Seq_Allele2", "__UNKNOWN__");
        this.defaultMap.put("dbSNP_RS", "__UNKNOWN__");
        this.defaultMap.put("dbSNP_Val_Status", "__UNKNOWN__");
        this.defaultMap.put("Tumor_Sample_Barcode", "__UNKNOWN__");
        this.defaultMap.put("Matched_Norm_Sample_Barcode", "__UNKNOWN__");
        this.defaultMap.put("Match_Norm_Seq_Allele1", "__UNKNOWN__");
        this.defaultMap.put("Match_Norm_Seq_Allele2", "__UNKNOWN__");
        this.defaultMap.put("Tumor_Validation_Allele1", "__UNKNOWN__");
        this.defaultMap.put("Tumor_Validation_Allele2", "__UNKNOWN__");
        this.defaultMap.put("Match_Norm_Validation_Allele1", "__UNKNOWN__");
        this.defaultMap.put("Match_Norm_Validation_Allele2", "__UNKNOWN__");
        this.defaultMap.put("Verification_Status", "__UNKNOWN__");
        this.defaultMap.put("Validation_Status", "__UNKNOWN__");
        this.defaultMap.put("Mutation_Status", "__UNKNOWN__");
        this.defaultMap.put("Sequencing_Phase", "__UNKNOWN__");
        this.defaultMap.put("Sequence_Source", "__UNKNOWN__");
        this.defaultMap.put("Validation_Method", "__UNKNOWN__");
        this.defaultMap.put("Score", "__UNKNOWN__");
        this.defaultMap.put("BAM_File", "__UNKNOWN__");
        this.defaultMap.put("Sequencer", "__UNKNOWN__");
        this.defaultMap.put("Tumor_Sample_UUID", "__UNKNOWN__");
        this.defaultMap.put("Matched_Norm_Sample_UUID", "__UNKNOWN__");
        this.defaultMap.put("Genome_Change", "__UNKNOWN__");
        this.defaultMap.put("Annotation_Transcript", "__UNKNOWN__");
        this.defaultMap.put("Transcript_Strand", "__UNKNOWN__");
        this.defaultMap.put("Transcript_Exon", "__UNKNOWN__");
        this.defaultMap.put("Transcript_Position", "__UNKNOWN__");
        this.defaultMap.put("cDNA_Change", "__UNKNOWN__");
        this.defaultMap.put("Codon_Change", "__UNKNOWN__");
        this.defaultMap.put("Protein_Change", "__UNKNOWN__");
        this.defaultMap.put("Other_Transcripts", "__UNKNOWN__");
        this.defaultMap.put("Refseq_mRNA_Id", "__UNKNOWN__");
        this.defaultMap.put("Refseq_prot_Id", "__UNKNOWN__");
        this.defaultMap.put("SwissProt_acc_Id", "__UNKNOWN__");
        this.defaultMap.put("SwissProt_entry_Id", "__UNKNOWN__");
        this.defaultMap.put("Description", "__UNKNOWN__");
        this.defaultMap.put("UniProt_AApos", "__UNKNOWN__");
        this.defaultMap.put("UniProt_Region", "__UNKNOWN__");
        this.defaultMap.put("UniProt_Site", "__UNKNOWN__");
        this.defaultMap.put("UniProt_Natural_Variations", "__UNKNOWN__");
        this.defaultMap.put("UniProt_Experimental_Info", "__UNKNOWN__");
        this.defaultMap.put("GO_Biological_Process", "__UNKNOWN__");
        this.defaultMap.put("GO_Cellular_Component", "__UNKNOWN__");
        this.defaultMap.put("GO_Molecular_Function", "__UNKNOWN__");
        this.defaultMap.put("COSMIC_overlapping_mutations", "__UNKNOWN__");
        this.defaultMap.put("COSMIC_fusion_genes", "__UNKNOWN__");
        this.defaultMap.put("COSMIC_tissue_types_affected", "__UNKNOWN__");
        this.defaultMap.put("COSMIC_total_alterations_in_gene", "__UNKNOWN__");
        this.defaultMap.put("Tumorscape_Amplification_Peaks", "__UNKNOWN__");
        this.defaultMap.put("Tumorscape_Deletion_Peaks", "__UNKNOWN__");
        this.defaultMap.put("TCGAscape_Amplification_Peaks", "__UNKNOWN__");
        this.defaultMap.put("TCGAscape_Deletion_Peaks", "__UNKNOWN__");
        this.defaultMap.put("DrugBank", "__UNKNOWN__");
        this.defaultMap.put("ref_context", "__UNKNOWN__");
        this.defaultMap.put("gc_content", "__UNKNOWN__");
        this.defaultMap.put("CCLE_ONCOMAP_overlapping_mutations", "__UNKNOWN__");
        this.defaultMap.put("CCLE_ONCOMAP_total_mutations_in_gene", "__UNKNOWN__");
        this.defaultMap.put("CGC_Mutation_Type", "__UNKNOWN__");
        this.defaultMap.put("CGC_Translocation_Partner", "__UNKNOWN__");
        this.defaultMap.put("CGC_Tumor_Types_Somatic", "__UNKNOWN__");
        this.defaultMap.put("CGC_Tumor_Types_Germline", "__UNKNOWN__");
        this.defaultMap.put("CGC_Other_Diseases", "__UNKNOWN__");
        this.defaultMap.put("DNARepairGenes_Activity_linked_to_OMIM", "__UNKNOWN__");
        this.defaultMap.put("FamilialCancerDatabase_Syndromes", "__UNKNOWN__");
        this.defaultMap.put("MUTSIG_Published_Results", "__UNKNOWN__");
        this.defaultMap.put("OREGANNO_ID", "__UNKNOWN__");
        this.defaultMap.put("OREGANNO_Values", "__UNKNOWN__");
        this.defaultMap.put("tumor_f", "__UNKNOWN__");
        this.defaultMap.put("t_alt_count", "__UNKNOWN__");
        this.defaultMap.put("t_ref_count", "__UNKNOWN__");
        this.defaultMap.put("n_alt_count", "__UNKNOWN__");
        this.defaultMap.put("n_ref_count", "__UNKNOWN__");
    }

    private void initializeOutputFieldNameMap() {
        this.outputFieldNameMap.put("Hugo_Symbol", MafOutputRendererConstants.OutputFieldNameMap_Hugo_Symbol);
        this.outputFieldNameMap.put("Entrez_Gene_Id", MafOutputRendererConstants.OutputFieldNameMap_Entrez_Gene_Id);
        this.outputFieldNameMap.put("Center", MafOutputRendererConstants.OutputFieldNameMap_Center);
        this.outputFieldNameMap.put("NCBI_Build", MafOutputRendererConstants.OutputFieldNameMap_NCBI_Build);
        this.outputFieldNameMap.put("Chromosome", MafOutputRendererConstants.OutputFieldNameMap_Chromosome);
        this.outputFieldNameMap.put("Start_Position", MafOutputRendererConstants.OutputFieldNameMap_Start_Position);
        this.outputFieldNameMap.put("End_Position", MafOutputRendererConstants.OutputFieldNameMap_End_Position);
        this.outputFieldNameMap.put("Strand", MafOutputRendererConstants.OutputFieldNameMap_Strand);
        this.outputFieldNameMap.put("Variant_Classification", MafOutputRendererConstants.OutputFieldNameMap_Variant_Classification);
        this.outputFieldNameMap.put("Variant_Type", MafOutputRendererConstants.OutputFieldNameMap_Variant_Type);
        this.outputFieldNameMap.put("Reference_Allele", MafOutputRendererConstants.OutputFieldNameMap_Reference_Allele);
        this.outputFieldNameMap.put("Tumor_Seq_Allele1", MafOutputRendererConstants.OutputFieldNameMap_Tumor_Seq_Allele1);
        this.outputFieldNameMap.put("Tumor_Seq_Allele2", MafOutputRendererConstants.OutputFieldNameMap_Tumor_Seq_Allele2);
        this.outputFieldNameMap.put("dbSNP_RS", MafOutputRendererConstants.OutputFieldNameMap_dbSNP_RS);
        this.outputFieldNameMap.put("dbSNP_Val_Status", MafOutputRendererConstants.OutputFieldNameMap_dbSNP_Val_Status);
        this.outputFieldNameMap.put("Tumor_Sample_Barcode", MafOutputRendererConstants.OutputFieldNameMap_Tumor_Sample_Barcode);
        this.outputFieldNameMap.put("Matched_Norm_Sample_Barcode", MafOutputRendererConstants.OutputFieldNameMap_Matched_Norm_Sample_Barcode);
        this.outputFieldNameMap.put("Match_Norm_Seq_Allele1", MafOutputRendererConstants.OutputFieldNameMap_Match_Norm_Seq_Allele1);
        this.outputFieldNameMap.put("Match_Norm_Seq_Allele2", MafOutputRendererConstants.OutputFieldNameMap_Match_Norm_Seq_Allele2);
        this.outputFieldNameMap.put("Tumor_Validation_Allele1", MafOutputRendererConstants.OutputFieldNameMap_Tumor_Validation_Allele1);
        this.outputFieldNameMap.put("Tumor_Validation_Allele2", MafOutputRendererConstants.OutputFieldNameMap_Tumor_Validation_Allele2);
        this.outputFieldNameMap.put("Match_Norm_Validation_Allele1", MafOutputRendererConstants.OutputFieldNameMap_Match_Norm_Validation_Allele1);
        this.outputFieldNameMap.put("Match_Norm_Validation_Allele2", MafOutputRendererConstants.OutputFieldNameMap_Match_Norm_Validation_Allele2);
        this.outputFieldNameMap.put("Verification_Status", MafOutputRendererConstants.OutputFieldNameMap_Verification_Status);
        this.outputFieldNameMap.put("Validation_Status", MafOutputRendererConstants.OutputFieldNameMap_Validation_Status);
        this.outputFieldNameMap.put("Mutation_Status", MafOutputRendererConstants.OutputFieldNameMap_Mutation_Status);
        this.outputFieldNameMap.put("Sequencing_Phase", MafOutputRendererConstants.OutputFieldNameMap_Sequencing_Phase);
        this.outputFieldNameMap.put("Sequence_Source", MafOutputRendererConstants.OutputFieldNameMap_Sequence_Source);
        this.outputFieldNameMap.put("Validation_Method", MafOutputRendererConstants.OutputFieldNameMap_Validation_Method);
        this.outputFieldNameMap.put("Score", MafOutputRendererConstants.OutputFieldNameMap_Score);
        this.outputFieldNameMap.put("BAM_File", MafOutputRendererConstants.OutputFieldNameMap_BAM_File);
        this.outputFieldNameMap.put("Sequencer", MafOutputRendererConstants.OutputFieldNameMap_Sequencer);
        this.outputFieldNameMap.put("Tumor_Sample_UUID", MafOutputRendererConstants.OutputFieldNameMap_Tumor_Sample_UUID);
        this.outputFieldNameMap.put("Matched_Norm_Sample_UUID", MafOutputRendererConstants.OutputFieldNameMap_Matched_Norm_Sample_UUID);
        this.outputFieldNameMap.put("Genome_Change", MafOutputRendererConstants.OutputFieldNameMap_Genome_Change);
        this.outputFieldNameMap.put("Annotation_Transcript", MafOutputRendererConstants.OutputFieldNameMap_Annotation_Transcript);
        this.outputFieldNameMap.put("Transcript_Strand", MafOutputRendererConstants.OutputFieldNameMap_Transcript_Strand);
        this.outputFieldNameMap.put("Transcript_Exon", MafOutputRendererConstants.OutputFieldNameMap_Transcript_Exon);
        this.outputFieldNameMap.put("Transcript_Position", MafOutputRendererConstants.OutputFieldNameMap_Transcript_Position);
        this.outputFieldNameMap.put("cDNA_Change", MafOutputRendererConstants.OutputFieldNameMap_cDNA_Change);
        this.outputFieldNameMap.put("Codon_Change", MafOutputRendererConstants.OutputFieldNameMap_Codon_Change);
        this.outputFieldNameMap.put("Protein_Change", MafOutputRendererConstants.OutputFieldNameMap_Protein_Change);
        this.outputFieldNameMap.put("Other_Transcripts", MafOutputRendererConstants.OutputFieldNameMap_Other_Transcripts);
        this.outputFieldNameMap.put("Refseq_mRNA_Id", MafOutputRendererConstants.OutputFieldNameMap_Refseq_mRNA_Id);
        this.outputFieldNameMap.put("Refseq_prot_Id", MafOutputRendererConstants.OutputFieldNameMap_Refseq_prot_Id);
        this.outputFieldNameMap.put("SwissProt_acc_Id", MafOutputRendererConstants.OutputFieldNameMap_SwissProt_acc_Id);
        this.outputFieldNameMap.put("SwissProt_entry_Id", MafOutputRendererConstants.OutputFieldNameMap_SwissProt_entry_Id);
        this.outputFieldNameMap.put("Description", MafOutputRendererConstants.OutputFieldNameMap_Description);
        this.outputFieldNameMap.put("UniProt_AApos", MafOutputRendererConstants.OutputFieldNameMap_UniProt_AApos);
        this.outputFieldNameMap.put("UniProt_Region", MafOutputRendererConstants.OutputFieldNameMap_UniProt_Region);
        this.outputFieldNameMap.put("UniProt_Site", MafOutputRendererConstants.OutputFieldNameMap_UniProt_Site);
        this.outputFieldNameMap.put("UniProt_Natural_Variations", MafOutputRendererConstants.OutputFieldNameMap_UniProt_Natural_Variations);
        this.outputFieldNameMap.put("UniProt_Experimental_Info", MafOutputRendererConstants.OutputFieldNameMap_UniProt_Experimental_Info);
        this.outputFieldNameMap.put("GO_Biological_Process", MafOutputRendererConstants.OutputFieldNameMap_GO_Biological_Process);
        this.outputFieldNameMap.put("GO_Cellular_Component", MafOutputRendererConstants.OutputFieldNameMap_GO_Cellular_Component);
        this.outputFieldNameMap.put("GO_Molecular_Function", MafOutputRendererConstants.OutputFieldNameMap_GO_Molecular_Function);
        this.outputFieldNameMap.put("COSMIC_overlapping_mutations", MafOutputRendererConstants.OutputFieldNameMap_COSMIC_overlapping_mutations);
        this.outputFieldNameMap.put("COSMIC_fusion_genes", MafOutputRendererConstants.OutputFieldNameMap_COSMIC_fusion_genes);
        this.outputFieldNameMap.put("COSMIC_tissue_types_affected", MafOutputRendererConstants.OutputFieldNameMap_COSMIC_tissue_types_affected);
        this.outputFieldNameMap.put("COSMIC_total_alterations_in_gene", MafOutputRendererConstants.OutputFieldNameMap_COSMIC_total_alterations_in_gene);
        this.outputFieldNameMap.put("Tumorscape_Amplification_Peaks", MafOutputRendererConstants.OutputFieldNameMap_Tumorscape_Amplification_Peaks);
        this.outputFieldNameMap.put("Tumorscape_Deletion_Peaks", MafOutputRendererConstants.OutputFieldNameMap_Tumorscape_Deletion_Peaks);
        this.outputFieldNameMap.put("TCGAscape_Amplification_Peaks", MafOutputRendererConstants.OutputFieldNameMap_TCGAscape_Amplification_Peaks);
        this.outputFieldNameMap.put("TCGAscape_Deletion_Peaks", MafOutputRendererConstants.OutputFieldNameMap_TCGAscape_Deletion_Peaks);
        this.outputFieldNameMap.put("DrugBank", MafOutputRendererConstants.OutputFieldNameMap_DrugBank);
        this.outputFieldNameMap.put("ref_context", MafOutputRendererConstants.OutputFieldNameMap_ref_context);
        this.outputFieldNameMap.put("gc_content", MafOutputRendererConstants.OutputFieldNameMap_gc_content);
        this.outputFieldNameMap.put("CCLE_ONCOMAP_overlapping_mutations", MafOutputRendererConstants.OutputFieldNameMap_CCLE_ONCOMAP_overlapping_mutations);
        this.outputFieldNameMap.put("CCLE_ONCOMAP_total_mutations_in_gene", MafOutputRendererConstants.OutputFieldNameMap_CCLE_ONCOMAP_total_mutations_in_gene);
        this.outputFieldNameMap.put("CGC_Mutation_Type", MafOutputRendererConstants.OutputFieldNameMap_CGC_Mutation_Type);
        this.outputFieldNameMap.put("CGC_Translocation_Partner", MafOutputRendererConstants.OutputFieldNameMap_CGC_Translocation_Partner);
        this.outputFieldNameMap.put("CGC_Tumor_Types_Somatic", MafOutputRendererConstants.OutputFieldNameMap_CGC_Tumor_Types_Somatic);
        this.outputFieldNameMap.put("CGC_Tumor_Types_Germline", MafOutputRendererConstants.OutputFieldNameMap_CGC_Tumor_Types_Germline);
        this.outputFieldNameMap.put("CGC_Other_Diseases", MafOutputRendererConstants.OutputFieldNameMap_CGC_Other_Diseases);
        this.outputFieldNameMap.put("DNARepairGenes_Activity_linked_to_OMIM", MafOutputRendererConstants.OutputFieldNameMap_DNARepairGenes_Activity_linked_to_OMIM);
        this.outputFieldNameMap.put("FamilialCancerDatabase_Syndromes", MafOutputRendererConstants.OutputFieldNameMap_FamilialCancerDatabase_Syndromes);
        this.outputFieldNameMap.put("MUTSIG_Published_Results", MafOutputRendererConstants.OutputFieldNameMap_MUTSIG_Published_Results);
        this.outputFieldNameMap.put("OREGANNO_ID", MafOutputRendererConstants.OutputFieldNameMap_OREGANNO_ID);
        this.outputFieldNameMap.put("OREGANNO_Values", MafOutputRendererConstants.OutputFieldNameMap_OREGANNO_Values);
        this.outputFieldNameMap.put("tumor_f", MafOutputRendererConstants.OutputFieldNameMap_tumor_f);
        this.outputFieldNameMap.put("t_alt_count", MafOutputRendererConstants.OutputFieldNameMap_t_alt_count);
        this.outputFieldNameMap.put("t_ref_count", MafOutputRendererConstants.OutputFieldNameMap_t_ref_count);
        this.outputFieldNameMap.put("n_alt_count", MafOutputRendererConstants.OutputFieldNameMap_n_alt_count);
        this.outputFieldNameMap.put("n_ref_count", MafOutputRendererConstants.OutputFieldNameMap_n_ref_count);
    }
}

