/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.metadata;

import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.funcotator.metadata.TumorNormalPair;
import org.broadinstitute.hellbender.utils.Utils;

public class SamplePairExtractor {
    public static List<String> TUMOR_SAMPLE_NAME_LIST = Arrays.asList("TUMOR", "CASE", "MET");
    public static List<String> NORMAL_SAMPLE_NAME_LIST = Arrays.asList("NORMAL", "CONTROL");
    public static String NO_NORMAL = "";

    private SamplePairExtractor() {
    }

    public static List<TumorNormalPair> extractPossibleTumorNormalPairs(VCFHeader vcfHeader) {
        Utils.nonNull(vcfHeader);
        if (vcfHeader.getMetaDataLine("tumor_sample") != null) {
            VCFHeaderLine normalMetaDataLine = vcfHeader.getMetaDataLine("normal_sample");
            return Collections.singletonList(new TumorNormalPair(vcfHeader.getMetaDataLine("tumor_sample").getValue(), normalMetaDataLine == null ? NO_NORMAL : normalMetaDataLine.getValue()));
        }
        ArrayList sampleNames = vcfHeader.getSampleNamesInOrder();
        if (sampleNames.size() == 1) {
            return Collections.singletonList(new TumorNormalPair((String)sampleNames.get(0), NO_NORMAL));
        }
        if (sampleNames.size() > 0) {
            List tumorSamples = sampleNames.stream().filter(s -> TUMOR_SAMPLE_NAME_LIST.contains(s)).collect(Collectors.toList());
            List normalSamples = sampleNames.stream().filter(s -> NORMAL_SAMPLE_NAME_LIST.contains(s)).collect(Collectors.toList());
            return tumorSamples.stream().flatMap(t -> normalSamples.stream().map(n -> new TumorNormalPair((String)t, (String)n))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

