/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.metadata;

import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.utils.Utils;
import org.broadinstitute.hellbender.tools.funcotator.metadata.FuncotationMetadata;

public class VcfFuncotationMetadata
implements FuncotationMetadata {
    private LinkedHashMap<String, VCFInfoHeaderLine> fieldNameToHeaderLineMap;

    private VcfFuncotationMetadata(LinkedHashMap<String, VCFInfoHeaderLine> fieldNameToHeaderLineMap) {
        this.fieldNameToHeaderLineMap = fieldNameToHeaderLineMap;
    }

    public static VcfFuncotationMetadata create(List<VCFInfoHeaderLine> vcfInfoHeaderLines) {
        Utils.nonNull(vcfInfoHeaderLines);
        return new VcfFuncotationMetadata(vcfInfoHeaderLines.stream().collect(Collectors.toMap(v -> v.getID(), Function.identity(), (x1, x2) -> x2, LinkedHashMap::new)));
    }

    @Override
    public VCFInfoHeaderLine retrieveHeaderInfo(String fieldName) {
        return this.fieldNameToHeaderLineMap.get(fieldName);
    }

    @Override
    public List<VCFInfoHeaderLine> retrieveAllHeaderInfo() {
        return new ArrayList<VCFInfoHeaderLine>(this.fieldNameToHeaderLineMap.values());
    }

    public String toString() {
        return "VcfFuncotationMetadata{fieldNameToHeaderLineMap=" + this.fieldNameToHeaderLineMap + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcfFuncotationMetadata that = (VcfFuncotationMetadata)o;
        return this.fieldNameToHeaderLineMap != null ? this.fieldNameToHeaderLineMap.equals(that.fieldNameToHeaderLineMap) : that.fieldNameToHeaderLineMap == null;
    }

    public int hashCode() {
        return this.fieldNameToHeaderLineMap != null ? this.fieldNameToHeaderLineMap.hashCode() : 0;
    }
}

