/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.simpletsvoutput;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.greypanther.natsort.SimpleNaturalComparator;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.funcotator.AliasProvider;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.OutputRenderer;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.LocatableFuncotationCreator;
import org.broadinstitute.hellbender.tools.funcotator.mafOutput.MafOutputRenderer;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableUtils;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;
import org.codehaus.plexus.util.StringUtils;

public class SimpleTsvOutputRenderer
extends OutputRenderer {
    private static final Logger logger = LogManager.getLogger(MafOutputRenderer.class);
    private static final String SIMPLE_TSV_OUTPUT_RENDERER_DUMMY_NAME = "SIMPLE_TSV_OUTPUT_RENDERER";
    private TableWriter<LinkedHashMap<String, String>> writer;
    private boolean isWriterInitialized;
    private LinkedHashMap<String, String> columnNameToFuncotationFieldMap;
    private final Set<String> excludedOutputFields;
    private final Path outputFilePath;
    private final LinkedHashMap<String, String> unaccountedForDefaultAnnotations;
    private final LinkedHashMap<String, String> unaccountedForOverrideAnnotations;
    private final AliasProvider aliasProvider;
    private final boolean isWriteFuncotationFieldsNotInConfig;

    @VisibleForTesting
    SimpleTsvOutputRenderer(Path outputFilePath, LinkedHashMap<String, String> unaccountedForDefaultAnnotations, LinkedHashMap<String, String> unaccountedForOverrideAnnotations, Set<String> excludedOutputFields, LinkedHashMap<String, List<String>> columnNameToAliasesMap, String toolVersion, boolean isWriteFuncotationFieldsNotInConfig) {
        super(toolVersion);
        Utils.nonNull(outputFilePath);
        Utils.nonNull(unaccountedForDefaultAnnotations);
        Utils.nonNull(unaccountedForOverrideAnnotations);
        Utils.nonNull(excludedOutputFields);
        Utils.nonNull(columnNameToAliasesMap);
        Utils.nonNull(toolVersion);
        this.excludedOutputFields = excludedOutputFields;
        this.outputFilePath = outputFilePath;
        this.isWriterInitialized = false;
        this.aliasProvider = new AliasProvider(columnNameToAliasesMap);
        this.unaccountedForDefaultAnnotations = unaccountedForDefaultAnnotations;
        this.unaccountedForOverrideAnnotations = unaccountedForOverrideAnnotations;
        this.isWriteFuncotationFieldsNotInConfig = isWriteFuncotationFieldsNotInConfig;
    }

    private void initializeWriter(List<String> columnNames) {
        Utils.validateArg(columnNames.size() > 0, "TSV output renderer has been configured to produce a blank file.  This is usually a user error.  Please check excluded columns.");
        TableColumnCollection columns = new TableColumnCollection(columnNames);
        try {
            this.writer = TableUtils.writer(this.outputFilePath, columns, (map, dataLine) -> map.keySet().forEach(k -> dataLine.set((String)k, (String)map.get(k))));
        }
        catch (IOException ioe) {
            throw new GATKException("Could not open the simple TSV writer.", ioe);
        }
        this.isWriterInitialized = true;
    }

    @Override
    public void close() {
        try {
            if (!this.isWriterInitialized) {
                List<String> columnNames = this.estimateOutputFieldsWithoutData(this.excludedOutputFields, this.unaccountedForDefaultAnnotations, this.unaccountedForOverrideAnnotations);
                this.initializeWriter(columnNames);
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException ioe) {
            throw new GATKException("Could not close the simple TSV output writing.", ioe);
        }
    }

    @Override
    public void write(VariantContext variant, FuncotationMap txToFuncotationMap) {
        if (txToFuncotationMap.getTranscriptList().size() > 1) {
            logger.warn("More than one transcript found.  This should be able to render (grouped by transcript), but you may need to do further processing.  No user action needed.");
        }
        if (!txToFuncotationMap.doAllTxAlleleCombinationsHaveTheSameFields()) {
            throw new GATKException.ShouldNeverReachHereException("The funcotation map cannot be written by this simple output renderer.  The fields in the funcotation map do not match across transcript-allele combinations.  This is almost certainly an issue for the GATK development team.");
        }
        for (String txId : txToFuncotationMap.getTranscriptList()) {
            for (Allele allele : txToFuncotationMap.getAlleles(txId)) {
                txToFuncotationMap.add(txId, LocatableFuncotationCreator.create((Locatable)variant, allele, SIMPLE_TSV_OUTPUT_RENDERER_DUMMY_NAME));
            }
        }
        if (!this.isWriterInitialized) {
            this.columnNameToFuncotationFieldMap = this.createColumnNameToFieldNameMap(txToFuncotationMap, txToFuncotationMap.getTranscriptList().get(0), this.excludedOutputFields, this.unaccountedForDefaultAnnotations, this.unaccountedForOverrideAnnotations, this.isWriteFuncotationFieldsNotInConfig);
            this.initializeWriter(new ArrayList<String>(this.columnNameToFuncotationFieldMap.keySet()));
        }
        try {
            for (String txId : txToFuncotationMap.getTranscriptList()) {
                for (Allele allele : txToFuncotationMap.getAlleles(txId)) {
                    LinkedHashMap<String, String> columnNameToValueMap = SimpleTsvOutputRenderer.createColumnNameToValueMap(this.columnNameToFuncotationFieldMap, txToFuncotationMap, txId, allele, this.unaccountedForDefaultAnnotations, this.unaccountedForOverrideAnnotations, this.excludedOutputFields);
                    this.writer.writeRecord(columnNameToValueMap);
                }
            }
        }
        catch (IOException ioe) {
            throw new GATKException("Could not write to the simple TSV writer.", ioe);
        }
    }

    private LinkedHashMap<String, String> createColumnNameToFieldNameMap(FuncotationMap funcotationMap, String txId, Set<String> excludedFields, LinkedHashMap<String, String> unaccountedForDefaultAnnotations, LinkedHashMap<String, String> unaccountedForOverrideAnnotations, boolean isWriteFuncotationFieldsNotInConfig) {
        LinkedHashMap<String, String> result = this.aliasProvider.createColumnNameToFieldNameMap(funcotationMap, txId);
        ArrayList leftovers = Lists.newArrayList();
        if (isWriteFuncotationFieldsNotInConfig) {
            Set<String> allFuncotationFields = funcotationMap.getFieldNames(txId);
            HashSet<String> usedFuncotationFields = new HashSet<String>(result.values());
            leftovers.addAll(this.getLeftoverStrings(allFuncotationFields, usedFuncotationFields));
        }
        leftovers.addAll(this.getLeftoverStrings(unaccountedForDefaultAnnotations.keySet(), new HashSet<String>(leftovers)));
        leftovers.addAll(this.getLeftoverStrings(unaccountedForOverrideAnnotations.keySet(), new HashSet<String>(leftovers)));
        leftovers.sort(SimpleNaturalComparator.getInstance());
        leftovers.forEach(c -> result.putIfAbsent((String)c, (String)c));
        excludedFields.forEach(result::remove);
        return result;
    }

    private List<String> estimateOutputFieldsWithoutData(Set<String> excludedFields, LinkedHashMap<String, String> unaccountedForDefaultAnnotations, LinkedHashMap<String, String> unaccountedForOverrideAnnotations) {
        return Lists.newArrayList(this.createColumnNameToFieldNameMap(FuncotationMap.createEmpty(), "DUMMY", excludedFields, unaccountedForDefaultAnnotations, unaccountedForOverrideAnnotations, false).keySet());
    }

    private List<String> getLeftoverStrings(Set<String> superset, Set<String> usedFuncotationFields) {
        Sets.SetView leftoverColumns = Sets.difference(superset, usedFuncotationFields);
        return leftoverColumns.stream().sorted().collect(Collectors.toList());
    }

    @VisibleForTesting
    static LinkedHashMap<String, String> createColumnNameToValueMap(LinkedHashMap<String, String> columnNameToFieldMap, FuncotationMap funcotationMap, String txId, Allele allele, LinkedHashMap<String, String> unaccountedDefaultAnnotations, LinkedHashMap<String, String> unaccountedOverrideAnnotations, Set<String> excludedFields) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : columnNameToFieldMap.entrySet()) {
            String key = entry.getKey();
            String funcotationFieldName = entry.getValue();
            if (excludedFields.contains(key)) continue;
            String funcotationMapFieldValue = funcotationMap.getFieldValue(txId, funcotationFieldName, allele);
            String finalValue = unaccountedOverrideAnnotations.getOrDefault(key, funcotationMapFieldValue == null ? unaccountedDefaultAnnotations.getOrDefault(key, "__UNKNOWN__") : funcotationMapFieldValue);
            result.put(key, finalValue);
        }
        return result;
    }

    @VisibleForTesting
    public static LinkedHashMap<String, List<String>> createColumnNameToAliasesMap(Path configFile) {
        Configuration configFileContents = FuncotatorUtils.retrieveConfiguration(configFile.toFile());
        ArrayList keys = Lists.newArrayList((Iterator)configFileContents.getKeys());
        return keys.stream().collect(Collectors.toMap(Function.identity(), k -> Arrays.asList(SimpleTsvOutputRenderer.splitAndTrim(configFileContents.getString(k), ",")), (x1, x2) -> {
            throw new IllegalArgumentException("Should not be able to have duplicate field names.");
        }, LinkedHashMap::new));
    }

    public static SimpleTsvOutputRenderer createFromFile(Path outputFilePath, LinkedHashMap<String, String> unaccountedForDefaultAnnotations, LinkedHashMap<String, String> unaccountedForOverrideAnnotations, Set<String> excludedOutputFields, Path configPath, String toolVersion, boolean isWriteColumnsNotInConfig) {
        return new SimpleTsvOutputRenderer(outputFilePath, unaccountedForDefaultAnnotations, unaccountedForOverrideAnnotations, excludedOutputFields, SimpleTsvOutputRenderer.createColumnNameToAliasesMap(configPath), toolVersion, isWriteColumnsNotInConfig);
    }

    public static SimpleTsvOutputRenderer createFromResource(Path outputFilePath, LinkedHashMap<String, String> unaccountedForDefaultAnnotations, LinkedHashMap<String, String> unaccountedForOverrideAnnotations, Set<String> excludedOutputFields, Path resourcePath, String toolVersion, boolean isWriteColumnsNotInConfig) {
        try {
            return new SimpleTsvOutputRenderer(outputFilePath, unaccountedForDefaultAnnotations, unaccountedForOverrideAnnotations, excludedOutputFields, SimpleTsvOutputRenderer.createColumnNameToAliasesMap(Resource.getResourceContentsAsFile(resourcePath.toString()).toPath()), toolVersion, isWriteColumnsNotInConfig);
        }
        catch (IOException ioe) {
            throw new GATKException.ShouldNeverReachHereException("Could not read config file: " + resourcePath, ioe);
        }
    }

    @VisibleForTesting
    static String[] splitAndTrim(String text, String separator) {
        return (String[])Stream.of(StringUtils.split((String)text, (String)separator)).map(String::trim).toArray(String[]::new);
    }

    @VisibleForTesting
    LinkedHashMap<String, String> getColumnNameToFuncotationFieldMap() {
        return this.columnNameToFuncotationFieldMap;
    }
}

