/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.funcotator.vcfOutput;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.tools.funcotator.DataSourceFuncotationFactory;
import org.broadinstitute.hellbender.tools.funcotator.Funcotation;
import org.broadinstitute.hellbender.tools.funcotator.FuncotationMap;
import org.broadinstitute.hellbender.tools.funcotator.FuncotatorUtils;
import org.broadinstitute.hellbender.tools.funcotator.OutputRenderer;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.DataSourceUtils;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotation;
import org.broadinstitute.hellbender.tools.funcotator.dataSources.gencode.GencodeFuncotationBuilder;
import org.broadinstitute.hellbender.utils.Utils;

public class VcfOutputRenderer
extends OutputRenderer {
    public static final String FUNCOTATOR_VCF_FIELD_NAME = "FUNCOTATION";
    public static final String HEADER_LISTED_FIELD_DELIMITER = "|";
    public static final String FIELD_DELIMITER = "|";
    public static final String OTHER_TRANSCRIPT_DELIMITER = "/";
    public static final String ALL_TRANSCRIPT_DELIMITER = "#";
    public static final String START_TRANSCRIPT_DELIMITER = "[";
    public static final String END_TRANSCRIPT_DELIMITER = "]";
    public static final String DESCRIPTION_PREAMBLE_DELIMITER = ": ";
    private final VariantContextWriter vcfWriter;
    private final VCFHeader existingHeader;
    private final LinkedHashSet<VCFHeaderLine> defaultToolVcfHeaderLines;
    private final List<String> finalFuncotationFieldNames;

    public VcfOutputRenderer(VariantContextWriter vcfWriter, List<DataSourceFuncotationFactory> dataSources, VCFHeader existingHeader, LinkedHashMap<String, String> unaccountedForDefaultAnnotations, LinkedHashMap<String, String> unaccountedForOverrideAnnotations, Set<VCFHeaderLine> defaultToolVcfHeaderLines, Set<String> excludedOutputFields, String toolVersion) {
        super(toolVersion);
        Utils.nonNull(vcfWriter);
        Utils.nonNull(dataSources);
        Utils.nonNull(existingHeader);
        Utils.nonNull(unaccountedForDefaultAnnotations);
        Utils.nonNull(unaccountedForOverrideAnnotations);
        Utils.nonNull(defaultToolVcfHeaderLines);
        Utils.nonNull(excludedOutputFields);
        this.vcfWriter = vcfWriter;
        this.existingHeader = existingHeader;
        this.dataSourceFactories = dataSources;
        this.manualAnnotations = new LinkedHashMap();
        this.manualAnnotations.putAll(unaccountedForDefaultAnnotations);
        this.manualAnnotations.putAll(unaccountedForOverrideAnnotations);
        this.defaultToolVcfHeaderLines = new LinkedHashSet<VCFHeaderLine>(defaultToolVcfHeaderLines);
        this.finalFuncotationFieldNames = Stream.concat(VcfOutputRenderer.getDataSourceFieldNamesForHeaderAsList(this.dataSourceFactories).stream(), this.manualAnnotations.keySet().stream()).filter(f -> !excludedOutputFields.contains(f)).collect(Collectors.toList());
        VCFHeader newHeader = this.createVCFHeader();
        vcfWriter.writeHeader(newHeader);
    }

    @Override
    public void close() {
        this.vcfWriter.close();
    }

    @Override
    public void write(VariantContext variant, FuncotationMap txToFuncotationMap) {
        VariantContextBuilder variantContextOutputBuilder = new VariantContextBuilder(variant);
        StringBuilder funcotatorAnnotationStringBuilder = new StringBuilder();
        Object existingAnnotation = variant.getAttribute(FUNCOTATOR_VCF_FIELD_NAME, null);
        List<Object> existingAlleleAnnotations = existingAnnotation != null ? Utils.split(existingAnnotation.toString(), ',') : Collections.emptyList();
        List alternateAlleles = variant.getAlternateAlleles();
        for (int alleleIndex = 0; alleleIndex < alternateAlleles.size(); ++alleleIndex) {
            Allele altAllele = (Allele)alternateAlleles.get(alleleIndex);
            if (alleleIndex < existingAlleleAnnotations.size()) {
                funcotatorAnnotationStringBuilder.append((String)existingAlleleAnnotations.get(alleleIndex));
                funcotatorAnnotationStringBuilder.append("|");
            }
            for (String txId : txToFuncotationMap.getTranscriptList()) {
                funcotatorAnnotationStringBuilder.append(START_TRANSCRIPT_DELIMITER);
                List<Funcotation> funcotations = txToFuncotationMap.get(txId);
                Funcotation manualAnnotationFuncotation = this.createManualAnnotationFuncotation(altAllele);
                funcotatorAnnotationStringBuilder.append(Stream.concat(funcotations.stream(), Stream.of(manualAnnotationFuncotation)).filter(f -> f.getAltAllele().equals((Object)altAllele)).filter(f -> f.getFieldNames().size() > 0).filter(f -> !f.getDataSourceName().equals("INPUT_VCF")).map(VcfOutputRenderer::adjustIndelAlleleInformation).map(f -> FuncotatorUtils.renderSanitizedFuncotationForVcf(f, this.finalFuncotationFieldNames)).collect(Collectors.joining("|")));
                funcotatorAnnotationStringBuilder.append("]#");
            }
            funcotatorAnnotationStringBuilder.deleteCharAt(funcotatorAnnotationStringBuilder.length() - 1);
            funcotatorAnnotationStringBuilder.append(",");
        }
        funcotatorAnnotationStringBuilder.deleteCharAt(funcotatorAnnotationStringBuilder.length() - 1);
        variantContextOutputBuilder.attribute(FUNCOTATOR_VCF_FIELD_NAME, (Object)funcotatorAnnotationStringBuilder.toString());
        variantContextOutputBuilder.genotypes(variant.getGenotypes());
        this.vcfWriter.add(variantContextOutputBuilder.make());
    }

    private Funcotation createManualAnnotationFuncotation(Allele altAllele) {
        return OutputRenderer.createFuncotationFromLinkedHashMap(this.manualAnnotations, altAllele, "UnaccountedManualAnnotations");
    }

    private static Funcotation adjustIndelAlleleInformation(Funcotation funcotation) {
        if (funcotation instanceof GencodeFuncotation) {
            return VcfOutputRenderer.adjustIndelAlleleInformation((GencodeFuncotation)funcotation);
        }
        return funcotation;
    }

    private static GencodeFuncotation adjustIndelAlleleInformation(GencodeFuncotation gencodeFuncotation) {
        GencodeFuncotation outFuncotation = new GencodeFuncotationBuilder(gencodeFuncotation).build();
        if (gencodeFuncotation.getVariantType().equals((Object)GencodeFuncotation.VariantType.DEL) || gencodeFuncotation.getVariantType().equals((Object)GencodeFuncotation.VariantType.INS)) {
            int altAlleleLength;
            int refAlleleLength = gencodeFuncotation.getRefAllele().length();
            if (refAlleleLength < (altAlleleLength = gencodeFuncotation.getTumorSeqAllele2().length())) {
                outFuncotation.setTumorSeqAllele2(gencodeFuncotation.getTumorSeqAllele2().substring(refAlleleLength));
                outFuncotation.setRefAllele("-");
                outFuncotation.setEnd(gencodeFuncotation.getStart() + 1);
            } else if (refAlleleLength > altAlleleLength) {
                outFuncotation.setRefAllele(gencodeFuncotation.getRefAllele().substring(altAlleleLength));
                outFuncotation.setTumorSeqAllele2("-");
                outFuncotation.setStart(gencodeFuncotation.getStart() + 1);
                outFuncotation.setEnd(gencodeFuncotation.getStart() + refAlleleLength - 1);
            }
        }
        return outFuncotation;
    }

    private VCFHeader createVCFHeader() {
        LinkedHashSet<Object> headerLines = new LinkedHashSet<Object>();
        headerLines.addAll(this.existingHeader.getMetaDataInInputOrder());
        String delimitedFields = String.join((CharSequence)"|", this.finalFuncotationFieldNames);
        headerLines.addAll(this.defaultToolVcfHeaderLines);
        headerLines.add(new VCFHeaderLine("Funcotator Version", this.toolVersion + " | " + this.getDataSourceInfoString()));
        headerLines.add(new VCFInfoHeaderLine(FUNCOTATOR_VCF_FIELD_NAME, VCFHeaderLineCount.A, VCFHeaderLineType.String, "Functional annotation from the Funcotator tool.  Funcotation fields are: " + delimitedFields));
        return new VCFHeader(headerLines, this.existingHeader.getGenotypeSamples());
    }

    private static List<String> getDataSourceFieldNamesForHeaderAsList(List<DataSourceFuncotationFactory> dataSourceFactories) {
        return dataSourceFactories.stream().sorted(DataSourceUtils::datasourceComparator).map(DataSourceFuncotationFactory::getSupportedFuncotationFields).flatMap(Collection::stream).map(Object::toString).collect(Collectors.toList());
    }
}

