/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.genomicsdb;

import java.nio.file.Path;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeCalculationArgumentCollection;

public final class GenomicsDBOptions {
    private final Path reference;
    private final boolean callGenotypes;
    private final int maxDiploidAltAllelesThatCanBeGenotyped;
    private final int maxGenotypeCount;
    private final boolean useBCFCodec;
    private final boolean sharedPosixFSOptimizations;

    public GenomicsDBOptions() {
        this(null);
    }

    public GenomicsDBOptions(Path reference) {
        this(reference, new GenomicsDBArgumentCollection());
    }

    public GenomicsDBOptions(Path reference, GenomicsDBArgumentCollection genomicsdbArgs) {
        this(reference, genomicsdbArgs, new GenotypeCalculationArgumentCollection());
    }

    public GenomicsDBOptions(Path reference, GenomicsDBArgumentCollection genomicsdbArgs, GenotypeCalculationArgumentCollection genotypeCalcArgs) {
        this.reference = reference;
        this.callGenotypes = genomicsdbArgs.callGenotypes;
        this.maxDiploidAltAllelesThatCanBeGenotyped = genomicsdbArgs.maxDiploidAltAllelesThatCanBeGenotyped;
        this.maxGenotypeCount = genotypeCalcArgs.MAX_GENOTYPE_COUNT;
        this.useBCFCodec = genomicsdbArgs.useBCFCodec;
        this.sharedPosixFSOptimizations = genomicsdbArgs.sharedPosixFSOptimizations;
    }

    public Path getReference() {
        return this.reference;
    }

    public boolean doCallGenotypes() {
        return this.callGenotypes;
    }

    public int getMaxDiploidAltAllelesThatCanBeGenotyped() {
        return this.maxDiploidAltAllelesThatCanBeGenotyped;
    }

    public int getMaxGenotypeCount() {
        return this.maxGenotypeCount;
    }

    public boolean useBCFCodec() {
        return this.useBCFCodec;
    }

    public boolean sharedPosixFSOptimizations() {
        return this.sharedPosixFSOptimizations;
    }
}

