/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.genomicsdb;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBOptions;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.genomicsdb.importer.GenomicsDBImporter;
import org.genomicsdb.model.GenomicsDBExportConfiguration;
import org.genomicsdb.model.GenomicsDBVidMapProto;

public class GenomicsDBUtils {
    private static final String SUM = "sum";
    private static final String ELEMENT_WISE_SUM = "element_wise_sum";
    private static final String ELEMENT_WISE_FLOAT_SUM = "element_wise_float_sum";
    private static final String ELEMENT_WISE_INT_SUM = "element_wise_int_sum";
    private static final String HISTOGRAM_SUM = "histogram_sum";
    private static final String MOVE_TO_FORMAT = "move_to_FORMAT";
    private static final String GDB_TYPE_FLOAT = "float";
    private static final String GDB_TYPE_INT = "int";

    public static void updateImportProtobufVidMapping(GenomicsDBImporter importer) {
        GenomicsDBVidMapProto.VidMappingPB vidMapPB = importer.getProtobufVidMapping();
        if (vidMapPB == null) {
            throw new UserException("Could not get protobuf vid mappping object from GenomicsDBImporter");
        }
        HashMap<String, Integer> fieldNameToIndexInVidFieldsList = GenomicsDBUtils.getFieldNameToListIndexInProtobufVidMappingObject(vidMapPB);
        vidMapPB = GenomicsDBUtils.updateINFOFieldCombineOperation(vidMapPB, fieldNameToIndexInVidFieldsList, "RAW_MQandDP", ELEMENT_WISE_SUM);
        vidMapPB = GenomicsDBUtils.updateAlleleSpecificINFOFieldCombineOperation(vidMapPB, fieldNameToIndexInVidFieldsList, "AS_RAW_MQ", ELEMENT_WISE_FLOAT_SUM);
        vidMapPB = GenomicsDBUtils.updateINFOFieldCombineOperation(vidMapPB, fieldNameToIndexInVidFieldsList, "MQ_DP", SUM);
        vidMapPB = GenomicsDBUtils.updateINFOFieldCombineOperation(vidMapPB, fieldNameToIndexInVidFieldsList, "QUALapprox", SUM);
        vidMapPB = GenomicsDBUtils.updateINFOFieldCombineOperation(vidMapPB, fieldNameToIndexInVidFieldsList, "VarDP", SUM);
        vidMapPB = GenomicsDBUtils.updateINFOFieldCombineOperation(vidMapPB, fieldNameToIndexInVidFieldsList, "RAW_GT_COUNT", ELEMENT_WISE_SUM);
        vidMapPB = GenomicsDBUtils.updateAlleleSpecificINFOFieldCombineOperation(vidMapPB, fieldNameToIndexInVidFieldsList, "AS_QUALapprox", ELEMENT_WISE_INT_SUM);
        importer.updateProtobufVidMapping(vidMapPB);
    }

    public static GenomicsDBExportConfiguration.ExportConfiguration createExportConfiguration(String workspace, String callsetJson, String vidmapJson, String vcfHeader, GenomicsDBOptions genomicsDBOptions) {
        GenomicsDBExportConfiguration.ExportConfiguration.Builder exportConfigurationBuilder = GenomicsDBExportConfiguration.ExportConfiguration.newBuilder().setWorkspace(workspace).setReferenceGenome(genomicsDBOptions.getReference().toAbsolutePath().toString()).setVidMappingFile(vidmapJson).setCallsetMappingFile(callsetJson).setVcfHeaderFilename(vcfHeader).setProduceGTField(genomicsDBOptions.doCallGenotypes()).setProduceGTWithMinPLValueForSpanningDeletions(false).setSitesOnlyQuery(false).setMaxDiploidAltAllelesThatCanBeGenotyped(genomicsDBOptions.getMaxDiploidAltAllelesThatCanBeGenotyped()).setMaxGenotypeCount(genomicsDBOptions.getMaxGenotypeCount()).setEnableSharedPosixfsOptimizations(genomicsDBOptions.sharedPosixFSOptimizations());
        Path arrayFolder = Paths.get(workspace, "genomicsdb_array").toAbsolutePath();
        if (Files.exists(arrayFolder, new LinkOption[0])) {
            exportConfigurationBuilder.setArrayName("genomicsdb_array");
        } else {
            exportConfigurationBuilder.setGenerateArrayNameFromPartitionBounds(true);
        }
        return exportConfigurationBuilder.build();
    }

    public static GenomicsDBExportConfiguration.ExportConfiguration createExportConfiguration(String workspace, String callsetJson, String vidmapJson, String vcfHeader) {
        return GenomicsDBUtils.createExportConfiguration(workspace, callsetJson, vidmapJson, vcfHeader, null);
    }

    public static GenomicsDBVidMapProto.VidMappingPB getProtobufVidMappingFromJsonFile(String vidmapJson) throws IOException {
        GenomicsDBVidMapProto.VidMappingPB.Builder vidMapBuilder = GenomicsDBVidMapProto.VidMappingPB.newBuilder();
        try (BufferedReader reader = Files.newBufferedReader(IOUtils.getPath(vidmapJson));){
            JsonFormat.merge((Readable)reader, (Message.Builder)vidMapBuilder);
        }
        return vidMapBuilder.build();
    }

    public static HashMap<String, Integer> getFieldNameToListIndexInProtobufVidMappingObject(GenomicsDBVidMapProto.VidMappingPB vidMapPB) {
        HashMap<String, Integer> fieldNameToIndexInVidFieldsList = new HashMap<String, Integer>();
        for (int fieldIdx = 0; fieldIdx < vidMapPB.getFieldsCount(); ++fieldIdx) {
            fieldNameToIndexInVidFieldsList.put(vidMapPB.getFields(fieldIdx).getName(), fieldIdx);
        }
        return fieldNameToIndexInVidFieldsList;
    }

    public static GenomicsDBVidMapProto.VidMappingPB updateINFOFieldCombineOperation(GenomicsDBVidMapProto.VidMappingPB vidMapPB, Map<String, Integer> fieldNameToIndexInVidFieldsList, String fieldName, String newCombineOperation) {
        int fieldIdx;
        int n = fieldIdx = fieldNameToIndexInVidFieldsList.containsKey(fieldName) ? fieldNameToIndexInVidFieldsList.get(fieldName) : -1;
        if (fieldIdx >= 0) {
            GenomicsDBVidMapProto.VidMappingPB.Builder updatedVidMapBuilder = vidMapPB.toBuilder();
            GenomicsDBVidMapProto.GenomicsDBFieldInfo.Builder fieldBuilder = updatedVidMapBuilder.getFieldsBuilder(fieldIdx);
            fieldBuilder.setVCFFieldCombineOperation(newCombineOperation);
            return updatedVidMapBuilder.build();
        }
        return vidMapPB;
    }

    public static GenomicsDBVidMapProto.VidMappingPB updateAlleleSpecificINFOFieldCombineOperation(GenomicsDBVidMapProto.VidMappingPB vidMapPB, Map<String, Integer> fieldNameToIndexInVidFieldsList, String fieldName, String newCombineOperation) {
        int fieldIdx;
        int n = fieldIdx = fieldNameToIndexInVidFieldsList.containsKey(fieldName) ? fieldNameToIndexInVidFieldsList.get(fieldName) : -1;
        if (fieldIdx >= 0) {
            GenomicsDBVidMapProto.VidMappingPB.Builder updatedVidMapBuilder = vidMapPB.toBuilder();
            GenomicsDBVidMapProto.GenomicsDBFieldInfo.Builder infoBuilder = updatedVidMapBuilder.getFieldsBuilder(fieldIdx);
            GenomicsDBVidMapProto.FieldLengthDescriptorComponentPB.Builder lengthDescriptorComponentBuilder = GenomicsDBVidMapProto.FieldLengthDescriptorComponentPB.newBuilder();
            infoBuilder.clearLength();
            infoBuilder.clearVcfDelimiter();
            infoBuilder.clearType();
            lengthDescriptorComponentBuilder.setVariableLengthDescriptor("R");
            infoBuilder.addLength(lengthDescriptorComponentBuilder.build());
            lengthDescriptorComponentBuilder.setVariableLengthDescriptor("var");
            infoBuilder.addLength(lengthDescriptorComponentBuilder.build());
            infoBuilder.addVcfDelimiter("|");
            infoBuilder.addVcfDelimiter(",");
            if (newCombineOperation.equals(HISTOGRAM_SUM)) {
                infoBuilder.addType(GDB_TYPE_FLOAT);
                infoBuilder.addType(GDB_TYPE_INT);
                infoBuilder.setVCFFieldCombineOperation(HISTOGRAM_SUM);
            } else {
                infoBuilder.setVCFFieldCombineOperation(ELEMENT_WISE_SUM);
                if (newCombineOperation.equals(ELEMENT_WISE_FLOAT_SUM)) {
                    infoBuilder.addType(GDB_TYPE_FLOAT);
                } else {
                    infoBuilder.addType(GDB_TYPE_INT);
                }
            }
            return updatedVidMapBuilder.build();
        }
        return vidMapPB;
    }
}

