/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.htsgetreader;

import htsjdk.samtools.util.FileExtensions;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.htsgetreader.HtsgetClass;
import org.broadinstitute.hellbender.tools.htsgetreader.HtsgetFormat;
import org.broadinstitute.hellbender.tools.htsgetreader.HtsgetRequestField;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public class HtsgetRequestBuilder {
    private final URI endpoint;
    private final String id;
    private HtsgetFormat format;
    private HtsgetClass dataClass;
    private SimpleInterval interval;
    private final EnumSet<HtsgetRequestField> fields;
    private final Set<String> tags;
    private final Set<String> notags;

    public HtsgetRequestBuilder(URI endpoint, String id) {
        this.endpoint = endpoint;
        this.id = id;
        this.fields = EnumSet.noneOf(HtsgetRequestField.class);
        this.tags = new HashSet<String>();
        this.notags = new HashSet<String>();
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getID() {
        return this.id;
    }

    public HtsgetFormat getFormat() {
        return this.format;
    }

    public HtsgetClass getDataClass() {
        return this.dataClass;
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public Set<HtsgetRequestField> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public Set<String> getNoTags() {
        return Collections.unmodifiableSet(this.notags);
    }

    public void setFormat(HtsgetFormat format) {
        this.format = format;
    }

    public void setDataClass(HtsgetClass dataClass) {
        this.dataClass = dataClass;
    }

    public void setInterval(SimpleInterval interval) {
        this.interval = interval;
    }

    public void addField(HtsgetRequestField field) {
        this.fields.add(field);
    }

    public void addFields(Collection<HtsgetRequestField> fields) {
        this.fields.addAll(fields);
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addTags(Collection<String> tags) {
        this.tags.addAll(tags);
    }

    public void addNotag(String notag) {
        this.notags.add(notag);
    }

    public void addNotags(Collection<String> notags) {
        this.notags.addAll(notags);
    }

    public HtsgetRequestBuilder withFormat(HtsgetFormat format) {
        this.format = format;
        return this;
    }

    public HtsgetRequestBuilder withDataClass(HtsgetClass dataClass) {
        this.dataClass = dataClass;
        return this;
    }

    public HtsgetRequestBuilder withInterval(SimpleInterval interval) {
        this.interval = interval;
        return this;
    }

    public HtsgetRequestBuilder withField(HtsgetRequestField field) {
        this.fields.add(field);
        return this;
    }

    public HtsgetRequestBuilder withFields(Collection<HtsgetRequestField> fields) {
        this.fields.addAll(fields);
        return this;
    }

    public HtsgetRequestBuilder withTag(String tag) {
        this.tags.add(tag);
        return this;
    }

    public HtsgetRequestBuilder withTags(Collection<String> tags) {
        this.tags.addAll(tags);
        return this;
    }

    public HtsgetRequestBuilder withNotag(String notag) {
        this.notags.add(notag);
        return this;
    }

    public HtsgetRequestBuilder withNotags(Collection<String> notags) {
        this.notags.addAll(notags);
        return this;
    }

    private void validateRequest() {
        String intersections;
        block5: {
            block6: {
                block7: {
                    if (!(this.dataClass == null || this.dataClass != HtsgetClass.header || this.interval == null && this.fields.isEmpty() && this.tags.isEmpty() && this.notags.isEmpty())) {
                        throw new UserException("Invalid request: no query parameters except `format` may be specified when class=header");
                    }
                    if (this.format == null) break block5;
                    if (this.id.endsWith(".bam")) break block6;
                    if (!this.id.endsWith(".sam") || this.format == HtsgetFormat.BAM) break block7;
                    if (this.format != HtsgetFormat.CRAM) break block6;
                }
                if (!FileExtensions.VCF_LIST.stream().anyMatch(this.id::endsWith) || this.format == HtsgetFormat.VCF || this.format == HtsgetFormat.BCF) break block5;
            }
            throw new UserException("Specified format: " + (Object)((Object)this.format) + " is incompatible with id's file extension");
        }
        if (!(intersections = this.tags.stream().filter(this.getNoTags()::contains).collect(Collectors.joining(", "))).isEmpty()) {
            throw new UserException("Invalid request: tags and notags overlap in the following fields: " + intersections);
        }
    }

    public URI toURI() {
        this.validateRequest();
        UriBuilder builder = UriBuilder.fromUri((URI)this.endpoint).scheme("https").path(this.id);
        if (this.format != null) {
            builder.queryParam("format", new Object[]{this.format.toString()});
        }
        if (this.dataClass != null) {
            builder.queryParam("class", new Object[]{this.dataClass});
        }
        if (this.interval != null) {
            builder.queryParam("referenceName", new Object[]{this.interval.getContig()});
            builder.queryParam("start", new Object[]{this.interval.getGA4GHStart()});
            builder.queryParam("end", new Object[]{this.interval.getGA4GHEnd()});
        }
        if (!this.fields.isEmpty()) {
            builder.queryParam("fields", new Object[]{this.fields.stream().map(Enum::toString).collect(Collectors.joining(","))});
        }
        if (!this.tags.isEmpty()) {
            builder.queryParam("tags", new Object[]{String.join((CharSequence)",", this.tags)});
        }
        if (!this.notags.isEmpty()) {
            builder.queryParam("notags", new Object[]{String.join((CharSequence)",", this.notags)});
        }
        return builder.build(new Object[0]);
    }
}

